/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.controller;

import com.seanreilly.apps.moneydance.controller.Common;
import com.seanreilly.util.StreamTable;
import com.seanreilly.util.StreamVector;
import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class UserPreferences {
    private StreamTable prefTable;
    private File preferencesFile;
    private DateFormat shortDateFormatter = DateFormat.getDateInstance(3);
    private DateFormat longDateFormatter = DateFormat.getDateInstance(1);
    private NumberFormat currencyFormat = NumberFormat.getCurrencyInstance();

    public boolean doesExist() {
        return this.preferencesFile.exists();
    }

    public char getDecimalChar() {
        String string = this.getSetting("decimal_character", ".");
        if (string.length() > 0) {
            return string.charAt(0);
        }
        return '.';
    }

    public DateFormat getShortDateFormatter() {
        return new SimpleDateFormat(this.getSetting("date_format", "MM/dd/yyyy"));
    }

    public DateFormat getLongDateFormatter() {
        return this.shortDateFormatter;
    }

    public NumberFormat getCurrencyFormatter() {
        return this.currencyFormat;
    }

    public Vector getAvailableLocales() {
        Vector<Locale> vector = new Vector<Locale>();
        vector.addElement(Locale.US);
        vector.addElement(Locale.GERMANY);
        return vector;
    }

    public Locale getLocale() {
        return new Locale(this.getSetting("locale.country", "us"), this.getSetting("locale.language", "EN"));
    }

    public ResourceBundle getResources() {
        return ResourceBundle.getBundle("com.seanreilly.apps.moneydance.view.Resources", this.getLocale());
    }

    public void readSettings() throws Exception {
        this.prefTable = new StreamTable();
        this.prefTable.readFromFile(this.preferencesFile);
    }

    public void writeSettings() throws Exception {
        this.prefTable.writeToFile(this.preferencesFile);
    }

    public String getSetting(String string, String string2) {
        Object object = this.prefTable.get(string);
        if (object == null || !(object instanceof String)) {
            return string2;
        }
        return (String)object;
    }

    public String getSetting(String string) {
        return this.getSetting(string, null);
    }

    public void setSetting(String string, String string2) {
        this.prefTable.put(string, string2);
    }

    public void setSetting(String string, StreamTable streamTable) {
        this.prefTable.put(string, streamTable);
    }

    public void setSetting(String string, StreamVector streamVector) {
        this.prefTable.put(string, streamVector);
    }

    public UserPreferences() {
        this(new File(Common.dataRootDir, "config.dict"));
    }

    public UserPreferences(String string) {
        this(new File(string));
        this.preferencesFile = new File(string);
    }

    public UserPreferences(File file) {
        this.preferencesFile = file;
        this.prefTable = new StreamTable();
    }
}

