/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.controller;

import com.seanreilly.apps.moneydance.controller.Common;
import com.seanreilly.apps.moneydance.controller.StatusMonitor;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.io.AccountUpgrader;
import com.seanreilly.apps.moneydance.model.io.FileUtils;
import com.seanreilly.apps.moneydance.model.io.QIFDataReader;
import com.seanreilly.apps.moneydance.model.io.QIFDataWriter;
import com.seanreilly.apps.moneydance.view.MoneydanceUI;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.SplashWindow;
import com.seanreilly.util.VersionVerifier;
import com.seanreilly.util.VersionVerifierCallback;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFrame;

public class Main
implements StatusMonitor,
VersionVerifierCallback {
    private static Main mainController = null;
    public static final String FILE_EXTENSION = "md";
    public static final String APPLICATION_NAME = "moneydance";
    public static final String DESCRIPTIVE_NAME = "Moneydance 2.0b5";
    public static final String CURRENT_VERSION = "2.0";
    private static final double CURRENT_VERSION_NUM = 2.0;
    public static boolean DEBUG = false;
    private static String initialFile = null;
    private MoneydanceUI ui;
    private RootAccount currentAccount = null;
    private File currentAccountFile = null;
    private ResourceBundle myResources = null;
    private UserPreferences preferences = null;
    private SplashWindow splashWindow;
    private boolean silentlyCheckVersion = true;

    public static Main getMainController() {
        return mainController;
    }

    public UserPreferences getPreferences() {
        return this.preferences;
    }

    public ResourceBundle getResources() {
        return this.myResources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].trim();
            if (string.length() > 0) {
                if (string.startsWith("-")) {
                    if (string.equals("-d")) {
                        DEBUG = true;
                    } else if (string.equals("-v") || string.equals("-V") || string.equals("--version")) {
                        System.out.println(DESCRIPTIVE_NAME);
                        return;
                    }
                } else if (initialFile == null) {
                    initialFile = string;
                } else {
                    System.err.println("ignoring argument: " + string);
                }
            }
            ++n;
        }
        try {
            mainController = new Main();
            mainController.initialize(stringArray);
            mainController.startApplication();
            mainController.checkVersion(true);
            return;
        }
        catch (Exception exception) {
            System.err.println("Unable to start moneydance: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(String[] stringArray) throws Exception {
        boolean bl = Common.initializeGlobals();
        this.splashWindow = new SplashWindow(new JFrame(), "com/seanreilly/apps/moneydance/images/splash.gif", -1);
        this.splashWindow.setVisible(true);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
        }
        this.setStatus("Loading Moneydance...");
        this.preferences = new UserPreferences();
        try {
            if (this.preferences.doesExist()) {
                this.preferences.readSettings();
            } else {
                this.setStatus("No preferences file found, using defaults...");
            }
        }
        catch (Exception exception) {
            this.setStatus("Error reading preferences: " + exception);
        }
        this.myResources = this.preferences.getResources();
        this.setStatus(this.myResources.getString("loading..."));
        String string = this.preferences.getSetting("current_version");
        if (string == null && !bl) {
            RootAccount rootAccount;
            this.setStatus(this.myResources.getString("upgrading_data..."));
            AccountUpgrader accountUpgrader = new AccountUpgrader();
            this.currentAccount = rootAccount = accountUpgrader.getAccountInfo(this);
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        this.preferences.setSetting("current_version", CURRENT_VERSION);
    }

    public void checkVersion(boolean bl) {
        this.silentlyCheckVersion = bl;
        if (this.preferences.getSetting("check_version_at_startup", "n").equals("y")) {
            VersionVerifier versionVerifier = new VersionVerifier("seanreilly.com", APPLICATION_NAME, this, 2.0);
        }
    }

    public void userHasOldVersion(String string, String string2, String[] stringArray) {
        this.ui.showNeedToUpgradeAlert(string, string2, stringArray);
    }

    public void userHasCurrentVersion() {
        if (!this.silentlyCheckVersion) {
            this.ui.showInfoMessage(this.myResources.getString("have_most_recent_version"));
        }
    }

    public void errorCheckingVersion(String string) {
        if (!this.silentlyCheckVersion) {
            this.ui.showErrorMessage(this.myResources.getString("error_checking_version") + ": " + string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startApplication() {
        String string;
        this.ui = new MoneydanceGUI();
        if (this.currentAccount == null && this.currentAccountFile == null && initialFile != null) {
            try {
                this.currentAccountFile = new File(initialFile);
                this.currentAccount = FileUtils.readAccountsFromFile(this.currentAccountFile, this);
            }
            catch (Exception exception) {
                this.currentAccountFile = null;
                this.currentAccount = null;
            }
        } else if (this.currentAccount == null && this.currentAccountFile == null && this.preferences.getSetting("restore_desktop_on_startup", "y").equals("y") && (string = this.preferences.getSetting("current_account_file")) != null) {
            try {
                this.currentAccountFile = new File(string);
                this.currentAccount = FileUtils.readAccountsFromFile(this.currentAccountFile, this);
            }
            catch (Exception exception) {
                this.currentAccountFile = null;
                this.currentAccount = null;
            }
        }
        if (this.currentAccount != null) {
            this.ui.setCurrentAccount(this.currentAccount, this.currentAccountFile);
        }
        this.splashWindow.setVisible(false);
        this.splashWindow.dispose();
        this.splashWindow = null;
        this.ui.go();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCurrentAccount() {
        File file = this.currentAccountFile;
        if (file == null) {
            file = this.ui.askForAccountFileToSave();
        }
        if (file == null) {
            return;
        }
        try {
            FileUtils.writeAccountsToFile(this.currentAccount, file, this);
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace(System.err);
            }
            this.ui.showErrorMessage(this.myResources.getString("error_saving_file") + ": " + exception);
            return;
        }
        this.currentAccountFile = file;
    }

    public void setCurrentAccount(RootAccount rootAccount, File file) {
        this.currentAccount = rootAccount;
        this.currentAccountFile = file;
        if (this.ui != null) {
            this.ui.setCurrentAccount(this.currentAccount, this.currentAccountFile);
        }
    }

    public RootAccount getCurrentAccount() {
        return this.currentAccount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveCurrentAccountAs() {
        File file = this.ui.askForAccountFileToSave();
        if (file == null) {
            return;
        }
        try {
            FileUtils.writeAccountsToFile(this.currentAccount, file, this);
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace(System.err);
            }
            this.ui.showErrorMessage(this.myResources.getString("error_saving_file") + ": " + exception);
            return;
        }
        this.currentAccountFile = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openAccountFile(File file) {
        try {
            this.currentAccount = FileUtils.readAccountsFromFile(file, this);
            this.currentAccountFile = file;
            this.setCurrentAccount(this.currentAccount, file);
            return;
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace(System.err);
            }
            this.ui.showErrorMessage(this.myResources.getString("error_opening_file") + ": " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        block3: {
            boolean bl = this.preferences.getSetting("save_workspace_on_exit", "yes").equals("yes");
            if (this.ui != null) {
                this.ui.shutdown(bl);
            }
            this.saveWorkSpace();
            try {
                this.preferences.writeSettings();
            }
            catch (Exception exception) {
                if (!DEBUG) break block3;
                System.err.println("Error saving settings: " + exception);
            }
        }
        System.exit(0);
    }

    public void saveWorkSpace() {
        if (this.currentAccountFile != null) {
            this.preferences.setSetting("current_account_file", this.currentAccountFile.getAbsolutePath());
        }
    }

    public void setPercentComplete(float f) {
        if (this.splashWindow != null) {
            this.splashWindow.setProgressValue((int)(f * 100.0f));
        }
    }

    public void setStatus(String string) {
        if (this.splashWindow != null) {
            this.splashWindow.setStatusText(string);
        }
    }

    public void importQIFIntoAccount(RootAccount rootAccount, File file, CurrencyType currencyType, Account account) throws Exception {
        QIFDataReader qIFDataReader = new QIFDataReader(rootAccount, file, currencyType, account);
        qIFDataReader.readTransactions(this);
    }

    public void importQIFIntoNewAccount(RootAccount rootAccount, File file, CurrencyType currencyType) throws Exception {
        QIFDataReader qIFDataReader = new QIFDataReader(rootAccount, file, currencyType);
        qIFDataReader.readTransactions(this);
    }

    public void exportAllAccountsIntoQIF(RootAccount rootAccount, File file, CurrencyType currencyType) throws Exception {
        System.err.println("can't export just yet... sorry.");
        QIFDataWriter qIFDataWriter = new QIFDataWriter(rootAccount, file, currencyType);
        qIFDataWriter.writeAllAccounts();
    }

    public void exportAccountIntoQIF(RootAccount rootAccount, File file, Account account, CurrencyType currencyType) throws Exception {
        QIFDataWriter qIFDataWriter = new QIFDataWriter(rootAccount, file, currencyType);
        qIFDataWriter.writeAccount(account);
        System.err.println("can't export just yet... sorry.");
    }
}

