/* ------------------------------------------------------------------ */
/*
 * Lock
 *
 * Lock this file from other Steward processes
 *
 */

TRUE = 1
FALSE = 0

Lock: 

parse arg FileName

/* first open the lock file */
LockName = FileName'.lock'
rc = stream(LockName, 'C', 'OPEN')

/* Make sure we loop until we can open the lock file */
parse var rc state ':' code
/* We only loop for a 32 code which means someone else has it open */
do while state = 'NOTREADY' & code = '32'
  call SysSleep 1
  rc = stream(LockName, 'C', 'OPEN')
  parse var rc state ':'
  end

/* Make sure we actually opened it and didn't get an error message */
if state <> 'READY' then return FALSE

return TRUE

/* ------------------------------------------------------------------ */
