/* Filename: getright.cmd
*/
/* Description : Simple REXX script to execute GetRight under OS/2 with
*/
/*                JDK 1.1.1 or higher
*/
/* Installation: Just place it in the GetRight directory (this is the
*/
/*               directory with the followung sub-directory:
*/
/*                    /images
*/
/*
*/
/*
*/
/*                                        (w) von Alexander Hoff
*/
/*                                                N.E.W.S. GbR
*/
/*                                                Herrenhof 13
*/
/*                                                41515 Grevenbroich
*/
/*                                                Germany
*/
/*                                                Email: AHoff@news-gbr.de
*/
/*
*/

      /* load  REXX functions */
if RxFuncQuery('SysLoadFuncs') then do
 call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'
 call SysLoadFuncs
end

'@echo off'

setlocal

   /* get current drive and directory */
 parse upper source . . sourcefile
getrightdrive = filespec('DRIVE', sourcefile)
getrighthelp = filespec('PATH', sourcefile)
getrightpath = getrightdrive''getrighthelp

   /* setup environment variables */
'set classpath='getrightpath'getrightapp.jar;%CLASSPATH%'

     /* start the GetRight */
'java GetRight4J_DLM'

endlocal
exit

/*---------------------------------------------------------------------*/
/* Subroutines                                                         */
/*---------------------------------------------------------------------*/
GetValue: Procedure             /* Obtain an environment variable      */
  Arg EnvVal .
  res  = value(EnvVal,,'OS2ENVIRONMENT')
Return res
