/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageViewer
extends Canvas {
    protected Image image;
    protected String fileName;
    protected URL url;
    protected boolean centerMode;

    public ImageViewer() {
        this.image = null;
        this.fileName = null;
    }

    public ImageViewer(String string) throws MalformedURLException {
        this.setFileName(string);
    }

    public ImageViewer(URL uRL) {
        this.setURL(uRL);
    }

    public ImageViewer(Image image) {
        this.setImage(image);
    }

    public void setFileName(String string) {
        try {
            this.fileName = string;
            this.setURL(new URL(this.fileName));
        }
        catch (MalformedURLException malformedURLException) {}
        this.repaint();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
        this.fileName = null;
        Image image = this.getToolkit().getImage(this.url);
        if (image != null) {
            this.setImage(image);
            this.repaint();
        }
    }

    public URL getURL() {
        return this.url;
    }

    public void setCenterMode(boolean bl) {
        this.centerMode = bl;
        this.invalidate();
    }

    public boolean getCenterMode() {
        return this.centerMode;
    }

    public void setImage(Image image) {
        this.fileName = null;
        this.image = image;
        if (image != null) {
            try {
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(this.image, 0);
                mediaTracker.waitForID(0);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            Dimension dimension = this.size();
            graphics.clipRect(0, 0, dimension.width, dimension.height);
            int n = 0;
            int n2 = 0;
            if (this.centerMode) {
                n += (dimension.width - this.image.getWidth(this)) / 2;
                n2 += (dimension.height - this.image.getHeight(this)) / 2;
            }
            graphics.drawImage(this.image, n, n2, this);
        }
    }

    public Dimension preferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }
        return new Dimension(10, 10);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }
}

