/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import symantec.itools.awt.AlignStyle;
import symantec.itools.awt.BevelStyle;

public class ProgressBar
extends Canvas
implements BevelStyle,
AlignStyle {
    public static final int INDENT_ZERO = 0;
    public static final int INDENT_ONE = 1;
    public static final int INDENT_TWO = 2;
    private int align;
    private int type;
    private int progress;
    private Color color1;
    private Color color2;
    private Color textColor = Color.black;
    private Color borderedColor = Color.black;
    private Color progressColor = Color.blue;
    private boolean bShowProgress = true;
    private boolean bDrawBoxes = false;
    private int boxWidth = 10;
    private int gapWidth = 2;
    private FontMetrics fm;
    private int xTemp;
    private int yTemp;
    private int indent;

    public ProgressBar() {
        this(1, 3, 0);
    }

    public ProgressBar(int n, int n2, int n3) {
        this.setBorderIndent(n3, false);
        this.setBevelStyle(n2);
        this.setAlignStyle(n);
    }

    public void setProgressBarColor(Color color) {
        this.progressColor = color;
        this.invalidate();
    }

    public Color getProgressBarColor() {
        return this.progressColor;
    }

    public void setProgressBarTextColor(Color color) {
        this.textColor = color;
        this.invalidate();
    }

    public Color getProgressBarTextColor() {
        return this.textColor;
    }

    public boolean getDrawBoxes() {
        return this.bDrawBoxes;
    }

    public void setDrawBoxes(boolean bl) {
        this.bDrawBoxes = bl;
        this.invalidate();
    }

    public void setBoxWidth(int n) {
        this.boxWidth = n;
        this.invalidate();
    }

    public int getBoxWidth() {
        return this.boxWidth;
    }

    public void setGapWidth(int n) {
        this.gapWidth = n;
        this.invalidate();
    }

    public int getGapWidth() {
        return this.gapWidth;
    }

    public boolean getShowProgress() {
        return this.bShowProgress;
    }

    public void setShowProgress(boolean bl) {
        this.bShowProgress = bl;
        this.invalidate();
    }

    public void setAlignStyle(int n) {
        this.align = n;
        this.invalidate();
    }

    public int getAlignStyle() {
        return this.align;
    }

    public void setBevelStyle(int n) {
        this.type = n;
        switch (this.type) {
            case 0: {
                this.color1 = Color.black;
                this.color2 = Color.white;
                break;
            }
            case 2: {
                this.color1 = this.borderedColor;
                this.color2 = this.borderedColor;
                break;
            }
            case 1: {
                this.color1 = Color.white;
                this.color2 = Color.black;
                break;
            }
            default: {
                this.color2 = null;
                this.color1 = null;
            }
        }
        this.invalidate();
    }

    public int getBevelStyle() {
        return this.type;
    }

    public void setBorderIndent(int n) {
        this.setBorderIndent(n, true);
    }

    private void setBorderIndent(int n, boolean bl) {
        this.indent = n < 0 ? 0 : (n > 2 ? 2 : n);
        if (bl) {
            this.repaint();
        }
    }

    public int getBorderIndent() {
        return this.indent;
    }

    public void setBorderedColor(Color color) {
        this.borderedColor = color;
        if (this.type == 2) {
            this.color1 = color;
            this.color2 = color;
        }
        this.invalidate();
    }

    public Color getBorderedColor() {
        return this.borderedColor;
    }

    public void updateProgress(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        this.progress = n;
        this.repaint();
    }

    public void setValue(int n) {
        this.updateProgress(n);
    }

    public int getValue() {
        return this.progress;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        Color color = graphics.getColor();
        if (this.color1 != null) {
            graphics.clipRect(0, 0, rectangle.width, rectangle.height);
            graphics.setColor(this.color1);
            graphics.drawLine(1 + this.indent, this.indent, rectangle.width - 3 - this.indent, this.indent);
            graphics.setColor(this.color2);
            graphics.drawLine(1 + this.indent, rectangle.height - 1 - this.indent, rectangle.width - 3 - this.indent, rectangle.height - 1 - this.indent);
            graphics.setColor(this.color1);
            graphics.drawLine(this.indent, this.indent, this.indent, rectangle.height - 1 - this.indent);
            graphics.setColor(this.color2);
            graphics.drawLine(rectangle.width - 2 - this.indent, this.indent, rectangle.width - 2 - this.indent, rectangle.height - 1 - this.indent);
            graphics.clipRect(1 + this.indent, 1 + this.indent, rectangle.width - 3 - this.indent, rectangle.height - 2 - this.indent);
            this.yTemp = 1 + this.indent;
        } else {
            graphics.setColor(this.getBackground());
            graphics.drawRect(this.indent, this.indent, rectangle.width - 2 - this.indent, rectangle.height - 1 - this.indent);
            graphics.clipRect(2, 1, rectangle.width - 3, rectangle.height - 2);
            this.yTemp = 1;
        }
        graphics.setColor(this.progressColor);
        if (this.bDrawBoxes) {
            int n = this.boxWidth + this.gapWidth;
            int n2 = this.boxWidth * 100 / rectangle.width;
            int n3 = 0;
            int n4 = 0;
            while (n2 < this.progress) {
                graphics.setColor(this.progressColor);
                graphics.fillRect(n * n4, 1, this.boxWidth, rectangle.height - 2);
                graphics.setColor(this.getBackground());
                graphics.fillRect(n * n4 + this.boxWidth, 1, this.gapWidth, rectangle.height - 2);
                n3 = n * ++n4;
                n2 = (n3 + this.boxWidth) * 100 / rectangle.width;
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(n3 + 1, 1, rectangle.width - n3 - 1, rectangle.height - 1);
        } else {
            graphics.fillRect(1, 1, rectangle.width * this.progress / 100, rectangle.height - 1);
            graphics.setColor(this.getBackground());
            graphics.fillRect(1 + rectangle.width * this.progress / 100, 1, rectangle.width - rectangle.width * this.progress / 100, rectangle.height - 1);
        }
        if (this.bShowProgress) {
            this.fm = this.getFontMetrics(this.getFont());
            this.yTemp = (rectangle.height + this.fm.getAscent()) / 2 - 2;
            graphics.setColor(this.textColor);
            String string = Integer.toString(this.progress) + "%";
            this.xTemp = (rectangle.width - this.fm.stringWidth(string)) / 2;
            switch (this.align) {
                case 0: {
                    if (this.type == 3) {
                        graphics.drawString(string, 4, this.yTemp);
                        break;
                    }
                    graphics.drawString(string, 8, this.yTemp);
                    break;
                }
                case 2: {
                    this.xTemp = rectangle.width - this.fm.stringWidth(string);
                    if (this.type == 3) {
                        graphics.drawString(string, this.xTemp - 6, this.yTemp);
                        break;
                    }
                    graphics.drawString(string, this.xTemp - 10, this.yTemp);
                    break;
                }
                case 1: {
                    this.xTemp = (rectangle.width - this.fm.stringWidth(string)) / 2;
                    if (this.type == 3) {
                        graphics.drawString(string, this.xTemp, this.yTemp);
                        break;
                    }
                    graphics.drawString(string, this.xTemp, this.yTemp);
                    break;
                }
            }
        }
        graphics.setColor(color);
    }

    public Dimension preferredSize() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.minimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension minimumSize() {
        this.fm = this.getFontMetrics(this.getFont());
        return new Dimension(50, this.fm.getHeight() + 4);
    }
}

