/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Insets;
import java.util.Vector;
import symantec.beans.Beans;
import symantec.itools.awt.BaseTabbedPanel;

public class TabPanel
extends BaseTabbedPanel {
    Vector vPanels = new Vector();
    String[] labels;
    boolean bOsHack;

    public TabPanel() {
        this(0, 0);
    }

    public TabPanel(boolean bl) {
        this(bl ? 0 : 1, bl ? 0 : 1);
    }

    public TabPanel(int n, int n2) {
        super(n, n2);
        String string = System.getProperty("os.name");
        if (string.equals("Windows 95")) {
            this.bOsHack = true;
            return;
        }
        this.bOsHack = false;
    }

    public int addTabPanel(String string, boolean bl, Component component) {
        this.vPanels.addElement(component);
        return this.addTab(string, bl);
    }

    public int getCurrentPanelNdx() {
        return this.curIndex;
    }

    public void setCurrentPanelNdx(int n) {
        this.showTabPanel(n);
        if (!Beans.isDesignTime()) {
            this.curIndex = n;
        }
    }

    public Component add(Component component) {
        return this.add(component, -1);
    }

    private String createDefaultLabel(int n) {
        String string = "tab - ";
        string = string + String.valueOf(n);
        return string;
    }

    public synchronized Component add(Component component, int n) {
        int n2 = this.addTabPanel(this.createDefaultLabel(this.vPanels.size()), true, component);
        if (n2 == this.curIndex || Beans.isDesignTime()) {
            this.showTabPanel(n2);
        }
        this.updatePanelLabels();
        return component;
    }

    public synchronized Component add(String string, Component component) {
        return component;
    }

    public synchronized void remove(Component component) {
        int n = this.getPanelTabIndex(component);
        if (this.countTabs() == 1) {
            this.removeAllTabPanels();
            return;
        }
        if (n == 0) {
            this.showTabPanel(1);
        } else {
            this.showTabPanel(n - 1);
        }
        this.removeTabPanel(n);
    }

    public void setPanelLabels(String[] stringArray) {
        this.labels = stringArray;
        this.updatePanelLabels();
    }

    public String[] getPanelLabels() {
        return this.labels;
    }

    public void updatePanelLabels() {
        try {
            int n = 0;
            while (n < this.vPanels.size()) {
                String string;
                if (this.labels != null) {
                    try {
                        string = this.labels[n];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        string = this.createDefaultLabel(n);
                    }
                } else {
                    string = this.createDefaultLabel(n);
                }
                this.setLabel(string, n);
                ++n;
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void setTabsOnBottom(boolean bl) {
        this.setTabsInfo(bl ? 1 : 0, bl ? 1 : 0);
        this.layout();
    }

    public boolean getTabsOnBottom() {
        return this.getTabsPosition() != 0;
    }

    public synchronized void setTabPanel(String string, boolean bl, Component component, int n) {
        if (n < 0 || n >= this.vPanels.size()) {
            return;
        }
        if (n == this.currentTabIndex() && !bl) {
            return;
        }
        try {
            this.vPanels.setElementAt(component, n);
            this.setTab(string, bl, n);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public synchronized Component getTabPanel(int n) {
        if (n < 0 || n >= this.vPanels.size()) {
            return null;
        }
        Component component = null;
        try {
            component = (Component)this.vPanels.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return component;
    }

    public synchronized int getPanelTabIndex(Component component) {
        return this.vPanels.indexOf(component);
    }

    public synchronized void showTabPanel(int n) {
        if (this.tabIsEnabled(n)) {
            try {
                Component component = (Component)this.vPanels.elementAt(n);
                this.showTab(n);
                this.showPanel(component);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
    }

    public synchronized void enableTabPanel(boolean bl, int n) {
        if (n < 0 || n >= this.vPanels.size() || n == this.curIndex) {
            return;
        }
        this.enableTab(bl, n);
    }

    public synchronized void removeTabPanel(int n) {
        if (n < 0 || n >= this.vPanels.size() || n == this.curIndex) {
            return;
        }
        try {
            Component component = (Component)this.vPanels.elementAt(n);
            super.remove(component);
            this.vPanels.removeElementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        this.removeTab(n);
    }

    public synchronized void removeAllTabPanels() {
        this.vPanels = new Vector();
        this.curIndex = -1;
        this.removeAllTabs();
    }

    public int countTabs() {
        return this.vPanels.size();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 1001: {
                if (!(event.target instanceof TabPanel) || event.target != this) break;
                this.showTabPanel(this.currentTabIndex());
                break;
            }
        }
        return super.handleEvent(event);
    }

    public Dimension preferredSize() {
        Component component = null;
        Dimension dimension = null;
        Dimension dimension2 = this.size();
        int n = this.vPanels.size();
        Insets insets = this.insets();
        dimension2.width -= insets.left + insets.right;
        dimension2.height -= insets.top + insets.bottom;
        if (dimension2.width < 0) {
            dimension2.width = 0;
        }
        if (dimension2.height < 0) {
            dimension2.height = 0;
        }
        int n2 = 0;
        while (n2 < n) {
            component = (Component)this.vPanels.elementAt(n2);
            if (component != null) {
                dimension = component.minimumSize();
                if (dimension.width > dimension2.width) {
                    dimension2.width = dimension.width;
                }
                if (dimension.height > dimension2.height) {
                    dimension2.height = dimension.height;
                }
                dimension = component.preferredSize();
                if (dimension.width > dimension2.width) {
                    dimension2.width = dimension.width;
                }
                if (dimension.height > dimension2.height) {
                    dimension2.height = dimension.height;
                }
            }
            ++n2;
        }
        dimension2.width += insets.left + insets.right;
        dimension2.height += insets.top + insets.bottom;
        return dimension2;
    }

    public Dimension minimumSize() {
        Component component = null;
        Dimension dimension = null;
        Dimension dimension2 = new Dimension(0, 0);
        int n = this.vPanels.size();
        int n2 = 0;
        while (n2 < n) {
            component = (Component)this.vPanels.elementAt(n2);
            if (component != null) {
                dimension = component.minimumSize();
                if (dimension.width > dimension2.width) {
                    dimension2.width = dimension.width;
                }
                if (dimension.height > dimension2.height) {
                    dimension2.height = dimension.height;
                }
            }
            ++n2;
        }
        Insets insets = this.insets();
        dimension2.width += insets.left + insets.right;
        dimension2.height += insets.top + insets.bottom;
        return dimension2;
    }
}

