/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.util.BitSet;
import java.util.Date;
import java.util.Vector;
import symantec.beans.Beans;
import symantec.itools.awt.Cell;
import symantec.itools.awt.CompareCells;
import symantec.itools.awt.Matrix;
import symantec.itools.awt.MatrixEnumeration;

public class MultiList
extends Panel {
    public static final long CLICKTHRESHOLD = 250L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    static CompareCells func = new CompareCells();
    Color colorBg = Color.white;
    Color colorFg = Color.black;
    Color colorHBg = Color.blue;
    Color colorHFg = Color.white;
    Matrix cells = new Matrix();
    boolean multiSelect = false;
    int[] splitters;
    String[] headings;
    int[] align;
    Image[] cellIm;
    int[] columnSizes;
    Color headingBg = Color.lightGray;
    Color headingFg = Color.black;
    Font headingFont;
    Font cellFont;
    Scrollbar sb;
    int cursor;
    int colClick = -1;
    int memoryClick = -1;
    long clickTime;
    BitSet highlightedRows = new BitSet();
    int selectedRow;
    int topRow;
    int dragColumn = -1;
    int xDragLast = -1;
    boolean isDragging;
    int headingHeight;
    int cellHeight;
    int cellAscent;
    int cellDescent;
    int clickMargin = 5;
    int currentCursor;
    Image im;
    Graphics gg;
    int height = -1;
    int width = -1;
    int sbPosition;
    long scrollbarTimer;

    public MultiList() {
        this(0, false, Color.white);
    }

    public MultiList(int n) {
        this(n, false, Color.white);
    }

    public MultiList(int n, boolean bl) {
        this(n, bl, Color.white);
    }

    public MultiList(int n, boolean bl, Color color) {
        this.createColumns(n);
        this.multiSelect = bl;
        this.setLayout(new BorderLayout());
        this.setHeadingFont(new Font("Helvetica", 0, 12));
        this.setCellFont(new Font("Helvetica", 0, 12));
        this.colorBg = color;
        this.setBackground(this.colorBg);
        this.sb = new Scrollbar(1);
        this.sb.hide();
        this.add("East", this.sb);
    }

    public void setColumns(int n) {
        this.createColumns(n);
    }

    public int getColumns() {
        return this.headings.length;
    }

    public void setHeading(String string, int n, int n2) {
        this.headings[n] = string;
        this.splitters[n + 1] = n2;
        this.redraw();
        this.repaint();
    }

    public String getHeading(int n) {
        return this.headings[n];
    }

    public void adjustHeadings() {
        if (this.headings.length == 0) {
            this.createColumns(0);
            ((Component)this).invalidate();
            return;
        }
        Dimension dimension = this.size();
        int n = 0;
        int n2 = dimension.width / this.headings.length;
        this.splitters[0] = 0;
        int n3 = 0;
        while (n3 < this.headings.length) {
            this.splitters[n3 + 1] = n += n2;
            ++n3;
        }
    }

    public void setHeadings(String[] stringArray) {
        if (stringArray.length == 0) {
            this.createColumns(0);
            ((Component)this).invalidate();
        } else {
            Dimension dimension = this.size();
            int n = 0;
            int n2 = dimension.width / stringArray.length;
            this.splitters[0] = 0;
            this.createColumns(stringArray.length);
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.setHeading(stringArray[n3], n3, n += n2);
                ++n3;
            }
        }
        this.redraw();
        this.repaint();
    }

    public String[] getHeadings() {
        return this.headings;
    }

    public void setHeadingFont(Font font) {
        this.headingFont = font;
        this.headingHeight = this.getFontMetrics(font).getHeight() + 4;
        this.redraw();
        this.repaint();
    }

    public Font getHeadingFont() {
        return this.headingFont;
    }

    public void setCellFont(Font font) {
        this.cellFont = font;
        this.cellAscent = this.getFontMetrics(font).getAscent();
        this.cellDescent = this.getFontMetrics(font).getDescent();
        this.cellHeight = this.getFontMetrics(font).getHeight();
        this.redraw();
        this.repaint();
    }

    public Font getCellFont() {
        return this.cellFont;
    }

    public void setHeadingColors(Color color, Color color2) {
        this.headingFg = color;
        this.headingBg = color2;
        this.redraw();
        this.repaint();
    }

    public void setHeadingFg(Color color) {
        this.headingFg = color;
        this.redraw();
        this.repaint();
    }

    public void setHeadingBg(Color color) {
        this.headingBg = color;
        this.redraw();
        this.repaint();
    }

    public Color getHeadingFg() {
        return this.headingFg;
    }

    public Color getHeadingBg() {
        return this.headingBg;
    }

    public void setCellColors(Color color, Color color2) {
        this.colorFg = color;
        this.colorBg = color2;
        this.redraw();
        this.repaint();
    }

    public void setCellFg(Color color) {
        this.colorFg = color;
        this.redraw();
        this.repaint();
    }

    public void setCellBg(Color color) {
        this.colorBg = color;
        this.redraw();
        this.repaint();
    }

    public Color getCellFg() {
        return this.colorFg;
    }

    public Color getCellBg() {
        return this.colorBg;
    }

    public String[] getColumnAlignments() {
        String[] stringArray = new String[this.align.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.align[n] == 0 ? "Left" : (this.align[n] == 1 ? "Center" : (this.align[n] == 2 ? "Right" : "Left"));
            ++n;
        }
        return stringArray;
    }

    public void setColumnAlignments(String[] stringArray) {
        if (stringArray.length > 0) {
            this.align = new int[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                this.align[n] = stringArray[n] != null ? (stringArray[n].equalsIgnoreCase("Left") ? 0 : (stringArray[n].equalsIgnoreCase("Center") ? 1 : (stringArray[n].equalsIgnoreCase("Right") ? 2 : 0))) : 0;
                ++n;
            }
            return;
        }
        this.align = new int[this.headings.length];
        int n = 0;
        while (n < this.headings.length) {
            this.align[n] = 0;
            ++n;
        }
    }

    public String[] getColumnSizes() {
        String[] stringArray = new String[this.columnSizes.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                stringArray[n] = String.valueOf(this.columnSizes[n]);
            }
            catch (Exception exception) {
                stringArray[n] = "";
            }
            ++n;
        }
        return stringArray;
    }

    public void setColumnSizes(String[] stringArray) {
        if (stringArray.length > 0) {
            this.columnSizes = new int[stringArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                block6: {
                    try {
                        if (stringArray[n2] != null) {
                            this.columnSizes[n2] = Integer.parseInt(stringArray[n2]);
                            if (this.splitters.length >= n2) {
                                this.splitters[n2 + 1] = n += this.columnSizes[n2];
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.columnSizes[n2] = 10;
                        if (this.splitters.length < n2) break block6;
                        this.splitters[n2 + 1] = n += 10;
                    }
                }
                ++n2;
            }
            this.splitters[0] = 0;
            return;
        }
        this.columnSizes = null;
        this.adjustHeadings();
    }

    public int getColumnSize(int n) {
        return this.splitters[n];
    }

    public void setColumnAlignment(int n, int n2) {
        this.align[n] = n2;
    }

    public int getNumberofCols() {
        return this.headings.length;
    }

    public void setSelectedRow(int n) throws IllegalArgumentException {
        if (n > this.cells.rows()) {
            throw new IllegalArgumentException(n + " is not a valid row number");
        }
        this.selectedRow = n;
        this.redraw();
        this.repaint();
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public int[] getSelectedRows() {
        int n = this.highlightedRows.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.highlightedRows.get(n3)) {
                ++n2;
            }
            ++n3;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (this.highlightedRows.get(n4)) {
                nArray[n2++] = n4;
            }
            ++n4;
        }
        return nArray;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        long l;
        int n3;
        if (n2 < this.headingHeight) {
            n3 = 1;
            while (n3 < this.headings.length) {
                if (n < this.splitters[n3] + this.clickMargin && n > this.splitters[n3] - this.clickMargin) {
                    this.dragColumn = n3;
                    this.isDragging = true;
                    this.mouseDrag(event, n, n2);
                    return true;
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.headings.length) {
                int n5;
                int n6 = n5 = n4 == this.headings.length - 1 ? this.size().width : this.splitters[n4 + 1];
                if (n > this.splitters[n4] && n < n5) {
                    this.colClick = n4;
                    this.drawHeading(true);
                    this.repaint();
                    return true;
                }
                ++n4;
            }
        }
        if (n > this.width) {
            return false;
        }
        n3 = this.selectedRow;
        this.changeSelection((n2 - this.headingHeight - 4) / this.cellHeight + this.topRow, event.modifiers);
        if ((this.selectedRow == n3 || n3 < 0) && (l = event.when - this.clickTime) < 250L) {
            this.postEvent(1001, this.selectedRow);
        }
        this.clickTime = event.when;
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        Dimension dimension = this.size();
        if (!this.isDragging) {
            if (this.colClick > -1) {
                int n3 = this.colClick == 0 ? 0 : this.splitters[this.colClick];
                int n4 = this.colClick == this.headings.length - 1 ? dimension.width : this.splitters[this.colClick + 1];
                if (n < n3 || n > n4 || n2 > this.headingHeight || n2 < 0) {
                    this.memoryClick = this.colClick;
                    this.colClick = -1;
                    this.drawHeading(false);
                    this.repaint();
                }
            } else if (this.memoryClick > -1) {
                int n5 = this.memoryClick == 0 ? 0 : this.splitters[this.memoryClick];
                int n6 = this.memoryClick == this.headings.length - 1 ? dimension.width : this.splitters[this.memoryClick + 1];
                if (n > n5 && n < n6 && n2 < this.headingHeight && n2 > 0) {
                    this.colClick = this.memoryClick;
                    this.memoryClick = -1;
                    this.drawHeading(false);
                    this.repaint();
                }
            }
            return true;
        }
        if (n < 0) {
            n = 0;
        }
        this.gg.setColor(this.colorBg);
        this.gg.setXORMode(Color.black);
        this.gg.drawLine(this.xDragLast, 0, this.xDragLast, dimension.height);
        this.gg.drawLine(n, 0, n, dimension.height);
        this.gg.setColor(Color.black);
        this.gg.setPaintMode();
        this.xDragLast = n;
        this.repaint();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.isDragging) {
            if (n < 0) {
                n = 0;
            }
            this.gg.setColor(this.colorBg);
            this.gg.setXORMode(Color.black);
            this.gg.drawLine(this.xDragLast, 0, this.xDragLast, this.size().height);
            this.gg.setColor(Color.black);
            this.gg.setPaintMode();
            this.xDragLast = -1;
            this.isDragging = false;
            this.splitters[this.dragColumn] = n;
            this.redraw();
            this.repaint();
            return true;
        }
        if (this.colClick != -1) {
            this.highlightedRows = new BitSet();
            this.selectedRow = -1;
            this.cells.sort(func, this.colClick);
            this.colClick = -1;
            this.redraw();
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        Frame frame;
        int n3;
        boolean bl = false;
        if (n2 < this.headingHeight) {
            n3 = 1;
            while (n3 < this.headings.length) {
                if (n < this.splitters[n3] + this.clickMargin && n > this.splitters[n3] - this.clickMargin) {
                    bl = true;
                }
                ++n3;
            }
        }
        int n4 = n3 = bl ? 10 : 0;
        if (n3 != this.currentCursor && (frame = this.frame()) != null) {
            this.currentCursor = n3;
            frame.setCursor(this.currentCursor);
        }
        return false;
    }

    public boolean keyDown(Event event, int n) {
        switch (n) {
            case 1005: {
                if (this.selectedRow >= this.cells.rows() - 1) break;
                this.changeSelection(this.selectedRow + 1, event.modifiers);
                break;
            }
            case 1003: {
                this.changeSelection(this.selectedRow + this.getPageSize(), event.modifiers);
                break;
            }
            case 1004: {
                if (this.selectedRow <= 0) break;
                this.changeSelection(this.selectedRow - 1, event.modifiers);
                break;
            }
            case 1002: {
                this.changeSelection(this.selectedRow - this.getPageSize(), event.modifiers);
                break;
            }
            case 10: {
                if (this.selectedRow <= -1) break;
                this.postEvent(1001, this.selectedRow);
                break;
            }
        }
        return false;
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.sb && event.arg != null) {
            Date date = new Date();
            event.when = date.getTime();
            if (event.when - this.scrollbarTimer < 300L && event.id == 605) {
                return false;
            }
            this.scrollbarTimer = event.when;
            if (this.topRow != this.sb.getValue()) {
                this.sbPosition = this.topRow = this.sb.getValue();
                this.redraw();
                this.repaint();
            }
        }
        return super.handleEvent(event);
    }

    public void createColumns(int n) {
        this.headings = new String[n];
        this.align = new int[n];
        this.splitters = new int[n + 1];
        this.cellIm = new Image[n];
        this.columnSizes = null;
    }

    public void clear() {
        this.cells.removeAllElements();
        this.xDragLast = -1;
        this.isDragging = false;
        this.selectedRow = 0;
        this.highlightedRows = new BitSet();
        this.topRow = 0;
    }

    public void addTextCell(int n, int n2, String string) {
        Cell cell = new Cell(this, string);
        this.cells.updateElement(n, n2, cell);
        this.repaint();
    }

    public void addImageCell(int n, int n2, Image image) {
        Cell cell = new Cell(this, image);
        this.cells.updateElement(n, n2, cell);
        this.repaint();
    }

    public void addCell(int n, int n2, String string, Image image) {
        Cell cell = new Cell(this, string, image);
        this.cells.updateElement(n, n2, cell);
        this.repaint();
    }

    public String getCellText(int n, int n2) {
        Cell cell = (Cell)this.cells.elementAt(n, n2);
        if (cell != null) {
            return cell.text;
        }
        return null;
    }

    public void setListItems(String[] stringArray) {
        this.clear();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string == null) {
                string = new String("");
            }
            int n2 = string.length();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 <= n2 && n4 < this.headings.length) {
                if (n5 == n2 || string.charAt(n5) == ';') {
                    this.addCell(n, n4++, string.substring(n3, n5), null);
                    n3 = n5 + 1;
                }
                ++n5;
            }
            while (n4 < this.headings.length) {
                this.addCell(n, n4++, "", null);
            }
            ++n;
        }
        this.redraw();
        this.repaint();
    }

    public String[] getListItems() {
        new Vector();
        String[] stringArray = new String[this.cells.rows()];
        int n = 0;
        while (n < this.cells.rows()) {
            String string = "";
            int n2 = 0;
            while (n2 < this.headings.length) {
                String string2 = this.getCellText(n, n2);
                if (n2 != 0) {
                    string = string + ";";
                }
                string = string + (string2 != null ? string2 : "");
                ++n2;
            }
            stringArray[n] = string;
            ++n;
        }
        return stringArray;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void checkClipping(Graphics graphics) {
        Rectangle rectangle = graphics.getClipRect();
        Dimension dimension = this.size();
        if (rectangle.x != 0 || rectangle.y != 0 || rectangle.width != dimension.width || rectangle.height != dimension.height) {
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        this.checkClipping(graphics);
        Font font = graphics.getFont();
        Dimension dimension = this.size();
        if (font == null) {
            font = this.headingFont;
            ((Component)this).setFont(font);
            return;
        }
        if (this.width != dimension.width || this.height != dimension.height || Beans.isDesignTime()) {
            this.redraw();
        }
        graphics.drawImage(this.im, 0, 0, this);
    }

    public void redraw() {
        Dimension dimension = this.size();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        if (this.width != dimension.width || this.height != dimension.height) {
            this.width = dimension.width;
            this.height = dimension.height;
            this.im = this.createImage(this.width, this.height);
            if (this.gg != null) {
                this.gg.dispose();
            }
            this.gg = this.im.getGraphics();
        }
        this.gg.setColor(this.colorBg);
        this.gg.fillRect(0, 0, this.width, this.height);
        if (this.cellHeight > 0 && this.cells.rows() * this.cellHeight > this.height - this.headingHeight) {
            this.sb.setValues(this.sbPosition, this.height / this.cellHeight, 0, this.cells.rows() - 1);
            this.sb.setPageIncrement(1);
            this.sb.show();
            this.getParent().paintAll(this.getParent().getGraphics());
        } else {
            this.topRow = 0;
            this.sb.hide();
        }
        this.gg.setFont(this.headingFont);
        this.drawHeading(false);
        int n = this.topRow + (this.cellHeight > 0 ? (this.height - 3) / this.cellHeight - 1 : 0);
        if (n > this.cells.rows()) {
            n = this.cells.rows();
        }
        this.gg.setFont(this.cellFont);
        this.drawRows(0, n, this.topRow);
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.columnSizes == null) {
            this.adjustHeadings();
        }
    }

    void drawRows(int n, int n2, int n3) {
        MatrixEnumeration matrixEnumeration = this.cells.elements();
        Cell cell = null;
        int n4 = this.headings.length;
        if (n3 > 0) {
            cell = (Cell)matrixEnumeration.advanceTo(n3);
        }
        while (matrixEnumeration.hasMoreElements() || cell != null) {
            int n5 = 0;
            while (n5 < n4) {
                int n6 = n5 < n4 - 1 ? this.splitters[n5 + 1] - this.splitters[n5] : this.size().width - this.splitters[n5] - 4;
                int n7 = n5 == 0 ? 1 : this.splitters[n5] - 3;
                this.gg.setColor(this.highlightedRows.get(n3) ? this.colorHBg : this.colorBg);
                this.gg.fillRect(n7, this.headingHeight + n * this.cellHeight + 4, n6 + 4, this.cellHeight);
                this.gg.setColor(this.highlightedRows.get(n3) ? this.colorHFg : this.colorFg);
                if (cell == null) {
                    cell = (Cell)matrixEnumeration.nextElement();
                }
                if (cell != null && matrixEnumeration.currRow() == n3 && matrixEnumeration.currCol() == n5) {
                    cell.drawCell(this.gg, this.align[n5], this.splitters[n5] + 3, this.headingHeight + n * this.cellHeight + 4, n6, this.cellHeight, this.cellAscent);
                    cell = null;
                }
                if (cell != null && matrixEnumeration.currRow() < n3) {
                    cell = null;
                }
                ++n5;
            }
            if (--n2 == 0) break;
            ++n3;
            ++n;
        }
    }

    boolean postEvent(int n, int n2) {
        return this.postEvent(new Event(this, n, new Integer(n2)));
    }

    int getPageSize() {
        return this.size().height / this.cellHeight;
    }

    void draw3DBox(Rectangle rectangle, boolean bl) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        this.gg.setColor(bl ? Color.black : Color.white);
        this.gg.drawLine(n3, n2, n3, n4);
        this.gg.drawLine(n3 + 1, n2, n3 + 1, n4);
        this.gg.drawLine(n, n4, n3, n4);
        this.gg.drawLine(n, n4 + 1, n3, n4 + 1);
        this.gg.setColor(bl ? Color.white : Color.gray);
        this.gg.drawLine(n, n2, n3 - 2, n2);
        this.gg.drawLine(n, n2, n, n4 - 1);
    }

    void drawHeading(boolean bl) {
        int n = 1;
        int n2 = 1;
        Font font = this.getFont();
        this.gg.setFont(this.headingFont);
        FontMetrics fontMetrics = this.gg.getFontMetrics();
        Dimension dimension = this.size();
        int n3 = 0;
        while (n3 < this.headings.length) {
            int n4;
            int n5;
            n = this.splitters[n3];
            if (n3 < this.headings.length - 1) {
                n5 = this.splitters[n3 + 1];
                n4 = n5 - n;
            } else {
                n5 = dimension.width;
                n4 = n5 - n;
            }
            Rectangle rectangle = new Rectangle(n, n2, n4 - 2, this.headingHeight);
            this.draw3DBox(rectangle, this.colClick != n3);
            this.gg.setColor(this.headingBg);
            this.gg.fillRect(rectangle.x + 1, rectangle.y + 1, n4 - 3, this.headingHeight - 1);
            this.gg.setColor(this.headingFg);
            if (this.headings[n3] != null) {
                int n6 = fontMetrics.stringWidth(this.headings[n3]);
                int n7 = n4 - 3;
                int n8 = bl && this.colClick == n3 ? 1 : 0;
                switch (this.align[n3]) {
                    case 0: {
                        this.gg.drawString(this.headings[n3], n + 8 + n8, this.headingHeight - 3 + n8);
                        break;
                    }
                    case 1: {
                        if (n6 > n7) {
                            this.gg.drawString(this.headings[n3], n + 8 + n8, this.headingHeight - 3 + n8);
                            break;
                        }
                        this.gg.drawString(this.headings[n3], n + (n7 - n6) / 2 + n8, this.headingHeight - 3 + n8);
                        break;
                    }
                    case 2: {
                        if (n6 > n7) {
                            this.gg.drawString(this.headings[n3], n + 8 + n8, this.headingHeight - 3 + n8);
                            break;
                        }
                        this.gg.drawString(this.headings[n3], n + n7 - n6 - 6 + n8, this.headingHeight - 3 + n8);
                        break;
                    }
                }
                if (this.colClick == n3) {
                    this.gg.drawLine(rectangle.x + 1, this.headingHeight + 2, n5 - 3, this.headingHeight + 2);
                }
            }
            ++n3;
        }
        this.gg.setColor(Color.black);
        this.gg.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        this.gg.setFont(font);
    }

    Frame frame() {
        Container container = this;
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    void changeSelection(int n, int n2) {
        int n3;
        block17: {
            block16: {
                if (!this.multiSelect) break block16;
                switch (n2) {
                    case 2: {
                        if (this.highlightedRows.get(n)) {
                            this.highlightedRows.clear(n);
                            break;
                        }
                        this.highlightedRows.set(n);
                        break;
                    }
                    case 1: {
                        n3 = Math.min(this.selectedRow, n);
                        while (n3 <= Math.max(this.selectedRow, n)) {
                            if (n3 >= 0) {
                                this.highlightedRows.set(n3);
                            }
                            ++n3;
                        }
                        break block17;
                    }
                    default: {
                        this.highlightedRows = new BitSet();
                        this.highlightedRows.set(n);
                        break;
                    }
                }
                break block17;
            }
            if (this.selectedRow >= 0) {
                this.highlightedRows.clear(this.selectedRow);
            }
            this.highlightedRows.set(n);
        }
        n3 = this.cells.rows();
        if (n > n3 - 1) {
            n = n3 - 1;
        } else if (n < 0) {
            n = 0;
        }
        if (n < this.topRow) {
            this.topRow = n - 1;
            if (this.topRow < 0) {
                this.topRow = 0;
            }
            this.sbPosition = this.topRow;
            this.sb.setValue(this.sbPosition);
        }
        if (n >= -1 + this.topRow + this.getPageSize()) {
            ++this.topRow;
            if (this.topRow > n3 - 1) {
                this.topRow = n;
            }
            this.sbPosition = this.topRow;
            this.sb.setValue(this.sbPosition);
        }
        if (this.selectedRow != n && n2 > 0) {
            this.postEvent(702, this.selectedRow);
        }
        this.selectedRow = n;
        this.redraw();
        this.repaint();
        this.postEvent(701, n);
    }

    public synchronized Dimension preferredSize() {
        return new Dimension(175, 125);
    }

    public synchronized Dimension minimumSize() {
        return new Dimension(50, 50);
    }
}

