/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import symantec.itools.awt.CompareFunc;
import symantec.itools.awt.MatrixEnumeration;

class Matrix {
    Matrix rowHead;
    Matrix nextRow;
    Matrix nextElt;
    int row;
    int col;
    Object o;
    static boolean debug;

    public Matrix() {
        this.rowHead = this;
    }

    private Matrix(int n, int n2, Object object) {
        this(n, n2, object, null);
    }

    private Matrix(int n, int n2, Object object, Matrix matrix, Matrix matrix2, Matrix matrix3) {
        this.rowHead = matrix == null ? (n2 != 0 ? new Matrix(n, 0, null, null, matrix2, this) : this) : matrix;
        this.row = n;
        this.col = n2;
        this.o = object;
        this.nextRow = matrix2;
        this.nextElt = matrix3;
    }

    private Matrix(int n, int n2, Object object, Matrix matrix, Matrix matrix2) {
        this(n, n2, object, null, matrix, matrix2);
    }

    private Matrix(int n, int n2, Object object, Matrix matrix) {
        this(n, n2, object, null, matrix, null);
    }

    public void removeAllElements() {
        this.nextRow = null;
        this.nextElt = null;
        this.o = null;
    }

    public void addElement(int n, int n2, Object object) throws IllegalArgumentException {
        if (debug) {
            this.checkPrecondition(n, n2);
        }
        Matrix matrix = this.nearest(n, n2);
        if (matrix.row != n) {
            matrix.setNextRow(new Matrix((int)n, (int)n2, (Object)object, (Matrix)matrix.nextRow).rowHead);
            return;
        }
        if (n2 == matrix.col && n2 == 0) {
            if (matrix.o != null) {
                throw new IllegalArgumentException("Element already in Matrix");
            }
            matrix.o = object;
            return;
        }
        matrix.nextElt = new Matrix(n, n2, object, matrix.rowHead, matrix.nextRow, matrix.nextElt);
    }

    void setNextRow(Matrix matrix) {
        Matrix matrix2 = this;
        while (matrix2 != null) {
            matrix2.nextRow = matrix;
            matrix2 = matrix2.nextElt;
        }
    }

    public void updateElement(int n, int n2, Object object) {
        Matrix matrix = this.nearest(n, n2);
        try {
            if (matrix == null) {
                this.addElement(n, n2, object);
                return;
            }
            if (matrix.row != n || matrix.col != n2) {
                matrix.addElement(n, n2, object);
                return;
            }
            matrix.o = object;
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return;
        }
    }

    Matrix nearest(int n, int n2) {
        Matrix matrix = this;
        while (n > matrix.row) {
            if (matrix.nextRow != null && matrix.nextRow.row <= n) {
                matrix = matrix.nextRow;
                continue;
            }
            return matrix;
        }
        while (matrix.nextElt != null && n2 >= matrix.nextElt.col) {
            matrix = matrix.nextElt;
        }
        return matrix;
    }

    public Object elementAt(int n, int n2) throws NullPointerException {
        Matrix matrix = this.nearest(n, n2);
        if (matrix == null || matrix.row != n || matrix.col != n2 || matrix.o == null) {
            throw new NullPointerException("Element row: " + n + " col=" + n2 + " is not in matrix");
        }
        return matrix.o;
    }

    public void removeElementAt(int n, int n2) {
        Matrix matrix = this.nearest(n, n2);
        if (matrix == null || matrix.row != n || matrix.col != n2) {
            return;
        }
        if (n2 == 0) {
            matrix.o = null;
            return;
        }
        Matrix matrix2 = matrix = matrix.rowHead;
        while (matrix.col != n2) {
            matrix2 = matrix;
            matrix = matrix.nextElt;
        }
        matrix2.nextElt = matrix.nextElt;
    }

    public void removeRow(int n) {
        Matrix matrix = this.nearest(n, 0);
        if (matrix.row == n) {
            matrix = matrix.rowHead;
            matrix.o = null;
            matrix.nextElt = null;
        }
    }

    public void insertRow(int n) {
        Matrix matrix;
        if (n == 0) {
            matrix = new Matrix();
            matrix.setNextRow(this);
        } else {
            matrix = this.nearest(n - 1, 0);
            Matrix matrix2 = new Matrix(n, 0, null, matrix.nextRow);
            matrix.setNextRow(matrix2);
            matrix = matrix2;
        }
        if (matrix.nextRow.row == n) {
            matrix = matrix.nextRow;
            while (matrix != null) {
                matrix.updateRowNum(++n);
                matrix = matrix.nextRow;
                if (matrix.row == n) continue;
                return;
            }
        }
    }

    public void sort(CompareFunc compareFunc, int n) {
        this.compact();
        boolean bl = true;
        Matrix matrix = this;
        Matrix matrix2 = null;
        while (matrix != null) {
            matrix2 = this.findLeast(compareFunc, matrix, n, bl);
            if (matrix2 != null) {
                if (matrix.row == 0 && bl) {
                    bl = false;
                    this.swapRows(matrix2);
                    matrix = this;
                    continue;
                }
                this.swapRows(matrix, matrix2);
            }
            if (bl) {
                bl = false;
                continue;
            }
            matrix = matrix.nextRow;
        }
        this.compact();
    }

    Matrix findLeast(CompareFunc compareFunc, Matrix matrix, int n, boolean bl) {
        if (!bl) {
            matrix = matrix.nextRow;
        }
        if (matrix == null || matrix.nextRow == null) {
            return null;
        }
        Matrix matrix2 = matrix.nextRow.rowHead;
        Matrix matrix3 = matrix.rowHead;
        Matrix matrix4 = null;
        matrix = matrix.nearest(matrix.row, n);
        while (matrix2 != null) {
            matrix2 = matrix2.nearest(matrix2.row, n);
            if (matrix2.col != n) {
                matrix3 = matrix2.rowHead;
                matrix2 = matrix2.nextRow;
                continue;
            }
            if (matrix.col != n) {
                matrix = matrix2;
                matrix4 = matrix3;
                continue;
            }
            if (compareFunc.lessThan(matrix2.o, matrix.o)) {
                matrix = matrix2;
                matrix4 = matrix3;
            }
            matrix3 = matrix2.rowHead;
            matrix2 = matrix2.nextRow;
        }
        return matrix4;
    }

    protected void swapRows(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = matrix.nextRow;
        Matrix matrix4 = matrix3.nextRow;
        Matrix matrix5 = matrix2.nextRow;
        Matrix matrix6 = matrix5.nextRow;
        matrix.setNextRow(matrix5);
        matrix2.setNextRow(matrix3);
        if (matrix2 == matrix3) {
            matrix5.setNextRow(matrix3);
        } else {
            matrix5.setNextRow(matrix4);
        }
        matrix3.setNextRow(matrix6);
        int n = matrix3.row;
        matrix3.updateRowNum(matrix5.row);
        matrix5.updateRowNum(n);
    }

    protected void swapRows(Matrix matrix) {
        Matrix matrix2 = matrix.nextRow;
        Matrix matrix3 = new Matrix(-1, matrix2.col, this.o, null, this.nextElt);
        matrix.rowHead.setNextRow(matrix3);
        matrix3.setNextRow(matrix2.nextRow);
        matrix3.updateRowNum(matrix2.row);
        matrix3.setRowHead();
        this.nextElt = matrix2.nextElt;
        this.o = matrix2.o;
        this.setNextRow(this.nextRow);
        this.updateRowNum(0);
        this.setRowHead();
    }

    void setRowHead() {
        Matrix matrix = this.nextElt;
        Matrix matrix2 = this;
        while (matrix != null) {
            matrix.rowHead = matrix2;
            matrix = matrix.nextElt;
        }
    }

    public void printRow(int n) {
        Matrix matrix = this.nearest(n, 0);
        if (matrix.row != n) {
            matrix = matrix.nextRow;
            if (matrix.row != n) {
                System.out.println("Row " + n + " is not in the matrix");
                return;
            }
        }
        System.out.println("-------- Printing row " + n + " ----------");
        while (matrix != null) {
            System.out.println("Row=" + matrix.row + "  Col=" + matrix.col + "  value=" + matrix.o);
            matrix = matrix.nextElt;
        }
    }

    public void compact() {
        int n = 0;
        Matrix matrix = this;
        Matrix matrix2 = null;
        while (matrix != null) {
            if (matrix.nextElt == null && matrix.o == null) {
                matrix = matrix.nextRow;
                continue;
            }
            matrix.updateRowNum(n++);
            if (matrix2 != null && matrix2.nextRow != matrix) {
                matrix2.setNextRow(matrix);
            }
            matrix2 = matrix;
            matrix = matrix.nextRow;
        }
    }

    public int rows() {
        this.compact();
        Matrix matrix = this;
        while (matrix.nextRow != null) {
            matrix = matrix.nextRow;
        }
        return matrix.row + 1;
    }

    private void updateRowNum(int n) {
        Matrix matrix = this;
        while (matrix != null) {
            matrix.row = n;
            matrix = matrix.nextElt;
        }
    }

    MatrixEnumeration elements() {
        return new MatrixEnumeration(this);
    }

    public String toString() {
        return "Matrix: row=" + this.row + " col=" + this.col + " o=" + this.o;
    }

    private void checkPrecondition(int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n2 < 0 || n < this.row || n2 < this.col) {
            throw new IllegalArgumentException("Failed precondition check: r=" + n + " c=" + n2);
        }
    }
}

