/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.util.Vector;

public class KeyPressManagerPanel
extends Panel {
    public static final int PLAIN = 0;
    public static final int SHIFT = 1;
    public static final int CTRL = 2;
    Vector tabbed;
    Button defaultButton;
    Button cancelButton;
    Event defaultEvent;
    Event cancelEvent;
    Event[] fKeyEvents = new Event[36];
    Container defaultDeliver;
    Container cancelDeliver;
    Container[] fKeyDeliver = new Container[36];
    boolean bDefaultSetFocus;
    boolean bCancelSetFocus;
    boolean bTabHack;
    boolean bAutoTab = true;
    Event eventLostFocus;

    public KeyPressManagerPanel() {
        this.resetKeyManager();
    }

    public void setAutoTabState(boolean bl) {
        this.bAutoTab = bl;
    }

    public boolean getAutoTabState() {
        return this.bAutoTab;
    }

    public synchronized boolean handleEvent(Event event) {
        switch (event.id) {
            case 403: {
                int n = event.key - 1008;
                switch (event.modifiers) {
                    case 1: {
                        n += 12;
                        break;
                    }
                    case 2: {
                        n += 24;
                        break;
                    }
                    default: {
                        n = -1;
                    }
                    case 0: 
                }
                if (n <= -1 || n >= 36 || this.fKeyEvents[n] == null) break;
                this.deliverEventTo(this.fKeyEvents[n], this.fKeyDeliver[n]);
                return true;
            }
            case 401: {
                this.bTabHack = false;
                if (!this.keyPressed(event)) break;
                return true;
            }
            case 1005: {
                if (!(event.target instanceof TextComponent)) break;
                this.eventLostFocus = event;
                this.bTabHack = true;
                break;
            }
            case 402: {
                if (!this.bTabHack) break;
                this.bTabHack = false;
                this.eventLostFocus.key = event.key;
                this.eventLostFocus.modifiers = event.modifiers;
                if (!this.keyPressed(this.eventLostFocus)) break;
                return true;
            }
        }
        return super.handleEvent(event);
    }

    boolean keyPressed(Event event) {
        switch (event.key) {
            case 9: {
                if (event.target instanceof Component) {
                    return this.doTab((Component)event.target, event.modifiers);
                }
                return this.doTab(this, event.modifiers);
            }
            case 10: {
                if (this.defaultButton == null || !this.defaultButton.isEnabled()) break;
                if (this.bDefaultSetFocus) {
                    this.defaultButton.requestFocus();
                }
                this.deliverEventTo(this.defaultEvent, this.defaultDeliver);
                return true;
            }
            case 27: {
                if (this.cancelButton == null || !this.cancelButton.isEnabled()) break;
                if (this.bCancelSetFocus) {
                    this.cancelButton.requestFocus();
                }
                this.deliverEventTo(this.cancelEvent, this.cancelDeliver);
                return true;
            }
        }
        return false;
    }

    public void resetKeyManager() {
        this.tabbed = new Vector();
        this.defaultButton = null;
        this.cancelButton = null;
        this.defaultEvent = null;
        this.cancelEvent = null;
        this.defaultDeliver = null;
        this.cancelDeliver = null;
        this.bDefaultSetFocus = false;
        this.bCancelSetFocus = false;
        int n = 0;
        while (n < 36) {
            this.fKeyEvents[n] = null;
            this.fKeyDeliver[n] = null;
            ++n;
        }
    }

    public Component add(Component component) {
        if (this.bAutoTab && !(component instanceof Label)) {
            this.setTabStop(component);
        }
        return super.add(component);
    }

    public void removeDefaultButton() {
        this.defaultButton = null;
        this.defaultEvent = null;
        this.defaultDeliver = null;
        this.bDefaultSetFocus = false;
    }

    public void setTabStop(Component component) {
        if (component != this) {
            this.tabbed.addElement(component);
        }
    }

    public void setDefaultButton(Button button) {
        this.setDefaultButton(button, new Event(button, 1001, null), null, true);
    }

    public void setDefaultButton(Button button, Event event, Container container, boolean bl) {
        this.defaultButton = button;
        this.defaultEvent = event;
        this.defaultDeliver = container;
        this.bDefaultSetFocus = bl;
        button.requestFocus();
    }

    public void setCancelButton(Button button) {
        this.setCancelButton(button, new Event(button, 1001, null), null, true);
    }

    public void setCancelButton(Button button, Event event, Container container, boolean bl) {
        this.cancelButton = button;
        this.cancelEvent = event;
        this.bCancelSetFocus = bl;
        this.cancelDeliver = container;
    }

    public void removeCancelButton() {
        this.cancelButton = null;
        this.cancelEvent = null;
        this.cancelDeliver = null;
        this.bCancelSetFocus = false;
    }

    public void setFKeyEvent(int n, Event event, Container container) {
        this.setFKeyEvent(n, 0, event, container);
    }

    public void removeFKeyEvent(int n) {
        this.removeFKeyEvent(n, 0);
    }

    public void setFKeyEvent(int n, int n2, Event event, Container container) {
        int n3 = n - 1008;
        if (n3 < 0 || n3 > 11) {
            return;
        }
        switch (n2) {
            case 1: {
                n3 += 12;
                break;
            }
            case 2: {
                n3 += 24;
                break;
            }
        }
        this.fKeyEvents[n3] = event;
        this.fKeyDeliver[n3] = container;
    }

    public void removeFKeyEvent(int n, int n2) {
        int n3 = n - 1008;
        if (n3 < 0 || n3 > 11) {
            return;
        }
        switch (n2) {
            case 1: {
                n3 += 12;
                break;
            }
            case 2: {
                n3 += 24;
                break;
            }
        }
        this.fKeyEvents[n3] = null;
        this.fKeyDeliver[n3] = null;
    }

    void deliverEventTo(Event event, Container container) {
        if (container == null) {
            this.postEvent(event);
            return;
        }
        container.postEvent(event);
    }

    boolean doTab(Component component, int n) {
        int n2 = this.tabbed.size();
        if (n2 > 0 && (n == 0 || n == 1)) {
            int n3;
            Component component2 = null;
            int n4 = n3 = this.tabbed.indexOf(component);
            if (n3 == -1) {
                Component component3 = component;
                while (component3 != this && n3 == -1) {
                    n3 = this.tabbed.indexOf(component3);
                    component3 = component3.getParent();
                }
            }
            if (n3 == -1) {
                if (n == 0) {
                    this.doTab((Component)this.tabbed.lastElement(), n);
                } else {
                    this.doTab((Component)this.tabbed.firstElement(), n);
                }
                return true;
            }
            int n5 = n3;
            while (true) {
                if (n == 0) {
                    if (++n3 == n2) {
                        n3 = 0;
                    }
                } else if (--n3 == -1) {
                    n3 = n2 - 1;
                }
                if (n5 == n3) break;
                try {
                    Component component4;
                    component2 = (Component)this.tabbed.elementAt(n3);
                    if (!component2.isEnabled()) continue;
                    component2.requestFocus();
                    if (component2 instanceof TextComponent) {
                        component4 = (TextComponent)component2;
                        ((TextComponent)component4).selectAll();
                    }
                    component4 = (Component)this.tabbed.elementAt(n4);
                    Event event = new Event(component4, 1005, null);
                    component4.postEvent(event);
                    component2 = (Component)this.tabbed.elementAt(n3);
                    Event event2 = new Event(component2, 1004, null);
                    component2.postEvent(event2);
                    return true;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    continue;
                }
                break;
            }
        }
        return false;
    }
}

