/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import symantec.itools.awt.ButtonBase;
import symantec.itools.lang.OS;

public class DirectionButton
extends ButtonBase {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    private int direction;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private int indent;
    private Polygon poly;

    public DirectionButton() {
        this(0);
    }

    public DirectionButton(int n) {
        this.direction = n;
        this.left = 0;
        this.right = 0;
        this.bottom = 0;
        this.indent = 0;
        this.poly = null;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setArrowIndent(int n) {
        this.indent = n;
        this.invalidate();
    }

    public int getArrowIndent() {
        return this.indent;
    }

    public void shrinkTriangle(int n, int n2, int n3, int n4) {
        this.left = n;
        this.right = n2;
        this.top = n3;
        this.bottom = n4;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.updatePolygon();
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.gray);
        }
        graphics.fillPolygon(this.poly);
    }

    public Dimension preferredSize() {
        Dimension dimension = this.size();
        return new Dimension(Math.max(dimension.width, this.minimumSize().width), Math.max(dimension.height, this.minimumSize().height));
    }

    void updatePolygon() {
        Dimension dimension = this.size();
        this.poly = new Polygon();
        int n = dimension.width / 2 + this.pressedAdjustment;
        int n2 = dimension.height / 2 + this.pressedAdjustment;
        int n3 = this.top + this.bevel * 2 + this.pressedAdjustment + this.indent;
        int n4 = dimension.height - this.bottom - this.bevel * 2 + this.pressedAdjustment - this.indent;
        int n5 = this.left + this.bevel * 2 + this.pressedAdjustment + this.indent;
        int n6 = dimension.width - this.right - this.bevel * 2 + this.pressedAdjustment - this.indent;
        switch (this.direction) {
            case 2: {
                if (OS.isMacintosh()) {
                    this.poly.addPoint(n - 1, n3 - 1);
                    this.poly.addPoint(n5 - 1, n4 - 2);
                    this.poly.addPoint(n6 - 2, n4 - 2);
                    return;
                }
                this.poly.addPoint(n, n3);
                this.poly.addPoint(n5, n4);
                this.poly.addPoint(n6, n4);
                return;
            }
            case 3: {
                if (OS.isMacintosh()) {
                    this.poly.addPoint(n - 1, n4);
                    this.poly.addPoint(n5 - 1, n3);
                    this.poly.addPoint(n6 - 1, n3);
                    return;
                }
                this.poly.addPoint(n, n4);
                this.poly.addPoint(n5, n3);
                this.poly.addPoint(n6, n3);
                return;
            }
            case 0: {
                if (OS.isMacintosh()) {
                    this.poly.addPoint(n5 - 2, n2 - 1);
                    this.poly.addPoint(n6 - 2, n3 - 1);
                    this.poly.addPoint(n6 - 2, n4 - 1);
                    return;
                }
                this.poly.addPoint(n5, n2);
                this.poly.addPoint(n6, n3);
                this.poly.addPoint(n6, n4);
                return;
            }
            case 1: {
                if (OS.isMacintosh()) {
                    this.poly.addPoint(n6 - 1, n2 - 1);
                    this.poly.addPoint(n5, n3 - 1);
                    this.poly.addPoint(n5, n4 - 2);
                    return;
                }
                this.poly.addPoint(n6, n2);
                this.poly.addPoint(n5, n3);
                this.poly.addPoint(n5, n4);
                return;
            }
        }
    }
}

