/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.AWTException;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import symantec.beans.Beans;
import symantec.itools.awt.InfoTipManager;
import symantec.itools.util.Timer;

public abstract class ButtonBase
extends Canvas {
    protected boolean pressed = false;
    protected boolean released = true;
    protected boolean inButton;
    protected boolean notifyWhilePressed = false;
    protected boolean showInfoTip = false;
    protected boolean running = false;
    protected boolean notified = false;
    protected boolean showFocus;
    protected boolean doInfoTip;
    protected int bevel = 1;
    protected int notifyDelay = 1000;
    protected int infoTipDelay = 1000;
    protected int pressedAdjustment = 0;
    protected String infoTipText;
    protected Color infoTipTextColor = Color.black;
    protected Timer notifyTimer = null;
    protected Timer infoTipTimer = null;
    protected int infoTipX;
    protected int infoTipY;
    protected LayoutManager infoTipLayoutManager;

    protected ButtonBase() {
        this.resize(10, 10);
    }

    public void setBevelHeight(int n) {
        try {
            this.checkBevelSize(n);
        }
        catch (AWTException aWTException) {
            System.err.println("Invalid Bevel Size " + n);
        }
        this.bevel = n;
        this.invalidate();
    }

    public int getBevelHeight() {
        return this.bevel;
    }

    public void setNotifyWhilePressed(boolean bl) {
        this.notifyWhilePressed = bl;
        if (this.notifyWhilePressed) {
            this.notifyTimer = new Timer(this, this.notifyDelay, true, 1001);
            return;
        }
        if (this.notifyTimer != null) {
            this.notifyTimer = null;
        }
    }

    public boolean getNotifyWhilePressed() {
        return this.notifyWhilePressed;
    }

    public void setNotifyDelay(int n) {
        this.notifyDelay = n;
    }

    public int getNotifyDelay() {
        return this.notifyDelay;
    }

    public void setShowInfoTip(boolean bl) {
        this.showInfoTip = bl;
        if (this.showInfoTip) {
            this.infoTipTimer = new Timer(this, this.notifyDelay, true, 1001);
            return;
        }
        if (this.infoTipTimer != null) {
            this.infoTipTimer = null;
        }
    }

    public boolean getShowInfoTip() {
        return this.showInfoTip;
    }

    public void setInfoTipDelay(int n) {
        this.infoTipDelay = n;
    }

    public int getInfoTipDelay() {
        return this.infoTipDelay;
    }

    public void setShowFocus(boolean bl) {
        this.showFocus = bl;
    }

    public boolean getShowFocus() {
        return this.showFocus;
    }

    public void setInfoTipText(String string) {
        this.infoTipText = string;
    }

    public String getInfoTipText() {
        return this.infoTipText;
    }

    public void setInfoTipTextColor(Color color) {
        this.infoTipTextColor = color;
    }

    public Color getInfoTipTextColor() {
        return this.infoTipTextColor;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.running) {
            this.running = false;
            this.notifyTimer.stop();
        }
        if (this.pressed) {
            this.pressed = false;
            this.pressedAdjustment = 0;
            if (!this.notifyWhilePressed || !this.notified) {
                this.postEvent(new Event(this, 1001, null));
            }
        }
        this.released = true;
        this.repaint();
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.notifyWhilePressed && !this.running) {
            this.running = true;
            this.notifyTimer.start();
        }
        this.pressed = true;
        this.released = false;
        this.pressedAdjustment = this.bevel;
        this.repaint();
        return true;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.inButton = true;
        if (this.showInfoTip) {
            this.infoTipX = n;
            this.infoTipY = n2;
            this.infoTipTimer.start();
        }
        if (!this.released) {
            this.mouseDown(event, n, n2);
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.inButton = false;
        if (this.showInfoTip) {
            this.infoTipTimer.stop();
            Panel panel = InfoTipManager.getInfoTipPanel();
            panel.getParent().setLayout(this.infoTipLayoutManager);
            panel.hide();
        }
        if (this.pressed) {
            this.pressed = false;
            this.pressedAdjustment = 0;
        }
        return true;
    }

    public boolean action(Event event, Object object) {
        if (this.notifyWhilePressed && event.target == this.notifyTimer && !Beans.isDesignTime()) {
            this.postEvent(new Event(this, 1001, null));
            return true;
        }
        if (this.showInfoTip && event.target == this.infoTipTimer) {
            this.doInfoTip = true;
            this.repaint();
            this.infoTipTimer.stop();
            return true;
        }
        return super.action(event, object);
    }

    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.pressed = false;
            this.pressedAdjustment = 0;
        }
        this.repaint();
    }

    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            if (this.notifyTimer != null) {
                this.notifyTimer.stop();
            }
            if (this.infoTipTimer != null) {
                this.infoTipTimer.stop();
            }
            this.pressed = false;
            this.pressedAdjustment = 0;
        }
        this.repaint();
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.size();
        graphics.clipRect(0, 0, dimension.width, dimension.height);
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = this.bevel + 1;
        int n4 = this.bevel + 1;
        int n5 = n - 1;
        int n6 = n2 - 1;
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, n, n2);
        if (this.pressed) {
            n4 = n3 += this.bevel > 0 ? 2 : 1;
            graphics.setColor(Color.lightGray);
            int n7 = 1;
            while (n7 < this.bevel + 1) {
                graphics.drawLine(n7, n6 - n7, n5 - n7, n6 - n7);
                graphics.drawLine(n5 - n7, n6 - n7, n5 - n7, n7);
                ++n7;
            }
            graphics.setColor(Color.gray);
            n7 = 1;
            while (n7 < this.bevel + 1) {
                graphics.drawLine(n7, n6, n7, n7);
                graphics.drawLine(n7, n7, n5, n7);
                ++n7;
            }
        } else {
            graphics.setColor(Color.white);
            int n8 = 1;
            while (n8 < this.bevel + 1) {
                graphics.drawLine(n8, n6 - n8, n8, n8);
                graphics.drawLine(n8, n8, n5 - n8, n8);
                ++n8;
            }
            graphics.setColor(Color.gray);
            n8 = 1;
            while (n8 < this.bevel + 2) {
                graphics.drawLine(n8, n6 - n8, n5 - n8, n6 - n8);
                graphics.drawLine(n5 - n8, n6 - n8, n5 - n8, n8);
                ++n8;
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(1, 0, n - 2, 0);
        graphics.drawLine(0, 1, 0, n2 - 2);
        graphics.drawLine(1, n2 - 1, n - 2, n2 - 1);
        graphics.drawLine(n - 1, n2 - 2, n - 1, 1);
        if (this.showInfoTip && this.doInfoTip) {
            this.drawInfoTip();
        }
    }

    protected void drawInfoTip() {
        this.doInfoTip = false;
        Point point = this.location();
        Panel panel = InfoTipManager.getInfoTipPanel();
        this.infoTipX += point.x;
        this.infoTipY += point.y;
        this.infoTipLayoutManager = panel.getParent().getLayout();
        InfoTipManager.draw(this.infoTipX, this.infoTipY, this.infoTipText, this.getFontMetrics(this.getFont()), Color.yellow, Color.black);
    }

    private void checkBevelSize(int n) throws AWTException {
        Dimension dimension = this.size();
        if (n < 0 || n >= dimension.width / 2 || n >= dimension.height / 2) {
            throw new AWTException("invalid bevel size");
        }
    }
}

