/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import symantec.itools.awt.AlignStyle;
import symantec.itools.awt.BevelStyle;

public class BorderPanel
extends Panel
implements AlignStyle,
BevelStyle {
    protected static final int labelpadx = 10;
    protected static final int labelipadx = 4;
    protected Color borderColor;
    protected Color labelColor;
    protected int padtop = 10;
    protected int padbottom = 6;
    protected int padleft = 6;
    protected int padright = 6;
    protected int ixPad = 4;
    protected int iyPadTop = 2;
    protected int iyPadBottom = 7;
    protected int style;
    protected String label;
    protected int labelAlignment;
    protected Insets internalInsets;
    protected Panel panel;
    Dimension oldSize = new Dimension();

    public BorderPanel() {
        this(null, 1, 2);
    }

    public BorderPanel(int n) {
        this(null, 1, n);
    }

    public BorderPanel(String string) {
        this(string, 1, 2);
    }

    public BorderPanel(String string, int n) {
        this(string, n, 2);
    }

    public BorderPanel(String string, int n, int n2) {
        this.borderColor = Color.black;
        this.labelColor = Color.black;
        this.label = string != null && string.length() == 0 ? null : string;
        this.labelAlignment = n;
        this.internalInsets = new Insets(10, 10, 10, 10);
        this.style = n2;
        this.setLayout(null);
        this.panel = new Panel();
        super.add(this.panel);
        this.sizepanel(true);
    }

    public void addNotify() {
        super.addNotify();
        this.sizepanel(true);
    }

    public void setPaddingTop(int n) {
        this.padtop = n;
        this.sizepanel(true);
        ((Component)this).invalidate();
    }

    public int getPaddingTop() {
        return this.padtop;
    }

    public void setPaddingBottom(int n) {
        this.padbottom = n;
        this.sizepanel(true);
        ((Component)this).invalidate();
    }

    public int getPaddingBottom() {
        return this.padbottom;
    }

    public void setPaddingLeft(int n) {
        this.padleft = n;
        this.sizepanel(true);
        ((Component)this).invalidate();
    }

    public int getPaddingLeft() {
        return this.padleft;
    }

    public void setPaddingRight(int n) {
        this.padright = n;
        this.sizepanel(true);
        ((Component)this).invalidate();
    }

    public int getPaddingRight() {
        return this.padright;
    }

    public void setIPadTop(int n) {
        this.iyPadTop = n;
        this.sizepanel(true);
        ((Component)this).invalidate();
    }

    public void setIPadBottom(int n) {
        this.iyPadBottom = n;
        this.sizepanel(true);
        ((Component)this).invalidate();
    }

    public int getIPadTop() {
        return this.iyPadTop;
    }

    public void setIPadSides(int n) {
        this.ixPad = n;
        this.sizepanel(true);
        ((Component)this).invalidate();
    }

    public int getIPadBottom() {
        return this.iyPadBottom;
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        this.padtop = n;
        this.padbottom = n2;
        this.padleft = n3;
        this.padright = n4;
        this.sizepanel(true);
        ((Component)this).invalidate();
    }

    public int getIPadSides() {
        return this.ixPad;
    }

    public void setLabel(String string) {
        this.label = string != null && string.length() == 0 ? null : string;
        this.sizepanel(true);
        ((Component)this).invalidate();
    }

    public String getLabel() {
        return this.label;
    }

    public void setBorderColor(Color color, boolean bl) {
        this.borderColor = color;
        if (bl) {
            this.labelColor = color;
        }
        ((Component)this).invalidate();
    }

    public void setBorderColor(Color color) {
        this.setBorderColor(color, false);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setAlignStyle(int n) {
        this.labelAlignment = n;
        this.sizepanel(true);
        ((Component)this).invalidate();
    }

    public int getAlignStyle() {
        return this.labelAlignment;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
        ((Component)this).invalidate();
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setBevelStyle(int n) {
        this.style = n;
        ((Component)this).invalidate();
    }

    public int getBevelStyle() {
        return this.style;
    }

    public void setInternalInsets(Insets insets) {
        this.internalInsets = insets;
        this.sizepanel(true);
        ((Component)this).invalidate();
    }

    public Insets getInternalInsets() {
        return this.internalInsets;
    }

    public void layout() {
        this.sizepanel(false);
        this.panel.layout();
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        Dimension dimension = this.panel.preferredSize();
        dimension.width = Math.max(dimension.width, this.getLabelWidthMargin());
        dimension.width += this.padleft + this.padright + this.ixPad * 2 + 1;
        dimension.height += this.getLabelTopMargin() + this.padbottom + this.iyPadTop + this.iyPadBottom + 1;
        return dimension;
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.panel != null) {
            this.panel.setLayout(layoutManager);
        }
    }

    public LayoutManager getLayout() {
        return this.panel.getLayout();
    }

    public Component add(Component component) {
        return this.panel.add(component);
    }

    public Component add(String string, Component component) {
        return this.panel.add(string, component);
    }

    public Component add(Component component, int n) {
        if (component == this.panel) {
            return super.add(component, n);
        }
        return this.panel.add(component, n);
    }

    public void remove(Component component) {
        this.panel.remove(component);
    }

    public void removeAll() {
        this.panel.removeAll();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.sizepanel(false);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.size();
        Insets insets = this.insets();
        graphics.setColor(this.getBackground());
        if (insets.left > 0) {
            graphics.fillRect(0, 0, insets.left, dimension.height);
        }
        if (insets.top > 0) {
            graphics.fillRect(0, 0, dimension.width, insets.top);
        }
        if (insets.bottom > 0) {
            graphics.fillRect(0, dimension.height - insets.bottom, dimension.width, insets.bottom);
        }
        if (insets.right > 0) {
            graphics.fillRect(dimension.width - insets.right, 0, insets.right, dimension.height);
        }
        this.paint(graphics);
        this.panel.repaint();
    }

    public int countComponents() {
        return this.panel.countComponents();
    }

    public Component getComponent(int n) {
        return this.panel.getComponent(n);
    }

    public Component[] getComponents() {
        return this.panel.getComponents();
    }

    public Insets insets() {
        int n = this.getLabelTopMargin();
        Insets insets = this.getInternalInsets();
        return new Insets(n + insets.top, insets.left, insets.bottom, insets.right);
    }

    void sizepanel(boolean bl) {
        Dimension dimension = this.size();
        if (bl || this.oldSize.width != dimension.width || this.oldSize.height != dimension.height) {
            this.oldSize = this.size();
            this.panel.reshape(this.padleft + this.ixPad, this.getLabelTopMargin() + this.iyPadTop, this.oldSize.width - this.padright - this.padleft - this.ixPad * 2 - 1, this.oldSize.height - this.padbottom - this.getLabelTopMargin() - this.iyPadBottom - this.iyPadTop - 1);
        }
    }

    public void paint(Graphics graphics) {
        this.sizepanel(false);
        graphics.setColor(this.getBackground());
        this.draw(graphics);
    }

    void draw(Graphics graphics) {
        Dimension dimension = this.size();
        int n = this.padtop;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        graphics.clipRect(0, 0, dimension.width, dimension.height);
        if (this.label != null && fontMetrics != null) {
            n = (fontMetrics.getAscent() + fontMetrics.getDescent() + this.padtop) / 2;
        }
        int n2 = this.padleft;
        int n3 = n;
        int n4 = dimension.width - this.padleft - this.padright - 1;
        int n5 = dimension.height - 1 - n - this.padbottom;
        this.drawBorder(graphics, n2, n3, n4, n5);
        this.drawLabel(graphics, fontMetrics);
    }

    void drawBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.style) {
            case 1: {
                graphics.setColor(Color.white);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics.setColor(Color.gray);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
                return;
            }
            case 0: {
                graphics.setColor(Color.gray);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics.setColor(Color.white);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
                return;
            }
            case 2: {
                graphics.setColor(this.borderColor);
                graphics.drawRect(n, n2, n3, n4);
                return;
            }
            default: {
                graphics.setColor(this.borderColor);
                graphics.drawRect(n, n2, n3, n4);
            }
            case 3: 
        }
    }

    void drawLabel(Graphics graphics, FontMetrics fontMetrics) {
        if (this.label != null && fontMetrics != null) {
            int n;
            int n2 = 10;
            Dimension dimension = this.size();
            if (this.getFont().getSize() > n2) {
                n2 += this.getFont().getSize() / 2;
            }
            int n3 = fontMetrics.stringWidth(this.label);
            int n4 = fontMetrics.getAscent();
            int n5 = fontMetrics.getDescent();
            switch (this.labelAlignment) {
                case 1: {
                    n = (dimension.width - n3) / 2;
                    break;
                }
                case 2: {
                    n = dimension.width - n2 - (n3 + 7);
                    break;
                }
                default: {
                    n = n2 + 7;
                }
            }
            int n6 = n4 + n5 + this.padtop;
            int n7 = (n2 - n6) / 2 + (this.padtop + n4);
            graphics.setColor(this.getBackground());
            graphics.fillRect(n - 2, n7 - 1 - n4 - this.padtop / 2, n3 + 4, n6);
            graphics.setColor(this.labelColor);
            graphics.drawString(this.label, n, n7 - 1);
        }
    }

    protected int getLabelTopMargin() {
        if (this.label == null) {
            return this.padtop;
        }
        int n = this.padtop;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            n = fontMetrics.getAscent() + fontMetrics.getDescent() + this.padtop;
        }
        return n;
    }

    int getLabelWidthMargin() {
        if (this.label == null) {
            return 0;
        }
        int n = 2 + this.internalInsets.left + this.internalInsets.right;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            n = Math.max(n, 2 + fontMetrics.stringWidth(this.label) + 10 + 4);
        }
        return n;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.panel.setBackground(color);
    }
}

