/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import symantec.itools.awt.DirectionButton;

public abstract class BaseTabbedPanel
extends Panel {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int ROUNDED = 0;
    public static final int SQUARE = 1;
    private int TF_LEFT = 9;
    private int TF_RIGHT = -9;
    private int TF_TOP = 30;
    private int TF_BOTTOM = -9;
    private int TF_BTN_HEIGHT = 20;
    private Vector vLabels = new Vector();
    private Vector vEnabled = new Vector();
    private Vector vPolys = new Vector();
    protected int curIndex = -1;
    private Font fReg;
    private Font fSel;
    private Component userPanel;
    private int iTabsPosition;
    private int iTabsStyle;
    private int osAdjustment;
    private int firstVisibleTab;
    private DirectionButton dbLeft;
    private DirectionButton dbRight;
    private Polygon nullPoly;
    private int lastWidth = -1;
    private Insets btpInsets = new Insets(0, 0, 0, 0);

    public BaseTabbedPanel() {
        this(0, 0);
    }

    public BaseTabbedPanel(boolean bl) {
        this(bl ? 0 : 1, bl ? 0 : 1);
    }

    public BaseTabbedPanel(int n, int n2) {
        this.setTabsInfo(n, n2);
        this.fReg = new Font("Helvetica", 0, 12);
        this.fSel = new Font("Helvetica", 1, 12);
        this.osAdjustment = System.getProperty("os.name").startsWith("S") ? -1 : 0;
        super.setLayout(null);
        this.dbLeft = new DirectionButton(0);
        this.dbRight = new DirectionButton(1);
        this.dbLeft.setShowFocus(false);
        this.dbRight.setShowFocus(false);
        this.dbLeft.shrinkTriangle(1, 1, 0, 1);
        this.dbRight.shrinkTriangle(1, 1, 0, 1);
        super.add((Component)this.dbLeft, -1);
        super.add((Component)this.dbRight, -1);
        this.nullPoly = new Polygon();
        this.nullPoly.addPoint(0, 0);
        this.nullPoly.addPoint(1, 1);
        this.nullPoly.addPoint(0, 0);
    }

    public void setTabsPosition(int n) {
        if (this.iTabsPosition != n) {
            this.setTabsInfo(n, this.iTabsStyle);
        }
    }

    public int getTabsPosition() {
        return this.iTabsPosition;
    }

    public void setTabsStyle(int n) {
        if (this.iTabsStyle != n) {
            this.setTabsInfo(this.iTabsPosition, n);
        }
    }

    public int getTabsStyle() {
        return this.iTabsStyle;
    }

    public void setTabsInfo(int n, int n2) {
        this.iTabsPosition = n;
        this.iTabsStyle = this.iTabsPosition == 0 ? 0 : n2;
        this.TF_BTN_HEIGHT = this.iTabsStyle == 0 ? 20 : 17;
        this.repaint();
    }

    public void setPanel(Component component) {
        this.removeAll();
        this.userPanel = component;
        if (this.userPanel != null) {
            super.add(this.userPanel, -1);
            this.userPanel.requestFocus();
        }
    }

    public void showPanel(Component component) {
        if (this.userPanel != null) {
            this.userPanel.hide();
        }
        this.userPanel = component;
        if (this.userPanel != null) {
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (componentArray[n2] == this.userPanel) break;
                ++n2;
            }
            if (n2 == n) {
                super.add(this.userPanel, -1);
            }
            this.userPanel.show();
            this.userPanel.requestFocus();
            this.validate();
            this.repaint();
        }
    }

    public int addTab(String string, boolean bl) {
        this.vLabels.addElement(string);
        this.vEnabled.addElement(new Boolean(bl));
        int n = this.vLabels.size() - 1;
        if (this.curIndex == -1 && bl) {
            this.showTab(n);
        }
        return n;
    }

    public synchronized void setTab(String string, boolean bl, int n) {
        if (n < 0 || n >= this.vLabels.size()) {
            return;
        }
        if (n == this.curIndex && !bl) {
            return;
        }
        try {
            this.vLabels.setElementAt(string, n);
            this.vEnabled.setElementAt(new Boolean(bl), n);
            this.repaint();
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public synchronized void setLabel(String string, int n) {
        if (n < 0 || n >= this.vLabels.size()) {
            return;
        }
        try {
            this.vLabels.setElementAt(string, n);
            this.repaint();
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public synchronized String getLabel(int n) {
        if (n < 0 || n >= this.vLabels.size()) {
            return "";
        }
        try {
            return (String)this.vLabels.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public synchronized void setEnabled(boolean bl, int n) {
        if (n < 0 || n >= this.vLabels.size()) {
            return;
        }
        if (n == this.curIndex && !bl) {
            return;
        }
        try {
            this.vEnabled.setElementAt(new Boolean(bl), n);
            this.repaint();
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public void showTab(int n) {
        if (n < 0 || n >= this.vLabels.size() || n == this.curIndex) {
            return;
        }
        if (this.tabIsEnabled(n)) {
            this.curIndex = n;
            ((Component)this).invalidate();
            this.validate();
            this.repaint();
            this.postEvent(new Event(this, 1001, null));
        }
    }

    public boolean tabIsEnabled(int n) {
        if (n < 0 || n >= this.vLabels.size()) {
            return false;
        }
        try {
            Boolean bl = (Boolean)this.vEnabled.elementAt(n);
            if (bl.booleanValue()) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return false;
    }

    public int currentTabIndex() {
        return this.curIndex;
    }

    public void enableTab(boolean bl, int n) {
        if (n < 0 || n >= this.vEnabled.size() || n == this.curIndex) {
            return;
        }
        try {
            this.vEnabled.setElementAt(new Boolean(bl), n);
            this.repaint();
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public void removeTab(int n) {
        if (n < 0 || n >= this.vEnabled.size() || n == this.curIndex) {
            return;
        }
        try {
            this.vLabels.removeElementAt(n);
            this.vEnabled.removeElementAt(n);
            this.repaint();
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public void removeAllTabs() {
        this.vLabels = new Vector();
        this.vEnabled = new Vector();
        this.vPolys = new Vector();
        this.curIndex = -1;
        this.firstVisibleTab = 0;
        this.lastWidth = -1;
        this.removeAll();
        this.repaint();
    }

    public void layout() {
        Rectangle rectangle = this.bounds();
        int n = rectangle.width - this.TF_LEFT + this.TF_RIGHT;
        if (n < 0) {
            return;
        }
        int n2 = rectangle.height - this.TF_TOP + this.TF_BOTTOM;
        if (n2 < 0) {
            return;
        }
        int n3 = this.TF_LEFT;
        int n4 = 0;
        n4 = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        if (this.userPanel != null) {
            this.userPanel.reshape(n3 + 3, n4 + 3, n - 6, n2 - 5);
            this.userPanel.invalidate();
            this.userPanel.validate();
            if (this.userPanel instanceof Canvas || this.userPanel instanceof Panel) {
                this.userPanel.repaint();
                return;
            }
            this.repaint();
        }
    }

    public synchronized void paint(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        int n = rectangle.width - this.TF_LEFT + this.TF_RIGHT;
        if (n < 0) {
            return;
        }
        int n2 = rectangle.height - this.TF_TOP + this.TF_BOTTOM;
        if (n2 < 0) {
            return;
        }
        if (rectangle.width > this.lastWidth) {
            this.firstVisibleTab = 0;
        }
        this.lastWidth = rectangle.width;
        int n3 = this.TF_LEFT;
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        int n4 = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        graphics.setColor(Color.white);
        graphics.drawLine(n3, n4, n3 + n - 1, n4);
        graphics.drawLine(n3, n4, n3, n4 + n2 - 1);
        graphics.setColor(Color.gray);
        graphics.drawLine(n3 + 2, n4 + n2 - 2, n3 + n - 2, n4 + n2 - 2);
        graphics.drawLine(n3 + n - 2, n4 + 2, n3 + n - 2, n4 + n2 - 2);
        graphics.setColor(Color.black);
        graphics.drawLine(n3 + 1, n4 + n2 - 1, n3 + n - 1, n4 + n2 - 1);
        graphics.drawLine(n3 + n - 1, n4 + 1, n3 + n - 1, n4 + n2 - 1);
        int n5 = this.TF_LEFT + 8;
        int n6 = 0;
        int n7 = this.TF_LEFT;
        int n8 = this.vLabels.size();
        this.vPolys.removeAllElements();
        Font font = graphics.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(this.fReg);
        FontMetrics fontMetrics2 = this.getFontMetrics(this.fSel);
        int n9 = 0;
        int n10 = 0;
        while (n10 < this.firstVisibleTab) {
            this.vPolys.addElement(this.nullPoly);
            ++n10;
        }
        if (n10 > 0) {
            n7 += 2;
        }
        while (n10 < n8) {
            Polygon polygon = new Polygon();
            try {
                int n11;
                int n12;
                int n13;
                String string = (String)this.vLabels.elementAt(n10);
                n9 = n10 == this.curIndex ? fontMetrics2.stringWidth(string) : fontMetrics.stringWidth(string);
                if (this.iTabsPosition == 0) {
                    n13 = this.TF_TOP - this.TF_BTN_HEIGHT;
                    n12 = this.TF_TOP - 1;
                } else {
                    n13 = rectangle.height + this.TF_BOTTOM + 1;
                    n12 = rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT;
                }
                if (this.iTabsStyle == 0) {
                    n11 = n7 + 2;
                    n5 = n11 + n9 + 13;
                } else {
                    n11 = n5 - 7;
                    n5 = n11 + n9 + 28;
                }
                if (n5 + 36 - this.TF_RIGHT > rectangle.width) break;
                if (this.iTabsPosition == 0) {
                    if (n10 == this.curIndex) {
                        n13 -= 3;
                        n11 -= 2;
                    }
                    graphics.setColor(Color.white);
                    if (this.curIndex == n10 + 1) {
                        graphics.drawLine(n11 + 2, n13, n5 - 2, n13);
                    } else {
                        graphics.drawLine(n11 + 2, n13, n5, n13);
                    }
                    if (this.curIndex != n10 - 1) {
                        graphics.drawLine(n11, n13 + 2, n11, n12);
                        n6 = n11;
                    } else {
                        n6 = n11 + 1;
                    }
                    graphics.drawLine(n11 + 1, n13 + 1, n11 + 1, n13 + 1);
                    if (this.curIndex != n10 + 1) {
                        graphics.setColor(Color.gray);
                        graphics.drawLine(n5, n13, n5, n12);
                        graphics.setColor(Color.black);
                        graphics.drawLine(n5 + 1, n13 + 2, n5 + 1, n12);
                        n7 = n5;
                    } else {
                        n7 = n5 - 1;
                    }
                } else if (this.iTabsStyle == 1) {
                    graphics.setColor(Color.gray);
                    graphics.drawLine(n11 + 9, n13, n5 - 9, n13);
                    graphics.setColor(Color.black);
                    if (n10 == 0 || n10 == this.curIndex) {
                        graphics.drawLine(n11, n12, n11 + 9, n13);
                        polygon.addPoint(n11, n12);
                    } else {
                        graphics.drawLine(n11 + 4, n13 - 9, n11 + 9, n13);
                        polygon.addPoint(n11 + 9, n12);
                        polygon.addPoint(n11 + 4, n13 - 9);
                    }
                    polygon.addPoint(n11 + 9, n13);
                    polygon.addPoint(n5 - 9, n13);
                    if (n10 + 1 == this.curIndex) {
                        graphics.drawLine(n5 - 5, n13 - 9, n5 - 9, n13);
                        polygon.addPoint(n5 - 5, n13);
                        polygon.addPoint(n5 - 9, n12);
                    } else {
                        graphics.drawLine(n5, n12, n5 - 9, n13);
                        polygon.addPoint(n5, n12);
                    }
                    if (n10 == 1 || n10 == this.curIndex) {
                        polygon.addPoint(n11, n12);
                    } else {
                        polygon.addPoint(n11 + 9, n12);
                    }
                } else {
                    if (n10 == this.curIndex) {
                        n13 += 3;
                        n11 -= 2;
                    }
                    graphics.setColor(Color.white);
                    if (this.curIndex == n10 + 1) {
                        graphics.drawLine(n11 + 2, n13, n5 - 2, n13);
                    } else {
                        graphics.drawLine(n11 + 2, n13, n5, n13);
                    }
                    if (this.curIndex != n10 - 1) {
                        graphics.drawLine(n11, n13 - 2, n11, n12);
                        n6 = n11;
                    } else {
                        n6 = n11 + 1;
                    }
                    graphics.drawLine(n11 + 1, n13 - 1, n11 + 1, n13 - 1);
                    if (this.curIndex != n10 + 1) {
                        graphics.setColor(Color.gray);
                        graphics.drawLine(n5, n13, n5, n12);
                        graphics.setColor(Color.black);
                        graphics.drawLine(n5 + 1, n13 - 2, n5 + 1, n12);
                        n7 = n5;
                    } else {
                        n7 = n5 - 1;
                    }
                }
                if (n10 == this.curIndex) {
                    n12 = this.iTabsPosition == 0 ? ++n12 : --n12;
                    graphics.setColor(this.getBackground());
                    graphics.drawLine(n11 + 1, n12, n5, n12);
                    if (this.iTabsPosition == 1) {
                        graphics.drawLine(n11 + 1, n12 - 1, n5, n12 - 1);
                    }
                    graphics.setFont(this.fSel);
                } else {
                    graphics.setFont(this.fReg);
                }
                if (this.iTabsStyle == 0) {
                    polygon.addPoint(n6, n12);
                    polygon.addPoint(n7, n12);
                    polygon.addPoint(n7, n13);
                    polygon.addPoint(n6, n13);
                    polygon.addPoint(n6, n12);
                }
                this.vPolys.addElement(polygon);
                Boolean bl = (Boolean)this.vEnabled.elementAt(n10);
                if (bl.booleanValue()) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(Color.gray);
                }
                if (this.iTabsPosition == 0) {
                    graphics.drawString(string, n11 + 8, n13 + 15 + this.osAdjustment);
                } else if (this.iTabsStyle == 0) {
                    graphics.drawString(string, n11 + 8, n13 - 6 + this.osAdjustment);
                } else {
                    graphics.drawString(string, n11 + 14, n13 - 4 + this.osAdjustment);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            ++n10;
        }
        if (this.firstVisibleTab > 0 || n10 < n8) {
            this.dbLeft.show();
            this.dbRight.show();
            if (this.firstVisibleTab > 0) {
                this.dbLeft.enable();
            } else {
                this.dbLeft.disable();
            }
            if (n10 < n8) {
                this.dbRight.enable();
            } else {
                this.dbRight.disable();
            }
            if (this.iTabsPosition == 0) {
                this.dbLeft.reshape(rectangle.width - 33 + this.TF_RIGHT, this.TF_TOP - 16, 16, 15);
                this.dbRight.reshape(rectangle.width - 16 + this.TF_RIGHT, this.TF_TOP - 16, 16, 15);
            } else {
                this.dbLeft.reshape(rectangle.width - 33 + this.TF_RIGHT, rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT, 16, 15);
                this.dbRight.reshape(rectangle.width - 16 + this.TF_RIGHT, rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT, 16, 15);
            }
        } else {
            this.dbLeft.hide();
            this.dbRight.hide();
        }
        while (n10 < n8) {
            this.vPolys.addElement(this.nullPoly);
            ++n10;
        }
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 501: {
                int n = this.vPolys.size();
                int n2 = 0;
                while (n2 < n) {
                    try {
                        Polygon polygon = (Polygon)this.vPolys.elementAt(n2);
                        if (polygon != this.nullPoly && polygon.inside(event.x, event.y)) {
                            this.showTab(n2);
                            return true;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    ++n2;
                }
                break;
            }
            case 1001: {
                if (event.target == this.dbLeft) {
                    if (--this.firstVisibleTab < 0) {
                        this.firstVisibleTab = 0;
                    } else {
                        this.repaint();
                    }
                    return true;
                }
                if (event.target != this.dbRight) break;
                int n = this.vLabels.size();
                if (++this.firstVisibleTab == n) {
                    --this.firstVisibleTab;
                } else {
                    this.repaint();
                }
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public Component add(Component component) {
        return component;
    }

    public synchronized Component add(Component component, int n) {
        return component;
    }

    public synchronized Component add(String string, Component component) {
        return component;
    }

    public synchronized void remove(Component component) {
        if (component == this.dbLeft || component == this.dbRight) {
            return;
        }
        super.remove(component);
        if (component == this.userPanel) {
            this.userPanel = null;
        }
    }

    public synchronized void removeAll() {
        super.removeAll();
        super.add((Component)this.dbLeft, -1);
        super.add((Component)this.dbRight, -1);
        this.userPanel = null;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public Insets insets() {
        this.btpInsets = super.insets();
        this.btpInsets.left += this.TF_LEFT + 3;
        this.btpInsets.right += 6 - this.TF_RIGHT;
        if (this.iTabsPosition == 0) {
            this.btpInsets.top += this.TF_TOP + 3;
            this.btpInsets.bottom += 5 - this.TF_BOTTOM;
        } else {
            this.btpInsets.top += this.TF_TOP - this.TF_BTN_HEIGHT + 3;
            this.btpInsets.bottom += this.TF_BTN_HEIGHT + 5 - this.TF_BOTTOM;
        }
        return this.btpInsets;
    }

    public Dimension preferredSize() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.minimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension minimumSize() {
        if (this.userPanel != null) {
            Dimension dimension = this.userPanel.minimumSize();
            return new Dimension(dimension.width + this.btpInsets.left + this.btpInsets.right, dimension.height + this.btpInsets.top + this.btpInsets.bottom);
        }
        return new Dimension(100, 100);
    }
}

