/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gl4java.GLCapabilities;
import gl4java.GLEnum;
import gl4java.GLFunc;
import gl4java.GLUFunc;
import gl4java.awt.GLCanvas;
import gl4java.drawable.GLDrawable;
import gl4java.drawable.GLDrawableFactory;
import gl4java.drawable.GLEventListener;
import gnu.gleem.BSphere;
import gnu.gleem.BSphereProvider;
import gnu.gleem.CameraParameters;
import gnu.gleem.ExaminerViewer;
import gnu.gleem.HandleBoxManip;
import gnu.gleem.ManipManager;
import gnu.gleem.MouseButtonHelper;
import gnu.gleem.linalg.Vec3f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class TestExaminerViewer {
    private static final int X_SIZE = 400;
    private static final int Y_SIZE = 400;

    public static void main(String[] args) {
        Frame frame = new Frame("ExaminerViewer Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        GLCanvas canvas = GLDrawableFactory.getFactory().createGLCanvas(new GLCapabilities(), 400, 400);
        canvas.addGLEventListener((GLEventListener)new Listener());
        frame.add((Component)canvas, "Center");
        frame.pack();
        frame.show();
    }

    static {
        X_SIZE = 400;
        Y_SIZE = 400;
    }

    static class Listener
    implements GLEventListener,
    GLEnum {
        private GLFunc gl;
        private GLUFunc glu;
        private CameraParameters params = new CameraParameters();
        private ExaminerViewer viewer;

        Listener() {
        }

        public void init(GLDrawable drawable) {
            this.gl = drawable.getGL();
            this.glu = drawable.getGLU();
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            float[] lightPosition = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
            float[] ambient = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            float[] diffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            this.gl.glLightfv(16384, 4608, ambient);
            this.gl.glLightfv(16384, 4609, diffuse);
            this.gl.glLightfv(16384, 4611, lightPosition);
            this.gl.glEnable(2896);
            this.gl.glEnable(16384);
            this.gl.glEnable(2929);
            this.params.setPosition(new Vec3f(0.0f, 0.0f, 0.0f));
            this.params.setForwardDirection(Vec3f.NEG_Z_AXIS);
            this.params.setUpDirection(Vec3f.Y_AXIS);
            this.params.setVertFOV(0.3926991f);
            this.params.setImagePlaneAspectRatio(1.0f);
            this.params.xSize = 400;
            this.params.ySize = 400;
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            this.glu.gluPerspective(45.0, 1.0, 1.0, 100.0);
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
            ManipManager manager = ManipManager.getManipManager();
            manager.registerWindow(drawable);
            HandleBoxManip manip = new HandleBoxManip();
            manip.setTranslation(new Vec3f(0.0f, 0.0f, -10.0f));
            manager.showManipInWindow(manip, drawable);
            this.viewer = new ExaminerViewer(MouseButtonHelper.numMouseButtons());
            this.viewer.attach(drawable, new HandleBoxManipBSphereProvider(manip));
            this.viewer.viewAll(this.gl, this.glu);
        }

        public void display(GLDrawable drawable) {
            this.gl.glClear(16640);
            this.viewer.update(this.gl, this.glu);
            ManipManager.getManipManager().updateCameraParameters(drawable, this.viewer.getCameraParameters());
            ManipManager.getManipManager().render(drawable, this.gl);
        }

        public void reshape(GLDrawable drawable, int w, int h) {
        }

        public void preDisplay(GLDrawable drawable) {
        }

        public void postDisplay(GLDrawable drawable) {
        }

        public void cleanup(GLDrawable drawable) {
        }
    }

    static class HandleBoxManipBSphereProvider
    implements BSphereProvider {
        private HandleBoxManip manip;

        private HandleBoxManipBSphereProvider(HandleBoxManip manip) {
            this.manip = manip;
        }

        public BSphere getBoundingSphere() {
            BSphere bsph = new BSphere();
            bsph.setCenter(this.manip.getTranslation());
            Vec3f scale0 = this.manip.getScale();
            Vec3f scale1 = this.manip.getGeometryScale();
            Vec3f scale = new Vec3f();
            scale.setX(2.0f * scale0.x() * scale1.x());
            scale.setY(2.0f * scale0.y() * scale1.y());
            scale.setZ(2.0f * scale0.z() * scale1.z());
            bsph.setRadius(scale.length());
            return bsph;
        }
    }
}

