#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include <dos.h>

int
main(int argc, char **argv)
{
  int start = 1, end = 10;
  struct dostime_t now;

  /* read command line options, if any */

  if (argc == 2) {
    /* usage: random end */

    end = atoi(argv[1]);
  }
  else if (argc == 3) {
    /* usage: random start end */

    start = atoi(argv[1]);
    end = atoi(argv[2]);
  }
  else if (argc > 2) {
    fputs("random: Generate a random number in a range\n", stderr);
    fputs("random: Too many options\n", stderr);
    fputs("usage: random [[start] end]\n", stderr);
    fprintf(stderr, "  Defaults are start=%d, end=%d\n", start, end);

    return 1;
  }

  /* check the range */

  if (start >= end) {
    fprintf(stderr, "random: Bad range\n");
    fprintf(stderr, "  Range is start=%d, end=%d\n", start, end);
    return 2;
  }

  /* generate a random number in the range */

  _dos_gettime( &now );
  srand( now.hour + now.minute + now.second + now.hsecond );

  printf("%d\n", ((rand() % (end - start + 1)) + start));

  return 0;
}
