program loadbmp;

{ load only bmp images 320x200x256 }

uses crt, vga2, paint2u;
var
  RGB             :ARRAY[0..255,1..4] OF Byte;

Procedure Load_BMP(Name:String;where:word);

type
  Virtual = Array [1..64000] of byte;

VAR
  PicBuf          :^Virtual;
  Data            :File;
  Header          :Array[1..54] of Byte;
  aAddr           :word;
  I               :Byte;

Procedure SetPal(Col,R,G,B : Byte); assembler;

asm
  mov    dx,3c8h
  mov    al,[col]
  out    dx,al
  inc    dx
  mov    al,[r]
  out    dx,al
  mov    al,[g]
  out    dx,al
  mov    al,[b]
  out    dx,al
end;
var
 NR : Integer;
 F  : File of Byte;
begin
  Assign(F,Name);
  Reset(F);
  NR := FileSize(F)-54-1024;
  Close(F);

  GetMem (PicBuf,64000);
  Assign(Data,Name); Reset(Data,1);
  BlockRead(Data,Header,54);
  BlockRead(Data,RGB,1024);
  for i :=0 to 255 do
    SetPal(I,RGB[I,3] div 4,RGB[I,2] div 4,RGB[I,1] div 4);
  NR := 0;
  {$I-}BlockRead(Data,PicBuf^,63360);{$I+}
  Close(Data);
  aAddr := seg (PicBuf^);

  asm
    push si
    push di
    push es
    push ds
    mov es, [where]
    mov ds, [aAddr]
    mov di, 0
    mov dx, 63680
    mov cx, 200
  @page:
    push cx
    mov cx, 320
    mov si, dx
  @line:
    mov bh, byte ptr ds:[si]
    mov es:[di], bh
    inc di
    inc si
    loop @line
    sub dx, 320
    pop cx
    loop @page
    pop ds
    pop es
    pop di
    pop si
  end;
  freeMem(PicBuf,64000);
end;
var
 Palt : a_palette;
 F : File;
begin
  asm
    mov ax,0013h;
    int 10h;
  end;
  Load_BMP('garg4sm.bmp',$A000);
 { LoadFont('Default.yfn');
  VGAColor := 250;
  OutFont('Hellow');}
  repeat until keypressed;
  SavePic2('10.ymg',1,1,290,190);
  Assign(f,'bbb.pal');
  Rewrite(f,1);
  BlockWrite(F,RGB,SizeOf(RGB));
  Close(F);
end.

