#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>

char helptext[]  = "\n\
 TIMESTMP 2.0 by Jrgen Hoffmann (2010) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n\
 usage:  timestmp [/N] [/O] [/S<char>] [ text ... ] +<time-def> [ text ... ]\n\n\
     with  /N: no implicit spaces\n\
	   /O: open end (don't append a newline)\n\
	   /S: use <char> instead of '+' to mark <time-def>\n\
     and <time-def>\n\
	 year:     'J','j':  '2000' .. '2999'\n\
	 year:     'Y': '00' .. '99'   --    'y': '0' .. '99'\n\
	 month:    'M': '01' .. '12'   --    'm': '1' .. '12'\n\
	 day:      'D': '01' .. '31'   --    'd': '1' .. '31'\n\
	 hour:     'H': '00' .. '23'   --    'h': '0' .. '23'\n\
	 minute:   'I': '00' .. '59'   --    'i': '0' .. '59'\n\
	 second:   'S': '00' .. '59'   --    's': '0' .. '59'\n\
	 1/100:    'U': '00' .. '99'   --    'u': '0' .. '99'\n\n\
	 'q': a single quote (\')  --  'Q': a double quote (\")\n\
	 'N': name of the month   --  needs set TIMESTMP_M=...\n\
	 'n': name of day of week --  needs set TIMESTMP_W=...\n\
	      e.g. set TIMESTMP_W=:Sun:Mon:Tue:Wed:Thu:Fri:Sat\n\n";

char datesign    = '+';
char endst[2]    = "\n";
char space[2]    = " ";
char fd[4]       = "%d";
char f2d[6]      = "%02d";

char name0[]     = "I";
char name1[]     = "II";
char name2[]     = "III";
char name3[]     = "IV";
char name4[]     = "V";
char name5[]     = "VI";
char name6[]     = "VII";
char name7[]     = "VIII";
char name8[]     = "IX";
char name9[]     = "X";
char name10[]    = "XI";
char name11[]    = "XII";
char *mname[12]  = { name0,name1,name2,name3,name4,name5,
		     name6,name7,name8,name9,name10,name11 };
char *wdname[12] = { name0,name1,name2,name3,name4,name5,name6 };

char mstr[130];
char wstr[130];

struct dosdate_t sysdate;
struct dostime_t systime;


void main (int argc, char* argv[]) {
  int   i,j;
int k;
  char *p;

  if(argc < 2) printf(helptext);
  else {
    if((p=getenv("TIMESTMP_M"))!=NULL) strncpy(mstr,p,129);
    mstr[129] = '\0';
    if(mstr[0]&&mstr[1]) for(i=0,j=mstr[0],p=mstr; *p&&i<12; p++)
      if(*p==j) {
	*p++ = '\0';
	mname[i++] = p;
	}
    if((p=getenv("TIMESTMP_W"))!=NULL) strncpy(wstr,p,129);
    wstr[129] = '\0';
    if(wstr[0]&&wstr[1]) for(i=0,j=wstr[0],p=wstr; *p&&i<7; p++)
      if(*p==j) {
	*p++ = '\0';
	wdname[i++] = p;
	}
    _dos_getdate(&sysdate);
    _dos_gettime(&systime);
    for(i=1; i < argc && (*argv[i]=='/' || *argv[i]=='-');i++) {
      switch (toupper(argv[i][1])) {
	case 'N': space[0] = '\0';       break;
	case 'O': endst[0] = '\0';       break;
	case 'S': datesign = argv[i][2]; break;
	}
      }
    j = i;
    while(i < argc) {
      if(*argv[i] != datesign) {
	if(i == j) printf("%s",argv[i]);
	else printf("%s%s",space,argv[i]);
	}
      else {
	p = argv[i];
	p++;
	if(i > j) printf("%s",space);
	while(*p != '\0') {
	  switch(*p) {
	    case 'J':
	    case 'j': printf("%4d",sysdate.year);             break;
	    case 'Y': printf(f2d,sysdate.year % 100);         break;
	    case 'y': printf(fd,sysdate.year % 100);          break;
	    case 'M': printf(f2d,sysdate.month);              break;
	    case 'm': printf(fd,sysdate.month);               break;
	    case 'D': printf(f2d,sysdate.day);                break;
	    case 'd': printf(fd,sysdate.day);                 break;
	    case 'H': printf(f2d,systime.hour);               break;
	    case 'h': printf(fd,systime.hour);                break;
	    case 'I': printf(f2d,systime.minute);             break;
	    case 'i': printf(fd,systime.minute);              break;
	    case 'S': printf(f2d,systime.second);             break;
	    case 's': printf(fd,systime.second);              break;
	    case 'U': printf(f2d,systime.hsecond);            break;
	    case 'u': printf(fd,systime.hsecond);             break;
	    case 'N': printf("%s",mname[sysdate.month-1]);    break;
	    case 'n': printf("%s",wdname[sysdate.dayofweek]); break;
	    case 'Q': printf("\"");                           break;
	    case 'q': printf("'");                            break;
	    default : printf("%c",*p);
	    }
	  p++;
	  }
	}
      i++;
      }
    printf(endst);
    }
  }