#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <dir.h>
#include <mem.h>

char cmdbuf[300];
char outbuf[270];
char dostore    = 0;
char splitmode  = 0;
char makeabs    = 0;
int  lfnmode    = 0;
char xchgcase   = 0;
char newext[32] = "";
char drive[MAXDRIVE+2];
char dir[270];
char file[270];
char ext[32];

#define GDRIVE 0X01
#define DRPURE 0X02
#define GPATH  0X04
#define PAPURE 0X08
#define GNAME  0X10
#define GEXT   0X40
#define EXPURE 0X80
#define NOEXT  ~(GEXT|EXPURE)

char helptext[] = "\n\
 FNTOOL 1.0 by Jrgen Hoffmann (2011) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n\
 usage:  fntool [ options ] <filename>\n\n\
 valid options are:\n\
     /A       convert to absolute filename\n\
     /AL      convert to canonical long  name (reqires LFN support)\n\
     /AS      convert to canonical short name (reqires LFN support)\n\
     /D[P]    return  drive component   (/DP: without trailing ':')\n\
     /P[P]    return  path  component   (/PP: without trailing '\\')\n\
     /B       return  basename component\n\
     /F       return  filename components (same as /B and /T)\n\
     /T[P]    return  type (extension)  (/TP: without leading  '.')\n\
     /X<ext>  replace type (extension) by <ext>\n\
     /U       make result upper case\n\
     /L       make result lower case\n\
     /S[var]  make set command for environment variable [var]\n\
     /E[var]  store [var] in environment (default: FNTOOL_RESULT)\n\
     /H /?    write this help text\n";

void error(int code) {
  fprintf(stderr,"ERROR: ");
  switch(code) {
    case 1:  fprintf(stderr,"bad name in /S switch\n");               break;
    case 2:  fprintf(stderr,"while converting into absolute path\n"); break;
    case 3:  fprintf(stderr,"no long filename support available\n");  break;
    }
  exit(1);
  }

void put_parentenv(char *cmdp) {
  unsigned int far *ip1; // ptr --> parent's PSP
  unsigned int far *ip2; // ptr --> ptp -->  parent's environment
  unsigned int far *ip3; // ptr --> size  of parent's environment
  int pesize, peused;    // available, actually used
  char far *pebeg;       // ptr --> Parent's Environment BEGin
  char far *peend;       // ptr --> Parent's Environment END
  char far *cp1;
  char far *cp2;
  char far *vpos;        // ptr --> variable, if already present
  int  vlen,vsiz;        // new len, present len, if already present
  vpos = NULL;
  vsiz = 0;
  vlen = (strchr(cmdp,'=') - cmdp) + 1;
  ip1 = MK_FP(_psp,0X0016);
  ip2 = MK_FP(*ip1,0X002C);
  pebeg = MK_FP(*ip2,0);
  ip3 = MK_FP(*ip2-1,3); // !!!!!!!!
  for(cp1=pebeg; *cp1; cp1=MK_FP(FP_SEG(cp1),FP_OFF(cp1)+_fstrlen(cp1)+1))
    if(!_fstrncmp(cp1,cmdp,vlen)) { vpos = cp1; vsiz = _fstrlen(cp1) + 1; }
  peend  = cp1;
  peused = cp1 - pebeg + 1;
  pesize = *ip3 <<  4;
  if(vsiz) {             // if already present, remove it first
    cp1 = vpos;
    cp2 = MK_FP(FP_SEG(cp1),FP_OFF(cp1)+vsiz);
    while(cp2 < peend) *cp1++ = *cp2++;
    peend  = cp1;
    peused -= vsiz;
    }
  if((pesize-peused-5)<strlen(cmdp)) error(7);
  else {                 // now append new copy, if space is sufficient
    _fstrcpy(peend,cmdp);
    cp1  = MK_FP(FP_SEG(peend),FP_OFF(peend)+strlen(cmdp)+1);
    *cp1 = '\0';
    }
  }

void lfn_support(char *p, char *q) {
  struct REGPACK r;
  char lnam[270];
  lnam[0] = '\0';
  r.r_ax=0X7160;
  r.r_cx=lfnmode;
  r.r_ds=FP_SEG(p);
  r.r_si=FP_OFF(p);
  r.r_es=FP_SEG(lnam);
  r.r_di=FP_OFF(lnam);
  intr(0X21,&r);
  if(r.r_flags&1) {
    if(r.r_ax==0X7100) error(3);
    else error(2);
    }
  strncpy(q, lnam, 266);
  }


void main (int argc, char* argv[]) {
  char *p;
  int   i,j;

  if(argc < 2) printf(helptext);
  else {
    for(i=1; i < argc && ((*argv[i]=='/')||(*argv[i]=='-'));i++) {
      switch (toupper(argv[i][1])) {
	case 'A': makeabs++;
		  if(toupper(argv[i][2])=='S')      lfnmode = 1;
		  else if(toupper(argv[i][2])=='L') lfnmode = 2;     break;
	case 'D': splitmode |= GDRIVE;
		  if(toupper(argv[i][2])=='P') splitmode |= DRPURE;  break;
	case 'B': splitmode |= GNAME;                                break;
	case 'F': splitmode |= (GNAME|GEXT);                         break;
	case 'P': splitmode |= GPATH;
		  if(toupper(argv[i][2])=='P') splitmode |= PAPURE;  break;
	case 'T': splitmode |= GEXT;
		  if(toupper(argv[i][2])=='P') splitmode |= EXPURE;  break;
	case 'U': xchgcase = 1;                                      break;
	case 'L': xchgcase = -1;                                     break;
	case 'X': strncpy(newext,&argv[i][2],30);                    break;
	case 'H':
	case '?': printf(helptext);                                  exit(0);
	case 'E': dostore = 1;
	case 'S': if(argv[i][2]) strncpy(cmdbuf,&argv[i][2],64);
		  if(!cmdbuf[0]) strcpy(cmdbuf,"FNTOOL_RESULT");     break;
	}
      }
    if(i >= argc) printf(helptext);
    else {
      if(cmdbuf[0]) {
	if(strchr(cmdbuf,'=')) error(1);
	else {
	  strupr(cmdbuf);
	  strcat(cmdbuf,"=");
	  }
	}
      if(!makeabs) strcpy(outbuf,argv[i]);
      else {
	if(lfnmode) lfn_support(argv[i],outbuf);
	else if(_fullpath(outbuf,argv[i],260)==NULL) error(2);
	}
      if(newext[0]) {
	if(newext[0]!='.') {
	  movmem(newext,&newext[1],(lfnmode==2)?30:3);
	  newext[0] = '.';
	  }
	if(lfnmode < 2) newext[4] = '\0';
	else newext[30] = '\0';
	if(!splitmode) splitmode = GDRIVE|GPATH;
	splitmode &= NOEXT;
	splitmode |= GNAME;
	}
      if(splitmode) {
	fnsplit(outbuf,drive,dir,file,ext);
	if(lfnmode==2) {
	  if((p=strrchr(outbuf,'\\'))==NULL) p = outbuf;
	  if((p=strstr(p,file))!=NULL) {
	    strncpy(file,p,265);
	    if((p=strstr(file,ext))!=NULL) {
	      strncpy(ext,p,30);
	      *p = '\0';
	      }
	    file[269] = '\0';
	    ext[31]   = '\0';
	    }
	  }
	outbuf[0] = '\0';
	if(splitmode&GDRIVE) {
	  if((splitmode&DRPURE)&&(drive[1]==':')) drive[1] = '\0';
	  strcpy(outbuf,drive);
	  }
	if(splitmode&GPATH) {
	  if(splitmode&PAPURE) {
	    j = strlen(dir);
	    if(j > 1) {
	      j--;
	      if(dir[j]=='\\') dir[j] = '\0';
	      }
	    }
	    strcat(outbuf,dir);
	  }
	if(splitmode&GNAME) strcat(outbuf,file);
	if(splitmode&GEXT) {
	  p = (splitmode&EXPURE) ? &ext[1] : ext;
	  strcat(outbuf,p);
	  }
	if(newext[0]) strcat(outbuf,newext);
	}
      if(xchgcase > 0)      for(p=outbuf; *p; p++) *p=toupper(*p);
      else if(xchgcase < 0) for(p=outbuf; *p; p++) *p=tolower(*p);
      if(cmdbuf[0]) {
	strcat(cmdbuf,outbuf);
	if(!dostore) printf("SET %s\n",cmdbuf);
	else put_parentenv(cmdbuf);
	}
      else printf("%s\n",outbuf);
      }
    }
  exit(0);
  }
