#include <stdio.h>fld
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <conio.h>
#include <bios.h>
#include <time.h>
#include <dos.h>
#include <dir.h>
#include <mem.h>
#include <sys\stat.h>

// #define EXTRADEBUG

typedef unsigned char uchr;

char  author[] = "1.0 by Jrgen Hoffmann (2011) j_hoff@hrz1.hrz.tu-darmstadt.de";
char *mypath;
char *myname;
FILE *layoutfil;
char *lofnam;
int   lineno   = 0;
long  lofpos;
int   debug    = 0;
int  gargc     = 0;
char *gargv[10] = {NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};

extern int _wscroll = 0;

int  scrwid = 80;
int  scrlen = 25;
int  scrmod = C80;

char nrow   = 0;
char lrow   = 0;
char lcol   = 0;
char lfld   = '_';
char dfld   = '_';
char roff   = 1;
char coff   = 1;
uchr nfld   = 0;
char **form;
char *scrsave;
char rowsave;
uchr tatt   = 7;
uchr fatt   = 7;
uchr orgatt;
char clrfrm = 1;
char smode  = 0;
char minimal= -2;
char dobeep = 0;

#define MINL 0X80000000
#define MAXL 0X7FFFFFFF

typedef struct {
  long   min;
  long   max;
  } LIM;

typedef struct {
  uchr   idx;
  uchr   max;
  char  *lst[];
  } SEL;

typedef union {
  char *txt;
  LIM  *lim;
  SEL  *sel;
  } AUX;

typedef struct {
  char r;
  char c;
  char w;
  char ml;
  unsigned char typ;
  char *text;
  AUX  aux;
  } FSTR;
FSTR **field;
uchr  *fld2;
uchr  nfld2 = 0;
uchr  f0    = 0;
uchr  f1    = 0;
uchr  f2    = 0;

typedef struct output_def {
  struct output_def *next;
  char              *name;
  char              *text;
  };

struct output_def *outlist = NULL;
struct output_def *execute = NULL;

char toflg = 0;
unsigned long tout = 0L;
unsigned long t0   = 0L;
unsigned long far *timer = (unsigned long *)MK_FP(0X0040,0X006C);

/*****
  typ =   X0 : ordinary input field for any kind of text
	  X1 : input field with value checking, specified by "X"
	  X2 : input field with value checking, specified by "X"
	  X3 : field with pre-defined list of values
	  X5 : checkbox or member of radio button set "X"
	  X6 : error message field (used by FORM itself)
	  X7 : message field (output only)

  codes = A : ANY characters but  (52)
	  C : character set       (51)
	  CL: lower case set      (D9)
	  CU: upper case set      (D1)
	  E : error field         (06)
	  F : file must exist     (61)
	  FL: lower case file     (E9)
	  FU: upper case file     (E1)
	  H : hexadecimal         (41)
	  HL: lower case hex      (C9)
	  HU: upper case hex      (C1)
	  L : list of values      (03)
	  LD: directory list      (03)
	  LF: file list           (03)
	  M : message field       (07)
	  ML: lower case message  (07)
	  MU: upper case message  (07)
	  N : file must not exist (71)
	  NL: lower case no file  (F9)
	  NU: upper case no file  (F1)
	  O : octal value         (31)
	  R : real number         (21)
	  S : signed decimal      (11)
	  T : text field          (00)
	  TL: lower case text     (88)
	  TU: upper case text     (80)
	  U : unsigned decimal    (01)
	  X : checkbox            (05)
	  Xn: radio button        (n2)
*****/
char illegal_fn[] = " <>=,;*?[]+|/\"";
char legal_char[] = ".+-0123456789ABCDEFabcdef";
char *lgl_sign    = &legal_char[1];
char *lgl_hex     = &legal_char[3];
char *lgl_oct     = &legal_char[10];
char *lgl_dec     = &legal_char[12];

#define MAXERRTXT 30
int  errfld = -1;
char ertxt1[MAXERRTXT+2] = "file not found: ";
char ertxt2[MAXERRTXT+2] = "file exists: ";
char ertxt3[MAXERRTXT+2] = "minimum value: ";
char ertxt4[MAXERRTXT+2] = "maximum value: ";
char ertxt5[MAXERRTXT+2] = "misplaced character: ";
char ertxt6[MAXERRTXT+2] = "minimum length: ";

#define NUMKEYWORDS 8
char *keywords[NUMKEYWORDS] = {"LAYOUT","DISPLAY","COLOR","FIELD","OUTPUT","ERRTEXT","EXECUTE","TIMEOUT"};

char ruler[100] = "123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789";
char *rulend = &ruler[92];

/*--- error handling and clean-up ---------------------------------*/

void fatal_error(int arg, char *p) {
  char buf[128];
  fprintf(stderr,"ERROR: ");
  if(lineno) {
    fprintf(stderr,"in layoutfile, line: %d: ",lineno);
    if(!(debug&1)) {
      fprintf(stderr,"\n");
      fseek(layoutfil,lofpos,0);
      if(fgets(buf,126,layoutfil)!=0) fprintf(stderr,"%d: %s",lineno,buf);
      }
    }
  switch(arg) {
    case  0: sprintf(buf,"Out of memory   %s",p);                       break;
    case  1: sprintf(buf,"No layout file specified");                   break;
    case  2: sprintf(buf,"Cannot open layout file: %s",p);              break;
    case  3: sprintf(buf,"Unknown keyword: %s",p);                      break;
    case  4: sprintf(buf,"Expected %s but found: %s",keywords[0],p);    break;
    case  5: sprintf(buf,"Expected number but found: %s",p);            break;
    case  6: sprintf(buf,"Number out of bounds: %s",p);                 break;
    case  7: sprintf(buf,"No %s definitions found",keywords[4]);        break;
    case  8: sprintf(buf,"Undefined field type: %s",p);                 break;
    case  9: sprintf(buf,"Additional string argument expected");        break;
    case 10: sprintf(buf,"Too many input fields");                      break;
    case 11: sprintf(buf,"%s + %s requires /s",keywords[4],keywords[6]);break;
    case 12: sprintf(buf,"Illegal character in preset string: %s",p);   break;
    case 13: sprintf(buf,"Only one field of type 'E' allowed");         break;
    case 14: sprintf(buf,"One field of type 'E' required");             break;
    case 15: sprintf(buf,"The '=' sign is not allowed here: %s",p);     break;
    case 16: sprintf(buf,"Expression too long: %s",p);                  break;
    case 17: sprintf(buf,"Upper limit is less than lower limit");       break;
    case 18: sprintf(buf,"Empty list");                                 break;
    case 19: sprintf(buf,"Out of environment space");                   break;
    }
  fprintf(stderr,"%s\n\n",buf);
  exit(3);
  }

void num_error(int arg1, int arg2) {
  char buf[12];
  sprintf(buf,"%d",arg2);
  fatal_error(arg1,buf);
  }

void dump_data(int flg) {
  struct output_def *od;
  int i,j;
  printf("\n");
  if(flg) {
    printf("Size row=%d  col=%d  '%c'\n",lrow,lcol,lfld);
    printf("  :%*.*s:\n",lcol,lcol,ruler);
    for(i=0; i<nrow; i++) printf("%2d:%s:\n",i+1,form[i]);
    printf("  :%*.*s:\n",lcol,lcol,ruler);
    printf("Pos  row=%d  col=%d  '%c'\n",roff,coff,dfld);
    printf("Attr txt=%02X  fld=%02X\n\n",tatt,fatt);
    }
  for(i=0; i<nfld; i++) {
    printf("field %-2d: r=%-2d c=%-2d w=%-2d t=%02X \"%s\"",
      i+1,field[i]->r+1,field[i]->c+1,field[i]->w,field[i]->typ,field[i]->text);
    if(field[i]->aux.txt) {
      if((field[i]->typ&7)==3) for(j=0; j<field[i]->aux.sel->max; j++)
	printf(" \"%s\"",field[i]->aux.sel->lst[j]);
      else if(((field[i]->typ&7)==1)&&((field[i]->typ&0X70)<0X50))
	printf("  %ld:%ld",field[i]->aux.lim->min,field[i]->aux.lim->max);
      else printf("  \"%s\"",field[i]->aux.txt);
      }
    printf("\n");
    }
  printf("\n");
  if(flg) {
    for(od=outlist; od; od = od->next) printf("out: %s=\"%s\"\n",od->name,od->text);
    if(execute) printf("exec: %s %s\n",execute->name,execute->text);
    }
  if(toflg) printf("tout: %ld %c\n",tout*5/91,(toflg==0X0D)?'R':' ');
#ifdef EXTRADEBUG
  if(debug&8) {
    printf("\nform  -->  %04X --> %04X\n",&form,form);
    for(i=0; i<nrow; i++) printf("%-20s%04X[%2d] --> %04X = %-20.20s\n","",&form[i],i,form[i],form[i]);
    printf("\nfield -->  %04X --> %04X\n",&field,field);
    for(i=0; i<nfld; i++) {
      printf("%-20s%04X[%2d] --> %04X --> %04X = %-20.20s\n","",&field[i],i,field[i],field[i]->text,field[i]->text);
      printf("%-37s --> %04X","",field[i]->aux);
      if((field[i]->typ&7)==3) {
	printf("\n");
	for(j=0; j<field[i]->aux.sel->max; j++)
	  printf("%46s --> %04X[%2d] --> %04X = %-7.7s\n","aux:",
	  &field[i]->aux.sel->lst[j],j,field[i]->aux.sel->lst[j],field[i]->aux.sel->lst[j]);
	}
      else if(field[i]->aux.txt&&(((field[i]->typ&7)!=1)||((field[i]->typ&0X70)>0X40)))
	printf(" = %-20.20s\n",field[i]->aux.txt);
      else printf("\n");
      }
    printf("\nout   -->  %04X --> %04X  (%04X)  %-20.20s\n",&outlist,outlist,outlist->next,outlist->name);
    for(od=outlist->next; od; od = od->next) printf("%-20s%04X  (%04X)  %-20.20s\n","",od,od->next,od->name);
    }
#endif
  exit(2);
  }

/*--- miscellaneous helper routines -------------------------------*/

char helptext1[] = "\n\
valid options are:\n\
      /D<n>   debug   1=list layout-file   2/4=dump internal data\n\
      /K      keep menu on exit\n\
      /M[c]   minimalistic mode (no layout-file) c=color\n\
      /S      make SET command (also for testing)\n\
      /H /?   print this helptext\n\n\
syntax of layout-file:\n\
      LAYOUT  <rows> <columns> [ layout field-marker ]\n\
	      (must be first and followed by exactly <rows> lines of text)\n\
      DISPLAY <top-most row> <left-most column> [ display field-marker ]\n\
      COLOR   <text-FG> [ text-BG [ field-FG [ field-BG ]]]\n\
      FIELD   <n> <type> [ expand-string1 [ expand-string2 ]]\n\
      OUTPUT  <varname> <expression>          e.g. RESULT \"abc $1 xyz\"\n\
      EXECUTE <command> <argument-list>       e.g. RENAME \"$1 $2\"\n\
      ERRTEXT <n> <text>\n\
      TIMEOUT <seconds> [ R ]\n\n\
      set FORM_DIR=<path to directory of layout files>\n";

char helptext2[] = "\n\nField types:\n\
      A[LU][ml] [ preset string  [ character set ] ]  (any characters but)\n\
      C[LU][ml]  <preset string> < character set>        (characters from)\n\
      E[B]      [ preset string ]          (B=beep)  (error message field)\n\
      F[LU]     [ preset name [ path ]]                  (file must exist)\n\
      H[LU][ml] [ preset value [[minimum]:[maximum]]   (hexadecimal value)\n\
      L         <sep><item><sep><item> ... <sep>item>    (list of strings)\n\
      LD        [ search path ]                (list of (sub-)directories)\n\
      LF        [ search path ]                       (list of file names)\n\
      M[LU]     <text>                                           (message)\n\
      N[LU]     [ preset name [ path ]]              (file must not exist)\n\
      O[ml]     [ preset value [[minimum]:[maximum]]        (octal number)\n\
      R[ml]     [ preset value [[minimum]:[maximum]]         (real number)\n\
      S[ml]     [ preset value [[minimum]:[maximum]]      (signed decimal)\n\
      T[LU]     [ preset string ]                       (text of any kind)\n\
      U[ml]     [ preset value [[minimum]:[maximum]]    (unsigned decinal)\n\
      X         <response text> [ X ]                           (checkbox)\n\
      Xn        <response text> [ X ]            (radio button of set <n>)\n\n\
    [LU] = lower(L)/upper(U) case   [ml] = minimum length (1..field width)\n\
    %%name --> content of environment variable     %%%%text --> literal %%text\n\
    #n (n=0..9) --> argument <n>    ##n --> literal #n   # --> placeholder\n";

void show_help(void) {
  char ch;
  clrscr();
  printf("\n%s %s\n\n",myname,author);
  printf("usage: %s [ options ] <layout-file> [ <arg1> ... ]\n",myname);
  printf(helptext1);
  cprintf("  --- press <ESC> to abort or any other key to continue ---\r");
  ch = getch();
  cprintf("%-40s\r"," ");
  if((ch==0x1B)||(ch==0x03)) exit(2);
  printf(helptext2);
  exit(2);
  }

int get_scrlen(void) {
  struct text_info ti;
  gettextinfo(&ti);
  orgatt = ti.attribute;
  return(ti.screenheight);
  }

/*--- layout-file processing --------------------------------------*/

void show_form(int m);

void clr_radio_buttons(int fld, int flg) {
  int i;
  uchr set;
  set = field[fld]->typ;
  for(i=0; i<nfld; i++) if(field[i]->typ==set) {
    field[i]->text[0] = '\0';
    if(flg) show_form(i+1);
    }
  }

void identify_input(void) {
  int i,n;
  for(i=n=0; i<nfld; i++) if((field[i]->typ&0X07)<0X06) n++;
  if(NULL==(fld2=malloc(n+1))) fatal_error(0,"(A)");
  for(i=n=0; i<nfld; i++) if((field[i]->typ&0X07)<0X06) fld2[n++] = i;
  nfld2 = n;
  if(nfld2) f1 = fld2[0];
  }

char *scanlin(unsigned char *p) {
  unsigned char *p1;
  static unsigned char *p2;
  if(p != NULL) p2 = p;
  while(*p2&&(*p2<=' ')) p2++;
  if(*p2!='"') {
    p1 = p2;
    while(*p2>' ') p2++;
    if(*p2) *p2++ = '\0';
    }
  else {
    p1 = ++p2;
    while(*p2&&(*p2!='"')) p2++;
    if(*p2=='"') *p2++ = '\0';
    }
  return(p1);
  }

int get_number(char *p, int min, int max) {
  int i;
  char tmp[30];
  if(!isdigit(*p)) fatal_error(5,p);
  i = atoi(p);
  if((i<min)||(i>max)) {
    sprintf(tmp,"%d <= %d <= %d",min,i,max);
    fatal_error(6,tmp);
    }
  return(i);
  }

char check_ch(char ch, uchr f) {
  char *p;
  p = lgl_hex;
  if(field[f]->typ&0X80) {
    if(field[f]->typ&0X08) ch = tolower(ch);
    else ch = toupper(ch);
    }
  if((field[f]->typ&0X77)==0X52) {
    if(field[f]->aux.txt&&(NULL!=(p=strchr(field[f]->aux.txt,ch)))) ch = 0;
    }
  else if((field[f]->typ&0X07)==1) {
    if(((field[f]->typ&0X70)>0X50)&&strchr(illegal_fn,ch)) ch = 0;
    else if((field[f]->typ&0X70)==0X50) p = strchr(field[f]->aux.txt,ch);
    else if((field[f]->typ&0X70)<0X50) p = strchr(legal_char,ch);
    if(!p) ch = 0;
    else switch(field[f]->typ&0X70) {
      case 0X40: if( p<lgl_hex)                ch = 0; break;
      case 0X30: if((p<lgl_hex) ||(p>lgl_oct)) ch = 0; break;
      case 0X20: if( p>lgl_dec)                ch = 0; break;
      case 0X10: if((p<lgl_sign)||(p>lgl_dec)) ch = 0; break;
      case 0X00: if((p<lgl_hex) ||(p>lgl_dec)) ch = 0; break;
      }
    }
  return(ch);
  }

void read_layout(char *p1, char *p2, char *p3) {
  int i,j,k;
  uchr buf[84], c, c0;
  lrow = get_number(p1,1,scrlen);
  lcol = get_number(p2,1,scrwid);
  if(*p3>' ') lfld = *p3;
  dfld = lfld;
  if(NULL==(form=calloc(lrow,sizeof(char*)))) fatal_error(0,"(B)");
  for(i=0; i<lrow&&!feof(layoutfil); i++) {
    if(NULL!=fgets(buf,82,layoutfil)) nrow++;
    else break;
    buf[83] = '\0';
    lineno++;
    if(debug&1) fprintf(stderr,"%2d: %s",lineno,buf);
    if(NULL==(form[i]=malloc(lcol+2))) fatal_error(0,"(C)");
    j = strlen(buf);
    while((j >= 0)&&(buf[j] < ' ')) buf[j--] = '\0';
    while(j < 83) buf[++j] = ' ';
    buf[lcol]= '\0';
    strcpy(form[i],buf);
    }
  if(NULL==(scrsave=malloc((nrow*lcol*2)+4))) fatal_error(0,"(D)");
  for(i=0; i<nrow; i++) for(j=0,c='\0'; j<lcol; j++) if(form[i][j] != c) {
    if(form[i][j] == lfld) nfld++;
    if(nfld > 254) fatal_error(10,NULL);
    c = form[i][j];
    }
  if(!nfld) return;
  if(NULL==(field=calloc(nfld,sizeof(FSTR*)))) fatal_error(0,"(E)");
  for(i=0,k=-1; i<nrow; i++) for(j=0,c='\0'; j<lcol; j++) {
    c0 = form[i][j];
    if(form[i][j] == lfld) {
      if(c == lfld) field[k]->w++;
      else {
	k++;
	if(NULL==(field[k]=malloc(sizeof(FSTR)))) fatal_error(0,"(F)");
	field[k]->r       = i;
	field[k]->c       = j;
	field[k]->w       = 1;
	field[k]->ml      = 0;
	field[k]->typ     = 0;
	field[k]->text    = NULL;
	field[k]->aux.txt = NULL;
	}
      form[i][j] = ' ';
      }
    c = c0;
    }
  for(i=0; i<nfld; i++) {
    if(NULL==(field[i]->text=malloc(field[i]->w+2))) fatal_error(0,"(G)");
      memset(field[i]->text,0,field[i]->w+2);
    }
  }

LIM *get_limits(char *p) {
  char *q, *r;
  LIM *tmp;
  long lval;
  if(!*p) return(NULL);
  if(NULL==(tmp=malloc(sizeof(LIM))))  fatal_error(0,"(H)");
  tmp-> min = 0X80000000L;
  tmp-> max = 0X7FFFFFFFL;
  q = p;
  if(isdigit(*p)||(*p=='-')||(*p=='+')) {
    lval = strtol(p,&q,0);
    if(!*q||(*q==':')) tmp->min = lval;
    }
  if(*q&&(*q!=':')) fatal_error(5,p);
  if(*q==':') q++;
  if(isdigit(*q)||(*q=='-')||(*q=='+')) {
    lval = strtol(q,&r,0);
    if(!*r) tmp->max = lval;
    else fatal_error(5,q);
    }
  if(tmp->max < tmp->min) fatal_error(17,NULL);
  return(tmp);
  }

char *resolve_string(char *p, int w) {
  int i;
  char *tmp, *e;
  static char temp[128];
  temp[0] = '\0';
  if(((*p=='%')&&(p[1]=='%'))||((*p=='#')&&(p[1]=='#'))) strncpy(temp,&p[1],126);
  else if(*p=='%') {
    e = getenv(strupr(&p[1]));
    if(e) strncpy(temp,e,126);
    }
  else if(*p=='#'&&p[1]>='0'&&p[1]<='9'&&p[2]<=' ') {
    if((p[1]&0X0F)<gargc) strncpy(temp,gargv[p[1]&0X0F],126);
    }
  else if((*p!='#')||(p[1])) strncpy(temp,p,126);
  temp[127] = '\0';
  if(w) {
    temp[w] = '\0';
    return(temp);
    }
  else {
    if(NULL==(tmp=malloc(strlen(temp)+2))) fatal_error(0,"(I)");
    strcpy(tmp,temp);
    }
  return(tmp);
  }

void get_dir_list(char *p3, int nf, char sc) {
  SEL *sel;
  char tmp[130];
  int i,j,n,w;
  uchr attr0,attr1;
  struct ffblk ffblk;
  w = field[nf]->w;
  tmp[0] = '\0';
  if(!*p3) strcpy(tmp,"*.*");
  else {
    strcpy(tmp,p3);
    if(tmp[strlen(tmp)-1]=='\\') strcat(tmp,"*.*");
    else if((!strchr(p3,'*'))&&(!strchr(p3,'?'))) strcat(tmp,"\\*.*");
    }
  if(sc=='D') attr1 = attr0 = 0X10;
  else {
    attr0 = 0X27;
    attr1 = 0X20;
    }
  n = 0;
  i = findfirst(tmp,&ffblk,attr0);
  while(!i) {
    j = ffblk.ff_attrib&attr1;
    if((j==0X10)&&(ffblk.ff_name[0]=='.')) j = 0;
    if(j) n++;
    i = findnext(&ffblk);
    }
  if(n) {
    if(NULL==(sel=malloc(n*sizeof(char*)+sizeof(SEL)))) fatal_error(0,"(J)");
    for(i=0; i<n; i++) {
      if(NULL==(sel->lst[i]=malloc(w+2))) fatal_error(0,"(K)");
      else *sel->lst[i] = '\0';
      }
    n = 0;
    i = findfirst(tmp,&ffblk,attr0);
    while(!i) {
      j = ffblk.ff_attrib&attr1;
      if((j==0X10)&&(ffblk.ff_name[0]=='.')) j = 0;
      if(j) {
	if(w < 12) ffblk.ff_name[w] = '\0';
	strcpy(sel->lst[n++],ffblk.ff_name);
	}
      i = findnext(&ffblk);
      }
    sel->idx = 0;
    sel->max = n;
    field[nf]->typ = 0X03;
    field[nf]->aux.sel = sel;
    strcpy(field[nf]->text,field[nf]->aux.sel->lst[0]);
    }
  else fatal_error(18,NULL);
  }

void get_list(char *p, int nf) {
  char *q,l;
  int i,j,n;
  SEL *sel;
  if(!*p) fatal_error(18,NULL);
  for(q=p,l=*p,n=0; *q; q++) if((*q==l)&&q[1]) n++;
  if(NULL==(sel=malloc(n*sizeof(char*)+sizeof(SEL)))) fatal_error(0,"(L)");
  j = field[nf]->w;
  for(i=0; i<n; i++) {
    if(NULL==(sel->lst[i]=malloc(j+2))) fatal_error(0,"(M)");
    else *sel->lst[i] = '\0';
    }
  for(i=0,q=++p; *p; p++) if(*p==l) {
    *p = '\0';
    if(strlen(q) > j) q[j] = '\0';
    strcpy(sel->lst[i++],q);
    q=&p[1];
    }
  if(!*p&&*q) strcpy(sel->lst[i],q);
  sel->idx = 0;
  sel->max = n;
  field[nf]->typ = 0X03;
  field[nf]->aux.sel = sel;
  strcpy(field[nf]->text,field[nf]->aux.sel->lst[0]);
  }

void specify_field(char *p1, char *p2, char *p3, char *p4) {
  int i,nf;
  char tc, sc, ml;
  nf = get_number(p1,1,nfld) - 1;
  field[nf]->typ  = 0X00;
  memset(field[nf]->text,0,field[nf]->w+2);
  ml = 0;
  tc = toupper(*p2);
  sc = toupper(p2[1]);
  if(isdigit(sc)) {
    sc = 0;
    ml = get_number(&p2[1],(tc=='X')?1:0,(tc=='X')?15:field[nf]->w);
    }
  else if(sc&&isdigit(p2[2])) ml = get_number(&p2[2],(tc=='X')?1:0,(tc=='X')?15:field[nf]->w);
  switch(tc) {
    case 'E': field[nf]->typ  = 0X06;
	      if(errfld >= 0) fatal_error(13,NULL);
	      if(*p3) strcpy(field[nf]->text,resolve_string(p3,field[nf]->w));
	      errfld = nf;
	      if(sc=='B') dobeep = 1;
	      break;
    case 'M': field[nf]->typ  = 0X07;
	      if(!*p3) fatal_error(9,NULL);
	      strcpy(field[nf]->text,resolve_string(p3,field[nf]->w));
	      break;
    case 'T': field[nf]->typ  = 0X00;
	      if(*p3) strcpy(field[nf]->text,resolve_string(p3,field[nf]->w));
	      break;
    case 'L': if((sc=='F')||(sc=='D')) get_dir_list(resolve_string(p3,127),nf,sc);
	      else get_list(resolve_string(p3,127),nf);
	      break;
    case 'X': field[nf]->typ = (ml<<4) | 0x05;
	      field[nf]->w = 1;
	      if(!*p3) fatal_error(9,NULL);
	      field[nf]->aux.txt = resolve_string(p3,0);
	      if(toupper(*p4)=='X') {
		if(field[nf]->typ&0XF0) clr_radio_buttons(nf,0);
		field[nf]->text[0] = 'X';
		}
	      else field[nf]->text[0] = '\0';
	      field[nf]->text[1] = '\0';
	      break;
    case 'C': if(!field[nf]->typ) field[nf]->typ = 0X51;
	      if(!*p4) fatal_error(9,NULL);
    case 'A': if(!field[nf]->typ) field[nf]->typ = 0X52;
	      field[nf]->ml = ml;
    case 'N': if(!field[nf]->typ) field[nf]->typ = 0X71;
    case 'F': if(!field[nf]->typ) field[nf]->typ = 0X61;
	      if(*p3) {
		strcpy(field[nf]->text,resolve_string(p3,field[nf]->w));
		if(*p4) field[nf]->aux.txt = resolve_string(p4,0);
		}
	      if(errfld < 0) errfld = -2;
	      break;
    case 'U': if(!field[nf]->typ) field[nf]->typ = 0X01;
    case 'R': if(!field[nf]->typ) field[nf]->typ = 0X21;
    case 'H': if(!field[nf]->typ) field[nf]->typ = 0X41;
    case 'O': if(!field[nf]->typ) field[nf]->typ = 0X31;
    case 'S': if(!field[nf]->typ) field[nf]->typ = 0X11;
	      if(*p3) {
		strcpy(field[nf]->text,resolve_string(p3,field[nf]->w));
		field[nf]->aux.lim = get_limits(resolve_string(p4,50));
		}
	      field[nf]->ml = ml;
	      if(errfld < 0) errfld = -2;
	      break;
    default : fatal_error(8,p2);
    }
  if(strchr("ACNFHMT",tc)&&((((field[nf]->typ&7)<3))||(((field[nf]->typ&7)==7)))) {
    if(sc=='U') {
      strupr(field[nf]->text);
      if(tc!='M') field[nf]->typ |= 0X80;
      }
    else if(sc=='L') {
      strlwr(field[nf]->text);
      if(tc!='M') field[nf]->typ |= 0X88;
      }
    }
  if(strchr("ACNFURHOS",tc)) for(i=0; field[nf]->text[i]; i++)
    if(!check_ch(field[nf]->text[i],nf)) fatal_error(12,field[nf]->text);
  }

void specify_output(char *p1, char *p2, char flg) {
  struct output_def *tmp;
  char *p, buf[4];
  int i,w;
  if(!p2) fatal_error(9,NULL);
  if(NULL==(tmp=malloc(sizeof(struct output_def)))) fatal_error(0,"(N)");
  if(flg) { tmp->next = NULL;    execute = tmp; }
  else    { tmp->next = outlist; outlist = tmp; }
  if(NULL==(tmp->name=malloc(strlen(p1)+2))) fatal_error(0,"(O)");
  if(NULL==(tmp->text=malloc(strlen(p2)+2))) fatal_error(0,"(P)");
  strcpy(tmp->name,p1);
  strcpy(tmp->text,p2);
  strupr(tmp->name);
  if(strchr(tmp->name,'=')) fatal_error(15,tmp->name);
  if(!flg&&smode&&strchr(tmp->text,'=')) fatal_error(15,tmp->text);
  for(w=0,p=tmp->text; *p; p++) if(*p!='$') w++;
    else {
      i = 0;
      while(isdigit(p[1])&&(i<3)) buf[i++] = *(++p);
      buf[i] = '\0';
      if(!buf[0]) w++;
      else {
	i = get_number(buf,1,nfld) - 1;
	w += field[i]->w;
	}
      }
  if(w > sizeof(ruler) - 10) fatal_error(16,tmp->text);
  }

void read_layoutfile(void) {
  int i,j,k;
  char *p[5], *q, buf[256];
  while(!feof(layoutfil)) {
    buf[0] = '\0';
    lofpos = ftell(layoutfil);
    fgets(buf,254,layoutfil);
    lineno++;
    if(debug&1) fprintf(stderr,"%2d: %s",lineno,buf);
    p[0] = scanlin(buf);
    if(*p[0]&&(*p[0]!=';')) {
      strupr(p[0]);
      for(i=1; i<5; i++) p[i] = scanlin(NULL);
      for(i=j=0; i<NUMKEYWORDS; i++) if(!strcmp(keywords[i],p[0])) j = i + 1;
      if((lrow==0)&&(j!=1)) fatal_error(4,p[0]);
      switch(j) {
	case  1: // LAYOUT
		 read_layout(p[1],p[2],p[3]);
		 break;
	case  2: // DISPLAY
		 roff = get_number(p[1],1,scrlen-lrow+1);
		 coff = get_number(p[2],1,scrwid-lcol+1);
		 if(*p[3]&0X70) dfld = *p[3];
		 break;
	case  3: // COLOR
		 i = k = 0;
		 i = get_number(p[1],0,15);
		 if(p[2]&&*p[2]) k = get_number(p[2],0,7);
		 tatt = i | (k<<4);
		 if(p[3]&&*p[3]) {
		   i = get_number(p[3],0,15);
		   if(p[4]&&*p[4]) k = get_number(p[4],0,7);
		   }
		 fatt = i | (k<<4);
		 break;
	case  4: // FIELD
		 specify_field(p[1],p[2],p[3],p[4]);
		 break;
	case  5: // OUTPUT
		 specify_output(p[1],p[2],0);
		 break;
	case  6: // ERRTXT
		 i = get_number(p[1],1,6);
		 if(!*p[2]) fatal_error(9,NULL);
		 switch(i) {
		   case 1: q = ertxt1; break;
		   case 2: q = ertxt2; break;
		   case 3: q = ertxt3; break;
		   case 4: q = ertxt4; break;
		   case 5: q = ertxt5; break;
		   case 6: q = ertxt6; break;
		   }
		 strncpy(q,p[2],MAXERRTXT);
		 q[MAXERRTXT] = '\0';
		 break;
	case  7: // EXECUTE
		 specify_output(p[1],p[2],1);
		 break;
	case  8: // TIMEOUT
		 tout  = get_number(p[1],1,300) * 91 / 5;
		 toflg = (toupper(*p[2])=='R')?0X0D:0X1B;
		 break;
	default: fatal_error(3,p[0]);
		 break;
	}
      }
    }
  fclose(layoutfil);
  lineno = 0;
  if(errfld < -1) fatal_error(14,NULL);
  identify_input();
  if(!outlist&&!execute&&nfld2) fatal_error(7,NULL);
  if(!smode&&outlist&&execute) fatal_error(11,NULL);
  }

void minimalistic(int i, int argc, char* argv[]) {
  struct output_def *tmp;
  char buf[82];
  int j,l;
  lcol = 75;  // 78
  if(NULL==(form=calloc(1,sizeof(char*)))) fatal_error(0,"(Q)");
  if(NULL==(form[0]=malloc(lcol+2))) fatal_error(0,"(R)");
  if(i < argc) strncpy(buf,argv[i++],lcol-10);
  else strcpy(buf,"Input");
  if(buf[strlen(buf)-1]!=':') strcat(buf,":");
  for(j=l=strlen(buf); j<lcol; j++) buf[j] = ' ';
  buf[lcol] = '\0';
  strcpy(form[0],buf);
  if(NULL==(field=calloc(1,sizeof(FSTR*)))) fatal_error(0,"(S)");
  if(NULL==(field[0]=malloc(sizeof(FSTR)))) fatal_error(0,"(T)");
  field[0]->r       = 0;
  field[0]->c       = l + 1;
  field[0]->w       = lcol - field[0]->c;
  field[0]->ml      = 0;
  field[0]->typ     = 0;
  field[0]->text    = NULL;
  field[0]->aux.txt = NULL;
  if(NULL==(field[0]->text=malloc(field[0]->w+2))) fatal_error(0,"(U)");
  memset(field[0]->text,0,field[0]->w+2);
  if(i < argc) strncpy(field[0]->text,argv[i++],field[0]->w);
  if(NULL==(fld2=malloc(2))) fatal_error(0,"(V)");
  f1 = fld2[0] = 0;
  lrow = nrow = nfld = nfld2 = 1;
  roff = wherey();
  if(NULL==(tmp=malloc(sizeof(struct output_def)))) fatal_error(0,"(W)");
  tmp->next = outlist;
  outlist = tmp;
  if(NULL==(tmp->name=malloc(16))) fatal_error(0,"(X)");
  if(NULL==(tmp->text=malloc(6))) fatal_error(0,"(Y)");
  if(NULL==(scrsave=malloc((nrow*lcol*2)+4))) fatal_error(0,"($)");
  strcpy(tmp->name,"FORM_RESPONSE");
  strcpy(tmp->text,"$1");
  if(minimal>0) fatt = tatt = minimal;
  else if(minimal==0) fatt = tatt = 0X70;
  }

/*--- keyboard handling routines ----------------------------------*/

void beep(void) {
  sound(550);
  delay(200);
  nosound();
  }

void show_form(int m) {
  int i,j,n;
  textattr(tatt);
  if(m < 0) for(i=0; i<nrow; i++) {
    gotoxy(coff,roff+i);
    cprintf("%s",form[i]);
    }
  n = (m<1)?nfld:m;
  for(i=(m<1)?0:m-1; i<n; i++) {
    gotoxy(coff+field[i]->c,roff+field[i]->r);
    if((field[i]->typ&0X07)<0X06) textattr(fatt);
    else textattr(tatt);
    cprintf("%s",field[i]->text);
    if((field[i]->typ&0X07)<0X06)
      for(j=strlen(field[i]->text); j<field[i]->w; j++) cprintf("%c",dfld);
    else if((field[i]->typ&0X07)==0X06)
      for(j=strlen(field[i]->text); j<field[i]->w; j++) cprintf("%c",' ');
    }
  if(nfld2) gotoxy(coff+field[f1]->c+f2,roff+field[f1]->r);
  else gotoxy(1,1);
  }

char *chknum(int i) {
  int t;
  long lnum;
  char *p, *q;
  char form[10];
  t = (field[i]->typ&0X70) >> 4;
  strcpy(form,"%s %ld");
  switch(t) {
    case 0:
    case 1:
    case 2: lnum = strtol(field[i]->text,&p,10); break;
    case 3: lnum = strtol(field[i]->text,&p,8);  strcpy(form,"%s 0%lo");  break;
    case 4: lnum = strtol(field[i]->text,&p,16); strcpy(form,"%s 0X%lX"); break;
    }
  if(*p=='.') {
    q = strchr(&p[1],'.');
    if(!q) q = strchr(&p[1],'+');
    if(!q) q = strchr(&p[1],'-');
    if((p!=field[i]->text)||(p[1])) p = q;
    }
  if(p&&*p) {
    sprintf(ruler,"%s '%c'",ertxt5,*p);
    return(ruler);
    }
  if(field[i]->aux.lim) {
    if(lnum<field[i]->aux.lim->min) {
      sprintf(ruler,form,ertxt3,field[i]->aux.lim->min);
      return(ruler);
      }
    if(lnum>field[i]->aux.lim->max) {
      sprintf(ruler,form,ertxt4,field[i]->aux.lim->max);
      return(ruler);
      }
    }
  return(NULL);
  }

char *chkfil(int i, int flg) {
  int l;
  FILE *test;
  char *tmp, *res, *txt, eflg;
  res  = NULL;
  test = NULL;
  txt  = (flg)?ertxt2:ertxt1;
  if(NULL==(tmp=strrchr(field[i]->text,'\\'))) tmp = field[i]->text;
  if(NULL!=(tmp=strrchr(tmp,'.'))) {
    tmp[4] = '\0';
    show_form(i+1);
    }
  l = strlen(field[i]->text) + 6;
  if(field[i]->aux.txt) l += strlen(field[i]->aux.txt);
  if(NULL!=(tmp=malloc(l))) {
    if(field[i]->aux.txt) strcpy(tmp,field[i]->aux.txt);
    else *tmp = '\0';
    if(*tmp&&tmp[strlen(tmp)-1]!='\\') strcat(tmp,"\\");
    strcat(tmp,field[i]->text);
    test=fopen(tmp,"r");
    if(NULL==test) eflg = (flg==0);
    else {
      fclose(test);
      eflg = flg;
      }
    if(eflg) {
      l = sizeof(ruler) - strlen(txt) - 4;
      tmp[l] = '\0';
      sprintf(ruler,"%s%s",txt,tmp);
      res = ruler;
      }
    free(tmp);
    }
  return(res);
  }

char check_results(void) {
  int i,j;
  char *etxt;
  etxt = NULL;
  for(i=0; i<nfld2; i++) {
    j = fld2[i];
    if(strlen(field[j]->text)<field[j]->ml) {
      sprintf(ruler,"%s%d",ertxt6,field[j]->ml);
      etxt = ruler;
      }
    else if((field[j]->typ&0X07)==1) switch(field[j]->typ&0X70) {
      case 0X00:
      case 0X10:
      case 0X20:
      case 0X30:
      case 0X40: etxt=chknum(j);   break;
      case 0X50:                   break;
      case 0X60: etxt=chkfil(j,0); break;
      case 0X70: etxt=chkfil(j,1); break;
      }
    if(etxt) {
      f0 = i; f1 = fld2[i]; f2 = 0;
      fatt |= 0X80;
      show_form(j+1);
      fatt &= 0X7F;
      strncpy(field[errfld]->text,etxt,field[errfld]->w);
      field[errfld]->text[field[errfld]->w] = '\0';
      show_form(errfld+1);
      if(dobeep) beep();
      return(0);
      }
    }
  return(0X0D);
  }

int kbd_service(void) {
  int ch, upd, i;
  ch = 0;
  t0 = *timer;
  do {
    if(kbhit()) {
       t0 = *timer;
       upd = 1;
       ch  = getch();
       if(!ch) ch = getch() | 0X100;
       if(nfld2) switch(ch) {
	 case 0X08:  // back space
		     if(f2&&(field[f1]->typ&7)<3) { // text field
		       i = f2 - 1;
		       while(field[f1]->text[i]) {
			 field[f1]->text[i] = field[f1]->text[i+1];
			 i++;
			 }
		       f2--;
		       }
		     break;
	 case 0X147: // cursor home
		     f0 = 0;
		     f1 = fld2[f0];
		     f2 = 0;
		     break;
	 case 0X148: // cursor up
		     if(f0) f0--;
		     else f0 = nfld2 - 1;
		     f1 = fld2[f0];
		     f2 = 0;
		     break;
	 case 0X14B: // cursor left
		     if((field[f1]->typ&7)<3) { // text field
		       if(f2 > 0) f2--;
		       else upd = 0;
		       }
		     else if((field[f1]->typ&7)==3) { // pre-defined
		       if(field[f1]->aux.sel->idx>0) field[f1]->aux.sel->idx--;
		       else field[f1]->aux.sel->idx = field[f1]->aux.sel->max -1;
		       strcpy(field[f1]->text,field[f1]->aux.sel->lst[field[f1]->aux.sel->idx]);
		       }
		     else upd = 0;
		     break;
	 case 0X14D: // cursor right
		     if((field[f1]->typ&7)<3) { // text field
		       if(f2 < strlen(field[f1]->text)) f2++;
		       else upd = 0;
		       }
		     else if((field[f1]->typ&7)==3) { // pre-defined
		       if(field[f1]->aux.sel->idx<field[f1]->aux.sel->max-1) field[f1]->aux.sel->idx++;
		       else field[f1]->aux.sel->idx = 0;
		       strcpy(field[f1]->text,field[f1]->aux.sel->lst[field[f1]->aux.sel->idx]);
		       }
		     else upd = 0;
		     break;
	 case 0X09:  // TAB
	 case 0X150: // cursor down
		     f0++;
		     if(f0>=nfld2) f0 = 0;
		     f1 = fld2[f0];
		     f2 = 0;
		     break;
	 case 0X152: // insert
		     if((field[f1]->typ&7)<3) { // text field
		       i = field[f1]->w - 1;
		       while(i > f2) {
			 field[f1]->text[i] = field[f1]->text[i-1];
			 i--;
			 }
		       if(check_ch(' ',f1)) field[f1]->text[f2] = ' ';
		       }
		     break;
	 case 0X153: // erase
		     if((f2<strlen(field[f1]->text))&&(field[f1]->typ&7)<3) { // text field
		       i = f2;
		       while(field[f1]->text[i]) {
			 field[f1]->text[i] = field[f1]->text[i+1];
			 i++;
			 }
		       }
		     break;
	 case 0X173: // CTRL/cursor-left
		     if((field[f1]->typ&7)<3) f2 = 0; // text field
		     break;
	 case 0X174: // CTRL/cursor-right
		     if((field[f1]->typ&7)<3) f2 = strlen(field[f1]->text); // text field
		     break;
	 default:    if(ch < ' ') upd = 0;
		     else if((field[f1]->typ&7)<3) {
		       ch = check_ch(ch,f1);
		       if(!ch&&dobeep) beep();
		       if(ch&&(f2<field[f1]->w)) field[f1]->text[f2++] = ch;
		       }
		     else if((field[f1]->typ&7)==5) {
		       if(!(field[f1]->typ&0XF0)) field[f1]->text[0] = (ch==' ')?' ':'X';
		       else if(ch==' ') upd = 0;
		       else {
			 clr_radio_buttons(f1,1);
			 field[f1]->text[0] = 'X';
			 }
		       }
		     else upd = 0;
	  }
	else upd = 0;
	if(upd) show_form(f1+1);
	upd = 0;
	if(ch==0X0D) ch = check_results();
	}
      if(toflg) if((*timer-t0)>tout) {
	ch = toflg;
	if(ch==0X0D) ch = check_results();
	toflg = 0;
	}
      }
    while((ch!=0x1B)&&(ch!=0x0D));
  return(ch);
  }

/*--- output routines ---------------------------------------------*/

void put_parentenv(char *cmdp) {
  unsigned int far *ip1; // ptr --> parent's PSP
  unsigned int far *ip2; // ptr --> ptp -->  parent's environment
  unsigned int far *ip3; // ptr --> size  of parent's environment
  int pesize, peused;    // available, actually used
  char far *pebeg;       // ptr --> Parent's Environment BEGin
  char far *peend;       // ptr --> Parent's Environment END
  char far *cp1;
  char far *cp2;
  char far *vpos;        // ptr --> variable, if already present
  int  vlen,vsiz;        // new len, present len, if already present
  vpos = NULL;
  vsiz = 0;
  vlen = (strchr(cmdp,'=') - cmdp) + 1;
  ip1 = MK_FP(_psp,0X0016);
  ip2 = MK_FP(*ip1,0X002C);
  pebeg = MK_FP(*ip2,0);
  ip3 = MK_FP(*ip2-1,3);
  for(cp1=pebeg; *cp1; cp1=MK_FP(FP_SEG(cp1),FP_OFF(cp1)+_fstrlen(cp1)+1))
    if(!_fstrncmp(cp1,cmdp,vlen)) { vpos = cp1; vsiz = _fstrlen(cp1) + 1; }
  peend  = cp1;
  peused = cp1 - pebeg + 1;
  pesize = *ip3 <<  4;
  if(vsiz) {             // if already present, remove it first
    cp1 = vpos;
    cp2 = MK_FP(FP_SEG(cp1),FP_OFF(cp1)+vsiz);
    while(cp2 < peend) *cp1++ = *cp2++;
    peend  = cp1;
    peused -= vsiz;
    }
  if((pesize-peused-5)<strlen(cmdp)) fatal_error(19,NULL);
  else {                 // now append new copy, if space is sufficient
    _fstrcpy(peend,cmdp);
    cp1  = MK_FP(FP_SEG(peend),FP_OFF(peend)+strlen(cmdp)+1);
    *cp1 = '\0';
    }
  }

void evaluate_results(struct output_def *od, char *sep) {
  int i,j,t;
  char *p, *q, *r, buf[4];
  strcpy(ruler,od->name);
  strcat(ruler,sep);
  for(p=od->text,q=&ruler[strlen(ruler)]; *p&&(q<rulend); p++)
    if(*p!='$') *q++ = *p;
    else {
      *q = '\0';
      i = 0;
      while(isdigit(p[1])&&(i<3)) buf[i++] = *(++p);
      buf[i] = '\0';
      if(!buf[0]) *q++ = *(++p);
      else {
	i = atoi(buf) - 1;
	t = field[i]->typ;
	if((t&0X07)!=0X05) r = field[i]->text;
	else if(!(t&0XF0)) { r = field[i]->text; if(*r) r = field[i]->aux.txt; }
	else for(j=0; j<nfld; j++)
	  if((field[j]->typ==t)&&(field[j]->text[0])) r = field[j]->aux.txt;
	if((strlen(ruler)+strlen(r)) < (sizeof(ruler)-8)) strcat(ruler,r);
	q = &ruler[strlen(ruler)];
	}
      }
  *q = '\0';
  }

void output_results(void) {
  struct output_def *od;
  int i,j,t;
  char *p;
  for(od=outlist; od; od=od->next) {
    evaluate_results(od,"=");
    if(smode) printf("SET %s\n",ruler);
    else if(!execute) put_parentenv(ruler);
    }
  }

void execute_command(void) {
  if(!execute) return;
  evaluate_results(execute," ");
  if(smode) printf("%s\n",ruler);
  else system(ruler);
  }

/*--- main program ------------------------------------------------*/

void main (int argc, char* argv[]) {
  int i,j,m;
  char *p;
  if((mypath=malloc(strlen(argv[0])+4))==NULL) fatal_error(0,"(Z)");
  strcpy(mypath,argv[0]);
  strupr(mypath);
  if((p=strrchr(mypath,'\\'))==NULL) p = strchr(mypath,':');
  if(p) {
    *p++   = '\0';
    myname = p;
    }
  else {
    memmove(&mypath[1],mypath,strlen(mypath)+1);
    *mypath = '\0';
    myname  = &mypath[1];
    }
  if((p=strrchr(myname,'.'))!=NULL) *p = '\0';
  scrlen = get_scrlen();

  for(i=1; i < argc && ((*argv[i]=='/')||(*argv[i]=='-'));i++) {
    switch (toupper(argv[i][1])) {
      case 'D': debug  = atoi(&argv[i][2]);            break;
      case 'K': clrfrm = 0;                            break;
      case 'S': smode  = 1;                            break;
      case 'M': if(!isdigit(argv[i][2])) minimal = -1;
		else minimal = atoi(&argv[i][2])&0X7F; break;
      case 'H':
      case '?': show_help();                           break;
      }
    }
  if(minimal > -2) minimalistic(i,argc,argv);
  else {
    if(i>=argc) fatal_error(1,NULL);
    p = getenv("FORM_DIR");
    j = strlen(argv[i])+8;
    if(p) j += strlen(p);
    if((lofnam=malloc(j))==NULL) fatal_error(0,"(#)");
    if(!p||(argv[i][0]=='.')||(argv[i][0]=='\\')) lofnam[0] = '\0';
    else {
      strcpy(lofnam,p);
      if(lofnam[strlen(lofnam)-1]!='\\') strcat(lofnam,"\\");
      }
    strcat(lofnam,argv[i]);
    strupr(lofnam);
    if((p=strrchr(lofnam,'\\'))==NULL) p = strrchr(lofnam,':');
    if(!p) p = lofnam;
    if(strchr(p,'.')==NULL) strcat(lofnam,".FRM");
    while((i<argc)&&(gargc<9)) gargv[gargc++] = argv[i++];
    if(NULL==(layoutfil=fopen(lofnam,"r"))) fatal_error(2,lofnam);
    read_layoutfile();
    fclose(layoutfil);
    }
  if(debug&2) dump_data(1);
  rowsave = wherey();
  gettext(coff,roff,coff+lcol-1,roff+nrow-1,scrsave);
  show_form(-1);

  m = kbd_service();

  if(clrfrm) puttext(coff,roff,coff+lcol-1,roff+nrow-1,scrsave);
  textmode(C80);
  gotoxy(1,rowsave);
  if(!clrfrm&&(minimal > -2)) {
    gotoxy(79,rowsave);
    textattr(orgatt);
    cprintf(" \n");
    printf("\r");
    }
  if(debug&4) dump_data(0);
  if(m == 0X0D) {
    output_results();
    execute_command();
    }
  exit((m==0X0D)?0:1);
  }
