#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>

// #define debugvers 1

typedef struct {
  unsigned char beg;
  unsigned char len;
  } fieldtype;
fieldtype field[10];
fieldtype separ[10];
unsigned  char nfld;
char *replace[12];
char *rplsave[12];
char  rplflag = 0;
struct {
  unsigned char beg;
  unsigned char len;
  } pmatch[10];

typedef struct xchelement {
  struct xchelement *next;
  unsigned     char  fm;
  unsigned     char  to;
  } xchelement;
typedef xchelement *xchelemp;
xchelemp xch[12], xchsave[12];
char xchflag = 0;

typedef struct matchtype {
  struct matchtype *next;
  char              text[];
  } matchtype;
typedef matchtype *mtp;
mtp match[12];

unsigned int trunc = 0;
unsigned int lnr   = 0;
unsigned int numl0 = 0;
unsigned int numl1 = 0;
unsigned int numf0 = 0;
unsigned int numf1 = 0;

char prnomatch   = 0;
char matchmode   = 0;
char safemode    = 0;
char csvmode     = 0;
char fixmode     = 0;
#ifdef debugvers
char dbgmode     = 0;
#endif

char sepchr[256];
char inlin[770];
char *outlin;    // --> inlin[256] (to serve as overflow during read
char format[256] = "\\B\\S0\\F0\\S1\\F1\\S2\\F2\\S3\\F3\\S4\\F4\\S5\\F5\\S6\\F6\\S7\\F7\\S8\\F8\\S9\\F9";

char helptext[] = "\n\
 FAM 1.3 by Jrgen Hoffmann (2010) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n\
 usage: <program> | fam [ options ] [ format ] [ > newfile ]\n\
    or:             fam [ options ] [ format ] [ > newfile ] < <oldfile>\n\
 options are:\n\
     /F<fld>       define fixed fields e.g. /F3.5.2 or /F-3.5.2\n\
     /C<str>       define set of separator  characters\n\
     /W<str>       define set of whitespace characters\n\
		   A-Z range   \\XX hex   ^<str> complement\n\
     /R<m><str>    replace field <m> (0..9,#,*) by string <str> (or /S)\n\
     /X<m><c1><c2> exchange in field <m> character <c1> by <c2>\n\
     /P            print non-matching lines unchanged\n\
     /L<?><num>    only if line #   <?>: = equal  # not equal\n\
     /N<?><num>    only if # fields <?>: - less   + greater <num>\n\
     /M<n><c><str> only lines where field <n> matches <str> according to <c>\n\
	       <n> 0..9 field n     # last field  * any field\n\
	       <c> = is equal       { not- ( begining with  ? containing\n\
		   # is not equal   } not- ) ending with    ! not containing\n\
 format can be any text including the following special codes:\n\
		   \\Fn field n      \\Tn trim n    \\N # of fields\n\
		   \\F# last field   \\Pn pad to n  \\L line #\n\
		   \\F* input line   \\Q quote (\")  \\Xxx hex code\n\
		   \\Sn separator n  \\\\ backslash  \\B conditional break\n";

void error_msg(int i, char *p) {
  fprintf(stderr,"ERROR: ");
  switch(i) {
    case  1: fprintf(stderr,"bad field descriptor '%c' in switch: /M%s",*p,p);       break;
    case  2: fprintf(stderr,"bad match criterion '%c' in switch: /M%s",p[1],p);      break;
    case  3: fprintf(stderr,"bad field descriptor '%c' in switch: /R%s",*p,p);       break;
    case  4: fprintf(stderr,"number expected in switch: /F%s",p);                    break;
    case  5: fprintf(stderr,"bad code in output format: %3.3s",p);                   break;
    case  6: fprintf(stderr,"bad code in output format: %4.4s",p);                   break;
    case  7: fprintf(stderr,"bad qualifier '%c' in switch: %s",p[2],p);              break;
    case  8: fprintf(stderr,"number expected in switch: %s",p);                      break;
    case  9: fprintf(stderr,"bad command line switch: %s",p);                        break;
    case 10: fprintf(stderr,"bad field descriptor '%c' in switch: /X%s",*p,p);       break;
    case 11: fprintf(stderr,"bad field descriptor '%c' in switch: /S%s",*p,p);       break;
    case 12: fprintf(stderr,"bad hex code in switch: /X%s",p);                       break;
    case 13: fprintf(stderr,"line number %s is much to long ( > 760 characters)",p); break;
    }
  fprintf(stderr,"\n");
  exit(1);
  }

#ifdef debugvers
void dump_sepchr(void) {
  int i,j,l;
  l = strlen(sepchr);
  for(i=0; i < l; i+=16) {
    for(j=0; j < 16; j++) fprintf(stderr,((i+j)<l?"%02X ":"   "),sepchr[i+j]&0XFF);
    fprintf(stderr,"  ");
    for(j=0; j<16&&i+j<l; j++) fprintf(stderr,"%c",((sepchr[i+j]&0xFF)<' '?'':sepchr[i+j]));
    fprintf(stderr,"\n");
    }
  }
#endif

void set_numarg(char *p) {
  unsigned int num0, num1;
  switch(p[2]) {
    case '+': num0 = 4; break;
    case '-': num0 = 5; break;
    case '=': num0 = 6; break;
    case '#': num0 = 7; break;
    default: error_msg(7,p);
    }
  if(!isdigit(p[3])) error_msg(8,p);
  else num1 = atoi(&p[3]);
  if(toupper(p[1])=='N') { numf0 = num0; numf1 = num1; }
  else                   { numl0 = num0; numl1 = num1; }
  }

void set_match(char *p) {
  matchtype *mt;
  int i,l;
  if(isdigit(*p))  i = *p & 0X0F;
  else if(*p=='#') i = 10;
  else if(*p=='*') i = 11;
  else error_msg(1,p);
  if(!p[1]||!strchr("=#()?!{}",p[1])) error_msg(2,p);
  p++;
  mt = malloc(strlen(p)+1+sizeof(mtp));
  if(!mt) return;
  mt->next = match[i];
  strcpy(mt->text,p);
  match[i] = mt;
  matchmode = 1;
  }

void set_replace(char *p, unsigned char subst) {
  int i;
  if(isdigit(*p))  i = *p & 0X0F;
  else if(*p=='#') i = 10;
  else if(*p=='*') i = 11;
  else error_msg((subst=='R')?3:11,p);
  *p = subst;
  if(replace[i]==NULL) {
    replace[i] = malloc(strlen(p)+1);
    if(replace[i]!=NULL) strcpy(replace[i],p);
    }
  rplflag = 1;
  }

unsigned char hex2b(char *p, char *p0) {
  char tmp[4];
  if(!isxdigit(*p)||!isxdigit(p[1])) error_msg(12,p0);
  tmp[0] = *p++;
  tmp[1] = *p++;
  tmp[2] = '\0';
  return(strtol(tmp,NULL,16) & 0XFF);
  }

void set_xchange(char *p) {
  int i;
  char *p0;
  xchelemp xp;
  if(isdigit(*p))  i = *p & 0X0F;
  else if(*p=='#') i = 10;
  else if(*p=='*') i = 11;
  else error_msg(10,p);
  p0 = p++;
  if(!*p) error_msg(12,p0);
  xp = malloc(sizeof(xchelement));
  if(!xp) return;
  if(*p!='\\')        xp->fm = *p++;
  else if(*++p=='\\') xp->fm = *p++;
  else {
    xp->fm = hex2b(p,p0);
    p += 2;
    }
  if(*p!='\\')        xp->to = *p++;
  else if(*++p=='\\') xp->to = *p++;
  else xp->to = hex2b(p,p0);
  xp->next = xch[i];
  xch[i]   = xp;
  xchflag  = 1;
  }

void set_sepchr(char *p) {
  unsigned char tmp[230];
  unsigned char *q, c, neg, tmp2[4];
  neg = 0;
  if(*p=='^') {
    neg = 1;
    p++;
    }
  if(strchr(p,'\\')) {
    for(q=tmp; *p; p++)
      if(*p!='\\') *q++ = *p;
      else {
	p++;
	if(!isxdigit(*p)||!isxdigit(p[1])) *q++ = *p;
	else {
	  tmp2[0] = *p++;
	  tmp2[1] = *p;
	  tmp2[2] = '\0';
	  *q++ = strtol(tmp2,NULL,16) & 0XFF;
	  }
	}
    *q++ = '\0';
    p = tmp;
    }
  q = &sepchr[31];
  *q++ = c = *p++;
  for( ; *p; p++)
    if((*p!='-')||(c>=p[1])) *q++ = c = *p;
    else for(c++ ; c<p[1]; c++)  *q++ = c;
  *q = '\0';
  if(neg) {
    for(q=tmp,c=' '; c<255; c++) if(!strchr(&sepchr[31],c)) *q++ = c;
    *q = '\0';
    strcpy(&sepchr[31],tmp);
    }
  }

void set_fixmode(char *p) {
  char *q;
  q = p;
  fixmode = 1;
  if(*p=='-') {
    p++;
    fixmode = -1;
    }
  if(isdigit(*p)) {
    q = &sepchr[31];
    while(*p) {
      *q++ = atoi(p);
      while(isdigit(*p)) p++;
      while(*p&&!isdigit(*p)) p++;
      }
    *q = 0;
    sepchr[40] = 0;
    }
  else error_msg(4,q);
  }

void chop(void) {
  int i,j,k,l;
  nfld = 0;
  l = strlen(inlin);
  for(i=1; i<10; i++) {
    field[i].beg = field[i].len = 0;
    separ[i].beg = separ[i].len = 0;
    }
  if(fixmode>0) {
    for(i=31,j=0; sepchr[i]&&j<l; i++,nfld++) {
      field[nfld].beg = j;
      if((j+sepchr[i])<=l) field[nfld].len = sepchr[i];
      else field[nfld].len = l-j;
      j += sepchr[i];
      }
    if(j<l) {
      field[nfld].beg = j;
      field[nfld].len = l-j;
      nfld++;
      }
    }
  else {
    for(i=31; sepchr[i]; i++); i--;
    for(k=9,j=l; j>sepchr[i]&&i>30; i--,k--) {
      j -= sepchr[i];
      field[k].beg = j;
      field[k].len = sepchr[i];
      }
    if(j) {
      field[k].beg = 0;
      field[k].len = j;
      }
    for(nfld=0; k<10; k++,nfld++) {
      field[nfld].beg = field[k].beg;
      field[nfld].len = field[k].len;
      }
    for(k=nfld ; k<10; k++) field[k].beg = field[k].len = 0;
    }
  }

void split(void) {
  int i;
  nfld = 0;
  for(i=0; i<10; i++) field[i].beg = field[i].len = separ[i].beg = separ[i].len = 0;
  for(i=0; inlin[i]&&nfld<10; i++) if(strchr(sepchr,inlin[i])) {
    field[nfld].len = i - field[nfld].beg;
    nfld++;
    if(nfld<10) {
      separ[nfld].beg = i;
      separ[nfld].len = 1;
      field[nfld].beg = i+1;
      }
    }
  if(nfld>9) field[9].len = strlen(inlin) - field[9].beg;
  else {
    field[nfld].len = strlen(inlin) - field[nfld].beg;
    if(field[0].len||separ[1].len) nfld++;
    }
  }

void scan(void) {
  int i;
  nfld = 0;
  for(i=0; i<10; i++) field[i].beg = field[i].len = separ[i].beg = separ[i].len = 0;
  for(i=0; inlin[i]&&nfld<10; ) {
    while(inlin[i]&&strchr(sepchr,inlin[i])) i++;
    separ[nfld].len = i - separ[nfld].beg;
    if(inlin[i]) {
      field[nfld].beg = i;
      while(inlin[i]&&!strchr(sepchr,inlin[i])) i++;
      field[nfld].len = i - field[nfld].beg;
      nfld++;
      if(inlin[i]&&nfld<10) separ[nfld].beg = i;
      }
    }
  if(inlin[i]&&field[9].beg) field[9].len = strlen(inlin) - field[9].beg;
  }

int check_num(void) {
  int res;
  res = 1;
  if(!numl0&&!numf0) return(res);
  switch(numf0) {
    case 4: if(nfld<=numf1) res = 0; break;
    case 5: if(nfld>=numf1) res = 0; break;
    case 6: if(nfld!=numf1) res = 0; break;
    case 7: if(nfld==numf1) res = 0; break;
    }
  if(res) switch(numl0) {
    case 4: if(lnr<=numl1) res = 0; break;
    case 5: if(lnr>=numl1) res = 0; break;
    case 6: if(lnr!=numl1) res = 0; break;
    case 7: if(lnr==numl1) res = 0; break;
    }
  return(res);
  }

int matches(char *p, int f) {
  int b,l,m;
  char *q;
  b = field[f].beg;
  l = field[f].len;
  m = strlen(&p[1]);
  switch(*p++) {
    case '=': return((l>=m)&&!strncmp(p,&inlin[b],l));
    case '#': return((l<m)||strncmp(p,&inlin[b],l));
    case '(': if(l<m) return(0);
	      if(!strncmp(p,&inlin[b],m)) {
		pmatch[f].len = m;
		return(1);
		}
	      else return(0);
    case '{': return((l<m)||strncmp(p,&inlin[b],m));
    case ')': if(l<m) return(0);
	      if(!strncmp(p,&inlin[b+l-m],m)) {
		pmatch[f].beg = l-m;
		pmatch[f].len = m;
		return(1);
		}
	      else return(0);
    case '}': return((l<m)||strncmp(p,&inlin[b+l-m],m));
    case '?': if(!l) return(0);
	      q = strstr(&inlin[b],p);
	      if(q&&(q<=&inlin[b+l-m])) {
		pmatch[f].beg = q - &inlin[b];
		pmatch[f].len = m;
		return(1);
		}
	      else return(0);
    case '!': if(!l) return(1);
	      q = strstr(&inlin[b],p);
	      return(!q||(q>&inlin[b+l-m]));
    }
  return(1);
  }

int chkmtch(int x, int y) {
  mtp mt;
  int res;
  res = 0;
  mt  = match[x];
  if(!mt) return(1);
  while(!res&&mt) {
    res = matches(mt->text,y);
    mt  = mt->next;
    }
  return(res);
  }

int check_match(void) {
  int res,i,j;
  if(replace[10]) replace[(nfld)?nfld-1:0] = replace[10];
  if(xch[10]) xch[(nfld)?nfld-1:0] = xch[10];
  if(!check_num()) return(0);
  if(!matchmode)   return(1);
  for(res=1,i=0; res&&i<11; i++) {
    j = (i<10)?i:(nfld)?nfld-1:0;
    res = chkmtch(i,j);
    }
  if(!match[11]||!res) return(res);
  for(res=i=0; i<nfld; i++) if(chkmtch(11,i)) {
    if(replace[11]) replace[i] = replace[11];
    if(xch[11]) xch[i] = xch[11];
    res = 1;
    }
  return(res);
  }

void putline(void) {
  int i,j,b,l,brk,trm;
  char *p, *q, *q0, c, tmp[8];
  xchelemp xp;
  trm = brk = 0;
  for(p=format,q=outlin; *p&&brk<2; ) {
    if(*p!='\\') *q++ = *p++;
    else switch(toupper(p[1])) {
      case 'B': brk = 1; p += 2;              break;
      case 'T': trm = 1;
      case 'F': i = p[2];
		q0 = q;
		if(isdigit(i)||(i=='#')) {
		  if(isdigit(i)) j = i & 0X0F;
		  else j = (nfld)?nfld-1:0;
		  if(replace[j]==NULL) {
		    b = field[j].beg;
		    l = field[j].len;
		    if(trm) {
		      while(l&&inlin[b]<=' ') { b++; l--; }
		      while(l&&inlin[b-1+l]<=' ') l--;
		      }
		    strncpy(q,&inlin[b],l);
		    q += l;
		    }
		  else {
		    if(replace[j][0]=='R'||!pmatch[j].len) {
		      strcpy(q,&replace[j][1]);
		      q += strlen(&replace[j][1]);
		      }
		    else {
		      if(pmatch[j].beg) {
			b = field[j].beg;
			l = pmatch[j].beg;
			if(trm) while(l&&inlin[b]<=' ') { b++; l--; }
			strncpy(q,&inlin[b],l);
			q += l;
			}
		      strcpy(q,&replace[j][1]);
		      q += strlen(&replace[j][1]);
		      b = field[j].beg+pmatch[j].beg+pmatch[j].len;
		      l = field[j].len - pmatch[j].beg - pmatch[j].len;
		      if(l>0) {
			if(trm) while(l&&inlin[b-1+l]<=' ') l--;
			strncpy(q,&inlin[b],l);
			q += l;
			}
		      }
		    }
		  if(xch[j]) while(q0<q) {
		    xp = xch[j];
		    while(xp) {
		      if(xp->fm==*q0) {
			*q0 = xp->to;
			break;
			}
		      xp = xp->next;
		      }
		    q0++;
		    }
		  if(brk&&isdigit(i)&&(j>=(nfld-1))) brk = 2;
		  }
		else if(i=='*') {
		  strcpy(q,inlin);
		  q += strlen(inlin);
		  }
		else error_msg(5,p);
		p += 3;			      break;
      case 'L': sprintf(tmp,"%d",lnr);
		strcpy(q,tmp);
		q += strlen(tmp);
		p += 2;                       break;
      case 'N': sprintf(tmp,"%d",nfld);
		strcpy(q,tmp);
		q += strlen(tmp);
		p += 2;                       break;
      case 'P': i = 0;
		if((p[2]>='2')&&(p[2]<='9')) i = p[2] & 0X0F;
		else if((p[2]=='1')&&(p[3]>='0')&&(p[3]<='9')) {
		  i = 10 + (p[3] & 0X0F);
		  p += 1;
		  }
		if(i) {
		  l = q - outlin;
		  while(l % i) { *q++ = ' '; l++; }
		  }
		p += 3;                       break;
      case 'S': i = p[2];
		if(isdigit(i)||(i=='#')) {
		  if(isdigit(i)) j = i & 0X0F;
		  else j = (nfld)?nfld-1:0;
		  strncpy(q,&inlin[separ[j].beg],separ[j].len);
		  q += separ[j].len;
		  }
		else error_msg(5,p);
		 p += 3;		      break;
      case 'Q': *q++ = '"'; p += 2;           break;
      case 'X': if(!isxdigit(p[2])||!isxdigit(p[3])) error_msg(6,p);
		else {
		  tmp[0] = p[2];
		  tmp[1] = p[3];
		  tmp[2] = '\0';
		  p += 2;
		  *q++ = strtol(tmp,NULL,16) & 0XFF;
		  }
		p += 2;                       break;
#ifdef debugvers
      case 'Y': i = p[2];
		if(isdigit(i)||(i=='#')||(i=='*')) {
		  if(i=='*') sprintf(tmp,"%d",strlen(inlin));
		  else {
		    if(isdigit(i)) j = i & 0X0F;
		    else j = (nfld)?nfld-1:0;
		    sprintf(tmp,"%d",field[j].len);
		    }
		  strcpy(q,tmp);
		  q += strlen(tmp);
		  }
		p += 3;                       break;
#endif
      default:  p++; *q++ = *p++;             break;
      }
    trm = 0;
    }
  *q++ = '\0';
  printf("%s\n",outlin);
  }

void main (int argc, char* argv[]) {
  int   i,j;
  char *p;

  for(i=0; i<12; i++) xch[i]     = NULL;
  for(i=0; i<12; i++) match[i]   = NULL;
  for(i=0; i<32; i++) sepchr[i]  = i+1;
  for(i=0; i<12; i++) replace[i] = rplsave[i] = NULL;
  for(i=1; i < argc && ((*argv[i]=='/')||(*argv[i]=='-')); i++) {
    switch (toupper(argv[i][1])) {
      case 'F': set_fixmode(&argv[i][2]);         break;
      case 'L': set_numarg(argv[i]);              break;
      case 'M': set_match(&argv[i][2]);           break;
      case 'N': set_numarg(argv[i]);              break;
      case 'P': prnomatch = 1;                    break;
      case 'C': csvmode   = 1;
      case 'W': set_sepchr(&argv[i][2]);          break;
      case 'R': set_replace(&argv[i][2],'R');     break;
      case 'S': set_replace(&argv[i][2],'S');     break;
      case 'X': set_xchange(&argv[i][2]);         break;
#ifdef debugvers
      case 'Y': dbgmode = 1;                      break;
#endif
      case 'H':
      case '?': printf(helptext);                 exit(0);
      default : error_msg(9,argv[i]);
      }
    }
  for(j=i ; i < argc; i++) {
    if(i==j) strcpy(format,argv[i]);
    else {
      strcat(format," ");
      strcat(format,argv[i]);
      }
    }
  outlin = &inlin[256];
#ifdef debugvers
  if(dbgmode) {
    fprintf(stderr,"csvmode=%d fixmode=%d matchmode=%d rplflag=%d xchflag=%d len(sepchr)=%d\n",
		    csvmode,fixmode,matchmode,rplflag,xchflag,strlen(sepchr));
    fprintf(stderr,"format=%s\n",format);
    dump_sepchr();
    }
#endif
  while(gets(inlin)) {
    lnr++;
    i = strlen(inlin);
    if(i > 255) {
      trunc++;
      if(i > 760) {
	sprintf(outlin,"%d",lnr);
	error_msg(13,outlin);
	}
      }
    inlin[255] = '\0';
    if(matchmode) for(i=0; i<10; i++) pmatch[i].beg = pmatch[i].len = 0;
    if(rplflag)   for(i=0; i<10; i++) rplsave[i] = replace[i];
    if(xchflag)   for(i=0; i<10; i++) xchsave[i] = xch[i];
    if(fixmode) chop();
    else if(csvmode) split();
    else scan();
    if(check_match())  putline();
    else if(prnomatch) printf("%s\n",inlin);
    if(rplflag) for(i=0; i<10; i++) replace[i] = rplsave[i];
    if(xchflag) for(i=0; i<10; i++) xch[i]     = xchsave[i];
    }
  if(trunc) fprintf(stderr,"WARNING: %d lines truncated to 255 characters\n",trunc);
  exit(0);
  }
