unit Parser;
{$N+}
{$E+}
{It is a GNU/GPL source and it does not use any part by somebody else than me}
interface
Function SpocitejVyraz(s:string):real;
Function Prepocet_pozice_chyby(s:string):byte;

const
      pocet_funkci_parseru = 12;
      funkce_parseru:array[1..pocet_funkci_parseru] of string[10] =
                                                    ('SIN',
                                                     'COS',
                                                     'SQR',
                                                     'SQRT',
                                                     'TAN',
                                                     'COTAN',
                                                     'ARCSIN',
                                                     'ARCCOS',
                                                     'ARCTAN',
                                                     'LN',
                                                     'EXP',
                                                     'NOT'
                                                    );


      CHYBA_ZADNA             = 0;
      CHYBA_ZADANI            = 1;
      CHYBA_DELENI_0          = 2;
      CHYBA_ZAPORNA_ODMOCNINA = 3;
      CHYBA_MOCNENI           = 4;
      CHYBA_BITOVA_OPERACE_S_REALNYM_CISLEM = 5;
      CHYBA_MOCVELKE          = 6;
      CHYBA_MOCMALE           = 7;
      CHYBA_LOGARITMU         = 8;

type ProcType = procedure;

var
StaryExit:ProcType;
druh_chyby_parseru:byte;
pozice_chyby_parseru:byte;
zpracuj_chybu_parseru:procedure;


{=========================================================================}
implementation

const NIC     =0;
      SOUCET  =1;
      ODECET  =3;
      NASOBENI=4;
      DELENI  =5;
      MOCNENI =6;
      BIT_AND =7;
      BIT_XOR =8;
      BIT_OR  =9;

      ZAPORNE_NASOBENI =104;
      ZAPORNE_DELENI   =105;
      ZAPORNE_MOCNENI  =106;
      ZAP_BIT_AND      =107;
      ZAP_BIT_XOR      =108;
      ZAP_BIT_OR       =109;


symboly = ['+','-','*','/','^','|'];
cislice = ['0'..'9','.'];

Type JumpRecord = Record
                        SpReg,
                        BpReg  : Word;
                        JmpPt  : Pointer;
                  end;

var odskok:jumprecord;

Function Uroven1(s:string):real;forward;
{==========================================================================}


Procedure SetJump ( Var JumpDest : JumpRecord );
{Storing SP,BP and the address}
inline(
       $5F/                   {pop di           }
       $07/                   {pop es           }
       $26/$89/$25/           {mov es:[di],sp   }
       $26/$89/$6D/$02/       {mov es:[di+2],bp }
       $E8/$00/$00/           {call null        }
                              {null:            }
       $58/                   {pop ax           }
       $05/$0C/$00/           {add ax,12        }
       $26/$89/$45/$04/       {mov es:[di+4],ax }
       $26/$8C/$4D/$06);      {mov es:[di+6],cs }
                              {next:            }

Procedure LongJump ( Var JumpDest : JumpRecord );
{Restore everything and jump}
inline(
       $5F/                   {pop di           }
       $07/                   {pop es           }
       $26/$8B/$25/           {mov sp,es:[di]   }
       $26/$8B/$6D/$02/       {mov bp,es:[di+2] }
       $26/$FF/$6D/$04);      {jmp far es:[di+4]}


function Mocnina(base,exponent:real):real;
var r:real;
begin
Mocnina:=0;
if (Exponent=0.0) and (base=0.0) then
   begin druh_chyby_parseru:=CHYBA_MOCNENI;Exit;end;
if (base<0) and (frac(exponent)<>0) then
     begin druh_chyby_parseru:=CHYBA_MOCNENI;Exit;end;
r:=exp(exponent*ln(base));
Mocnina:=r;
if (r=0) and (exponent<0) then {dalsi ojeb, jak detekovat podteceni}
   begin druh_chyby_parseru:=CHYBA_MOCMALE;Exit;end;
end;

Function Operace4(r,r2:real;o:byte):real;
var a,b:longint;
begin
if o=NIC then begin Operace4:=r2;Exit;end;

if (frac(r)<>0.0) or (frac(r2)<>0.0) then
   begin druh_chyby_parseru:=CHYBA_BITOVA_OPERACE_S_REALNYM_CISLEM;Exit;end;
a:=round(r);
b:=round(r2);
case o of
   BIT_AND:a:=a and b;
   BIT_OR:a:=a or b;
   BIT_XOR:a:=a xor b;
   ZAP_BIT_AND:a:=a and -b;
   ZAP_BIT_OR:a:=a or -b;
   ZAP_BIT_XOR:a:=a xor -b;
end;  {case}
Operace4:=a;
end;


Function Operace3(r,r2:real;o:byte):real;
begin
case o of
   NIC: r:=r2;
   MOCNENI:r:=Mocnina(r,r2);
   ZAPORNE_MOCNENI:r:=Mocnina(r,-r2);
end;  {case}
Operace3:=r;
end;


Function Operace2(r,r2:real;o:byte):real;
begin
case o of
   NIC             : r:=r2;
   NASOBENI        : r:=r*r2;
   DELENI          : if r2=0 then
                        begin
                        druh_chyby_parseru:=CHYBA_DELENI_0;
                        Operace2:=0;
                        Exit;
                        end else r:=r/r2;
   ZAPORNE_NASOBENI: r:=-r*r2;
   ZAPORNE_DELENI  : r:=-r/r2;
end;  {case}
Operace2:=r;
end;


Function Operace1(r,r2:real;o:byte):real;
begin
case o of
   NIC: r:=r2;
   SOUCET:r:=r+r2;
   ODECET:r:=r-r2;
end;  {case}
Operace1:=r;
end;


Function ZpracujClen(t:string;r,r2:real;o:byte):real;
var k:integer;
    l:longint;
    i:byte;
    n:real;
    s:string[10];
begin
Val(t,r2,k);      {napred to zkus proste prevest na cislo}
if k<>0 then      {konverze cisla se nepovedla, tudiz je to neco slozitejsiho}
   if t[1]='(' then
      begin                  {zacina to zavorkou, je to tedy zavorka}
      delete(t,Length(t),1);
      delete(t,1,1);
      r2:=Uroven1(t);
      end
      else begin
      k:=Pos('(',t);     {zavorka je uvnitr kazdopadne, ale co je pred ni?}
      s:=Copy(t,1,k-1);
      delete(t,Length(t),1);
      delete(t,1,k);
      r2:=Uroven1(t);

      if s='SIN' then r2:=sin(r2) else
      if s='COS' then r2:=cos(r2) else
      if s='SQR' then r2:=sqr(r2) else
      if s='SQRT' then
         begin
         if r2<0 then
            begin ZpracujClen:=0;druh_chyby_parseru:=CHYBA_ZAPORNA_ODMOCNINA;Exit;end;
         r2:=sqrt(r2);
         end else

      if s='TAN' then
         begin
         n:=cos(r2);
         if n=0 then
            begin ZpracujClen:=0;druh_chyby_parseru:=CHYBA_DELENI_0;Exit;end;
         r2:=sin(r2)/n;
         end else

      if s='COTAN' then
         begin
         n:=sin(r2);
         if n=0 then
            begin ZpracujClen:=0;druh_chyby_parseru:=CHYBA_DELENI_0;Exit;end;
         r2:=cos(r2)/n;
         end else

      if s='ARCSIN' then
         begin
         if (r2>=1) or (r2<=-1) then
            begin ZpracujClen:=0;druh_chyby_parseru:=CHYBA_DELENI_0;Exit;end;
         r2:=ArcTan(r2/sqrt(1-sqr(r2)));
         end else

      if s='ARCCOS' then
         begin
         if (r2>=1) or (r2<=-1) or (r2=0) then
            begin ZpracujClen:=0;druh_chyby_parseru:=CHYBA_DELENI_0;Exit;end;
         r2:=ArcTan(sqrt(1-sqr(r2)/r2));
         end else
      if s='ARCTAN' then r2:=ArcTan(r2) else
      if s='LN' then
         begin
         if r2<=0 then
            begin ZpracujClen:=0;druh_chyby_parseru:=CHYBA_LOGARITMU;Exit;end;
         r2:=Ln(r2)
         end else
      if s='EXP' then r2:=Exp(r2) else
      if s='NOT' then
         begin
         if frac(r2)<>0.0 then
            begin druh_chyby_parseru:=CHYBA_BITOVA_OPERACE_S_REALNYM_CISLEM;Exit;end
            else begin
            l:=not(round(r2));
            r2:=l;
            end;
         end;
      end;
ZpracujClen:=Operace4(r,r2,o);
end;

Function Uroven4(const s:string):real;
{bitove operace}
var i,o,z:byte;
    r,r2:real;
    k:integer;
    t:string;
begin
if s='' then begin Uroven4:=0;Exit;end;
t:='';
o:=NIC;
r:=0;
z:=0;
for i:=1 to Length(s) do
    begin
    if s[i]='(' then inc(z);
    if s[i]=')' then dec(z);

    if (z<>0) or (not (s[i] in ['a','b','c','d','e','f'])) then t:=t+s[i]
       else begin
       r:=ZpracujClen(t,r,r2,o);
       if druh_chyby_parseru<>CHYBA_ZADNA then
          begin
          Uroven4:=0;
          Exit;
          end;
       t:='';
       case s[i] of
          'a':o:=BIT_OR;
          'b':o:=ZAP_BIT_OR;
          'c':o:=BIT_AND;
          'd':o:=ZAP_BIT_AND;
          'e':o:=BIT_XOR;
          'f':o:=ZAP_BIT_XOR;
       end;  {case}
       end;  {else begin}
    end;
{dodelame posledni cislo, za kterym uz neni znak zadne operace}
Uroven4:=ZpracujClen(t,r,r2,o);
end;



Function BackPos(c:char;s:string):byte;
var i:byte;
begin
for i:=Length(s) downto 1 do
    if s[i]=c then begin BackPos:=i;Exit;end;
BackPos:=0;
end;

Function Uroven3(s:string):real;
{mocniny, odmocniny}
var z,i,o:byte;
    r,r2:real;
    t:string;
begin
if s='' then begin Uroven3:=0;Exit;end;
t:='';
o:=NIC;
r:=0;
z:=0;
for i:=1 to Length(s) do
    begin
    if s[i]='(' then inc(z);
    if s[i]=')' then dec(z);
    if (z<>0) or (not (s[i] in ['^','&']))
       then t:=t+s[i]
       else
       begin
       r2:=Uroven4(t);
       r:=Operace3(r,r2,o);
       t:='';
       case s[i] of
          '^':o:=MOCNENI;
          '&':o:=ZAPORNE_MOCNENI;
       end;  {case}
       end;  {else begin}
    end;
{dodelame posledni cislo, za kterym uz neni znak zadne operace}
if druh_chyby_parseru<>CHYBA_ZADNA then
   begin
   Uroven3:=0;
   Exit;
   end;
r2:=Uroven4(t);
Uroven3:=Operace3(r,r2,o);
end;


Function Uroven2(s:string):real;
var z,i,o:byte;
    r,r2:real;
    t:string;
begin
if s='' then begin Uroven2:=0;Exit;end;
t:='';
o:=NIC;
r:=0;
z:=0;
for i:=1 to Length(s) do
    begin
    if s[i]='(' then inc(z);
    if s[i]=')' then dec(z);
    if (z<>0) or (not (s[i] in ['*','/','@','#']))
       then t:=t+s[i]
       else
       begin
       r2:=Uroven3(t);
       r:=Operace2(r,r2,o);
       t:='';
       case s[i] of
          '*':o:=NASOBENI;
          '/':o:=DELENI;
          '@':o:=ZAPORNE_NASOBENI;
          '#':o:=ZAPORNE_DELENI;
       end;  {case}
       end;  {else begin}
    end;
{dodelame posledni cislo, za kterym uz neni znak zadne operace}
if druh_chyby_parseru<>CHYBA_ZADNA then
   begin
   Uroven2:=0;
   Exit;
   end;
r2:=Uroven3(t);
Uroven2:=Operace2(r,r2,o);
end;



Function Uroven1(s:string):real;
var z,i,o:byte;
    r,r2:real;
    t:string;
begin
if s='' then begin Uroven1:=0;Exit;end;
t:='';
o:=NIC;
r:=0;
z:=0;
for i:=1 to Length(s) do
    begin
    if s[i]='(' then inc(z);
    if s[i]=')' then dec(z);
    if (z<>0) or (not (s[i] in ['+','-']))
       then t:=t+s[i]
       else
       begin
       r2:=Uroven2(t);
       r:=Operace1(r,r2,o);
       t:='';
       case s[i] of
          '+':o:=SOUCET;
          '-':o:=ODECET;
       end;  {case}
       end;  {else begin}
    end;
{dodelame posledni cislo, za kterym uz neni znak zadne operace}
if druh_chyby_parseru<>CHYBA_ZADNA then
   begin
   Uroven1:=0;
   Exit;
   end;
r2:=Uroven2(t);
Uroven1:=Operace1(r,r2,o);
end;

Function ZrusMezery(s:string):string;
var t:string;
    i:byte;
begin
t:='';
for i:=1 to Length(s) do if s[i]<>' ' then t:=t+s[i];
ZrusMezery:=t;
end;


Function SpravneUzavorkovani(s:string):byte;
var i:shortint;
    j,k:byte;
begin
j:=0;
for i:=1 to Length(s) do
    if s[i]='(' then begin inc(j);k:=i;end else
    if s[i]=')' then
       if i=0 then
          begin
          SpravneUzavorkovani:=i;
          Exit;
          end
          else dec(j);
if j<>0 then SpravneUzavorkovani:=k else SpravneUzavorkovani:=0;
end;


Function ZkontrolujCislo(s:string):byte;
var k:integer;
    r:real;
    bpz:boolean;
    h,i,j,prc,poc:byte;
    t,u:string;
begin
Val(s,r,k);
if k=0 then begin ZkontrolujCislo:=0;Exit;end; {je to zkratka platne cislo...}

bpz:=false;
prc:=0;
poc:=0;
for j:=1 to Length(s) do
    if not (s[j] in cislice) then
       begin
       if s[j]=')' then bpz:=true   {byla zaznamenana prava zavorka}
          else
          if prc>0 then begin ZkontrolujCislo:=j;Exit;end;
       end
       else if bpz=true    {cislice za pravou zavorkou? Nelze}
               then begin ZkontrolujCislo:=j;Exit;end
               else begin
               if prc=0 then prc:=j; {prvni cislice}
               poc:=j;               {posledni cislice}
               end;


if (poc<Length(s)) and (s[poc+1]<>')') then
   begin ZkontrolujCislo:=1;Exit;end;

if (prc>1) and (s[prc-1]<>'(') then
   begin ZkontrolujCislo:=1;Exit;end;

Val(Copy(s,prc,poc-prc+1),r,k);  {zkontroluj usek mezi zavorkami}
if k<>0 then             {v neporadku? patrne vice desetinnych tecek}
   begin ZkontrolujCislo:=k;Exit;end;

t:=Copy(s,1,prc-1);      {rozbor retezce pred levou zavorkou}
h:=1;
while t<>'' do
   begin

   {sqrt(sqr(}

   i:=Pos('(',t);
   if i=0 then
      begin ZkontrolujCislo:=h;Exit;end;

   if i>1 then
      begin
      u:=Copy(t,1,i-1);
      {Vime, ze pred zavorkou je pritomna jakasi matematicka funkce.}
      {Znam ji ale?}
      bpz:=false;
      for j:=1 to pocet_funkci_parseru do
          if u=funkce_parseru[j] then begin bpz:=true;Break;end; {znama funkce}
      if bpz=false then
         begin ZkontrolujCislo:=h;Exit;end;
      delete(t,1,i);
      inc(j,i);
      end
      else begin delete(t,1,1);inc(j);end;
   end;

{-----------------------------------------------------------------}
for i:=poc+1 to Length(s) do       {kontrola pravych zavorek}
    if s[i]<>')' then
       begin ZkontrolujCislo:=i;Exit;end;


ZkontrolujCislo:=0; {sem se procedura dostane v pripade, ze jsou pritomny}
                    {prave zavorky a jsou v poradku}
end;

Function DejNaVelka(s:string):string;
var t:string;
    i:byte;
begin
t:='';
for i:=1 to Length(s) do t:=t+UpCase(s[i]);
DejNaVelka:=t;
end;


Procedure ZpracujBitoveOperatory(var s:string);
var i:byte;
begin
{|***|','|++|','|---|'];}
 {and}   {or}   {xor}
i:=Pos(' AND ',s);
while i<>0 do
   begin
   delete(s,i,5);
   insert('|***|',s,i);     {and}
   i:=Pos(' AND ',s);
   end;

i:=Pos(' OR ',s);
while i<>0 do
   begin
   delete(s,i,4);
   insert('|++|',s,i);      {or}
   i:=Pos(' OR ',s);
   end;

i:=Pos(' XOR ',s);
while i<>0 do
   begin
   delete(s,i,5);
   insert('|---|',s,i);     {xor}
   i:=Pos(' XOR ',s);
   end;
end;


Procedure Preprocesor(s:string;var t:string;var chyba:byte);
var i,j:byte;
    k:integer;
    c,d:char;
    r:real;
    uvnitr:boolean;
    u:string;
begin
t:=DejNaVelka(s);
ZpracujBitoveOperatory(t);
t:=ZrusMezery(t);   {zrusim mezery, aby se to lepe prohledavalo}
if t='' then
   begin
   chyba:=1;
   Exit;
   end;
s:='';
chyba:=SpravneUzavorkovani(t);
if chyba<>0 then Exit;

uvnitr:=true;           {zaciname uvnitr cisla}
u:='';
for i:=1 to Length(t) do
    begin
    if uvnitr=true then {uvitr cisla...}
       begin
       if not (t[i] in symboly) then u:=u+t[i]
          else begin
          j:=ZkontrolujCislo(u);
          if j<>0 then
                begin
                chyba:=i-Length(u)+j;
                Exit;
                end;
          s:=s+u;
          u:=t[i];
          uvnitr:=false;
          end;
       end
       else begin       {jsme vne cisla...}
       if t[i] in symboly then u:=u+t[i]
          else begin
          if (Length(u)>1) or (u='|') then {kombinace symbolu?}
             begin
             if u='--' then u:='+' else
             if u='+-' then u:='-' else
             if u='*-' then u:='@' else  {ZAPORNE NASOBENI}
             if u='/-' then u:='#' else  {ZAPORNE DELENI}
             if u='^-' then u:='&' else  {ZAPORNE MOCNENI}

             if u='*--' then u:='*' else
             if u='^--' then u:='^' else
             if u='/--' then u:='/' else

             if u='|++|'    then u:='a' else  {BIT_OR}
             if u='|++|--'  then u:='a' else  {BIT_OR}
             if u='|++|-'   then u:='b' else  {ZAP_BIT_OR}
             if u='|***|'   then u:='c' else  {BIT_AND}
             if u='|***|--' then u:='c' else  {BIT_AND}
             if u='|***|-'  then u:='d' else  {ZAP_BIT_AND}
             if u='|---|'   then u:='e' else  {BIT_XOR}
             if u='|---|--' then u:='e' else  {BIT_XOR}
             if u='|---|-'  then u:='f' else  {ZAP_BIT_XOR}
                begin          {ostatni kombinace nejsou povolene}
                chyba:=i-1;
                Exit;
                end;
             end;
          s:=s+u;
          u:=t[i];
          uvnitr:=true;
          end;
       end;
    end;   {for}

if uvnitr=false then  {na konci vyrazu musi byt cislo, ne symbol}
   begin
   chyba:=i;
   Exit;
   end;

j:=ZkontrolujCislo(u);
if j<>0 then
   begin
   chyba:=i-Length(u)+j;
   Exit;
   end;

chyba:=0;
s:=s+u;
t:=s;
end;

Function SpocitejVyraz(s:string):real;
var n:byte;
    r:real;
    t:string;
begin
Preprocesor(s,t,n);
if n<>0 then
   begin
   druh_chyby_parseru:=CHYBA_ZADANI;
   pozice_chyby_parseru:=n;
   SpocitejVyraz:=0;
   end
   else begin
   druh_chyby_parseru:=CHYBA_ZADNA;
   pozice_chyby_parseru:=0;
   SetJump(odskok);
   if druh_chyby_parseru=0 then r:=Uroven1(t) else r:=0;
   SpocitejVyraz:=r;
   end;
end;


Function Prepocet_pozice_chyby(s:string):byte;
var a,b,c:byte;
    t:string;
begin
t:=DejNaVelka(s);
ZpracujBitoveOperatory(t);
b:=0;
a:=0;
c:=Length(t);
repeat
inc(a);
if t[a]<>' ' then
   begin
   inc(b);
   if b=pozice_chyby_parseru then begin Prepocet_pozice_chyby:=a;Exit;end;
   end;
until a=c;
Prepocet_pozice_chyby:=0;
end;

Procedure MujExit;
{hodne osklivy hack}
begin
if (Exitcode=205) or (Exitcode=206) then
   begin
   druh_chyby_parseru:=CHYBA_MOCVELKE;
   LongJump(odskok);
   end else Halt(0);
end;

Procedure Dummy;far;
begin end;

begin
{StaryExit:=proctype(ExitProc);}
ExitProc:=@MujExit;
end.