/* there is no internationally recognized "public domain" license, but I'll
    go ahead and release this as "public domain" anyway. :-)
*/

/* if your region does not recognize "public domain," then I release this
    under the "Fair License" (opensource.org/license/fair-php) as:

    copyright 2023 Jim Hall <jhall@freedos.org>

    Usage of the works is permitted provided that this
    instrument is retained within the works, so that any entity
    that uses the works is notified of this instrument.

    DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
*/

/* compare two values */

#include <stdio.h>
#include <stdlib.h> /* atoi */
#include <string.h> /* strcmp */

#define STRCMP(a,b) strcasecmp(a,b)

int
main(int argc, char **argv)
{
    int i;
    int n, m;

    /* usage: cmpr N expr M */

    if (argc != 4) {
	fputs("Syntax error\n", stderr);
	fputs("usage: cmpr N expr M\n", stderr);
	fputs("  where expr is LT, LE, GT, GE, EQ\n", stderr);
	return 1;
    }

    /* get values */

    n = atoi(argv[1]);
    m = atoi(argv[3]);

    /* compare */

    if (STRCMP(argv[2], "lt") == 0) {
	if (n<m) {
	    return 0;
	}
    }
    else if (STRCMP(argv[2], "le") == 0) {
	if (n<=m) {
	    return 0;
	}
    }
    else if (STRCMP(argv[2], "gt") == 0) {
	if (n>m) {
	    return 0;
	}
    }
    else if (STRCMP(argv[2], "ge") == 0) {
	if (n>=m) {
	    return 0;
	}
    }
    else if (STRCMP(argv[2], "eq") == 0) {
	if (n==m) {
	    return 0;
	}
    }
    else {
	fputs("Unrecognized comparison\n", stderr);
    }

    /* if we get here, either no operator was matched, or the compare
	test failed. either way, return an error code (1) */

    return 1;
}
