;********************************************************************
; CDPLAY.ASM
; Author: Fernando Ariel Gont
; Date:   1998, May 14th
; Place:  Haedo, Buenos Aires, Republica Argentina
;
; Description: This program plays an audio track from a CD-Audio
;              by calling several functions of int 2fh.
;              The track number is specified as a parameter from
;              the command line.
;
; Thankyou's: Dimitri Smits (Fidonet's 80XXX echo).
;
; Dedicated to: Everyone out there who give help, source code 
;               and/or information about different topics,
;		desinterestedly and for free.
;
; Contact me at:
; E-mail:   fgont@softhome.net
; Web-site: http://members.xoom.com/gont/
; FidoNet:  4:900/470.10
;
; IMPORTANT: Even though this program was tested on my system, and
; it worked as it was expected to, I'm not responsible of any 
; danger it could cause to the user, his hardware, or anything else
; related to him.
; Use it at your own risk! :)
;
; This program may be distributed freely. To do that, you must not
; modify this header.
; If you want to distribute modifications of this program, include
; a copy of this source code.
;
; Comments and/or questions are welcome.
;********************************************************************

.model tiny
.code
.startup

	mov dx, offset present_msg
	mov ah, 09h
	int 21h

;**********************************************************
; Check whether MSCDEX is installed.
;**********************************************************

	mov ax,0dadah
	push ax
	mov ax,1100h
	int 2fh
	pop bx
	cmp bx, 0adadh
	mov dx, offset no_inst_msg
	jne show_msg
	cmp al,0ffh
	jne show_msg

;**********************************************************
; Check if version is 2.00 or higher.
;**********************************************************
	mov ax, 150ch
	int 2fh
	mov dx, offset no_esup_200
	or bx, bx
	jz show_msg

;**********************************************************
; Get track number from the command line parameters.
;**********************************************************
	xor cx, cx
	mov cl, byte ptr cs:0080h
	mov di, 81h	

	mov bl, 10
	xor ax, ax

next_digit:
	mov dl, [di]
	cmp dl, 20h
	jz next
	cmp dl, 30h
	jb help
	cmp dl, 39h
	ja help
	sub dl, 30h
	mul bl
	add al, dl
	jc invalid_track
next:
	inc di
	loop next_digit

	mov track, al


; *********************************************************
; Get first CD-ROM drive number.
; The drive number will be got in cx.
; *********************************************************
	mov ax, 1500h
	xor bx,bx
	int 2fh

;**********************************************************
; Get Audio Disk Info, that holds the address of the start
; of the lead-out track, the lowest_track number, and the
; highest_track number.
;**********************************************************

	mov bx, offset block
	mov ctrlblseg, cs
	mov ctrlbloff, offset com_code
	mov ax, 1510h
	int 2fh

;**********************************************************
; Check whether the track number is valid.
;**********************************************************
	mov al, track
	cmp al, lowest_track
	jb invalid_track
	cmp al, highest_track
	ja invalid_track

;*********************************************************
; Get information about the track that'll be played.
;*********************************************************
	mov ctrlbloff, offset coma
	mov ax, 1510h
	int 2fh

; Convert RedBook format to HSG format

	call convert

; Store it to calculate the track lenght, and to use it
; to play the track

	mov startframe_l, ax
	mov startframe_h, dx

	inc track

	mov dl, track
	cmp dl, highest_track

	ja Audio_Disk_Info

;*************************************************************
; Get information about the next track.
;*************************************************************
	mov ax, 1510h	
	int 2fh

; Convert RedBook format to HSG format

conversion:

	call convert

;**************************************************************
; Get number of sectors to play
;
; It's got by subbing the address of the start of the track 
; that'll be played, from the address of the start of the next
; track.
;**************************************************************

        sub ax, startframe_l
        sbb dx, startframe_h
        mov frame_lenght_l, ax
	mov frame_lenght_h, dx

;**************************************************************
; Play track
;**************************************************************

	mov ax,1510h
	mov bx, offset bloq
	int 2fh

	mov dx, offset begin_msg

	jnc show_msg

	mov dx, offset cannot_play_msg

show_msg:
	mov ah,09h
	int 21h

salir:
	mov ax, 4c00h
	int 21h

;**************************************************************
; "ERROR: Track does not exist." will be displayed
;**************************************************************
invalid_track:

	mov dx, offset inv_track_msg
	jmp show_msg


;**************************************************************
; The syntax of the program will be displayed
;**************************************************************
help:

	mov dx, offset help_msg
	jmp show_msg


;**************************************************************
; This piece of code simply copies the address of the lead-out
; track to the strcuture that is used to convert RedBook 
; format to HSG format.
;**************************************************************
Audio_Disk_Info:

	push es
	les di, dword ptr redbook
	mov sredbw, es
	mov fredbw, di
	pop es
	jmp conversion

;**************************************************************
; Convert RedBook format to HSG format
;**************************************************************
convert proc
	push bx
	push cx
	mov al, byte ptr [redb+1]
	mov cl, 75
	mul cl

; ax=seconds

	mov bx,ax

	mov ax, 4500
	mov cl, byte ptr [redb+2]
	xor ch,ch
	mul cx

; dx:ax=minutes

	xor ch,ch
	mov cl, [redb]
	add bx, cx
	add ax,bx
	adc dx,0
	sub ax, 150
	sbb dx,0
	pop cx
	pop bx
ret
convert endp

cannot_play_msg   db 0ah, 0dh, "ERROR: Can't play the track."
                  db 0ah, 0dh, "$"

no_inst_msg       db 0ah, 0dh, "ERROR: MSCDEX is not installed."
                  db 0ah, 0dh, "$"

no_esup_200       db "ERROR: MSCDEX version 2.00 or higher not found."
	          db 0dh, 0ah, "$"

inv_track_msg     db 0dh, 0ah,"ERROR: The specified track number does "
	          db "not exist.", 0dh, 0ah, "$"

begin_msg         db 0dh, 0ah, "Starting to play...", 0dh, 0ah, "$"

help_msg          db 0dh, 0ah, "Syntax: CDPLAY [track number]"
		  db 0dh, 0ah, "$"

present_msg      db 0dh, 0ah
	         db "Ŀ", 0dh, 0ah
	         db " CDPLAY version 1.0 - FREEWARE      ", 0dh, 0ah
	         db " Programmed by Fernando Ariel Gont  ", 0dh, 0ah
	         db "Ĵ", 0dh, 0ah
	         db " e-mail:     fgont@softhome.net     ", 0dh, 0ah
	         db " Fidonet:    4:900/470.10           ", 0dh, 0ah
	         db "Ĵ", 0dh, 0ah
	         db "    http://members.xoom.com/gont/   ", 0dh, 0ah
	         db "Ĵ", 0dh, 0ah
	         db "   Haedo, Buenos Aires, ARGENTINA   ", 0dh, 0ah
	         db "", 0dh, 0ah
		 db "$"

;**********************************************************
; This block is used for all the calls to IOCTL INPUT
; functions.
; Within this block, the far address of a block that
; contains the command code is specified.
; I use this block to call Audio Track Info and Audio
; Disk Info.
;**********************************************************

block             db 26
subunit           db 0h
command           db 03h
                  db 10 dup (00h)
addressmode       db 00h
ctrlbloff         dw offset coma
ctrlblseg         dw ?
transfbytes       dw 0007h
reserved          db 6 dup (0)

;*************************************************
; The lenght of the tracks in RedBook format are
; got here, when Audio Track Info function is 
; used.
;*************************************************

coma  		  db 0bh
track  		  db 13

fredbw label word
redb  		  db ? 
      		  db ?

sredbw label word
      		  db ?
      		  db ?
		  db ?

;*************************************************
; Audio Disk Info is got here.
;*************************************************

com_code	  db 0ah
lowest_track	  db ?
highest_track	  db ?
redbook		  dd ?

;*************************************************
; This block is used to execute the PLAY command.
;*************************************************
bloq              db 22
subu              db 0h
comnd		  db 132
        	  db 10 dup (00h)
	          db 00h
startframe_l      dw ?
startframe_h      dw ?
frame_lenght_l	  dw ?
frame_lenght_h	  dw ?

end
