;
; Program to detect and delete type-ahead keys from
; ill-behaved applications (such as the Novell LOGIN procedure)
;
; Contains a nice HEX_AUS function which has been
; modified to trim leading zeroes.
;
; Assembly:
;
; MASM TAD;
; LINK TAD
; EXE2BIN TAD.EXE TAD.COM
;
;
ZAEHLER    EQU 10	       ; Decimal system
max_number equ 256	       ; Maximum keyboard contents
			       ; (only, if buffer redirected)
alpha	   equ 65	       ; first alphanumeric
;
code segment
	assume cs:code, ds:code
	org 100h	       ; yes, we still write .COM programs,
			       ; because it can be done in a minute

start:	jmp begin

tad	      db 'TAD - Detect and delete type-ahead keys',13,10
	      db '(c)   Burkhard Meiner',13,10
	      db '      Lilienstrae 51',13,10
	      db '      D-06122 Halle/Saale','$'
no_keys       db 'Keyboard buffer empty$'
numkeys       db 'Type-ahead keys deleted:   ','$'
crlf	      db 13,10,'$'

number	 dw 0
nullflag db 0



begin:
	mov dx, offset crlf	; Write message
	call text_out
	mov dx, offset tad
	call text_out
	mov dx, offset crlf
	call text_out
	call text_out

	call get_number 	; detect and kill type-ahead keys

	cmp word ptr number, 0	; how many found ?
	jg	kill
	jmp short no_typeahead	; no keys - special message

kill:
	mov dx, offset numkeys	; write message number of keys
	call text_out

	mov ax, number		; write number of keys killed
	call hex_aus

	mov dx, offset crlf
	call text_out
	call text_out

       jmp short stop

no_typeahead:
	mov dx, offset no_keys	; no keys - empty buffer message
	call text_out
	mov dx, offset crlf
	call text_out

stop:
	mov ah, 04Ch		; return to DOS - discard abend code
	int 21h


HEX_AUS  PROC near
	push bx
	push cx
	push dx
	mov byte ptr nullflag, 00h
	MOV CX,10000	     ; Lade CX mit Zhler
	MOV DX,0	     ; Lsche hherwertige Hlfte des
LABEL1: 		     ; Dividenden
	 DIV CX 	     ; Teile AX:DX durch CX
	 PUSH DX	     ; Rest sichern

	 cmp al, 00h	     ; what about leading zeroes???
	 jne hex_give
	 cmp byte ptr nullflag, 00h
	 je hex_div

hex_give:
	 mov byte ptr nullflag, 01h

	 MOV DL,AL	     ; Ausgabe des Ergebnisses
	 ADD DL,48
	 MOV AH,02
	 INT 21H
hex_div:
	 MOV AX,CX	     ; Zhler durch 10 dividieren
	 MOV DX,0	     ; Lsche hherwertige Hlfte
	 MOV CX,ZAEHLER
	 DIV CX
	 MOV CX,AX
	 POP AX
	 CMP CX,0		; Zahl = Null ?
	 JNZ LABEL1		; Nein, noch ein weiteres Mal
	 pop dx
	 pop cx
	 pop bx
	 RET
HEX_AUS  ENDP



; get number of type-ahead keys and destroy keys,
; using BIOS function (elementary).


get_number proc near
	push ax 		; ax will be modified (service codes)
	push bx
	mov bx, 0		; bx is our key counter

get_loop:
	mov	ah,1			; FUNCTION CODE 1 (detect key)
	int	16h			; KEYBOARD INTERRUPT
	jz	nokey			; zero flag: no key
	mov	ah, 00h 		; read key, if no zero flag
	int	16h
	inc	bx

	cmp	bx, max_number		; we do not want to be fooled
					; by irregular BIOS return values
					; normal max: 16
					; key buffer re-located: 48
					; we assume 256 to be much too large
					; a number to be correct
	jg	error_exit		; as yet: = normal exit

	jmp	get_loop		; next key (if any)

error_exit:				; if n > 256 (illegal)
nokey:

	mov	number, bx		; bx is copied to our number buffer


	pop bx				; restore values from stack
	pop ax
	ret				; and off we go

get_number endp
;
;
; write string pointed at by dx
;
text_out proc near			; normal DOS write service
	mov ah, 09h
	int 21h
	ret
text_out endp
;
;
code ends

end start
