;
; Restore normal cursor shape and video mode 3
; for ill-behaved applications (like Dyabola)
;
; Contains a nice HEX_AUS function which has been
; modified to trim leading zeroes.
;
; Assembly:
;
; MASM TAD;
; LINK TAD
; EXE2BIN TAD.EXE TAD.COM
;
;
des_mode   equ 03h
gra_mode   equ 12h
non_svuota equ 00h
ZAEHLER    EQU 10              ; Decimal system
max_number equ 256             ; Maximum keyboard contents
                               ; (only, if buffer redirected)
alpha      equ 65              ; first alphanumeric

obere_reihe  equ 00h
untere_reihe equ 018h
linke_spalte equ 00h
rechte_spalte equ 04Fh
erste_reihe equ 01h

;
code segment
        assume cs:code, ds:code
        org 100h               ; yes, we still write .COM programs,
                               ; because it can be done in a minute

start:  jmp begin

NCurs         db 'NORMCURS - Restore cursor to normal state',13,10
              db '(c)   Burkhard Meiner',13,10
              db '      Lilienstrae 51',13,10
              db '      D-06122 Halle/Saale','$'

crlf          db 13,10,'$'
v_mode        db 'Initial video mode:   ','$'
v_size        db 'Initial cursor size:  ','$'
colon         db ':','$'
dash          db '-','$'

spalten  db 0
mode     db 0
pages    db 0
nullflag db 0

c_first  db 0
c_last   db 0



begin:
        call get_mode           ; detect video mode

        call set_mode           ;

        call set_cursor

        mov dx, offset crlf     ; Write message
        call text_out
        mov dx, offset NCurs
        call text_out
        mov dx, offset crlf
        call text_out
        call text_out


        mov dx, offset v_mode
        call text_out
        xor ax,ax
        mov al, mode
        call hex_aus
        mov dx, offset crlf
        call text_out


        mov dx, offset v_size
        call text_out
        xor ax,ax
        mov al,c_first
        call hex_aus
        mov dx, offset dash
        call text_out
        xor ax,ax
        mov al, c_last
        call hex_aus
        mov dx, offset crlf
        call text_out


        mov dx, offset crlf
        call text_out
        call text_out
        xor ax,ax

stop:
        mov ah, 04Ch            ; return to DOS - discard abend code
        int 21h


HEX_AUS  PROC near
        push bx
        push cx
        push dx
        mov byte ptr nullflag, 00h
        MOV CX,10000         ; Lade CX mit Zhler
        MOV DX,0             ; Lsche hherwertige Hlfte des
LABEL1:                      ; Dividenden
         DIV CX              ; Teile AX:DX durch CX
         PUSH DX             ; Rest sichern

         cmp al, 00h         ; what about leading zeroes???
         jne hex_give
         cmp byte ptr nullflag, 00h
         je hex_div

hex_give:
         mov byte ptr nullflag, 01h

         MOV DL,AL           ; Ausgabe des Ergebnisses
         ADD DL,48
         MOV AH,02
         INT 21H
hex_div:
         MOV AX,CX           ; Zhler durch 10 dividieren
         MOV DX,0            ; Lsche hherwertige Hlfte
         MOV CX,ZAEHLER
         DIV CX
         MOV CX,AX
         POP AX
         CMP CX,0               ; Zahl = Null ?
         JNZ LABEL1             ; Nein, noch ein weiteres Mal
         pop dx
         pop cx
         pop bx
         RET
HEX_AUS  ENDP



; get number of type-ahead keys and destroy keys,
; using BIOS function (elementary).


get_mode  proc near
        push ax                 ; ax will be modified (service codes)
        push bx
        push cx
        push dx

                                ; get cursor position
        xor ax,ax
        mov ah, 03h
        xor bx,bx               ; page 0
        int 10h
        mov byte ptr c_first, ch
        mov byte ptr c_last, cl


        xor ax,ax
        xor bx,bx

        mov     ah,0Fh                  ; FUNCTION CODE 0Fh (get video mode)
        int     10h                     ; video BIOS INTERRUPT
        mov byte ptr spalten, ah
        mov byte ptr mode, al
        mov byte ptr pages, bh

        pop dx
        pop cx
        pop bx                          ; restore values from stack
        pop ax
        ret                             ; and off we go

get_mode endp
set_mode  proc near
        push ax                 ; ax will be modified (service codes)
        mov ah, 00h
;;        mov al, gra_mode
;;        int 10h

        mov al, des_mode
        or al, non_svuota       ; do not destroy video buffer
        int 10h
        pop ax
        ret                             ; and off we go

set_mode endp
set_cursor  proc near
        push ax                 ; ax will be modified (service codes)
        push bx
        push cx
        xor ax,ax
        mov ch,0Dh              ; 13(+1=14), first cursor line
        mov cl,0Eh              ; 14(+1=15), last cursor line
        mov ah, 01h
        int 10h

        mov ah, 02h            ; set cursor
        xor bx,bx              ; page 0
        mov dh, obere_reihe                 ; line 0
        mov dl, linke_spalte                ; line 0

        int 10h

        pop cx
        pop bx
        pop ax
        ret                             ; and off we go

set_cursor endp

;
;
; write string pointed at by dx
;
text_out proc near                      ; normal DOS write service
        mov ah, 09h
        int 21h
        ret
text_out endp
;
;
code ends

end start
