;
; Program to detect and display MSCDEX version stamp
; and a list of logical CD drive letters (if any)
;
; Contains a nice HEX_AUS function which has been
; modified to trim leading zeroes.
;
;
ZAEHLER  EQU 10              ; Definition einer Konstanten
alpha    equ 65
remoted  equ 0001000000000000b
;
code segment
        assume cs:code, ds:code, es: code
        org 100h

start:  jmp begin

buf           db ' : ','$'
cdt           db 'DDT - Detect and display all drives',13,10
              db '(c)   Burkhard Meiner',13,10
              db '      Lilienstrae 51',13,10
              db '      D-06122 Halle/Saale','$'
not_installed db 'No drives installed$'
numdriv       db 'Number of drives:   ','$'
logdriv       db 'Logical drive(s):   ','$'
crlf          db 13,10,'$'
nullflag db 0
counter dw 0

begin:

        mov dx, offset crlf
        call text_out
        mov dx, offset cdt
        call text_out
        mov dx, offset crlf
        call text_out
        call text_out

;;;;;;;;;;;;;;;;;;;
        call remote
;;;;;;;;;;;;;;;;;;;

        cmp word ptr counter, 0
        je no_drive

        mov dx, offset numdriv
        call text_out

        mov ax, counter
        call hex_aus

        mov dx, offset crlf
        call text_out

        mov dx, offset logdriv
        call text_out

        call drives_out

        mov dx, offset crlf
        call text_out
        call text_out

        jmp short stop

no_drive:


        mov dx, offset not_installed
        call text_out
        mov dx, offset crlf
        call text_out
stop:

        mov ah, 04Ch
        int 21h


HEX_AUS  PROC near
        push bx
        push cx
        push dx
        mov byte ptr nullflag, 00h
         MOV CX,10000        ; Lade CX mit Zhler
         MOV DX,0            ; Lsche hherwertige Hlfte des
LABEL1:                      ; Dividenden
         DIV CX              ; Teile AX:DX durch CX
         PUSH DX             ; Rest sichern

         cmp al, 00h
         jne hex_give
         cmp byte ptr nullflag, 00h
         je hex_div

hex_give:
         mov byte ptr nullflag, 01h

         MOV DL,AL           ; Ausgabe des Ergebnisses
         ADD DL,48
         MOV AH,02
         INT 21H
hex_div:
         MOV AX,CX           ; Zhler durch 10 dividieren
         MOV DX,0            ; Lsche hherwertige Hlfte
         MOV CX,ZAEHLER
         DIV CX
         MOV CX,AX
         POP AX
         CMP CX,0               ; Zahl = Null ?
         JNZ LABEL1             ; Nein, noch ein weiteres Mal
         pop dx
         pop cx
         pop bx
         RET
HEX_AUS  ENDP


;
; write string pointed at by dx
;
text_out proc near
        mov ah, 09h
        int 21h
        ret
text_out endp
;
; write logical drive list:
;
drives_out proc near
        push ax
        push cx
        push dx
        push si

        mov cx, counter          ; number of drives
        mov si, offset byte ptr cdt
drives_loop:
        lodsb
        dec al
        add al,alpha
        mov byte ptr buf, al
        mov dx, offset buf
        call text_out
        loop drives_loop

        pop si
        pop dx
        pop cx
        pop ax
        ret
drives_out endp
;
; Test which drives are remote devices:
;
remote proc near
        mov word ptr counter, 00h
        push ax
        push bx
        push cx
        push dx
        push si
        push di

        mov bx,01h
        mov di, offset cdt

remote_loop:

        mov ah, 44h
        mov al, 09h
        clc
        int 21h
        jc fehler

        mov cx, word ptr counter
        inc cx
        mov word ptr counter, cx
        mov al, bl
        stosb

fehler:
        inc bx
        cmp bx, 27
        jl remote_loop

enough_remote:
        pop di
        pop si
        pop dx
        pop cx
        pop bx
        pop ax
        ret
remote endp
;
code ends

end start
