;
; Program to detect and display MSCDEX version stamp
; and a list of logical CD drive letters (if any)
;
; Contains a nice HEX_AUS function which has been
; modified to trim leading zeroes.
;
;
ZAEHLER  EQU 10              ; Definition einer Konstanten
alpha    equ 65
;
code segment
        assume cs:code, ds:code
        org 100h

start:  jmp begin

buf           db ' : ','$'
cdt           db 'CDT - Detect and display all CD-ROM drives',13,10
              db '(c)   Burkhard Meiner',13,10
              db '      Lilienstrae 51',13,10
              db '      D-06122 Halle/Saale','$'
not_installed db 'No CD-ROM drives installed$'
version       db 'MSCDEX driver version: ','$'
numdriv       db 'Number of CD drives:   ','$'
logdriv       db 'Logical CD drive(s):   ','$'
crlf          db 13,10,'$'
dot           db '.','$'

number  dw 0
first   dw 0
majver  dw 0
minver  dw 0
nullflag db 0



begin:
        mov dx, offset crlf
        call text_out
        mov dx, offset cdt
        call text_out
        mov dx, offset crlf
        call text_out
        call text_out

        call get_number
        cmp number, 0
        jle no_drive

        call get_version

        call get_drive_list

        mov dx, offset version
        call text_out

        mov ax, word ptr majver
        call hex_aus

        mov dx, offset dot
        call text_out

        mov ax, word ptr minver
        call hex_aus

        mov dx, offset crlf
        call text_out

        mov dx, offset numdriv
        call text_out

        mov ax, number
        call hex_aus

        mov dx, offset crlf
        call text_out

        mov dx, offset logdriv
        call text_out

        call drives_out

        mov dx, offset crlf
        call text_out
        call text_out

       jmp short stop

no_drive:


        mov dx, offset not_installed
        call text_out
        mov dx, offset crlf
        call text_out
        jmp short stop


stop:
        mov ah, 04Ch
        int 21h


HEX_AUS  PROC near
        push bx
        push cx
        push dx
        mov byte ptr nullflag, 00h
         MOV CX,10000        ; Lade CX mit Zhler
         MOV DX,0            ; Lsche hherwertige Hlfte des
LABEL1:                      ; Dividenden
         DIV CX              ; Teile AX:DX durch CX
         PUSH DX             ; Rest sichern

         cmp al, 00h
         jne hex_give
         cmp byte ptr nullflag, 00h
         je hex_div

hex_give:
         mov byte ptr nullflag, 01h

         MOV DL,AL           ; Ausgabe des Ergebnisses
         ADD DL,48
         MOV AH,02
         INT 21H
hex_div:
         MOV AX,CX           ; Zhler durch 10 dividieren
         MOV DX,0            ; Lsche hherwertige Hlfte
         MOV CX,ZAEHLER
         DIV CX
         MOV CX,AX
         POP AX
         CMP CX,0               ; Zahl = Null ?
         JNZ LABEL1             ; Nein, noch ein weiteres Mal
        pop dx
        pop cx
        pop bx
         RET
HEX_AUS  ENDP



; get number of CD-units; driver installed ?


get_number proc near
        push ax
        push bx
        push cx

        mov ah,15h
        mov al, 00h
        xor bx, bx

        int 02Fh

        mov word ptr number, bx
        mov word ptr first, cx

        pop cx
        pop bx
        pop ax
        ret
get_number endp
;
; get MSCDEX version number
;
get_version proc near
        push ax
        push bx

        mov ah, 15h
        mov al, 0Ch
        xor bx,bx

        int 02Fh

        cmp bx,0
        je vers_1
        xor ax,ax
        mov al, bh
        mov word ptr majver, ax
        mov al, bl
        mov word ptr minver, ax
        jmp short vers_2


vers_1:
        mov word ptr majver, 1
        mov word ptr minver, 0
vers_2:

        pop bx
        pop ax
        ret
get_version endp
;
; get drive list
;
get_drive_list proc near
        push ax
        push bx

        mov bx, offset cdt
        mov ah, 15h
        mov al, 0Dh

        int 2Fh

        pop bx
        pop ax
        ret
get_drive_list endp
;
; write string pointed at by dx
;
text_out proc near
        mov ah, 09h
        int 21h
        ret
text_out endp
;
; write logical drive list:
;
drives_out proc near
        push ax
        push cx
        push dx
        push si

        mov cx, number          ; number of drives
        mov si, offset byte ptr cdt
drives_loop:
        lodsb
        add al,alpha
        mov byte ptr buf, al
        mov dx, offset buf
        call text_out
        loop drives_loop

        pop si
        pop dx
        pop cx
        pop ax
        ret
drives_out endp
;
code ends

end start
