;
; VTEST.COM tests the primary and secondary display adaptors and
; recommends which V&F version to use with them.
;
; The program returns the PS/2 display combination code
; for the primary display as DOS errorlevel
;
; 64  is for HERCULES,
; 255 marks an unknown graphics adaptor
; 0   signifies the uninstalled graphics adaptor
;
; (c) B.Meiner, 1992
;
;
CODE	SEGMENT
	ASSUME CS:CODE, DS:CODE, ES:CODE
	ORG 100h
START:	JMP ENTRY
	V_A	db	'VTEST - V&F video system detector utility,   (c) B.Meiner, 1992$'
	V_0	DB	'Graphics adaptor not installed',13,10,'V&F cannot be run$'
	V_1	db	'Monochrome display adaptor',13,10,'V&F cannot be run$'
	V_2	DB	'Colour graphics adaptor (CGA)',13,10,'Use V&F CGA version$'
	V_3_9	db	'Reserved display combination code (unknown)',13,10,'Try V&F CGA version$'
	V_4	db	'Enhanced graphics adaptor (EGA) in Colour mode',13,10,'Try V&F COMPAQ version; use CGA version, if problems occur$'
	V_5	db	'Enhanced graphics adaptor (EGA) in Monochrome mode',13,10,'Use V&F EGAVGA version$'
	V_6	db	'Professional graphics controller',13,10,'Try V&F COMPAQ version; use CGA version, if problems occur$'
	V_7	db	'Video graphics array with monochrome display',13,10,'Use V&F EGAVGA version$'
	V_8	db	'Video graphics array with colour display',13,10,'Use V&F COMPAQ version$'
	v_10	db	'Multi-colour graphics array (MCGA) with digital colour display',13,10,'Try V&F COMPAQ version; use CGA version, if problems occur$'
	V_11	db	'Multi-colour graphics array (MCGA) with analog monochrome display',13,10,'Try V&F EGAVGA version; use CGA version, if problems occur$'
	V_12	db	'Multi-colour graphics array (MCGA) with analog colour display',13,10,'Try V&F COMPAQ version; use CGA version, if problems occur$'
	v_64	db	'Hercules graphics card (HGC)',13,10,'Use V&F HERC version$'
	v_err	db	'Unknown display system',13,10,'Try V&F CGA version$'
	v_prim	db	'Primary display system:$'
	v_sec	db	'Secondary display system:$'
	V_PRIM_D	DB ' on primary display$'
	V_sec_D 	DB ' on secondary display$'
	v_end	db	13,10,'$'
	PRIMARY DB	0
	SECOND	DB	0

ENTRY:

	PUSH AX
	PUSH BX
	PUSH CX
	PUSH DX

	PUSH SI
	PUSH DI

	PUSH ES
	PUSH DS



	call identify

	mov byte ptr second, al
	mov cl, 8
	shr ax, cl
	mov byte ptr primary, al


	mov dx, cs
	mov ds, dx
	mov ah, 9
	mov dx, offset v_end
	int 21h
	mov dx, offset v_a
	int 21h
	mov dx, offset v_end
	int 21h
	int 21h
	mov dx, offset v_prim
	int 21h
	mov dx, offset v_end
	int 21h



	cmp byte ptr primary, 0
	je	v_0_p
	cmp byte ptr primary, 1
	je	v_1_p
	cmp byte ptr primary, 2
	je	v_2_p
	cmp byte ptr primary, 3
	je	v_3_9_p
	cmp byte ptr primary, 4
	je	v_4_p
	cmp byte ptr primary, 5
	je	v_5_p
	cmp byte ptr primary, 6
	je	v_6_p
	cmp byte ptr primary, 7
	je	v_7_p
	cmp byte ptr primary, 8
	je	v_8_p
	cmp byte ptr primary, 9
	je v_3_9_p
	cmp byte ptr primary, 10
	je	v_10_p
	cmp byte ptr primary, 11
	je	v_11_p
	cmp byte ptr primary, 12
	je	v_12_p
	cmp byte ptr primary, 64
	je	v_64_p

v_err_p:
	mov dl, 255
	mov byte ptr primary, dl
	mov dx, offset v_err
	jmp short prim
v_0_p:
	mov dx, offset v_0
	jmp short prim
v_1_p:
	mov dx, offset v_1
	jmp short prim
v_2_p:
	mov dx, offset v_2
	jmp short prim
v_3_9_p:
	mov dx, offset v_3_9
	jmp short prim
v_4_p:
	mov dx, offset v_4
	jmp short prim
v_5_p:
	mov dx, offset v_5
	jmp short prim
v_6_p:
	mov dx, offset v_6
	jmp short prim
v_7_p:
	mov dx, offset v_7
	jmp short prim
v_8_p:
	mov dx, offset v_8
	jmp short prim
v_10_p:
	mov dx, offset v_10
	jmp short prim
v_11_p:
	mov dx, offset v_11
	jmp short prim
v_12_p:
	mov dx, offset v_12
	jmp short prim
v_64_p:
	mov dx, offset v_64

prim:
	mov ah, 9
	int 21h
	mov dx, offset v_prim_d
	int 21h
	mov dx, offset v_end
	int 21h
	int 21h

	mov dx, offset v_sec
	int 21h
	mov dx, offset v_end
	int 21h


	cmp byte ptr second, 0
	je	v_0_s
	cmp byte ptr second, 1
	je	v_1_s
	cmp byte ptr second, 2
	je	v_2_s
	cmp byte ptr second, 3
	je	v_3_9_s
	cmp byte ptr second, 4
	je	v_4_s
	cmp byte ptr second, 5
	je	v_5_s
	cmp byte ptr second, 6
	je	v_6_s
	cmp byte ptr second, 7
	je	v_7_s
	cmp byte ptr second, 8
	je	v_8_s
	cmp byte ptr second, 9
	je v_3_9_s
	cmp byte ptr second, 10
	je	v_10_s
	cmp byte ptr second, 11
	je	v_11_s
	cmp byte ptr second, 12
	je	v_12_s
	cmp byte ptr second, 64
	je	v_64_s

v_err_s:
	mov dx, offset v_err
	jmp short sec
v_0_s:
	mov dx, offset v_0
	jmp short sec
v_1_s:
	mov dx, offset v_1
	jmp short sec
v_2_s:
	mov dx, offset v_2
	jmp short sec
v_3_9_s:
	mov dx, offset v_3_9
	jmp short sec
v_4_s:
	mov dx, offset v_4
	jmp short sec
v_5_s:
	mov dx, offset v_5
	jmp short sec
v_6_s:
	mov dx, offset v_6
	jmp short sec
v_7_s:
	mov dx, offset v_7
	jmp short sec
v_8_s:
	mov dx, offset v_8
	jmp short sec
v_10_s:
	mov dx, offset v_10
	jmp short sec
v_11_s:
	mov dx, offset v_11
	jmp short sec
v_12_s:
	mov dx, offset v_12
	jmp short sec
v_64_s:
	mov dx, offset v_64

sec:
	mov ah, 9
	int 21h
	mov dx, offset v_sec_d
	int 21h
	mov dx, offset v_end
	int 21h
	int 21h

	POP DS
	POP ES

	POP DI
	POP SI

	POP DX
	POP CX
	POP BX
	POP AX

	MOV AH, 04CH
	MOV AL, BYTE PTR PRIMARY
	INT 21H



IDENTIFY PROC NEAR

	MOV AX, 1A00h
	INT 10h
	CMP AL, 1Ah
	JE ACTIVE
	MOV AH, 12H
	MOV BL, 10H
	INT 10H
	CMP BL, 10H
	MOV BX, 0
	JE TESTCGA
	MOV AL, CL
	SHR AL, 1
	CMP AL, 3
	JL EGA1
	SUB AL, 3

EGA1:	MOV BH, 2
	JZ TESTMDA
	SHL BH, 1
	CMP AL, 1
	JE TESTMDA
	MOV BH, 5
	CALL CGA
	JNC ACTIVE
	MOV BL, 2
	JMP ACTIVE

TESTCGA:
	CALL CGA
	JNC TESTMDA
	MOV BH, 2

TESTMDA:
	CALL MDA
	JNC ACTIVE
	MOV BL, 1
	OR BH, BH
	JNC ACTIVE
	XCHG BH, BL

ACTIVE:
	OR BL, BL
	JZ TESTHERC
	PUSH BX
	MOV AH, 0FH
	INT 10H
	POP BX
	AND AL, 7
	CMP BH, 1
	JE MONO
	CMP BH, 5
	JNE NOTMONO

MONO:
	CMP AL, 7
	JE TESTHERC
	JMP TAUSCH

NOTMONO:
	CMP AL, 7
	JNE TESTHERC

TAUSCH:
	XCHG BH, BL

TESTHERC:
	CMP BH, 1
	JNE HERC1
	CALL HERC
	JNC RAUS
	MOV BH, 64

HERC1:
	CMP BL, 1
	JNE RAUS
	CALL HERC
	JNC RAUS
	MOV BL, 64

RAUS:
	MOV AX, BX
	RET


IDENTIFY ENDP


CGA	PROC NEAR
	MOV DX, 3D4H
	CALL TEST6845
	RET
CGA ENDP

MDA PROC NEAR
	MOV DX, 3B4H
	CALL TEST6845
	RET
MDA ENDP

HERC PROC NEAR
	MOV DX, 3BAH
	IN AL, DX
	AND AL, 10000000B
	MOV AH, AL
	XOR CX, CX
LOP:	IN AL, DX
	AND AL, 10000000B
	CMP AH, AL
	LOOPE LOP
	CLC
	JE NOHERC
	CMC

NOHERC:
	RET

HERC endp


TEST6845	PROC NEAR
	MOV AX, 01F0EH
	OUT DX, AL
	INC DX
	IN AL, DX
	XCHG AH, AL
	OUT DX, AL
	MOV CX, 100
	LOOP $
	IN AL, DX
	XCHG AH, AL
	OUT DX, AL
	CMP AH, 01FH
	CLC
	JNE NO6845
	CMC

NO6845:
	RET

TEST6845 ENDP


CODE	ENDS
	END START
