

;
; VGAFONT load font file into fist VGA character generator
; (c) B.Meissner
;

                .8086
                .model large

; 

; Segment type: Stack segment
seg000          segment byte stack 'STACK'
                assume cs:seg000
                assume es:nothing, ss:nothing, ds:nothing
                db 80h dup(0)
seg000          ends

; 

; Segment type: data segment for messages
seg001          segment para public 'UNK'
                assume cs:seg001
                assume es:nothing, ss:nothing, ds:nothing
nofilemsg       db '*** No valid file name, error reading file ***',7,0Ah,0Dh
hardmsg         db 'Hardware character generator restored',0Dh,0Ah ; 
authmsg         db 'VGAFONT      VGA font loader, (c) B.Meiner, 1992',0Dh,0Ah
                                        ; 
                db 'Usage:       VGAFONT [fontfile]',0Dh,0Ah,'$'
                db    0
                align 4
seg001          ends

; 

; Segment type: data segment for string and file data
seg002          segment para public 'UNK'
                assume cs:seg002
                assume es:nothing, ss:nothing, ds:nothing
word_130        dw 0                    ; 
                                        ; 
zerobytes       db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
word_142        dw 0                    ; 
                align 10h
spaces          db '                                                                 '
;                                       ; 
                db '                                                                 '
                db '  ',0
                align 10h
seg002          ends

; 

; Segment type: Code segment
seg003          segment para public 'CODE'
                assume cs:seg003
                assume es:nothing, ss:seg000, ds:nothing

; 


                public start
start           proc near
                call    readname
                jnb     short entry
                jmp     call_setfont2
; 

entry:                                  ; 
                mov     dx, seg seg002
                mov     ds, dx
                assume ds:seg002
                mov     al, 0
                mov     dx, 20h ; ' '
                mov     ah, 3Dh
                int     21h             ; DOS - 2+ - OPEN DISK FILE WITH HANDLE
                                        ; DS:DX -> ASCIZ filename
                                        ; AL = access mode
                                        ; 0 - read
                jb      short pre_setfont2
                mov     word_130, ax
                mov     word_142, 0
                call    setfont_0

pre_open_file:                          ; 
                mov     bx, word_130
                mov     dx, 2
                mov     cx, 10h
                mov     ah, 3Fh
                int     21h             ; DOS - 2+ - READ FROM FILE WITH HANDLE
                                        ; BX = file handle, CX = number of bytes to read
                                        ; DS:DX -> buffer
                jb      short pre_setfont2
                cmp     ax, 0
                jz      short pre_setfont1
                push    ax
                push    cx
                push    es
                push    di
                push    si
                mov     cx, 0A000h
                mov     es, cx
                assume es:nothing
                mov     cx, 10h
                mov     di, word_142
                mov     si, 2
                rep movsb
                mov     cx, 10h
                mov     al, 0
                rep stosb
                mov     word_142, di
                pop     si
                pop     di
                pop     es
                assume es:nothing
                pop     cx
                pop     ax
                jmp     short pre_open_file
; 

pre_setfont1:                           ; 
                call    setfont1
                mov     bx, word_130
                mov     ah, 3Eh
                int     21h             ; DOS - 2+ - CLOSE A FILE WITH HANDLE
                                        ; BX = file handle
                jb      short pre_setfont2
                mov     dx, seg seg001
                mov     ds, dx
                assume ds:seg001
                mov     dx, offset authmsg ; "VGAFONT      VGA font loader, (c) B.Mei"...
                mov     ah, 9
                int     21h             ; DOS - PRINT STRING
                                        ; DS:DX -> string terminated by "$"

pre_exit_pr:                            ; 
                mov     ah, 4Ch
                int     21h             ; DOS - 2+ - QUIT WITH EXIT CODE (EXIT)
                                        ; AL = exit code
; 

pre_setfont2:                           ; 
                call    setfont2
                mov     dx, seg seg001
                mov     ds, dx
                mov     dx, 0
                mov     ah, 9
                int     21h             ; DOS - PRINT STRING
                                        ; DS:DX -> string terminated by "$"
                jmp     short pre_exit_pr
; 

call_setfont2:                          ; 
                call    setfont2
                mov     dx, seg seg001
                mov     ds, dx
                mov     dx, offset hardmsg ; "Hardware character generator restored\r\n"
                mov     ah, 9
                int     21h             ; DOS - PRINT STRING
                                        ; DS:DX -> string terminated by "$"
                jmp     short pre_exit_pr
start           endp


; 


setfont_0       proc near               ; 
                cli
                push    ds
                push    ax
                push    dx
                mov     ax, cs
                mov     ds, ax
                assume ds:seg003
                mov     dx, 3C4h
                mov     ax, 402h
                out     dx, ax          ; 
                                        ; 
                mov     ax, 704h
                out     dx, ax          ; 
                                        ; 
                sti
                mov     dl, 0CEh ; ''
                mov     ax, 204h
                out     dx, ax          ; EGA: graph 1 and 2 addr reg:
                                        ; 
                mov     ax, 5
                out     dx, ax          ; EGA: graph 1 and 2 addr reg:
                                        ; mode register.Data bits:
                                        ; 0-1: Write mode 0-2
                                        ; 2: test condition
                                        ; 3: read mode: 1=color compare, 0=direct
                                        ; 4: 1=use odd/even RAM addressing
                                        ; 5: 1=use CGA mid-res map (2-bits/pixel)
                mov     ax, 6
                out     dx, ax          ; EGA: graph 1 and 2 addr reg:
                                        ; miscellaneous graphics control.Data bits:
                                        ; 0: 1=graphics; 0=enable char gen (text)
                                        ; 1: 1=chain odd maps after even maps
                                        ; 2: memory mapping for CPU
                                        ;    00=a000H (128K);   01=a000H (64K)
                                        ;    10=b000H (32K MDA);11=b800H (32K CGA)
                pop     dx
                pop     ax
                pop     ds
                assume ds:nothing
                retn
setfont_0       endp


; 


setfont1        proc near               ; 
                cli
                push    ds
                push    ax
                push    dx
                mov     ax, cs
                mov     ds, ax
                assume ds:seg003
                mov     dx, 3C4h
                mov     ax, 302h
                out     dx, ax          ; EGA: sequencer address reg
                                        ; 
                mov     ax, 304h
                out     dx, ax          ; EGA: sequencer address reg
                                        ; 
                sti
                mov     dl, 0CEh ; ''
                mov     ax, 4
                out     dx, ax          ; EGA: graph 1 and 2 addr reg:
                                        ; read map select.
                                        ; Data bits 0-2 select map # for read mode 00.
                mov     ax, 1005h
                out     dx, ax          ; EGA: graph 1 and 2 addr reg:
                                        ; unknown register
                mov     ax, 0E06h
                out     dx, ax          ; EGA: graph 1 and 2 addr reg:
                                        ; unknown register
                mov     ah, 0Fh
                int     10h             ; - VIDEO - GET CURRENT VIDEO MODE
                                        ; Return: AH = number of columns on screen
                                        ; AL = current video mode
                                        ; BH = current active display page
                cmp     al, 7
                jnz     short setfont1_ret
                mov     ax, 806h
                out     dx, ax          ; EGA: graph 1 and 2 addr reg:
                                        ; unknown register

setfont1_ret:                           ; 
                pop     dx
                pop     ax
                pop     ds
                assume ds:nothing
                retn
setfont1        endp


; 


setfont2        proc near               ; 
                                        ; 
                push    ax
                push    bx
                mov     ax, 1104h
                mov     bl, 0
                int     10h             ; - VIDEO - TEXT-MODE CHARACTER GENERATOR FUNCTIONS (PS, EGA, VGA)
                                        ; AL = 00h, 10h: load user-specified patterns
                                        ; AL = 01h, 11h: load ROM monochrome patterns (8 by 14)
                                        ; AL = 02h, 12h: load ROM 8 by 8 double-dot patterns
                                        ; AL = 03h: set block specifier
                pop     bx
                pop     ax
                retn
setfont2        endp

; 
                align 10h

; 


readname        proc near               ; 
                mov     dx, seg seg002
                mov     ds, dx
                assume ds:seg002
                mov     di, 80h ; ''
                xor     cx, cx
                mov     cl, es:[di]
;;;             ;;;                jcxz    short exit2   ;;   not correctly translated by the jwasm family of assemblers 
                cmp     cx,0
                je      short exit2
                inc     cx
                mov     al, 20h ; ' '

preprepex:                              ; 
                inc     di
                cmp     al, es:[di]
                loope   preprepex
                lea     si, spaces      ; 

prepex:                                 ; 
                mov     al, es:[di]
                mov     [si], al
                cmp     al, 20h ; ' '
                jz      short exit1
                cmp     al, 0Dh
                jz      short exit2
                inc     si
                inc     di
                loopne  prepex

exit1:                                  ; 
                mov     byte ptr [si], 0
                clc
                retn
; 

exit2:                                  ; 
                stc
                retn
readname        endp

seg003          ends


                end start
