;        TMODE.COM
;  New Version of TMODE for Hercules screens
;  Since I have lost the original source, a disassembly has been made
;  New function sets display control attributes correctly
;
;  TMODE restores the text mode on HERCULES graphics screens
;
;
;
;  assembly: TASM
;
; (c) B.Meissner, 2000
;
;
;        Define common ASCII control codes.
;
HT       EQU   9
LF       EQU   10
FF       EQU   12
CR       EQU   13
EOF      EQU   26
obere_reihe   equ 00h
untere_reihe  equ 018h
linke_spalte  equ 00h
rechte_spalte equ 04Fh
erste_reihe   equ 01h
;
;        Define MSDOS/PCDOS functions.
;
_EXIT    EQU   76
;
;      Macro to generate MSDOS/PCDOS calls.
;
MSDOS    MACRO  name
         IFDEF  &name
         MOV    AH,&name
         ENDIF
         INT    21H
         ENDM
;
Code_Seg SEGMENT PUBLIC
L0000H   EQU   00000H
L0001H   EQU   00001H
L000CH   EQU   0000CH
L00BEH   EQU   000BEH
L03B4H   EQU   003B4H
L03B8H   EQU   003B8H
L1919H   EQU   01919H
L4000H   EQU   04000H
L80F4H   EQU   080F4H
L8A03H   EQU   08A03H
LB000H   EQU   0B000H
LFFD9H   EQU   0FFD9H
Code_Seg ENDS
;
;
Code_Seg SEGMENT PUBLIC
;
         ASSUME CS:Code_Seg,DS:Code_Seg
         ORG   00100H
L0100H:  JMP   SHORT begin
tab      DB    90H                          ; Hercules control register
L0103H   DB    61H,50H,52H,0FH,19H,6        ; values
         DB    19H,19H,2,0DH,0BH,0CH        ;
L010FH   DB    0,0                          ;
;
L0111H:  MOV   DX,OFFSET L03B4H
         OUT   DX,AL
         JMP   SHORT L0117H
L0117H:  INC   DX
         MOV   AL,AH
         OUT   DX,AL
         RET
;
L011CH:  MOV   BL,OFFSET 20H
         LEA   SI,WORD PTR [L0103H]
         JMP   SHORT L0124H
L0124H:  MOV   DX,OFFSET L03B8H
         MOV   AL,BL
         OUT   DX,AL
         CLD                     ;Set forward direction flag.
         MOV   CX,OFFSET L000CH
         XOR   BH,BH
L0130H:  LODSB                   ;Load AL with byt at (SI)+-.
         MOV   AH,AL
         MOV   AL,BH
         CALL  L0111H
         INC   BH
         LOOP  L0130H            ;Dec CX, loop if CX<>0.
         OR    BL,8
         MOV   DX,OFFSET L03B8H
         MOV   AL,BL
         OUT   DX,AL             ; 
                                 ; 
         RET
;
L0146H:  PUSH  ES
         XOR   AX,AX
         XOR   DI,DI
         CMP   WORD PTR [L010FH],0
         JZ    L0156H
         OR    DI,OFFSET 8000H
L0156H:  MOV   DX,OFFSET LB000H
         MOV   ES,DX
         MOV   CX,OFFSET L4000H
         REPZ  STOSW              ;Store wrd in AX in (DI)+-.
         POP   ES
         RET
begin:   MOV   WORD PTR [L010FH],OFFSET L0000H
         CALL  L0146H
         MOV   WORD PTR [L010FH],OFFSET L0001H
         CALL  L0146H
         CALL  L011CH

        xor bx, bx
        mov ah, 06h            ; scroll screen
        mov bh, 07h

        mov al, 24
        mov ch, obere_reihe
        mov cl, linke_spalte
        mov dh, untere_reihe
        mov dl, rechte_spalte
        int 10h                 ; BIOS screen interrupt
set_curs:

        mov ah, 02h            ; set cursor
        xor bx,bx              ; page 0
        mov dh, obere_reihe                 ; line 0
        mov dl, linke_spalte                ; line 0

        int 10h

         MSDOS _EXIT             ;Terminate a process.

Code_Seg ENDS
         END   L0100H
