
;       loadfont.asm load font into first character generator

CSEG            Segment
                Assume  CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG
                Org     0080h
Parameter       Label   Byte
                Org     0100h
Entry:          Jmp Begin

;       All Data
;       --------


DosVersionFail  db      'Requires DOS 2.0 or above$'
FileFail        db      0Dh,'Hardware character generator 1 restored',0Dh,0Ah,"$" 

Delimiters      db      9,' ,;=/'       ; Delimiters in parameter
FileHandle      dw      ?               ; Use for saving file handle

copyright       db 'LOADFONT      VGA font loader, (c) B'
                db '.Meiner, 1992-2015',0Dh,0Ah
                db 'Usage:        LOADFONT [fontfile]',0Dh,0Ah
                db '$',0

Begin:          Cld                     ; All string directions forward

                Mov     DX,offset copyright
                Mov     AH,9            ; Write copyright message
                Int     21h


                Mov     AH,30h
                Int     21h             ; Get DOS Version Number
                Cmp     AL,2            ; Check for 2.0 or later
                Jae     DOSVerOK
                Mov     DX,Offset DOSVersionFail
ErrorExit:      Mov     AH,9            ; Write error message
                Int     21h
                Int     20h


DOSVerOK:       Mov     SI,1 + Offset Parameter ; Points to parameter
NameSearch:     Lodsb                           ; Get byte
                Cmp     AL,13                   ; Check if carriage return
                Jz      NoFileFound             ; If so, no file name
                Mov     DI,Offset Delimiters    ; String of delimiters
                Mov     CX,5                    ; Number of delimiters (no /)
                Repne   Scasb                   ; See if a match
                Je      NameSearch              ; If a delimiter, keep looking
                Mov     DX,SI                   ; Otherwise found file name
                Dec     DX                      ; Points to beginning of it
EndSearch:      Lodsb                           ; Get next byte
                Cmp     AL,13                   ; See if carriage return
                Je      GotFileEnd              ; If so, we're all done
                Mov     DI,Offset Delimiters    ; String of delimiters
                Mov     CX,6                    ; Number (including /)
                Repne   Scasb                   ; See if a match
                Jne     EndSearch               ; If not, still in file name
                Mov     Byte Ptr [SI - 1],0     ; If so, mark end of file name
                cmp     cx,0
                je      GotFlag 
;;;;;;;;;;                Jcxz    GotFlag                 ; 
                Jmp     EndSearch               ; 
GotFlag:        
                

;       Open the File
;       -------------

GotFileEnd:     Mov     Byte Ptr [SI - 1],0     ; Mark end of file name



                                                ; DX still points to name
                Mov     AX,3D00h                ; Open file for reading
                Int     21h                     ;   by calling DOS
                Jnc     GotTheFile              ; If no error, continue
NoFileFound:    

                push    ax
                push    bx
                mov     ax, 1104h
                mov     bl, 0
                int     10h            ; - VIDEO - TEXT-MODE CHARACTER GENERATOR FUNCTIONS (PS, EGA, VGA)
                                       ; AL = 04h, 10h: restore ROM 8x16 characters
                pop     bx
                pop     ax

                Mov     DX,Offset FileFail      ; Otherwise print a message
                Jmp     ErrorExit
GotTheFile:     Mov     [FileHandle],AX         ; Save the file handle

                push bx
                push cx
                push dx
                mov     bx, [FileHandle]
                mov     dx, offset Buffer
                mov     cx, 4096
                mov     ah, 3Fh
                int     21h

                mov ah, 3Eh
                int 21h


                pop dx
                pop cx
                pop bx

                push es
                push bp
                push dx
                mov ah, 11h
                mov al, 0
                push cs
                pop es
                mov bp,offset Buffer
                mov cx, 256
                xor dx,dx
                mov bl, 0
                mov bh, 16
                int 10h

                pop dx
                pop bp
                pop es


                mov ah, 4Ch
                int 21h



;       File Buffer
;       -----------

Buffer          db 4096 dup (0) 

CSEG            EndS                            ; End of segment
                End     Entry                   ; Denotes entry point




