

;
; 512font.exe load font into second VGA character generator
; 

                .8086
;;;;;;;;;;;;;                .model large

; 

; Segment type: Stack segment
seg000          segment para stack 'STACK'
                assume cs:seg000
                assume es:nothing, ss:nothing, ds:nothing
                db 80h dup(0)
seg000          ends

; 
; Segment type: Data segment for message strings
;
seg001          segment para public 'UNK'
                assume cs:seg001
                assume es:nothing, ss:nothing, ds:nothing
errmsg          db '*** No valid file name, error reading file ***',7,0Ah,0Dh
restmsg         db 'Normal font restored for bright characters',0Dh,0Ah
                                        ; 
authmsg         db '512FONT      VGA font loader for table 1, (c) B.Meiner, 1992',0Dh,0Ah
                                        ; 
                db 'Usage:       512FONT fontfile',0Dh,0Ah,'$'
                db    0
                align 4
seg001          ends

; 

; Segment type: Data segmet for file and font data
seg002          segment para public 'UNK'
                assume cs:seg002
                assume es:nothing, ss:nothing, ds:nothing
int_1           dw 0                    ; Inteegr value
bytestring      db 100Eh dup(0)
spaces          db '                                                                 '
                                        ; space string
                db '                                                                 '
                db '  ',0
                align 10h
seg002          ends

; 

; Segment type: Code segment
seg003          segment para public 'CODE'
                assume cs:seg003
                assume es:nothing, ss:seg000, ds:nothing

; 


                public start
start           proc near
                call    read_func
                jnb     short entry
                jmp     short char_gen2
; 
                nop

entry:                                  ; 
                mov     dx, seg seg002
                mov     ds, dx
                assume ds:seg002
                mov     al, 0
                mov     dx, 1010h
                mov     ah, 3Dh
                int     21h             ; DOS - 2+ - OPEN DISK FILE WITH HANDLE
                                        ; DS:DX -> ASCIZ filename
                                        ; AL = access mode
                                        ; 0 - read
                jb      short char_gen_1
                mov     int_1, ax
                mov     bx, int_1
                mov     dx, 2
                mov     cx, 1000h
                mov     ah, 3Fh
                int     21h             ; DOS - 2+ - READ FROM FILE WITH HANDLE
                                        ; BX = file handle, CX = number of bytes to read
                                        ; DS:DX -> buffer
                jb      short char_gen_1
                cmp     ax, 0
                jz      short ent_message
                push    bp
                mov     dx, seg seg002
                mov     es, dx
                assume es:seg002
                mov     ah, 11h
                mov     al, 0
                mov     bp, 2
                mov     cx, 100h
                mov     dx, 0
                mov     bl, 1
                mov     bh, 10h
                int     10h             ; - VIDEO - TEXT-MODE CHARACTER GENERATOR FUNCTIONS (PS, EGA, VGA)
                                        ; AL = 00h, 10h: load user-specified patterns
                                        ; AL = 01h, 11h: load ROM monochrome patterns (8 by 14)
                                        ; AL = 02h, 12h: load ROM 8 by 8 double-dot patterns
                                        ; AL = 03h: set block specifier
                mov     al, 3
                mov     bl, 4
                int     10h             ; - VIDEO - TEXT-MODE CHARACTER GENERATOR FUNCTIONS (PS, EGA, VGA)
                                        ; AL = 00h, 10h: load user-specified patterns
                                        ; AL = 01h, 11h: load ROM monochrome patterns (8 by 14)
                                        ; AL = 02h, 12h: load ROM 8 by 8 double-dot patterns
                                        ; AL = 03h: set block specifier
                pop     bp

ent_message:                            ; 
                mov     bx, int_1
                mov     ah, 3Eh
                int     21h             ; DOS - 2+ - CLOSE A FILE WITH HANDLE
                                        ; BX = file handle
                jb      short char_gen_1
                mov     dx, seg seg001
                mov     ds, dx
                assume ds:seg001
                mov     dx, offset authmsg ; "512FONT ... " signing-on message
                mov     ah, 9
                int     21h             ; DOS - PRINT STRING
                                        ; DS:DX -> string terminated by "$"

exit_ret:                               ; CODE XREF: start+7Ej start+94j
                mov     ah, 4Ch
                int     21h             ; DOS - 2+ - QUIT WITH EXIT CODE (EXIT)
                                        ; AL = exit code
; 

char_gen_1:                             ;    begin manipulating the character generator
                mov     ah, 11h
                mov     al, 3
                mov     bl, 0
                int     10h             ; - VIDEO - TEXT-MODE CHARACTER GENERATOR FUNCTIONS (PS, EGA, VGA)
                                        ; AL = 00h, 10h: load user-specified patterns
                                        ; AL = 01h, 11h: load ROM monochrome patterns (8 by 14)
                                        ; AL = 02h, 12h: load ROM 8 by 8 double-dot patterns
                                        ; AL = 03h: set block specifier
                mov     dx, seg seg001
                mov     ds, dx
                mov     dx, 0
                mov     ah, 9
                int     21h             ; DOS - PRINT STRING
                                        ; DS:DX -> string terminated by "$"
                jmp     short exit_ret
; 

char_gen2:                              ; restore the original character generator
                mov     ah, 11h
                mov     al, 3
                mov     bl, 0
                int     10h             ; - VIDEO - TEXT-MODE CHARACTER GENERATOR FUNCTIONS (PS, EGA, VGA)
                                        ; AL = 00h, 10h: load user-specified patterns
                                        ; AL = 01h, 11h: load ROM monochrome patterns (8 by 14)
                                        ; AL = 02h, 12h: load ROM 8 by 8 double-dot patterns
                                        ; AL = 03h: set block specifier
                mov     dx, seg seg001
                mov     ds, dx
                mov     dx, offset restmsg ; "Normal font restored for bright charact"... : appropriate restore message
                mov     ah, 9
                int     21h             ; DOS - PRINT STRING
                                        ; DS:DX -> string terminated by "$"
                jmp     short exit_ret
start           endp

; 
                align 10h

; 


read_func       proc near               ; 
                mov     dx, seg seg002
                mov     ds, dx
                assume ds:seg002
                mov     di, 80h ; 
                xor     cx, cx

char_read:
                mov     cl, es:[di]
;;;;;;;;;;;;;;;;;                jcxz    short c_read_ret2   ; bad for jwasm assemblers - I do not know,why 
                cmp     cx,0 
                je      short c_read_ret2
                inc     cx
                mov     al, 20h ; ' '

char_read_2:                            ; 
                inc     di
                cmp     al, es:[di]
                loope   char_read_2
                lea     si, spaces      ; spaces buffer

char_read_3:                            ; 
                mov     al, es:[di]
                mov     [si], al
                cmp     al, 20h ; ' '
                jz      short c_read_ret1
                cmp     al, 0Dh
                jz      short c_read_ret2
                inc     si
                inc     di
                loopne  char_read_3

c_read_ret1:                            ; 
                mov     byte ptr [si], 0
                clc
                retn
; 

c_read_ret2:                            ; 
                                        ; 
                stc
                retn
read_func       endp

seg003          ends


                end start
