;
;			   ------ KEYRUS ------
; 	                        HELP_FILE
;
code		segment
		assume	cs:code,ds:code
		org	100h

cr		equ	13
lf		equ	10

Start:
		dw 	Int_Help   ,Int_HelpLen
		dw	ScanTable  ,ScanTableLen
		dw	RussianHelp,RussianHelpLen
		dw	EnglishHelp,EnglishHelpLen

Int_Help	equ	offset $ -100h

		db	'',cr,lf
		db	' KEYRUS Interface                                 ',cr,lf
		db	'',cr,lf
		db	' subfun.         INT 16H ah=41h                  ',cr,lf
		db	'',cr,lf
		db	'  al=00h  ----- KEYRUS test for present          ',cr,lf
		db	'            Output: ax = 0AAAAh; bh,bl - version ',cr,lf
		db	'                    cx = ''KR'' (for Keyrus)     ',cr,lf
		db	'                    dx = segment in memory       ',cr,lf
		db	'  al=01h  ----- Get Status of KEYRUS             ',cr,lf
		db	'            Output: bl = Status byte             ',cr,lf
		db	'  al=02h  ----- Set Status of KEYRUS             ',cr,lf
		db	'            Input : bl = Status byte             ',cr,lf
		db	'  al=03h  ----- Blank screen (/BLANK=ON need)    ',cr,lf
		db	'  al=04h  ----- Restore blanked screen           ',cr,lf
		db	'  al=90h  ----- Set Russian mode ('''')         ',cr,lf
		db	'  al=4ch  ----- Set English mode (''L'')         ',cr,lf
		db	'',cr,lf,0ffh
		db	' Status byte:                                     ',cr,lf
		db	'',cr,lf
		db	'000000xx  Keyboard mode:                         ',cr,lf
		db	'            =00 - Russian                        ',cr,lf
		db	'            =01 - English                        ',cr,lf
		db	'            =10 - Alternate keyboard             ',cr,lf
		db	'            =11 - (reserved)                     ',cr,lf
		db	'00000x00  Enable loading chars                   ',cr,lf
		db	'            = 0 - Disable (use ROM fonts)        ',cr,lf
		db	'0000x000  English keyboard support (read only)   ',cr,lf
		db	'            = 1 - English support                ',cr,lf
		db	'xxxx0000  Internal bits (reserved)               ',cr,lf
		db	'',cr,lf,0

Int_HelpLen	equ	offset $ -100h - Int_Help


;-------------------------------------------------------------------------------
ScanTable	equ	offset $ -100h
		db	'ķ',cr,lf
		db      '  1  Esc     18  E       35  H       52  . >      69  NumLock   ',cr,lf
		db	'  2  1 !     19  R       36  J       53  / ?      70  ScrLock   ',cr,lf
		db      '  3  2 @     20  T       37  K       54  Shft(R ) 71  Home [7]  ',cr,lf
		db	'  4  3 #     21  Y       38  L       55  * PrtSc  72  Up   [8]  ',cr,lf
                db      '  5  4 $     22  U       39  ; :     56  Alt      73  PgUp [9]  ',cr,lf
		db      '  6  5 %     23  I       40  " ''     57  Space    74  Gray-     ',cr,lf
		db	'  7  6 ^     24  O       41  ` ~     58  CapsLock 75  Left [4]  ',cr,lf
                db      '  8  7 &     25  P       42  Shft(L) 59  F1       76  Cntr [5]  ',cr,lf
		db      '  9  8 *     26  [ {     43  \ |     60  F2       77  Right[6]  ',cr,lf
                db      ' 10  9 (     27  ] }     44  Z       61  F3       78  Gray+     ',cr,lf
		db	' 11  0 )     28  Enter   45  X       62  F4       79  End  [1]  ',cr,lf
		db      ' 12  - _     29  Ctrl    46  C       63  F5       80  Down [2]  ',cr,lf
		db	' 13  + =     30  A       47  V       64  F6       81  PgDn [3]  ',cr,lf
		db	' 14  bksp    31  S       48  B       65  F7       82  Ins  [0]  ',cr,lf
		db      ' 15  Tab     32  D       49  N       66  F8       83  Del  [.]  ',cr,lf
		db	' 16  Q       33  F       50  M       67  F9                     ',cr,lf
		db      ' 17  W       34  G       51  , <     68  F10                    ',cr,lf
		db	'Ķ',cr,lf
                db      ' 87  F11     71p Home    72p Up      82p Insert   28p GrayEnter ',cr,lf
		db      ' 88  F12     79p End     80p Down    83p Delete   84  Alt+PrtScr',cr,lf
		db	' 56p Alt(R)  73p PgUp    75p Left    53p Gray/   111p Macro     ',cr,lf
                db      ' 29p Ctrl(R) 81p PgDn    77p Right   55p SysReq                 ',cr,lf
		db	'Ľ',0ffh,cr,lf,0

ScanTableLen	equ	offset $ -100h - ScanTable

;-------------------------------------------------------------------------------

RussianHelp     equ     offset $ -100h

		db	'                       ͸                            ',cr,lf
		db	'                        ᭮  ணࠬ                             ',cr,lf
		db      '͸',cr,lf
		db	' /KEYBOARD[=ON]  --------------------------- ࠩ  () ',cr,lf
		db      '           =OFF                                                  (⪫) ',cr,lf
		db	' /ROM            ------------------------ ⪫ প 䮭⮢ ᯫ ',cr,lf
                db      '                                     (ᯮ짮 , ᠭ  ) ',cr,lf
		db      ' /INTERFACE[=ON] ------------------------------  䥩 () ',cr,lf
		db	'            =OFF                                                 (⪫) ',cr,lf
                db      '                    䥩  ࠢ ࠩ஬ ணࠬ, ',cr,lf
		db      '                                    㦠    १  /release, ',cr,lf
                db      '                                     ᪨  ࠬ ',cr,lf
		db      ';',cr,lf,0ffh

                db      '                           ͸                              ',cr,lf
                db      '                            ࠩ                                ',cr,lf
                db      '   ͸',cr,lf
                db      ' /SCAN=<scancode>[,<shift>]                                  ० ਫ ',cr,lf
                db      ' /LAT=OFF|<scancode>[,<shift>]                              ᪨ ० ',cr,lf
                db      ' /ALT=OFF|<scancode>[,<shift>]           ⥭⨢ ० (ᥢ䨪) ',cr,lf
		db	' /MODESHIFT=OFF|<scancode>[,<mode>]      ६ 室  <mode> ',cr,lf
                db      '    ͵',cr,lf
                db      '          ᫮ 祭          /COLOR=<col>,<altcol>    梥 ࠬ ',cr,lf
                db      'Ĵ /BEEP=<flag> [,<mode>]        㤮 ',cr,lf
                db      ' <flag> :  ON     <mode> :  RUS    /CLICK=<flag>[,<mode>]   ',cr,lf
                db      '           OFF              LAT    /LAMP=<flag> [,<mode>]    窮 ',cr,lf
                db      '                              ALT               ScrollLock   ',cr,lf
		db	';',cr,lf,0ffh
                db      '                      ͸                     ',cr,lf
                db      '                       ࠩ  (த)                      ',cr,lf
                db      '͸',cr,lf
		db	' /CLRSCAN[=<flag>]             ਧ 㫥   ४஢ ',cr,lf
                db      ' /RUSALT[=<flag>]              ९  Alt  . ० ',cr,lf
                db      ' /SWITCH[=<flag>]                                ண ',cr,lf
                db      '         =<scancode>[,<shift>]             祭/몫祭 䮭   ',cr,lf
                db      ' /BASE_KEYS[=<flag>]                         প ᪮  ',cr,lf
                db      ' /KEYS=<filename>                             䠩  ᪫  ',cr,lf
                db      ' /FAST[=<flag>[,<rate>[,<delay>]]]          ᪮ ࠡ  ',cr,lf
                db      ' /BUFFER[=<flag>]                                   让   ',cr,lf
                db      ' /BLANK[=<flag>[,<time>[,<mouse>[,<output>]]]]      ࠭  祭 ',cr,lf
                db      '                   <time> , ᫨  뫮 ⨩ , ࠡ   ',cr,lf
                db      '                   (᫨ <mouse>=ON),  뢮  ࠭ (᫨ <output>=ON) ',cr,lf
                db      ';',cr,lf,0ffh

                db      '                             ͸                               ',cr,lf
                db      '                              ࠩ ᯫ                                ',cr,lf
                db      '͸',cr,lf
                db      '     ͵',cr,lf
                db      ' /ALL                     ᨬ  /FONT=<file>   䮭  譥 䠩 ',cr,lf
                db      ' /128         ᫥ 128 ᨬ  /8x8=Off|On|Auto             䮭 8x8 ',cr,lf
                db      ' /RANGE=<st1>-<en1>,<st2>-<en2>       /8x14=Off|On|Auto           䮭 8x14 ',cr,lf
                db      '           ⮫쪮 ᨬ     /8x16=Off|On|Auto           䮭 8x16 ',cr,lf
                db      '           㪠 ஬⪠  /8xN=<size>,Off|On|Auto 䮭 8x<size> ',cr,lf
                db      ' /RUSSIAN     ⮫쪮 ᪨ ᨬ  /COMPRESS[=<flag>]      ᦠ⨥ 䮭⮢ ',cr,lf
                db      '͵',cr,lf
                db      ' /FULL   প ࠭        (/8x8 /8x14 /8x16 /all /compress=off) ',cr,lf
		db	' /8VGA[=<flag>]                             VGA ᨬ ਭ 8 ᥫ ',cr,lf
		db	' /LAPTOP[=<flag>]      室   Laptop & Notebook ஢ ',cr,lf
                db      ' /NEWFONT=<size>,<loadfun>,<graphfun>,<pointerfun>            ⠫஢ ',cr,lf
                db      '               ࠩ ⠭ 䮭 ࠧ <size> (. 㬥) ',cr,lf
		db	' /DELETEFONT                          ᫥ ⠫஢ 䮭 ',cr,lf
                db      ';',cr,lf,0ffh

                db      '                              ͸                                ',cr,lf
                db      '                               稥 樨                                  ',cr,lf
                db      '͸',cr,lf
                db      ' @<textfile>      ⠭ ⥪⮢ 䠩  ﬨ   ப ',cr,lf
                db      ' /FILES                        ᮧ 䠩  䮭⠬  楩  ',cr,lf
                db      ' /?                               䨣, ""  ࠩ ',cr,lf
		db	' /INT_HELP                              ணࠬ 䥩 KEYRUS ',cr,lf
		db	' /KEY?                                             ⠡  ',cr,lf
                db      ' /EGA   /VGA       㪠  EGA  VGA (  ࠡ뢠 ⨪) ',cr,lf
                db      ' /SAVE              ࠭ 䨣 ࠩ (஬ 権 /VGA, /EGA) ',cr,lf
                db      ' /RELEASE           㧨 ணࠬ   ( ⮡ /INTERFACE=ON) ',cr,lf
		db	' /DELAY_INIT                        ⫮ 㧪 ࠩ , ',cr,lf
                db	'                              㧪  ୮  ࠩ ',cr,lf
		db	' /ANYWAY                          㧪 ன  ࠩ   ',cr,lf
                db      ';',cr,lf,0ffh
                db      '͸',cr,lf
                db      ' 1.  ᫨  ᯮ ணࠬ VIDRAM   PCMOS,  㪠:        ',cr,lf
                db      '     KEYRUS /COMPRESS /VGA ( /EGA)                                        ',cr,lf
                db      ' 2.  ⮡  襭 ࠭ ॠ஢  , ࠩ           ',cr,lf
                db      '     㦠  KEYRUS                                                     ',cr,lf
                db      ' 3.    ࠬ    १㦠 ࠩ, ᫨   ',cr,lf
                db      '     /interface=on.    /scan, /lat, /alt, /color, /switch, /fast, /buffer    ',cr,lf
                db      '                       /modeshift, /keys, /font (᫨ /compress=off)         ',cr,lf
		db	' 4.  ᫨   㪠 16-筮 ᫮, । ᫮ ⠢ ᨬ ''$'' ',cr,lf
		db	' 5.  ᫨    ஡  ""  R.Alt  R.Ctrl,     ',cr,lf
		db	'      ஡ 㦠 keyrus ᫥ ணࠬ  autoexec.bat      ',cr,lf
		db	'       ࢮ ᪥ 㪠  /delay_init,  ᫥ 㧪       ',cr,lf
		db	'     ᫥ १⭮ ணࠬ,   ࠩ  ࠧ.      ',cr,lf
		db	'     ( /interface   ⠭  ON)                           ',cr,lf
		db	' 6.   砥 ஡  ᪨ ⮬  ⮯  㪠 ஡ ',cr,lf
		db      '       /laptop / ࠧ 䮭 8x19: /8xn=19,on            ',cr,lf
                db      ';',cr,lf,0

RussianHelpLen	equ	offset $ -100h - RussianHelp

;-------------------------------------------------------------------------------
EnglishHelp     equ     offset $ -100h

		db	'                       ͸                           ',cr,lf
		db	'                        Main parts of the program                            ',cr,lf
		db      '͸',cr,lf
		db	' /KEYBOARD[=ON]  -------------------------------------- Keyboard driver (on) ',cr,lf
		db      '           =OFF                                                        (off) ',cr,lf
		db	' /ROM            ----------------------------------- Turn off display driver ',cr,lf
                db      '                                                    (use built-in ROM fonts) ',cr,lf
		db      ' /INTERFACE[=ON] -------------------------------------- Interface block (on) ',cr,lf
		db	'            =OFF                                                       (off) ',cr,lf
                db      '                 Interface block allow to control driver from your programs, ',cr,lf
		db      '                                            release from memory by /RELEASE, ',cr,lf
                db      '                               change some parameters without restart driver ',cr,lf
		db      ';',cr,lf,0ffh

                db      '                             ͸                               ',cr,lf
                db      '                              Keyboard driver                                ',cr,lf
                db      ' KEYBOARD SWITCHES ͸',cr,lf
                db      ' /SCAN=<scancode>[,<shift>]                                     Russian mode ',cr,lf
                db      ' /LAT=OFF|<scancode>[,<shift>]                                  English mode ',cr,lf
                db      ' /ALT=OFF|<scancode>[,<shift>]        alternative mode (graphics characters) ',cr,lf
		db	' /MODESHIFT=OFF|<scancode>[,<mode>]    key for temporary switching to <mode> ',cr,lf
                db      ' KEYBOARD MODE INDICATION ͵',cr,lf
                db      '          acceptable values             /COLOR=<col>,<altcol>  border color ',cr,lf
                db      'Ĵ /BEEP=<flag> [,<mode>]         beep ',cr,lf
                db      ' <flag> :  ON     <mode> :  RUS    /CLICK=<flag>[,<mode>]    key click ',cr,lf
                db      '           OFF              LAT    /LAMP=<flag> [,<mode>]         lamp ',cr,lf
                db      '                              ALT                 ScrollLock on keyboard ',cr,lf
		db	';',cr,lf,0ffh
                db      '                          ͸                     ',cr,lf
                db      '                           Keyboard driver (continue)                      ',cr,lf
                db      '͸',cr,lf
		db	' /CLRSCAN[=<flag>]                       flag is ON to set scancodes in zero ',cr,lf
		db	'                                          (it is necessary for some editors) ',cr,lf
                db      ' /RUSALT[=<flag>]   for input punctuation marks by pressing Alt in Rus. mode ',cr,lf
                db      ' /SWITCH[=<flag>]                                       assign key for quick ',cr,lf
                db      '         =<scancode>[,<shift>]                             load/unload fonts ',cr,lf
                db      ' /BASE_KEYS[=<flag>]                                English keyboard support ',cr,lf
                db      ' /KEYS=<filename>                            set file with keyboard matrixes ',cr,lf
                db      ' /FAST[=<flag>[,<rate>[,<delay>]]]                        set keyboard speed ',cr,lf
                db      ' /BUFFER[=<flag>]                                      large keyboard buffer ',cr,lf
                db      ' /BLANK[=<flag>[,<time>[,<mouse>[,<output>]]]]        for blank screen after ',cr,lf
                db      '                            <time> minutes if there was not user''s activity, ',cr,lf
                db      '                     (acceptable values for <mouse> and <output> are ON/OFF) ',cr,lf
                db      ';',cr,lf,0ffh

                db      '                             ͸                                ',cr,lf
                db      '                              Display driver                                 ',cr,lf
                db      '͸',cr,lf
                db      ' LOADING SYMBOLS  FONTS ͵',cr,lf
                db      ' /ALL   the whole chars of ASCII set  /FONT=<file>    font of external file ',cr,lf
                db      ' /128   the second half of ASCII set  /8x8=Off|On|Auto             font 8x8 ',cr,lf
                db      ' /RANGE=<st1>-<en1>,<st2>-<en2>       /8x14=Off|On|Auto           font 8x14 ',cr,lf
                db      '        only for chars with codes in  /8x16=Off|On|Auto           font 8x16 ',cr,lf
                db      '                two specified ranges  /8xN=<size>,Off|On|Auto font 8x<size> ',cr,lf
                db      ' /RUSSIAN     only for Russian chars  /COMPRESS[=<flag>]   font compression ',cr,lf
                db      '͵',cr,lf
                db      ' /FULL  full screen support            (/8x8 /8x14 /8x16 /all /compress=off) ',cr,lf
		db	' /8VGA[=<flag>]                          to set characters width in 8 on VGA ',cr,lf
		db	' /LAPTOP[=<flag>]              required for some Laptop & Notebook computers ',cr,lf
                db      ' /NEWFONT=<size>,<loadfun>,<graphfun>,<pointerfun>                   install ',cr,lf
                db      '              into driver nonstandard font with size <size> (look full doc.) ',cr,lf
		db	' /DELETEFONT                                      delete last installed font ',cr,lf
                db      ';',cr,lf,0ffh

                db      '                                 ͸                                   ',cr,lf
                db      '                                  Others                                    ',cr,lf
                db      '͸',cr,lf
                db      ' @<textfile>                         text file is inserted into command line ',cr,lf
                db      ' /FILES                        create files with fonts and keyboard matrixes ',cr,lf
                db      ' /?                                        show default driver configuration ',cr,lf
		db	' /INT_HELP                        information about KEYRUS program interface ',cr,lf
		db	' /KEY?                                                        scancode table ',cr,lf
                db      ' /EGA   /VGA                     Select EGA or VGA (if diagnostic has fault) ',cr,lf
                db      ' /SAVE                 save driver configuration (except /VGA, /EGA options) ',cr,lf
                db      ' /RELEASE               release program from memory (/INTERFACE=ON required) ',cr,lf
		db	' /DELAY_INIT                             delayed loading of keyboard driver, ',cr,lf
                db	'                   to activate driver it is necessary to restart the program ',cr,lf
		db	' /ANYWAY                      allow to load other copy of driver into memory ',cr,lf
                db      ';',cr,lf,0ffh
                db      '͸',cr,lf
                db      ' 1.  If you use program VIDRAM or OS PCMOS, type                             ',cr,lf
                db      '     KEYRUS /COMPRESS /VGA (or /EGA)                                         ',cr,lf
                db      ' 2.  If you want KEYRUS to know about mouse, load mouse driver before        ',cr,lf
                db      '     KEYRUS itself                                                           ',cr,lf
                db      ' 3.  Following parameters may be changed without driver restart. (required   ',cr,lf
                db      '     /interface=on)    /scan, /lat, /alt, /color, /switch, /fast, /buffer    ',cr,lf
                db      '                       /modeshift, /keys, /font (if /compress=off)           ',cr,lf
		db	' 4.  Hexadecimal format for numbers: $number                                 ',cr,lf
		db	' 5.  If you have some troubles with keyboard, try to load KEYRUS after other ',cr,lf
		db	'     TSR programs. If it is impossible:                                      ',cr,lf
                db      '       start KEYRUS with parameter /delay_init (interface=on required)       ',cr,lf
		db	'       load all required TSR programs                                        ',cr,lf
                db      '       and restart KEYRUS again.                                             ',cr,lf
		db	' 6.  If you have some troubles with font on laptop/notebook, try set options ',cr,lf
		db      '     /laptop and /8xn=19,on (enable font 8x19)                               ',cr,lf
                db      ';',cr,lf,0

EnglishHelpLen	equ	offset $ -100h - EnglishHelp


code		ends
		end	start
