;
;			   ------ KEYRUS ------
; 		          ⤥প 
;
;-------------------------------------------------------------------------------
; 		  ࠡ稪 
;-------------------------------------------------------------------------------
KeyboardData	proc	near
		db	1
		dw	@@LenBlock
@@StartData	equ	this byte
						;  :  7=1 -> ext code
Scan_Cod	equ	$ - offset @@StartData	;   室  ᪨ ०
		dw	?
ResetCode	equ	$ - offset @@StartData	;   室  . ०
		dw	?
AlterCode	equ 	$ - offset @@StartData	;   室  . ०
		dw	?
Color		equ 	$ - offset @@StartData	;  ࠬ  ᪮ ०
		db	?
AltColor	equ 	$ - offset @@StartData	;  ࠬ  ୠ⨢ ०
		db	?
CodeSw		equ 	$ - offset @@StartData	;   ४祭 
		db	?
ShiftSw		equ 	$ - offset @@StartData	; Shift ४祭 
		db	?
Int09h		equ	$ - offset @@StartData	;  楤 ࠡ⪨ int 9h
		dw	?
ShiftScan	equ	$ - offset @@StartData	; . shiftmode
		db	?
ShiftMode	equ	$ - offset @@StartData	;  shiftmode
		db	?
RetShiftMode	equ	$ - offset @@StartData	;  ࠭ ०  shiftmode
		db	?
PrefixTst	equ	$ - offset @@StartData	;  ࠭  ᫥ 䨪
		db	?
KeybMatrixLen	equ	$ - offset @@StartData	;   ()
		dw	?

KeybMatrix	equ	$ - offset @@StartData  ; 㤠 㩤  

@@LenBlock      equ	$ - offset @@StartData
KeyboardData	endp
;-------------------------------------------------------------------------------
;--------------- ࠡ稪 ⭮ 뢠 09h
;----- 뢠  ࠧ,  Intel 8042 ନ  ᪠
;-------------------------------------------------------------------------------
KeyboardHandler	proc	near			; 䨪 
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset Int_09h_Entry - offset KeyboardHandler
						; ---  맮
		db	10
		dw	offset TestFontSwitch  , offset PrSwitch
		dw	offset TouchBlankScreen, offset BlankScreen
		dw	offset AltInRusTest    , offset AltRusTest
		dw	offset CallSetReset    , offset SetReset
		dw	offset @@TranslateCode , offset TranslateCode
		dw	offset @@KeySound      , offset KeySound
		dw	offset @@ModeShiftTest , offset _ModeShiftTest
		dw	offset @@DisableKeyboard,offset _DisableKeyboard
		dw	offset @@EndHandler9_1 , offset _EndHandler9
		dw	offset @@EndHandler9_2 , offset _EndHandler9

Int_09h_Entry:
		sti
		push	ax			; ⠢   ⥪
		push    si di ax bx cx dx ds es
		push	cs
		pop	ds
		mov	di,KeyboardBlockData	; di -   
		mov     es,BIOSSeg              ; Set BIOS Seg

@@DisableKeyboard 	CallNear		;  
		in      al,60h                  ; al <- scan cod

		mov     dl,Status
		stc
TouchBlankScreen	CallNear		; ᨫ ࠭ cf=1 - 
		jnc	@@JmpExit               ; cf=0 -  


TestFontSwitch		CallNear		; ஢ઠ  
						; ४祭 䮭
		cmp	al,0fah			; ACK code
		je	@@ignore
		cmp	al,0e0h
		jne     @@No_ext                ; 䨪 . 
		or      dl,10000000b            ; 䫠 䨪
@@ignore:	jmp	@@EatPrefix
@@No_Ext:
		mov	bl,RetShiftMode[di]
		cmp	bl,0ffh
		jne	@@SM
		mov     bl,dl
		and     bl,00000011b            ; bl : 0- rus, 1- engl, 2 - alter
@@SM:		xor     bh,bh
		mov     cx,2

@@lp:           dec     bl
		jns     @@2
		mov     bl,2                    ; 䨪   0-2-1-0-...
@@2:
		shl	bx,1
		lea	si,Scan_Cod[di+bx]      ; si-   ஢ન
		shr	bx,1
		call    TestSwitch
 		jcxz    MShiftTest              ; 室  
                loop    @@lp                    ; 横  2-  ४祭
						;    ४祭
		and     dl,10001111b            ; 㡨ࠥ press 䫠
MShiftTest:
		or	di,di			; zf=0
@@ModeShiftTest		CallNear
		jnz	@@WorkKeys
@@JmpExit:	jmp	@@Exit
@@WorkKeys:                                     ; 쭥 ࠡ⪠
						; al - ScanCode; dl - Status
		cmp     al,53                   ; ᫨   > 53 - Old Vec.
		ja      @@ClrPrefix             ;   ᪠
		test	dl,10000000b		;   䨪
		jne	@@ClrPrefix

		mov	ah,es:17h		; ah=keyboard flags
		and	ah,0ch			; Ctrl,Alt flags

AltInRusTest		CallNear		; -> JNE - Ctrl or Alt
				; JE - Ok, if ah=2, Alter mode in russian
		je	@@NoCtrlAlt
				   		; Ctrl or Alt
		test	dl,00001000b		; Support english ?
		je	@@ClrPrefix		; Ctrl, Alt without engl. support
		cmp	al,16			; key = character ?
		jae	@@ReadyForCall		;  ⤥প .
						;  ⨨ Ctrl/Alt + Char
						;   ஢ப
@@ClrPrefix:	jmp	@@ClearPrefix
@@NoCtrlAlt:					;  ctrl, alt 
						; Alt in Rus
		test	dl,00000001b		; Engl. mode ?
		je	@@ReadyForCall		;  ᪨ - Ok
		test	dl,00001000b		; Support english ?
		je	@@ClrPrefix		; ᫨  . - 室
@@ReadyForCall:
		mov     bx,es:1ch               ; bx - 墮  

__CallOld:      pushf
		CallFAR			        ; Call OldVector
Ofs_09a         dw      0
Seg_09a         dw      0

		or	al,al			; al=0 - 뫮 ४祭
						;   
		jne	@@OkScan
		mov	al,dl			; 뫮 ४祭; al - status
CallSetReset		CallNear		;  
		jmp	short @@Exit
@@OkScan:					;  뫮 ४祭
		cmp     bx,es:1ch               ;   墮 ?
		je      @@Exit                  ; ᫨  -  ࠡ뢠


@@TranslateCode		CallNear		; ࠡ⪠ 
						;  ᨬ  engl. support
@@KeySound		CallNear		;  ᨣ click

@@Exit:
@@EndHandler9_1		CallNear
		iret

@@ClearPrefix:  and     dl,01111111b            ;  䨪
@@EatPrefix:
@@EndHandler9_2		CallNear
		JmpFAR		                ; jmp Oldvector
Ofs_09h		dw	0
Seg_09h		dw	0
;
;
;----------- 楤 TestSwitch ᯮ  ࠡ稪 Int09h ᥣ
TestSwitch      proc    near
;  si - .   ஢ન; dl - Status; di - keyboard data; bl - mode
;  室 ४砥 ᠬ.
; --> ᫨ cx=0 -   ᪠, 뫮 ⨥ -  ᪠

		mov	dh,es:17h
		mov	ah,[si+1]		; shift mask for code
		and	dh,ah
		cmp	dh,ah
		jne	@@EndTest

		mov	ah,[si]
		mov     dh,ah
		and     ah,7fh                  ; ah - sc.code
		je	@@EndTest
		cmp     al,ah                   ; ஢ઠ  ⨥ 㦭 
		jne     @@NoPress

		push	dx
		xor	dh,dl
		and	dh,80h			; dh:80 - 10,01, 0 -11,00
		pop	dx
		jne	@@EndTest		;  ᮢ   䫠 䨪

		test    dl,00100000b            ; Already press ?
		jne     @@Already

		test	dl,10000000b		;  䨪
		je	@@1
		mov	PrefixTst[di],dh	; ᫨ 뫮 ⨥  䨪ᮬ -
						; ⠭ PrefixTst
@@1:		or      dl,00100000b            ; ⠭ 䫠 
@@2:		xor     cx,cx
		jmp     @@EndTest
@@Already:      or      dl,01000000b            ; 䫠 ୮ 
		jmp     @@2
@@NoPress:
		or      ah,80h
		cmp     al,ah                   ; ஢ઠ  ᪠
		jne     @@EndTest
		test    dl,00100000b            ;  ⮣ 뫮 ⨥ ?
		je      @@EndTest
		test    dl,01000000b
		jne     @@EndTest               ;  ঠ 
		test	dl,10000000b		;  䨪 ?
		je	@@NeedSwitch
		cmp	dh,PrefixTst[di]
		jne	@@EndTest
@@NeedSwitch:					; 믮塞 ४祭
		ClearProc
		and	dl,00001111b

		cmp	byte ptr RetShiftMode[di],0ffh   ; ஢ઠ -  ० modeshift?
		je	@@NoM
		mov	RetShiftMode[di],bl	; ᫨  -    
		jmp	MShiftTest
@@NoM:		
		and	dl,11111100b
		or	dl,bl
		xor	al,al
		jmp	__CallOld		;   筮 ४祭  
@@EndTest:
		ret
TestSwitch      endp

@@LenCode	equ	$ - offset Int_09h_Entry
KeyboardHandler endp
;-------------------------------------------------------------------------------
; 楤 EndHandler9: ⠭ ॣ, ࠧ蠥 
;                        ᯮ  ࠡ稪 Int09h ᥣ
;-------------------------------------------------------------------------------
EndHandler9	proc	near
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset EndHandler9
						; ---  맮
		db	1
		dw	offset @@EnableKeyboard, offset _EnableKeyboard
@@Start:

@@EnableKeyboard	CallNear
		pop	si
		push	bp
		mov	bp,sp
		mov	[bp+18],si		; move return addr.
		pop	bp
		mov	Status,dl
		pop	es ds dx cx bx ax di si
		ret

@@LenCode	equ	$ - offset @@Start
EndHandler9	endp
;-------------------------------------------------------------------------------
; 楤 ModeShiftTest :  室 al - sccode; dl - status;
;		            ࠡ⪠ Mode Shift, if ok -> zf & bl-new mode, clc
;-------------------------------------------------------------------------------
ModeShiftTest	proc	near			; 䨪 
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset ModeShiftTest
						; ---  맮
		db	1
		dw	offset @@SetReset, offset SetReset

@@Start:
		mov	ah,ShiftScan[di]	; ah - ShiftModeScan
		mov	bl,dl
		and	bl,3

		push	ax
		mov     dh,ah
		push	dx
		xor	dh,dl
		and	dh,80h			; dh:80 - 10,01, 0 -11,00
		pop	dx
		jne	@@EndTest0		;  ᮢ   䫠 䨪

		mov	bh,bl			; bh - Old Mode
		and     ah,7fh                  ; ah - sc.code
		cmp     al,ah                   ; ஢ઠ  ⨥ 㦭 
		je      @@Press
		or	ah,80h
		cmp	al,ah
		je	@@Release
		jmp	@@EndTest0
@@Press:
		cmp	byte ptr RetShiftMode[di],0ffh	; ਧ,    ६ ०
		jne	@@NeedSwitch		; ୮ ⨥
						;  
		mov	RetShiftMode[di],bl	; ࠭塞 ०
		mov	bl,ShiftMode[di]
		cmp	bl,bh
		jne	@@NeedSwitch
		mov	bl,1			; English
		jmp	@@NeedSwitch
@@Release:
		mov	al,RetShiftMode[di]
		cmp	al,0ffh
		je	@@NeedSwitch		; ୮ ⨥
		mov	bl,al
		mov	byte ptr RetShiftMode[di],0ffh
@@NeedSwitch:
		in	al,61h
		mov	ah,al
		or	al,80h
		out	61h,al
		xchg	al,ah
		out	61h,al
		mov	al,20h
		out     20h,al			;   

		cmp	bl,bh
		je	@@NoChange
		and     dl,01111100b            ;
		or      dl,bl                   ; ⠭ ० 
		mov	al,dl			; 뫮 ४祭; al - status
@@SetReset		CallNear		;  
@@NoChange:
		xor 	ah,ah                   ; zf=1
@@EndTest0:                                     ;  뫮 ४祭
		or      ah,ah                   ; zf=0
						; ah   =0
@@EndTest:      pop	ax
		ret

@@LenCode	equ	$ - offset @@Start
ModeShiftTest	endp
;-------------------------------------------------------------------------------
;	 ࠡ⪠   楤   ⤥প ᪮
;-------------------------------------------------------------------------------
WithoutEnglish	proc	near			; 䨪 
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset WithoutEnglish
						; ---  맮
		db	1
		dw	offset @@RightKeyTest, offset AdrRightKeyTest

@@Start:                 			; di -  
		push	bx
		xor     bl,bl                   ; 롮   䫠
						; 0,1 -rus; 2,3 -alt
	        test    dl,2
		je      @@NoAlt
		or      bl,2
@@NoAlt:                                        ; ࠭ ⨯ 
		or	bl,ah			; ah=0  2 (. AltRusTest)

		mov     ah,es:17h               ; ।塞 shift status
		test    ah,40h
		je      @@NoCaps

		cmp	al,43			; \
		je	@@NoCaps
		cmp	al,16                   ;  CAPS ० 孨  
		jb	@@NoCaps                ;  ४
		test	dl,3
		je	@@_Caps			;  ᪮ ० CAPS
						;   ࠢ 
@@RightKeyTest		CallNear		; . cf, ᫨ : [];',./
		jnc	@@NoCaps
@@_Caps:
		or      bl,1                    ; set shift
@@NoCaps:
		test    ah,3                    ; shift ?
		jz      @@NoShift
		xor     bl,1
@@NoShift:
		push    ax
		mov     al,53
		mul     bl
		mov     bx,KeybMatrix
		add	bx,di
		add     bx,ax
		pop     ax
						; bx -  
		mov     ah,al
		dec     al
		xlat                            ; al=[al+bx] table
						; al - ASCII
						; al - 0,if no translate
		or	al,al
		pop	bx
		je	@@Exit

		cmp     al,' '
		jb      @@KeepScan
ZeroScan1	equ	this word		; Write 9090h for Disable
		xor     ah,ah                   ; Set Scan Cod = 0
@@KeepScan:
		mov     es:[bx],ax		; 㥬 . 
@@Exit:
		ret

@@LenCode	equ	$ - offset @@Start
WithoutEnglish  endp
;-------------------------------------------------------------------------------
;	 ࠡ⪠   楤   ⤥প ᪮
;-------------------------------------------------------------------------------
WithEnglish	proc	near			; 䨪 
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset WithEnglish
						; ---  맮
		db	1
		dw	offset @@RightKeyTest, offset AdrRightKeyTest

@@Start:                 			; di -  
		push	bx
		xor     bl,bl                   ; 롮   䫠
						; 0,1 -rus; 2,3 -alt; 4,5 -eng
						; 6   -alt shift;
		mov	dh,ah			; dh = ctrl,alt flags
		test	dh,08h			; Alt Shift
		je	@@NoAltShift
		mov	bl,6
		jmp	@@ToAddr
@@NoAltShift:
		test	dh,04h			; Ctrl Shift
		je	@@NoCtrlShift
		mov	bl,5
		jmp	@@ToAddr
@@NoCtrlShift:
		test    dl,1			; engl ?
		je      @@NoEng
		or      bl,4
@@NoEng:        test    dl,2			; alt ?
		je      @@NoAlt
		or      bl,2
@@NoAlt:                                        ; ࠭ ⨯ 
		or	bl,ah			; ah=0  2 (. AltRusTest)
						; ----------------------------
		mov     ah,es:17h               ; ।塞 shift status
		test    ah,40h
		je      @@NoCaps

		cmp	al,43			; \
		je	@@NoCaps
		cmp	al,16                   ;  CAPS ० 孨  
		jb	@@NoCaps                ;  ४
		test	dl,3
		je	@@_Caps			;  ᪮ ० CAPS
						;   ࠢ 
@@RightKeyTest		CallNear		; . cf, ᫨ : [];',./
		jnc	@@NoCaps
@@_Caps:
		or      bl,1                    ; set shift
@@NoCaps:
		test    ah,3                    ; shift ?
		jz      @@ToAddr
		xor     bl,1
@@ToAddr:
		push    ax
		mov     al,53
		mul     bl
		mov     bx,KeybMatrix
		add	bx,di
		add     bx,ax
		pop     ax

		mov     ah,al
		dec     al
		xlat                            ; al=[al+bx] table
						; al - ASCII
						; al - 0,if no translate
		or	al,al
		pop	bx
		je	@@Exit

		test	dh,4			; ctrl shift
		je	@@NoCtrlShift1
		and	al,1fh			; generate ctrl code
		jmp	@@KeepScan
@@NoCtrlShift1:
		test	dh,8			; alt shift
		je	@@NoAltShift1
		mov	ah,al
		xor	al,al
		jmp	@@KeepScan
@@NoAltShift1:
		cmp     al,' '
		jb      @@KeepScan
		test	dl,1
		jne	@@KeepScan		;  .  
ZeroScan2	equ	this word		; Write 9090h for Disable
		xor     ah,ah                   ; Set Scan Cod = 0
@@KeepScan:
		mov     es:[bx],ax
@@Exit:
		ret

@@LenCode	equ	$ - offset @@Start
WithEnglish     endp
;-------------------------------------------------------------------------------
;         楤 RightKeyTest ᯮ  ࠡ稪 Int09h ᥣ
;-------------------------------------------------------------------------------
RightKeyTest	proc	near
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset RightKeyTest
						; ---  맮
		db	0

@@Start:
; 		al - ᪠ 
; 		-> f=0, ᫨ : [];',./\ (7    ९)

		cmp	al,26
		je	@@Ok
		cmp	al,27
		je	@@Ok
		cmp	al,39
		je	@@Ok
		cmp	al,40
		je	@@Ok
		cmp	al,51
		jb	@@Ret			; 7    ९
@@Ok:		clc
@@Ret:		ret

@@LenCode	equ	$ - offset @@Start
RightKeyTest	endp
;-------------------------------------------------------------------------------
;	楤 AltTest -    ९  Alt
;-------------------------------------------------------------------------------
AltTest		proc	near
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset AltTest
						; ---  맮
		db	1
		dw	offset @@RightKeyTest, offset AdrRightKeyTest

;	 室 : al-sc.code; dl-status; ah-keyb.flags and 0ch (Alt)
;	 室: zf=0 - Ctrl or Alt - to BIOS; zf=1 - Ok, ah={0|2}
;	ah=2, ᫨ ୠ⨢ ०  ᪮
@@Start:
		cmp	ah,8			; Alt ?
		je	@@Ok
@@No:						; no AltRus
		and	ah,0ch			; Ctrl, Alt test, zf=0, if true
		ret
@@Ok:
@@RightKeyTest		CallNear		; cf=0, ᫨ ࠢ 
		jc	@@No

		test	dl,3
		jne	@@No			; ⮫쪮  ᪮ ०
		xor	ah,ah			; zf=1
		mov	ah,2			; Alt flag
		ret

@@LenCode	equ	$ - offset @@Start
AltTest		endp
;-------------------------------------------------------------------------------
; 	楤 EGACGAText - । ⨯ ०  EGA/CGA
;-------------------------------------------------------------------------------
EGACGAText      proc    near
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset EGACGAText
						; ---  맮
		db	0

;       es=40h; 頥 zf, ᫨ ⥪⮢ ०  EGA

@@Start:
		push    ax es
		mov	es,BIOSSeg
		mov     al,es:49h               ; Video Mode
		and     al,7fh
		cmp     al,3
		jbe     @@ok
		cmp     al,7
		je      @@ok
		or      al,al                   ; zf=0
		jmp     short @@exit
@@ok:           xor     al,al
@@exit:         pop     es ax
		ret

@@LenCode	equ	$ - offset @@Start
EGACGAText      endp
;-------------------------------------------------------------------------------
; 	楤 VGAText - । ⨯ ०  VGA
;-------------------------------------------------------------------------------
VGAText         proc    near
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset VGAText
						; ---  맮
		db	0

;       es=40h; 頥 zf, ᫨ ⥪⮢ ०  VGA

@@Start:
		push    ax dx

		mov     dx,3ceh
		in	al,dx
		mov	ah,al			; Save Gr.Index
		mov	al,6
		out     dx,al
		inc     dx
		in      al,dx                   ; Gr6 ॣ VGA
		dec	dx
		test    al,1                    ;  0: =0 - text
		mov	al,ah
		out	dx,al

@@exit:         pop     dx ax
		ret

@@LenCode	equ	$ - offset @@Start
VGAText         endp
;-------------------------------------------------------------------------------
;楤 SwitchLoad: ࠡ⪠ 樨 , /⪫ 㧪 
;-------------------------------------------------------------------------------
SwitchLoad	proc	near
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset SwitchLoad
						; ---  맮
		db	2
		dw	offset @@ReloadChars	, offset _ReloadChars
		dw	offset @@EndHandler9	, offset _EndHandler9

;	al - scan code; es - BIOS seg; di - Keyboard Data
@@Start:
		cmp	al,CodeSw[di]		; ஢ઠ  
		jne	@@r

		push	ax
		mov	al,es:17h
		mov	ah,ShiftSw[di]
		and	al,ah
		cmp	al,ah
		jne	@@r1			; ஢ઠ 䫠 shift
						; ---  㦭 
		in	al,61h
		mov	ah,al
		or	al,80h
		out	61h,al
		xchg	al,ah
		out	61h,al
		mov	al,20h
		out     20h,al			;   

		xor     Status,00000100b	;   㧪
@@l:
@@ReloadChars		CallNear

		pop	ax
		ClearProc

		mov	dl,Status
@@EndHandler9		CallNear
		iret				;   뢠

@@r1:		pop	ax
@@r:		ret

@@LenCode	equ	$ - offset @@Start
SwitchLoad	endp
;-------------------------------------------------------------------------------
;楤 KeyWaitReady:  ⮢ 
;-------------------------------------------------------------------------------
KeyWaitReady    proc    near
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset KeyWaitReady
						; ---  맮
		db	0
@@Start:
		cli
		xor	cx,cx
@@lp:
		jmp	$+2
		in	al,64h			; port 64h, keyboard status
		test	al,2
		loopnz  @@lp
		jz	@@rt
@@lp1:
		jmp	$+2
		in	al,64h			; port 64h, keyboard status
		test	al,2
		loopnz  @@lp1
@@rt:		sti
		retn				; zf=1 - ok

@@LenCode	equ	$ - offset @@Start
KeyWaitReady    endp
;-------------------------------------------------------------------------------
;楤 EnableKeyboard: 襭 
;-------------------------------------------------------------------------------
EnableKeyboard  proc    near
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset EnableKeyboard
						; ---  맮
		db	1
		dw	offset @@WaitReady, offset _KeyWaitReady
@@Start:
@@WaitReady		CallNear
		mov	al,0AEh
		out	64h,al
		ret

@@LenCode	equ	$ - offset @@Start
EnableKeyboard  endp
;-------------------------------------------------------------------------------
;楤 DisableKeyboard: 饭 
;-------------------------------------------------------------------------------
DisableKeyboard  proc    near
		db	0			;  
		dw	@@LenCode
		dw	0			;  室 ॠ 
		dw	offset @@Start - offset DisableKeyboard
						; ---  맮
		db	2
		dw	offset @@WaitReady1, offset _KeyWaitReady
		dw	offset @@WaitReady2, offset _KeyWaitReady
@@Start:
@@WaitReady1		CallNear
		mov	al,0ADh
		out	64h,al
@@WaitReady2		CallNear

		ret

@@LenCode	equ	$ - offset @@Start
DisableKeyboard  endp
