;
;			   ------ KEYRUS ------
; 	        ⮢  ࠡ⪨  ப
;

ComLineSeg	dw	0		;    ப
					; (128 ࠣ䮢)
FileSeg		dw	0		;   ⥭ 䠩
					; (128 ࠣ䮢)
FileLen		dw	0		;  䠩
ComLineLength	dw	0		;   ப  

s_On            db      'ON',0
s_off           db      'OFF',0
s_auto          db      'AUTO',0
s_rus           db      'RUS',0
s_lat           db      'LAT',0
s_alt           db      'ALT',0

Mes_@Error	db	cr,lf,7,'@ : File name missed',0
Mes_Error       db      cr,lf,7
		db      'Warning! Error in parameter: /',0

Mes_MicroHelp	db	'USAGE: KEYRUS [/key1 /key2 ...]         - run KeyRus',cr,lf
		db	'       KEYRUS [/key1 /key2 ...] /SAVE   - for save parameters',cr,lf
		db	'       KEYRUS @filename                 - use text file with parameters',cr,lf
		db	'       KEYRUS /HELP[:RUS]               - for quick help',cr,lf,0

;-------------------------------------------------------------------------------
; PrepareCommandLine : ஢  ப  ᯥ樠 
;-------------------------------------------------------------------------------
PrepareCommandLine	proc near
		push	es

		mov     ax,EndProgram           ; ᬥ饭  ணࠬ
		mov	cl,4
		shr     ax,cl
		inc     ax                      ; ax -   ࠣ
		mov	bx,cs
		add	bx,ax
		add	bx,32			; 512   直 
		mov	ComLineSeg,bx
		add	bx,128
		mov	FileSeg,bx		; ࠧ⨫ 

		mov	cl,ds:80h		;   ப
		xor	ch,ch
		mov	es,ComLineSeg
		mov	si,81h
		xor	di,di
		mov	ComLineLength,0
@@1:
		jcxz	@@ret

@@lp:
		lodsb
		cmp	al,'@'
		jne	@@2

		call	ReadCommandFile		; 㦥 '@' -  䠩
		jmp	@@1
@@2:
		stosb
		inc	ComLineLength
		loop	@@lp
@@ret:
		pop	es
		ret
PrepareCommandLine	endp
;-------------------------------------------------------------------------------
; ReadCommandFile :  䠩,  ண   ப ᫥ '@'
; ds:si - comstr (FILE NAME); es:di - comstr buffer; cx - length comstr
;-------------------------------------------------------------------------------
ReadCommandFile		proc near

		jcxz	@@err
@@lp:		lodsb			; 뢠 ஡ ᯥ।
		cmp	al,' '
		loope	@@lp
		jcxz	@@err

		inc	cx
		dec	si

		push	si		; ᬥ饭 砫  䠩
@@lp1:
		lodsb
		dec	cx
		jcxz	@@0
		cmp	al,' '
		ja	@@lp1
@@0:
		push	di es
		push	ds
		pop	es
		mov	di,si
		dec	di		; es:di ->  ᨬ   䠩
		xor	al,al
		stosb			; 뢠 0 (ASCIIZ)
		pop	es di

		pop	dx		; ds:dx - filename
		mov	ax,3d00h
		int	21h		; open file
		jc	@@errfile

		push	ds dx cx
		mov	bx,ax
		mov	ds,cs:FileSeg
		xor	dx,dx
		mov	cx,2048		; 2048  ᨬ
		mov	ah,3fh
		int	21h
		pushf
		push	ax
		mov	ah,3eh		; close file
		int	21h
		pop	ax
		popf
		pop	cx dx ds

		jc	@@errfile

		mov	FileLen,ax	;  ⠭
		push	ds si cx
		mov	ds,cs:FileSeg
		xor	si,si
		mov	cx,cs:FileLen
		jcxz	@@Eof
@@lp2:
		lodsb
		cmp	al,' '
		jb	@@eol
		stosb
		inc	cs:ComLineLength
@@eol:		loop	@@lp2
@@eof:
		pop	cx si ds
		ret

@@err:                       			; 訡 ࠬ
		lea	si,Mes_@Error
		call	OutString
		jmp	@@e

@@errfile:					; 訡 䠩
		mov	si,dx
		call	OutString		; 뤠  䠩
		lea	si,Mes_FileError
		call	OutString
@@e:
		call	OutEoln
		mov	al,1
		call	Exit

ReadCommandFile		endp
;-------------------------------------------------------------------------------
; ReadPar :  । ࠬ ('/...')   ப
;       bx 㪠뢠  ᨬ  '/'
;       । ࠬ  .ப [bx] -> Buffer2
;       稢 0, bx - 砫 ᫥饣 ࠬ
;       zf, ᫨  ࠬ
;-------------------------------------------------------------------------------
ReadPar         proc    near

		push	ds es

		mov     di,Buffer2
		push	ds
		pop	es
		mov	ds,cs:ComLineSeg
		cld
@@lp:
		cmp	bx,cs:ComLineLength
		jae	@@EndLine		;   ப ?

		mov     al,[bx]
		inc     bx
		cmp     al,' '                  ; ய᪠ ஡
		je      @@lp
		cmp     al,'/'
		je      @@EndLine1

		cmp     al,'a'
		jb      @@NoUp
		sub     al,'a'-'A'              ; Uppercase
@@NoUp:         stosb				; 襬 ᨬ
		jmp     short @@lp
@@EndLine:
		mov     al,0
		stosb                           ;   
		mov     di,cs:Buffer2
		cmp     byte ptr es:[di],0
		jmp	@@ret
@@EndLine1:
		mov     al,0
		stosb                           ;   
		mov     di,cs:Buffer2
		or	di,di			; Next Parameter present
@@ret:
		pop	es ds
		ret
ReadPar		ENDP
;-------------------------------------------------------------------------------
; ReadKey : ⠥ ࠬ   ப (室,   ReadPar)
; 頥 al =    ᯨ᪠
;		= 0 , ᫨  ࠬ
;  訡 ࠬ - ਩ 室
;-------------------------------------------------------------------------------
ReadKey         proc    near

		push	ds
		pop	es
		call    ReadPar                 ; ⠥ ࠬ  Buffer2
		jnz     @@NoEmpty
		xor     al,al                   ;  ࠬ
		ret

@@NoEmpty:      mov     si,offset ComLines
		mov     ah,1

@@1:            mov     di,Buffer2
@@lp:           lodsb
		cmp     al,0
		je      @@Ok
		scasb
		je      @@lp
@@2:            lodsb                           ; ⠥   蠡
		cmp     al,0
		jne     @@2
		inc     ah
		cmp     ah,NumKeys+1            ; ᫮ ࠬ஢ + 1
		jne     @@1
@@Error:
		call    ParamError
		mov	al,1
		call	Exit
@@Ok:
		mov     al,ah
		ret
ReadKey         endp
;-------------------------------------------------------------------------------
; ParamError : 饭  訡 ࠬ [Buffer2]
;-------------------------------------------------------------------------------
ParamError	proc near
		push	si
		lea	si,Mes_Error
		call	OutString
		mov	si,Buffer2
		call	OutString
		call	OutEoln
		lea	si,Mes_MicroHelp
		call	OutString
		pop	si
		ret
ParamError      endp
;-------------------------------------------------------------------------------
; ReadSubPar :  ப [Buffer2]  '....=....' 뤥
;	       ப ᫥ '='  [Buffer1]; si -> Buffer1
;-------------------------------------------------------------------------------
ReadSubPar      proc    near

		mov     si,Buffer2
		mov     di,Buffer1
@@lp:
		lodsb
		cmp     al,0
		je      @@EndPar
		cmp     al,':'
		je      @@Ok
		cmp     al,'='
		jne     @@lp
@@Ok:
		lodsb
		stosb
		cmp     al,0
		jne     @@Ok
@@EndPar:
		xor	al,al
		stosb
		mov     si,Buffer1
		ret
ReadSubPar      endp
;-------------------------------------------------------------------------------
; NumPar :  ப si (ASCIIZ) 뤥 ᫮ ax
;               On = 1, Off=0, Auto=2 <Empty>=1; <᫮>P = <᫮> or 80h
;		$<᫮> = 16-筮 ᫮
;               Rus= 0, Lat=1, Alt=2
;               si -  
;-------------------------------------------------------------------------------
NumPar          proc    near

		cld
		cmp     byte ptr [si],0
		jne     @@NoEmpty
@@On:           mov     ax,1                    ;  ப - return(1)
		ret
@@NoEmpty:
		mov	dx,si

		lea     di,s_On
		mov	cx,2
		rep	cmpsb
		je      @@On                    ; ࠢ  'ON' = 1

		mov	si,dx
		lea     di,s_Off
		mov	cx,3
		rep	cmpsb
		je      @@Off                   ; ࠢ  'OFF' = 0

		mov	si,dx
		lea     di,s_Rus
		mov     cx,3
		rep     cmpsb
		je      @@Off                   ; ࠢ  'RUS' = 0

		mov	si,dx
		lea     di,s_Lat
		mov     cx,3
		rep     cmpsb
		je      @@On                    ; ࠢ  'LAT' = 1

		mov	si,dx
		lea     di,s_Alt
		mov     cx,3
		rep     cmpsb
		je      @@Alt                   ; ࠢ  'ALT' = 2

		mov	si,dx
		lea     di,s_Auto
		mov     cx,4
		rep     cmpsb
		jne     @@NoChar                ; ࠢ  'AUTO' = 2

@@alt:          mov     ax,2
		ret
@@Off:          xor     ax,ax
		ret
@@NoChar:
		mov	si,dx
		xor     ax,ax
		mov	cx,10			; radix
		cmp	byte ptr ds:[si],'$'
		jne	@@no16
		mov     cx,16                   ; radix
		inc	si
@@no16:
		push	bx
		xor	bh,bh
@@next:
		mov     bl,ds:[si]
		or      bl,bl
		je      @@Exit
		cmp     bl,'0'
		jb      @@Exit
		cmp	bl,'9'
		jbe	@@o
@@16:
		cmp	cl,16
		jne	@@TestE
		cmp     bl,'F'
		ja      @@TestE
		cmp	bl,'A'
		jb	@@Exit
		sub	bl,'A'-10
		jmp	@@10

@@o:		sub     bl,'0'
@@10:		mul     cx
		add     ax,bx
		inc     si
		jmp     short @@Next
@@TestE:
		cmp     bl,'P'
		jne     @@Exit
		or      al,80h
		inc     si
@@Exit:         pop     bx
		ret
NumPar          endp

