;
;			   ------ KEYRUS ------
; 		     樨  ப
;

;-------------------------------------------------------------------------------

ComLines        equ     this byte
_color          db      'COLOR',0       ; 梥 ࠬ                    ;1
_font		db      'FONT',0        ; 䮭 䠩 		        ;2
_keys		db      'KEYS',0        ; 䠩                ;3
_scanrus        db      'SCAN',0        ;   ४祭 rus     ;4
_scanalt        db      'ALT',0         ;   ४祭 alt     ;5
_scanlat        db      'LAT',0         ; । .        ;6
_rom            db      'ROM',0         ; ⪫ ࠡ稪 Int10h   ;7
_128            db      '128',0         ; 2-  ஢           ;8
_all            db      'ALL',0         ;  ⠡ ᨬ          ;9
_russian        db      'RUSSIAN',0     ;  㬮砭 ᨬ.         ;10
_compress       db      'COMPRESS',0    ; ⨥ ᨬ               ;11
_beep           db      'BEEP',0        ; 㪮 ᨣ               ;12
_lamp           db      'LAMP',0        ; 窠  AT        ;13
_click          db      'CLICK',0       ;    .           ;14
_switch         db      'SWITCH',0      ; ᯮ짮 . ४.    ;15
_save		db      'SAVE',0        ; ࠭ 䨣  䠩 ;16
_8x8            db      '8X8',0         ; 㧨 8x8,            ;17
_8x14           db      '8X14',0        ; 㧨 8x14            ;18
_8x16           db      '8X16',0        ; 㧨 8x16            ;19
_full           db      'FULL',0        ;  ࠭ প     ;20
_intrface       db      'INTERFACE',0   ; ᠤ  2f          ;21
_base_keys      db      'BASE_KEYS',0   ; support english               ;22
_range          db      'RANGE',0       ; range ᨬ  .         ;23
_keyboard       db      'KEYBOARD',0    ; ᠤ  09          ;24
_buffer		db      'BUFFER',0      ; 让        ;25
_fast		db      'FAST',0        ;              ;26
_blank		db      'BLANK',0       ; ᨫ ࠭                ;27
		db      'EGA',0         ;  ⠭ EGA         ;28
		db      'RELEASE',0     ; release                       ;29
		db      '?',0           ; show settings                 ;30
		db      'HELP',0        ; quick help                    ;31
		db	'FILES',0	; create files			;32
_rusalt		db	'RUSALT',0	; ..  ᪮  Alt   ;33
		db	'VGA',0		; ,  VGA		;34
_modeshift	db	'MODESHIFT',0	; ६ 室   xx. ०  ;35
		db	'INT_HELP',0    ; Interface help                ;36
_8xN		db	'8XN',0		; 㧨 8xN,            ;37
		db	'NEWFONT',0	;  䮭			;38
		db	'DELETEFONT',0	; 㤠 䮭			;39
_clrscan	db	'CLRSCAN',0	; 㫥  		;40
		db	'KEY?',0	; ⠡              ;41
		db	'DELAY_INIT',0	; প ⠫樨		;42
		db	'ANYWAY',0	; 㧨   砥	;43
_8vga		db	'8VGA',0	;  VGA ᨬ .8		;44
__laptop  	db	'LAPTOP',0	; প Laptop		;45

NumKeys         equ     45
ComFlags        db      NumKeys dup (0)                 ; 䫠 ࠬ஢

;-------------------------------------------------------------------------------
; CommandLine :    ப
;-------------------------------------------------------------------------------
CommandLine     proc    near

		cld
		lea	di,ComFlags
		mov	cx,NumKeys
		xor	al,al
		rep     stosb                   ;  䫠 ࠬ஢

		xor	bx,bx
		call    ReadPar                 ;  맮 - ⠥ 1- "/"
		jne     @@loop

@@Ex:        	jmp	@@Exit
@@loop:
		call    ReadKey                 ; ⠥  (al - code)
		cmp     al,0                    ;  ப ?
		je      @@Ex

		cmp     al,1
		jne     @@No_1
;---------------------------------------- 1. /COLOR=col[,altol]
		mov	ComFlags+0,1
		call	ReadSubPar
		call    NumPar                  ; 뤥塞 col
		mov	ColorBorder,al

		cmp     byte ptr ds:[si],','    ;  2- 梥 ?
		jne     @@End_1
		inc     si
		call    NumPar                  ; 뤥塞 altcol
		mov     AltColorBorder,al
@@End_1:        jmp     @@loop

@@No_1:         cmp     al,2
		jne     @@No_2
;---------------------------------------- 2. /FONT=file
		mov	ComFlags+1,1
		call	ReadSubPar
		call	FontFile		; ⠥ FONT-FILE
		jmp     @@loop

@@No_2:         cmp     al,3
		jne     @@No_3

;---------------------------------------- 3. /KEYS=file
		mov	ComFlags+2,1
		call	ReadSubPar
		call	KbdFile
		jmp     @@loop

@@No_3:         cmp     al,4
		jne     @@No_4
;---------------------------------------- 4. /SCAN=scancode[,shift]
		mov     ComFlags+3,1
		call	ReadSubPar
		call    NumPar                  ; ax=scan code
		mov	ScanCode,al
		cmp     byte ptr ds:[si],','    ;  2- ᫮ ?
		jne     @@End_4
		inc     si
		call    NumPar                  ; 뤥塞 shift
		mov     ScanCode+1,al
@@End_4:	jmp     @@loop

@@No_4:         cmp     al,5
		jne     @@No_5
;---------------------------------------- 5. /ALT=scancode
		mov     ComFlags+4,1
		call	ReadSubPar
		call    NumPar                  ; ax=scan code
		mov     AltCode,al
		cmp     byte ptr ds:[si],','    ;  2- ᫮ ?
		jne     @@End_5
		inc     si
		call    NumPar                  ; 뤥塞 shift
		mov     AltCode+1,al
@@End_5:	jmp     @@loop

@@No_5:         cmp     al,6
		jne     @@No_6
;---------------------------------------- 6. /LAT=scancode
		mov     ComFlags+5,1
		call	ReadSubPar
		call    NumPar                  ; ax=scan code
		mov     LatCode,al
		cmp     byte ptr ds:[si],','    ;  2- ᫮ ?
		jne     @@End_6
		inc     si
		call    NumPar                  ; 뤥塞 shift
		mov     LatCode+1,al
@@End_6:	jmp     @@loop

@@No_6:         cmp     al,7
		jne     @@No_7
;---------------------------------------- 7. /ROM
		mov     ComFlags+6,1
		mov     RangeFlag,0             ; ROM value
		jmp     @@loop

@@No_7:         cmp     al,8
		jne     @@No_8
;---------------------------------------- 8. /128
		mov     ComFlags+7,1
		mov     RangeFlag,2             ; /128 value
		mov	ComprFlag,0		; compress = off
		jmp     @@loop

@@No_8:         cmp     al,9
		jne     @@No_9
;---------------------------------------- 9. /ALL
		mov     ComFlags+8,1
		mov     RangeFlag,3             ; /ALL value
		mov	ComprFlag,0		; compress = off
		jmp     @@loop

@@No_9:         cmp     al,10
		jne     @@No_10
;---------------------------------------- 10. /RUSSIAN
		mov     ComFlags+9,1
		mov     RangeFlag,1             ; Define range value
		mov	ComprFlag,1		; compress = on
		mov	ComFlags+8,1
		mov     StChar1,80h
		mov     NChar1,48               ; ''-''
		mov	StChar2,0e0h
		mov     NChar2,22               ; ''-''
		mov     font_14,2               ; auto detect 8x14
		mov     font_16,2               ; auto detect 8x16
		jmp     @@loop

@@No_10:        cmp     al,11
		jne     @@No_11
;---------------------------------------- 11. /COMPRESS={ON|OFF}
		mov     ComFlags+10,1
		call	ReadSubPar
		call	NumPar
		mov	ComprFlag,al
		jmp     @@loop

@@No_11:        cmp     al,12
		jne     @@No_12
;---------------------------------------- 12. /BEEP={ON|OFF}[,{RUS|LAT|ALT}]
		mov     ComFlags+11,1
		call	ReadSubPar
		call	NumPar
		mov     BeepFlag,al
		cmp     byte ptr ds:[si],','    ;  2- ᫮ ?
		jne     @@End_12
		inc     si
		call    NumPar                  ; 뤥塞 rus/lat/alt (0,1,2)
		mov     WhereBeep,al
@@End_12:       jmp     @@loop

@@No_12:        cmp     al,13
		jne     @@No_13
;---------------------------------------- 13. /LAMP={ON|OFF}[,{RUS|LAT|ALT}]
		mov     ComFlags+12,1
		call	ReadSubPar
		call	NumPar
		mov     LampFlag,al
		cmp     byte ptr ds:[si],','    ;  2- ᫮ ?
		jne     @@End_13
		inc     si
		call    NumPar                  ; 뤥塞 rus/lat/alt (0,1,2)
		mov     WhereLamp,al
@@End_13:       jmp     @@loop

@@No_13:        cmp     al,14
		jne     @@No_14
;---------------------------------------- 14. /CLICK={ON|OFF}[,{RUS|LAT|ALT}]
		mov     ComFlags+13,1
		call	ReadSubPar
		call	NumPar
		mov     ClickFlag,al
		cmp     byte ptr ds:[si],','    ;  2- ᫮ ?
		jne     @@End_14
		inc     si
		call    NumPar                  ; 뤥塞 rus/lat/alt (0,1,2)
		mov     WhereClick,al
@@End_14:       jmp     @@loop

@@No_14:        cmp     al,15
		jne     @@No_15
;---------------------------------------- 15. /SWITCH={OFF|ON}|{sccode[,shift]}
		mov     ComFlags+14,1
		call	ReadSubPar
		call	NumPar
		mov     SwFlag,0
		cmp     al,0                    ; OFF
		je      @@End_15
		mov	SwFlag,1
		cmp	al,1
		je	@@End_15
		mov     SwCode,al               ; code[,shift]
		cmp     byte ptr ds:[si],','    ;  shift
		jne     @@End_15
		inc     si
		call    NumPar
		mov     SwShift,al
@@End_15:       jmp     @@loop

@@No_15:        cmp     al,16
		jne     @@No_16
;---------------------------------------- 16. /SAVE
		mov     ComFlags+15,1
		call    SaveMyself              ; save and exit

@@No_16:        cmp     al,17
		jne     @@No_17
;---------------------------------------- 16. /8x8={OFF|ON}
		mov     ComFlags+16,1
		call	ReadSubPar
		call	NumPar
		mov	font_8,al
		jmp     @@loop

@@No_17:        cmp     al,18
		jne     @@No_18
;---------------------------------------- 18. /8x14={OFF|ON|AUTO}
		mov     ComFlags+17,1
		call	ReadSubPar
		call	NumPar
		mov     font_14,al
		jmp     @@loop

@@No_18:        cmp     al,19
		jne     @@No_19
;---------------------------------------- 19. /8x16={OFF|ON|AUTO}
		mov     ComFlags+18,1
		call	ReadSubPar
		call	NumPar
		mov     font_16,al
		jmp     @@loop

@@No_19:        cmp     al,20
		jne     @@No_20
;---------------------------------------- 20. /FULL
		mov     ComFlags+19,1
		mov     font_8,1
		mov     font_14,1               ; all fonts: 8x8,8x14,8x16
		mov     font_16,1
		mov     ComprFlag,0             ; not compress
		mov     RangeFlag,3             ; /all value
		jmp     @@loop

@@No_20:        cmp     al,21
		jne     @@No_21
;---------------------------------------- 21. /INTERFACE={ON|OFF}
		mov     ComFlags+20,1
		call	ReadSubPar
		call	NumPar
		mov	IntFlag,al
		jmp     @@loop

@@No_21:        cmp     al,22
		jne     @@No_22
;---------------------------------------- 22. /BASE_KEYS={ON|OFF}
		mov     ComFlags+21,1
		call	ReadSubPar
		call	NumPar
		mov     BaseFlag,al
		jmp     @@loop

@@No_22:        cmp     al,23
		jne     @@No_23
;---------------------------------------- 23. /RANGE=st1-en1,st2-en2
		mov     ComFlags+22,1
		call	ReadSubPar
		call	NumPar
		cmp     al,1
		je      @@RanErr
		mov     RangeFlag,1                     ; define value
		mov     StChar1,al                      ; start char 1
		cmp     byte ptr ds:[si],'-'            ; test on '-'
		jne     @@RanErr
		inc     si
		call    NumPar                          ; end char 1
		cmp     al,1
		je      @@RanErr
		sub	al,StChar1
		jb      @@RanErr
		inc     al                              ; num chars 1
		mov	NChar1,al
		cmp     byte ptr ds:[si],','            ; test on ','
		jne     @@RanErr
		inc     si
		call	NumPar
		cmp     al,1
		je      @@RanErr
		mov     StChar2,al                      ; start char 2
		cmp     byte ptr ds:[si],'-'            ; test on '-'
		jne     @@RanErr
		inc     si
		call	NumPar
		cmp     al,1
		je      @@RanErr
		sub	al,StChar2
		jb      @@RanErr
		inc     al                              ; num chars 2
		mov	NChar2,al
		jmp     @@loop
@@RanErr:                                               ; error in range
		call	ParamError
		mov	al,1
		call	Exit

@@No_23:        cmp     al,24
		jne     @@No_24
;---------------------------------------- 24. /KEYBOARD={ON|OFF}
		mov     ComFlags+23,1
		call	ReadSubPar
		call	NumPar
		mov     KeybFlag,al
		jmp     @@loop

@@No_24:        cmp     al,25
		jne     @@No_25
;---------------------------------------- 25. /BUFFER
		mov     ComFlags+24,1
		call	ReadSubPar
		call	NumPar
		mov	KeyBufferFlag,al
		jmp     @@loop

@@No_25:        cmp     al,26
		jne     @@No_26
;---------------------------------------- 26. /FAST[={OFF|ON}[,rate[,delay]]]
		mov     ComFlags+25,1
		call	ReadSubPar
		call	NumPar
		mov	KeyFastFlag,al

		cmp	byte ptr ds:[si],','
		jne	@@End_26
		inc	si
		call	NumPar
		mov	ah,1fh
		and     al,ah
		not	ah
		and	KeyRate,ah		; clear bits 1fh
		or	KeyRate,al
		cmp     byte ptr ds:[si],','
		jne     @@End_26
		inc     si
		call    NumPar
		mov     cl,5
		shl     al,cl
		mov	ah,1fh
		and	KeyRate,ah		; clear bits 0e0h
		or	KeyRate,al
@@End_26:
		jmp     @@loop

@@No_26:        cmp     al,27
		jne     @@No_27
;---------------------------------------- 27. /BLANK={OFF|ON}[,time_min[,{OFF|ON}[,{OFF|ON}]]]
;-------------------------------------------- 1st {OFF|ON} - mouse; 2nd {OFF|ON} - scr. output

		mov     ComFlags+26,1
		call	ReadSubPar
		call	NumPar
		mov	BlankFlag,al
		cmp	byte ptr ds:[si],','
		jne	@@End_27
		inc	si
		call	NumPar
		cmp     al,50
		ja      @@Next26
		mov     BlankTime,al            ; ६  
@@Next26:	cmp	byte ptr ds:[si],','
		jne	@@End_27
		inc	si
		call	NumPar			; Get Mouse State
		mov	MouseFlag,al
		cmp	byte ptr ds:[si],','
		jne	@@End_27
		inc	si
		call	NumPar			; Get Screen Output State
		mov	ScrOutpFlag,al

@@End_27:       jmp     @@loop

@@No_27:        cmp     al,28
		jne     @@No_28
;---------------------------------------- 28. /EGA
		mov     ComFlags+27,1
		and     Adapter,11111100b       ; Clear EGA, VGA bits
		or      Adapter,00000001b       ; Set EGA bit
		jmp     @@loop

@@No_28:	cmp	al,29
		jne	@@No_29
;---------------------------------------- 29. /RELEASE
		mov	ComFlags+28,1
		call	Release

@@No_29:	cmp	al,30
		jne	@@No_30
;---------------------------------------- 30. /?
		mov	ComFlags+29,1
		call	OptHelp

@@No_30:	cmp	al,31
		jne	@@No_31
;---------------------------------------- 31. /HELP[:RUS]
		mov	ComFlags+30,1
		call	ReadSubPar
		call	NumPar
		mov	dx,EnglishHelp
		cmp	al,0
		jne	@@help
		mov	dx,RussianHelp
@@help:		call	QuickHelp

@@No_31:        cmp	al,32
		jne	@@No_32
;---------------------------------------- 32. /FILES
		mov	ComFlags+31,1
		call	CreateFiles

@@No_32:	cmp	al,33
		jne	@@No_33
;---------------------------------------- 33. /RUSALT={ON|OFF}
		mov	ComFlags+32,1
		call	ReadSubPar
		call	NumPar
		cmp	AltCode,0		;  .  ?
		je	@@End_33
		mov	RusAltFlag,al
@@End_33:	jmp	@@loop

@@No_33:	cmp	al,34
		jne	@@No_34
;---------------------------------------- 34. /VGA
		mov     ComFlags+33,1
		and     Adapter,11111100b       ; Clear EGA, VGA bits
		or      Adapter,00000010b       ; Set VGA bit
		jmp     @@loop

@@No_34:	cmp	al,35
		jne	@@No_35
;---------------------------------------- 35. /MODESHIFT={OFF|<scancode>}[,mode]
		mov     ComFlags+34,1
		call	ReadSubPar
		call    NumPar                  ; ax=scan code
		mov	ModeShiftKey,al
		cmp	byte ptr ds:[si],','
		jne	@@NoShiftMode
		inc	si
		call	NumPar
		mov	ModeShiftMode,al
@@NoShiftMode:
		jmp     @@loop

@@No_35:	cmp	al,36
		jne	@@No_36
;---------------------------------------- 36. /INT_HELP
		mov     ComFlags+35,1
		mov	dx,Int_Help
		call	QuickHelp

@@No_36:	cmp	al,37
		jne	@@No_37
;---------------------------------------- 37. /8XN=<size>,{OFF|ON|AUTO}
		push	cx bx
		mov     ComFlags+36,1
		call	ReadSubPar
		call	NumPar
		push	si
		mov	bl,al			; bl - font size
		lea	si,FontTable
		lodsw
		mov	cx,ax			; cx - ᫮ 䮭⮢
@@flp:
		cmp	[si],bl
		je	@@FindFont

		mov	si,[si+4]		; 騩 䮭
		loop	@@flp
@@fxerr:
		call	ParamError
		mov	al,1
		call	Exit
@@findfont:
		mov	bx,si
		pop	si
		push	bx			; Save addr. font
		cmp	byte ptr ds:[si],','
		jne	@@fxerr
		inc	si
		call	NumPar
		cmp	al,2
		ja	@@fxerr
		pop	bx

		mov	[bx+6],al
		pop	bx cx
		jmp     @@loop

@@No_37:	cmp	al,38
		je	@@_38
		jmp	@@No_38
;---------------------------------------- 38. /NEWFONT=<size>,<load>,<grload>,<addrfun>
@@_38:		mov     ComFlags+37,1
		call	ReadSubPar
		call	NumPar
		mov	NfSize,al
		cmp	byte ptr ds:[si],','
		jne	@@fxerr
		inc	si
		call	NumPar
		mov	NfLoadFun,al
		cmp	byte ptr ds:[si],','
		jne	@@fxerr
		inc	si
		call	NumPar
		mov	NFGraphFun,al
		cmp	byte ptr ds:[si],','
		jne	@@fxerr
		inc	si
		call	NumPar
		mov	NFAddrFun,al
@@38ok:
		cmp	NFSize,32		; size<=32, >4
		ja	@@fxerr
		cmp	NfSize,4
		jbe	@@fxerr

		mov	bl,NfSize

		lea	si,FontTable
		lodsw
		mov	cx,ax			; cx - ᫮ 䮭⮢
@@flp1:
		cmp	[si],bl
		je	@@FF38

		mov	si,[si+4]		; 騩 䮭
		loop	@@flp1

		mov	ah,NfSize
		xor	al,al
		mov	NFFSize,ax
		add	ax,7
		mov	bx,EndProgram
		add	EndProgram,ax
		mov	al,NfSize
		mov	byte ptr [bx+0],al
		mov	al,nfLoadFun
		mov	byte ptr [bx+1],al
		mov	al,nfGraphFun
		mov	byte ptr [bx+2],al
		mov	al,nfAddrFun
		mov	byte ptr [bx+3],al
		mov	ax,Nffsize
		add	ax,7
		add	ax,bx
		mov	word ptr [bx+4],ax
		mov	byte ptr [bx+6],0

		inc	NumberFonts
		lea	si,Mes_NewFont
		call	OutString
		call	SaveMySelf

@@Ff38:		lea	si,Mes_AlreadyNewFont
		call	OutString
		mov	al,1
		call	Exit

@@No_38:	cmp	al,39
		jne	@@No_39
;---------------------------------------- 39. /DELETEFONT
		mov     ComFlags+38,1
		cmp	NumberFonts,1
		jbe	@@err39
		dec	NumberFonts
		call	CalculateEndProgram
		lea	si,Mes_DelFont
		call	OutString
		call	SaveMySelf
@@err39:
		lea	si,Mes_NoDelFont
		call	OutString
		mov	al,1
		call	Exit

@@No_39:	cmp	al,40
		jne	@@No_40
;---------------------------------------- 40. /CLRSCAN=OFF|ON
		mov     ComFlags+39,1
		call	ReadSubPar
		call	NumPar
		mov	ClrScanFlag,al
		jmp	@@loop

@@No_40:	cmp	al,41
		jne	@@No_41
;---------------------------------------- 41. /KEY?
		mov	ComFlags+40,1
		mov	dx,ScanTable
		call	QuickHelp

@@No_41:	cmp	al,42
		jne	@@No_42
;---------------------------------------- 42. /DELAY_INIT
		mov	ComFlags+41,1
		jmp	@@loop

@@No_42:
		cmp	al,43
		jne	@@No_43
;---------------------------------------- 43. /ANYWAY
		mov	ComFlags+42,1
		jmp	@@loop
@@No_43:
		cmp	al,44
		jne	@@No_44
;---------------------------------------- 44. /8VGA=ON|OFF
		mov	ComFlags+43,1
		call	ReadSubPar
		call	NumPar
		mov	VGA8,al
		jmp	@@loop
@@No_44:
		cmp	al,45
		jne	@@No_45
;---------------------------------------- 45. /LAPTOP=ON|OFF
		mov	ComFlags+44,1
		call	ReadSubPar
		call	NumPar
		mov	Laptop,al
		jmp	@@loop
@@No_45:
@@Exit:
		ret
CommandLine     endp

;------------------------------------------------------------------------------
NFSize		db	0
NFLoadFun	db	0
NFGraphFun	db	0
NFAddrFun	db	0
NFFSize		dw	0
Mes_NewFont		db	'Space for new font reserved',cr,lf,0
Mes_AlreadyNewFont	db	7,'This font already installed',cr,lf,0
Mes_DelFont		db	'Last installed font deleted',cr,lf,0
Mes_NoDelFont		db	7,'Can''t delete last font',cr,lf,0
