;
;			   ------ KEYRUS ------
; 	              १⭮ 
;

;-------------------------------------------------------------------------------
; TryResidentChange : ⪠  KEYRUS  
;-------------------------------------------------------------------------------

TryResidentChange	proc	near

		lea	dx,@@Mes_Already		; write 'Already installled'
		mov	ah,9
		int	21h

		mov	ax,4100h
		int	16h				; Keyrus Test

		cmp	ax,0AAAAh
		jne	@@other
		cmp	cx,'KR'
		jne	@@other
		cmp	bh,CurVerHi
		jne	@@other
		cmp	bl,CurverLo
		je	@@OkVersion
@@other:
		lea	dx,@@Mes_Version
		mov	ah,9
		int	21h
		jmp	@@Exit
@@OkVersion:
		mov	es,dx
		mov	di,es:KeyboardBlockData

		test	di,8000h
		je	@@noDelay
		and	di,not 8000h
		mov	es:KeyboardBlockData,di
		call	DelayInstall9

@@NoDelay:	or	di,di
		jne	@@okkeys
		jmp	@@nokeys
@@okkeys:	cmp	ComFlags+0,1
		jne	@@NoBorder
		mov	al,ColorBorder
		mov	es:Color[di],al
		mov	al,AltColorBorder
		mov	es:AltColor[di],al
		lea	si,@@Mes_Border
		call	OutString
@@Noborder:
		cmp	ComFlags+3,1
		jne	@@NoScan
		mov	ax,word ptr ScanCode
		mov	es:Scan_cod[di],ax
		lea	si,@@Mes_Scan
		call	OutString
@@noscan:
		cmp	ComFlags+4,1
		jne	@@NoAlt
		cmp	byte ptr es:AlterCode[di],0
		je	@@NoAlt
		mov	ax,word ptr AltCode
		mov	es:AlterCode[di],ax
		lea	si,@@Mes_Alt
		call	outString
@@noAlt:
		cmp	ComFlags+5,1
		jne	@@NoLat
		mov	ax,word ptr LatCode
		or	al,al
		je	@@noLat
		mov	es:Resetcode[di],ax
		lea	si,@@Mes_Lat
		call	OutString
@@noLat:
		cmp	ComFlags+14,1
		jne	@@NoSwitch
		mov	bl,SwCode
		mov	bh,SwShift
		mov	es:CodeSw[di],bl
		mov	es:ShiftSw[di],bh
		lea	si,@@Mes_Switch
		call	OutString
@@noSwitch:
		cmp	ComFlags+21,1
		jne	@@nobase
		test	Status,8
		jne	@@nobase
		and	es:Status,11110111b
		lea	si,@@Mes_Base
		call	OutString
@@nobase:
		cmp	ComFlags+2,1
		jne	@@noKeys

		push	di
		mov	cx,es:KeybMatrixLen[di]
		add	di,KeybMatrix
		cld
		lea	si,kbd1
		rep	movsb
		pop	di
		lea	si,@@mes_keys
		call	OutString
@@noKeys:
		cmp	ComFlags+1,1
		jne	@@noFont

		push	di
		mov	di,es:VideoBlockData
		or	di,di
		je	@@exf
		cmp	byte ptr es:Compress[di],0
		jne	@@exf

		call	ChangeFonts

		lea	si,@@mes_font
		call	OutString
@@exf:
		pop	di
@@noFont:
		cmp	ComFlags+34,1
		jne	@@nomodeshift
		mov	al,ModeShiftKey
		mov	es:ShiftScan[di],al
		mov	al,ModeShiftMode
		mov	es:ShiftMode[di],al

		lea	si,@@mes_modeshift
		call	OutString

@@nomodeshift:

@@Exit:
 		ret
;-------------------------------------------------------------------------------
; ChangeFonts : Change fonts (di = Video block data)
;-------------------------------------------------------------------------------
ChangeFonts	proc	near

		cld
		mov	cx,es:NumFonts[di]		; number fonts in resid. part
		mov	bx,Fonts
@@lp:
		push	cx
		mov	al,es:[di+bx+0]			; font size
		call	SrchFont			; -> si = Addr. font or =0
		or	si,si
		je	@@no

		cmp	word ptr es:[di+bx+6],0		; 2 ranges ?
		jne	@@2
@@1:
		mov	ax,es:NumChars[di]
		mov	cl,es:[di+bx]
		xor	ch,ch				; cx - font size
		mul	cx
		mov	cx,ax				; cx - num bytes.

		mov	ax,es:BeginChar[di]
		mov	dl,es:[di+bx]
		xor	dh,dh
		mul	dx
		mov	dx,ax				; dx - offs.

		add	si,dx

		push	di
		mov	di,es:[di+bx+4]
		rep	movsb
		pop	di
		jmp	@@no
@@2:
		mov	al,es:NumChars[di]
		mul	byte ptr es:[di+bx]
		mov	cx,ax				; cx - num bytes. (1)

		mov	al,es:BeginChar[di]
		mul	byte ptr es:[di+bx]
		mov	dx,ax				; dx - offs. (1)

		push	si
		add	si,dx

		push	di
		mov	di,es:[di+bx+4]
		rep	movsb
		pop	di
		pop	si

		mov	al,es:NumChars+1[di]
		mul	byte ptr es:[di+bx]
		mov	cx,ax				; cx - num bytes. (2)

		mov	al,es:BeginChar+1[di]
		mul	byte ptr es:[di+bx]
		mov	dx,ax				; dx - offs. (2)

		add	si,dx

		push	di
		mov	di,es:[di+bx+6]
		rep	movsb
		pop	di
@@no:
		pop	cx
		add	bx,8
		loop	@@lp

		mov	al,es:Status
		xor	al,4
		mov	es:Status,al

		mov	ax,4101h
		int	16h				; bl - Status

		xor	bl,4

		mov	ax,4102h
		int	16h				; set status

		ret
ChangeFonts	endp
;-------------------------------------------------------------------------------
; SearchFont : al=font size -> si = Addr.
;-------------------------------------------------------------------------------
SrchFont	proc	near
		push	ax cx dx

		mov	dl,al
		cld
		lea	si,FontTable
		lodsw
		mov	cx,ax			; num fonts
@@l:
		cmp	dl,[si]
		je	@@ok
		mov	si,[si+4]
		loop	@@l
		xor	si,si
		jmp	@@r

@@ok:		add	si,7
@@r:
		pop	dx cx ax
		ret
SrchFont	endp
;-------------------------------------------------------------------------------
@@Mes_Already	db	'Already installed',cr,lf
		db	'Changes to resident module:',cr,lf,eom
@@Mes_Version	db	7,' - Warning! I can''t Change configuration',cr,lf,eom

@@Mes_Border	db	'/Color',cr,lf,0
@@mes_Scan	db	'/Scan',cr,lf,0
@@mes_Alt	db	'/Alt',cr,lf,0
@@mes_Lat	db	'/Lat',cr,lf,0
@@mes_Switch	db	'/Switch (key code)',cr,lf,0
@@mes_Base	db	'/Base_Keys disabled',cr,lf,0
@@mes_keys	db	'/Keys',cr,lf,0
@@mes_font	db	'/Font',cr,lf,0
@@mes_modeshift	db	'/ModeShift',cr,lf,0

TryResidentChange	endp
;-------------------------------------------------------------------------------
; DelayInstall9 : ⠫ ࠡ稪 
; es:di - KeyboardBlockData
;-------------------------------------------------------------------------------
DelayInstall9	proc	near
		push	di ds
		or	di,di
		je	@@rt

		push	es
		pop	ds

		mov	ax,3509h
		int	21h			; Get Int9 handler -> es:bx

		mov	di,KeyboardBlockData
		mov	di,Int09h[di]		; ds:di - My handler

		push	di
		push	di
		add	di,offset Ofs_09a - offset Int_09h_Entry
		mov	[di],bx
		mov	[di+2],es
		pop	di
		add	di,offset Ofs_09h - offset Int_09h_Entry
		mov	[di],bx
		mov	[di+2],es
		pop	dx
		mov	ax,2509h
		int	21h			; Set Int09h

@@rt:		pop	ds 
		lea	si,@@mes_delay
		call	OutString
		pop	di
		ret

@@mes_delay	db	'Keyboard driver installed',cr,lf,0

DelayInstall9	endp
