;
;			   ------ KEYRUS ------
; 	         ஥ १⭮   
;

;-------------------------------------------------------------------------------
; BuildInMemory : ⮥ १⭮   ; es = OldProgram
;-------------------------------------------------------------------------------
BuildInMemory	proc	near

		call	TryMoveDown		;  es, ᫨ 
		call	BuildProgram		; ந ⠫쭮
		ret
BuildInMemory	endp
;-------------------------------------------------------------------------------
BuildProgram : ந ணࠬ  
;-------------------------------------------------------------------------------
BuildProgram	proc	near
						;  ᭮ ६
		cld
		mov	es:Status,00000101b	; lat & enable loading
		mov	es:BiosSeg,40h
		mov	es:Int08h,0
		mov	es:Int16h,0
		mov	es:VideoBlockData,0
		mov	es:KeyboardBlockData,0
		mov	es:KeyrLabel1,'KR'
		mov	es:KeyrLabel2,'GR'	; Fill Keyrus Label

		lea	si,Dummy
		call	MoveBlock		; ६饭  si
		mov	AddrDummy,si

		lea	ax,Dummy
		push	es di
		push	cs
		pop	es
		lea	di,ProAddr
		mov	cx,NumAdr
		cld
		rep	stosw			;    Dummy
		pop	di es


		cmp	KeybFlag,0
		je	@@NoKeyboard

		call	BuildKeyboardBlock
@@NoKeyboard:
		call	TestVideoBlock
		jne	@@NoVideo
		call	BuildVideoBlock
@@NoVideo:
		cmp	KeybFlag,0
		je	@@nokbd
		test	Adapter,80h
		jne	@@ok16     		; use Keyboard & Bad Keyboard
@@noKbd:
		cmp	IntFlag,0        	; or use Interface
		je	@@no16
@@ok16:
		call	BuildInt16hBlock
@@no16:
		ret
BuildProgram	endp
;-------------------------------------------------------------------------------
; BuildKeyboardBlock :   
;-------------------------------------------------------------------------------
BuildKeyboardBlock	proc	near

		lea	si,KeyboardData
		call	MoveBlock		; 砥   
		mov	es:KeyboardBlockData,si
		mov	di,si			; di -> Keyboard Data
						;  ६  
		mov	ax,word ptr ScanCode
		mov	es:Scan_Cod[di],ax	;  ४.  
		mov	ax,word ptr LatCode
		or	al,al
		jne	@@1
		mov	ax,word ptr ScanCode    ; ᫨ /Lat=off, latkey=ruskey
@@1:		mov	es:ResetCode[di],ax	;  ४.  
		mov	ax,word ptr AltCode
		mov	es:AlterCode[di],ax	;  3- 
		mov	al,ColorBorder
		mov	es:Color[di],al		; 뢠 梥 ࠬ
		mov	al,AltColorBorder
		mov 	es:AltColor[di],al	; ୠ⨢ 梥 ࠬ
		mov	al,SwCode
		mov	es:CodeSw[di],al	;   Alt-tab
		mov	al,SwShift
		mov	es:ShiftSw[di],al 	; shift  Alt-tab
		mov	al,ModeShiftKey
		mov	es:ShiftScan[di],al
		mov	al,ModeShiftMode
		mov	es:ShiftMode[di],al
		mov	byte ptr es:RetShiftMode[di],0ffh
		mov	al,BaseFlag
		or	al,al
		je	@@2
		or	es:Status,00001000b	; english keyboard support
@@2:						;   
		lea	si,kbd1
		mov	cx,212
		cmp	BaseFlag,0		;   
		je	@@NoBase
		mov	cx,318+53		; + Alt 
		jmp	short @@AddKeyb
@@NoBase:	cmp	AltCode,0		; ୠ⨢  
		jne	@@AddKeyb
		cmp	RusAltFlag,0
		jne	@@AddKeyb
@@NoAltK:	shr	cx,1			; ᫨ AltCode=0, ⮫쪮 .
@@AddKeyb:
		mov	es:KeybMatrixLen[di],cx
		call	MoveBlock_CX		; 뫪 

		cmp	ClrScanFlag,0
		jne	@@needclear
		mov	ZeroScan1,9090h
		mov	ZeroScan2,9090h
@@needclear:

;	ࠡ稪 Int 09h ᯮ ᫥騥 ணࠬ
;		[EndHandler9]     : 砭
;		[DisableKeyboard] :  
;		[TranslateCode]   : ࠭ 
;		[AltRusTest]      :  ९  ᪮ ०  Alt
;		[SetReset]        :  ० 
;		[KeySound] 	  : ᯥ祭 /Click
;		[BlankScreen]     : 襭 ࠭
; 		[PrSwitch]        : /몫 䮭 (᫨  )
;		[ModeShiftTest]   : Mode Shift

; ------------- 祭 [_EndHandler9] = {EndHandler9}
; ᯮ    [_EnableKeyboard] : 襭 
;	------- 祭 [_EnableKeyboard] = {Dummy|EnableKeyboard}

		lea	si,Dummy
		test	Adapter,00100000b
		je	@@En0

		lea	si,KeyWaitReady
		mov	_KeyWaitReady,si
		call	MoveBlock		; 稫 KeytWaitReady
		lea	si,EnableKeyboard
@@En0:		mov	_EnableKeyboard,si
		call	MoveBlock		; 稫 EnableKeyboard

		lea	si,EndHandler9
		mov	_EndHandler9,si
		call	MoveBlock		; 稫 EndHandler9

; ------------- 祭 [_DisableKeyboard] = {Dummy|DisableKeyboard}
		lea	si,Dummy
		test	Adapter,00100000b
		je	@@Ds0
						; KeyWaitReady 㦥 祭
		lea	si,DisableKeyboard
@@Ds0:		mov	_DisableKeyboard,si
		call	MoveBlock		; 稫

; ------------- 祭 [TranslateCode] = {WithoutEnglish|WithEnglish}
; ᯮ    [AdrRightKeyTest] :    '[];',./'
;	------- 祭 [AdrRightKeyTest] = RightKeyTest

		lea	si,RightKeyTest
		mov	AdrRightKeyTest,si
		call	MoveBlock		; 稫
						; 롮 [TranslateCode]
		lea	si,WithoutEnglish
		cmp	BaseFlag,0
		je	@@3
		lea	si,WithEnglish
@@3:		mov	TranslateCode,si
		call	MoveBlock		; 稫

; ------------- 祭 [AltRusTest] = {AltTest|Dummy}
; ᯮ    [AdrRightKeyTest] :    '[];',./' (㦥 祭)

		lea	si,Dummy
		cmp	RusAltFlag,0
		je	@@4
		lea	si,AltTest
@@4:		mov	AltRusTest,si
		call	MoveBlock		; 稫

		call	AddSetReset		; 祭  SetReset

; ------------- 祭 [_ModeShiftTest] = {ModeShiftTest|Dummy}
; ᯮ    [SetReset] : (already connected)

		lea	si,Dummy
		cmp	ModeShiftKey,0
		je	@@44
		lea	si,ModeShiftTest
@@44:		mov	_ModeShiftTest,si
		call	MoveBlock		; 稫

; ------------- 祭 [KeySound] = {KeyClick|Dummy}
; ᯮ    [Sound] :  㪠

		lea	si,Dummy
		cmp	ClickFlag,0
		je	@@AddClick
		lea	si,KeyClick
		mov	al,WhereClick
		mov	ClickOn,al
		push	si
;	    --- 祭 [Sound] = SoundGen
		lea	si,SoundGen		; ᫨ Sound 祭, 祣 譮
		mov	Sound,si
		call	MoveBlock		; 稫 Sound
		pop	si
@@AddClick:	mov	KeySound,si
		call	MoveBlock		; 稫

		call	BuildBlankBlock		;   襭 ࠭

; ------------- 祭 [PrSwitch] = {SwitchLoad|Dummy}

		lea	si,Dummy
		cmp	SwFlag,0
		je	@@AddSwitch
		call	TestVideoBlock
		jne	@@AddSwitch

		lea	si,SwitchLoad

		call	AddReloadChars
							; EndHandler9 㦥 祭
@@AddSwitch:	mov	PrSwitch,si
		call	MoveBlock

; ------------- 祭 ࠡ稪 Int 09h = KeyboardHandler

		lea	si,KeyboardHandler
		call	MoveBlock
		mov	es:Int09h[di],si
		mov	New_09h,si

		ret
BuildKeyboardBlock	endp
;-------------------------------------------------------------------------------
; AddReloadChars :  ReloadChars
;-------------------------------------------------------------------------------
AddReloadChars	proc 	near
		push	si
		call	AddCheckTextMode		;  ⨪ ०
		call	AddBorder			;  ࠬ

;	------- 祭 [_SearchFont] = SearchFont

		lea	si,SearchFont
		mov	_SearchFont,si
		call	MoveBlock

		test	Adapter,2			; VGA Test
		je	@@NoVGA
		mov	SwitchVGAMask,9090h
@@NoVGA:
		lea	si,ReloadChars
		mov	_ReloadChars,si
		call	MoveBlock

		pop	si

		ret
AddReloadChars	endp
;-------------------------------------------------------------------------------
; AddSetReset :   樨 ० [SetReset]; di->KeyboardData
;-------------------------------------------------------------------------------
AddSetReset	proc	near

; ------------- 祭 [SetReset] = {PrSetReset|Dummy}
; PrSetReset ᯮ [SetBorder] 	:  ࠬ
;			[Beep]      	: 㤮  ४祭
;			[SetLamp]	:  窮 

		xor	bx,bx			; ⥫  SetReset<>Dummy

		call	AddBorder		; 祭 SetBorder

;	------- 祭 [Beep] = {XTBeep|Dummy}
; XTBeep ᯮ [Sound] 		:  㪠

		lea	si,Dummy
		cmp	BeepFlag,0
		je	@@AddBeep
		inc	bx
		mov	al,WhereBeep
		mov	BeepOn,al
		lea	si,XTBeep

		push	si
;	    --- 祭 [Sound] = SoundGen
		lea	si,SoundGen
		mov	Sound,si
		call	MoveBlock		; 稫 Sound

		pop	si
@@AddBeep:	mov	Beep,si
		call	MoveBlock		; 稫 Beep

;	------- 祭 [SetLamp] = {KeyLamp|Dummy}

		lea	si,Dummy
		cmp	LampFlag,0
		je	@@AddLamp
		test	Adapter,00100000b
		je	@@AddLamp		;  enh. 
		inc	bx
		lea	si,KeyLamp
		mov	al,WhereLamp
		mov	LampOn,al
@@AddLamp:	mov	SetLamp,si		; KeyWaitReady 㦥 祭
		call	MoveBlock		; 稫 SetLamp

		lea	si,Dummy
		or	bx,bx			; ᯮ짮 -
		je	@@AddSetReset
		lea	si,PrSetReset
@@AddSetReset:	mov	SetReset,si
		call	MoveBlock
@@ret:
		ret
AddSetReset	endp
;-------------------------------------------------------------------------------
; AddBorder :   ⠭ ࠬ [SetBorder]; di->KeyboardData
; ᫨ ࠬ 砥, inc bx
;-------------------------------------------------------------------------------
AddBorder	proc	near
		push	si

;	------- 祭 [SetBorder] = {CGABorder|EGABorder|Dummy}

		lea	si,Dummy
		mov	al,ColorBorder
		or	al,AltColorBorder
		or	al,al
		je	@@AddBorder		; ࠬ  ᯮ
		test	Adapter,4
		jne	@@AddBorder		; ஬ ( ࠬ)
		inc	bx
		lea	si,CGABorder
		test	Adapter,11b		;   EGA/VGA
		je	@@AddBorder
		lea	si,EGABorder
@@AddBorder:	mov	SetBorder,si
		call	MoveBlock		; 稫 ࠬ
		pop	si
@@ret:
		ret
AddBorder	endp
;-------------------------------------------------------------------------------
; AddCheckTextMode :   ⨪ ०
;-------------------------------------------------------------------------------
AddCheckTextMode	proc	near

; ------------- 祭 [CheckTextMode] = {EGACGAText|VGAText}

		lea	si,EGACGAText
		test	Adapter,2
		je	@@1
		lea	si,VGAText
@@1:
		mov	CheckTextMode,si
		call	MoveBlock
@@ret:
		ret
AddCheckTextMode	endp
;-------------------------------------------------------------------------------
; BuildBlankBlock :   襭 ࠭
;-------------------------------------------------------------------------------
BuildBlankBlock		proc	near
		lea	si,Dummy
		mov	BlankScreen,si
		cmp	BlankFlag,0
		je	@@r
		test	Adapter,11b		;   EGA/VGA
		jne	@@UseBlank
@@r:		jmp	@@Ret

@@UseBlank:
; ------------- 祭 [Blank] = {EGABlank|VGABlank}
; EGABlank ᯮ SetBorder

		lea	si,VGABlank
		test	Adapter,2 		;   VGA
		jne	@@AddBlank
		lea	si,EGABlank
		call	AddBorder		;  EGA 㦭 ࠬ
@@AddBlank:	mov	Blank,si
		call	MoveBlock		; 稫

; ------------- 祭 [BlankScreen] = FixBlank
						; ᫥ MaxTime, Timer
		mov	cl,BlankTime
		xor	ch,ch
		mov	ax,1092			;   
		mul	cx			; ax - ஬⮪  ⨪
		mov	MaxTime,ax
		mov	es:Timer,ax

		lea	si,FixBlank
		mov	BlankScreen,si
		call	MoveBlock		; 稫

		call	AddCheckTextMode	;   ஫ ⥪⮢ ०

; ------------- 祭 [CheckMouse] = {MouseComp|Dummy}

		lea	si,Dummy
		cmp	MouseFlag,0
		je	@@AddMouse
		test	Adapter,01000000b	; Mouse Test
		je	@@AddMouse

		lea	si,MouseComp
		or	si,si			; zf=0
@@AddMouse:	pushf
		mov	CheckMouse,si
		call	MoveBlock
		popf				; if zf=0 then +Mouse
		je	@@NoMouse
						;  MouseDataAdr
		add	si,offset MouseData - offset MouseCompStart
		mov	es:MouseDataAdr,si
@@NoMouse:
; ------------- 祭 ࠡ稪 Int 08h

		lea	si,Int_08h_Handler
		call	MoveBlock
		mov	es:Int08h,si
		mov	New_08h,si

; ------------- 祭 [_TouchInt10h] = {Dummy|TouchInt10h}

		lea	si,Dummy
		cmp	ScrOutpFlag,0
		je	@@AddInt10h
		call	TestVideoBlock		; 㤥 祭   ?
		jne	@@AddInt10h
		lea	si,TouchInt10h
@@AddInt10h:	mov	_TouchInt10h,si
		call	MoveBlock

; ------------- 祭 [BlankFun] = {Dummy|BlankFunctions}
@@ret:
		ret
BuildBlankBlock		endp
;-------------------------------------------------------------------------------
; TestVideoBlock : 頥 zf, ᫨   㤥 祭
;-------------------------------------------------------------------------------
TestVideoBlock		proc	near

		push	ax
		cmp	RangeFlag,0		; /ROM ?
		je	@@No

		test	Adapter,3
		jne	@@Yes			; EGA/VGA -  Int10h
					;  CGA ন /128 = graphics
		cmp	RangeFlag,2		; /128 ?
		jne	@@No			;   CGA  㧨
		cmp	ComprFlag,0
		jne	@@No			; compress=on - 䨪 
		cmp	font_8,0
		je	@@No			;  䮭 8x8 ?
@@Yes:
		xor	ax,ax			; zf
		jmp	@@ret
@@No:
		mov	al,1
		or	al,al			; zf=0

@@ret:		pop	ax
		ret
TestVideoBlock		endp
;-------------------------------------------------------------------------------
; BuildVideoBlock :  
;-------------------------------------------------------------------------------
BuildVideoBlock	proc	near

		lea	si,VideoData
		call	MoveBlock
		mov	es:VideoBlockData,si
		mov	di,si			; di = VideoData

		mov	al,ComprFlag
		mov	es:Compress[di],al	; ᠫ 䫠 ᦠ

		call	AddFontTables		;   䮭⮢

;	ࠡ稪 Int 10h ᯮ ᫥騥 ணࠬ
;		[_TouchInt10h]	  :   襭 ࠭
;		[CheckTextMode]	  : ⨪ ⥪⮢ ०
;		[_CheckFonts]	  : ஢ 稥 䮭  㭪樨
;		[Old_10h_adr]	  :  Int 10h
;		[Load]		  : 㧪 ᨬ (text mode)
;		[Graph]		  : 㧪 ᨬ (graph mode)
;		[Pointer]	  :   䮭

		cmp	_TouchInt10h,0
		jne	@@1
		lea	si,Dummy
		mov	_TouchInt10h,si		; ᫨ ᨫ 砫,
						;  ⠬ 㦥  Ok
@@1:
		call	AddCheckTextMode	;  CheckTextMode

; ------------- 祭 [_CheckFonts] = CheckFonts

		lea	si,CheckFonts
		mov	_CheckFonts,si
		call	MoveBlock		; 稫

; ------------- 祭 [Old_10h_adr] = Old_10h

		lea	si,Old_10h
		mov	Old_10h_adr,si
		call	MoveBlock		; 稫
		mov	es:OldInt10h[di],si

; ------------- 祭 [Load], [Graph], [Pointer], 䮭⮢

		lea	si,Dummy
		mov	Graph,si
		mov	Pointer,si
		mov	Load,si			; ⠭   Dummy

		cmp	RangeFlag,1
		je	@@Range
		cmp	RangeFlag,2
		je	@@128
						; 䨣 256 ᨬ
		call	CodeTable_256
		jmp	@@EndCodeTable
@@128:	                        		; 䨣 128 ᨬ
		call	CodeTable_128
		jmp	@@EndCodeTable
@@Range:					; 䨣 2 ஬⪮
		call	CodeTable_Range
@@EndCodeTable:
		lea	si,VideoHandler
		call	MoveBlock		;  ࠡ稪 Int 10h
		mov	New_10h,si

		call	AddFonts		;  䮭
		ret
BuildVideoBlock	endp
;-------------------------------------------------------------------------------
; AddFontTables :   䮭⮢; di -> VideoData
;-------------------------------------------------------------------------------
AddFontTables	proc	near

		mov	word ptr es:NumFonts[di],0

		lea	si,FontTable
		lodsw
		mov	cx,ax			; cx - ᫮ 䮭⮢
		xor	bx,bx			; bx - ᬥ饭  Fonts
@@lp:
		mov	al,[si]			; al - ࠧ ᨬ
		cmp	al,8
		je	@@1
		test	Adapter,3
		je	@@endloop		;  CGA ⮫쪮 8x8
@@1:
		cmp	byte ptr [si+6],0	; [si+6] - 䫠
		je	@@EndLoop
		cmp	byte ptr [si+6],1
		jne	@@NoON
		test	Adapter,2		; VGA Test
		jne	@@2			;  VGA On=On
		cmp	al,14
		jbe	@@2			;  EGA  䮭⮢ <=14 : On=On
		jmp	@@Auto			;   ࠢ Auto

@@NoOn:		cmp	byte ptr [si+6],2
		jne	@@endloop		; 䫠  0,1,2 -  ।
@@Auto:		cmp	al,ScanLines		; ࠡ⪠ Auto
		jne	@@EndLoop
@@2:						;  䮭
		add	LastAddr,8		; १ࢨ㥬 8 

		inc	word ptr es:NumFonts[di]
		mov	es:Fonts[di+bx+0],al	; 뢠 ࠧ 䮭
		mov	al,[si+1]		; 㭪  㧪
		mov	es:Fonts[di+bx+1],al
		mov	al,[si+2]		; 㭪  . 㧪
		mov	es:Fonts[di+bx+2],al
		mov	al,[si+3]		; 㭪  䮭
		mov	es:Fonts[di+bx+3],al
		mov	dx,si
		add	dx,7
		mov	es:Fonts[di+bx+4],dx	; ६  ࠭  䮭
		add	bx,8			; bx -  ᫥騩 䮭

@@endloop:	mov	si,[si+4]		; 騩 䮭
		loop	@@lp

		ret
AddFontTables	endp
;-------------------------------------------------------------------------------
; AddForLoad : 祭 /  Load (_SearchFont,LoadChar,SetBorder)
;-------------------------------------------------------------------------------
AddForLoad	proc	near

; ------------- 祭 [_SearchFont] = SearchFont

		lea	si,SearchFont
		mov	_SearchFont,si
		call	MoveBlock		; 稫

; ------------- 祭 [_F11] = {ComprLoad|Old_10h}

		lea	si,Old_10h
		cmp	ComprFlag,0
		je	@@AddF11
		lea	si,ComprLoad
@@AddF11:	mov	_F11,si
		mov	LoadChar,si
		call	MoveBlock
		mov	es:LdChar,si

; ------------- 祭 [_VGA8]    = {SetVGA8|Dummy}

		lea	si,Dummy
		cmp	VGA8,0
		je	@@AddVGA8
		test	Adapter,2
		je	@@AddVGA8
		lea	si,SetVGA8
@@AddVGA8:	mov	_VGA8,si
		call	MoveBlock

; ------------- 祭 [_Laptop]    = {SetLaptop|Dummy}

		lea	si,Dummy
		cmp	Laptop,0
		je	@@AddLaptop
		lea	si,SetLaptop
@@AddLaptop:	mov	_Laptop,si
		call	MoveBlock


; ------------- 祭 [LoadChar] = LoadFun

		lea	si,LoadFun
		mov	LoadChar,si
		call	MoveBlock

		call	AddBorder		; 祭 Border

		ret
AddForLoad	endp
;-------------------------------------------------------------------------------
; AddFonts :  䮭; di -> VideoData (formed)
;-------------------------------------------------------------------------------
AddFonts	proc	near

		mov	cx,es:NumFonts[di]		; ᫮ 䮭⮢
		xor	bx,bx				; 饭  ⠡
@@lp:
		push	cx

		mov	si,es:Fonts[di+bx+4]		;   䮭
		mov	cl,es:Fonts[di+bx+0]
	       	xor	ch,ch				; cx - ࠧ 䮭

		cmp	RangeFlag,1
		je	@@Range2			; 2 ஬⪠

		mov	ax,es:BeginChar[di]
		mul	cx
		add	si,ax				; si -  ஬⪠
		mov	ax,es:NumChars[di]
		mul	cx
		mov	cx,ax				; cx -  
		mov	ax,LastAddr
		mov	es:Fonts[di+bx+4],ax		;   䮭
		mov	word ptr es:Fonts[di+bx+6],0
		call	MovePackedBlock			; ।  [si]  cx   㯠
		jmp	@@EndLoop
@@Range2:
		push	cx si
		mov	al,es:BeginChar[di]
		mul	cl
		add	si,ax				; si -  1 ஬⪠
		mov	al,es:NumChars[di]
		mul	cl
		mov	cx,ax
		mov	ax,LastAddr
		mov	es:Fonts[di+bx+4],ax		; ॠ  1- ஬⪠
		call	MovePackedBlock
		pop	si cx

		mov	al,es:BeginChar+1[di]
		mul	cl
		add	si,ax				; si -  2 ஬⪠
		mov	al,es:NumChars+1[di]
		mul	cl
		mov	cx,ax
		mov	ax,LastAddr
		mov	es:Fonts[di+bx+6],ax		; ॠ  2- ஬⪠
		call	MovePackedBlock
@@EndLoop:
		pop	cx
		add	bx,8				; next font
		loop	@@lp

		ret
AddFonts	endp
;-------------------------------------------------------------------------------
; CodeTable_256 : ன 䨣樨 /All;  di -> VideoData
;-------------------------------------------------------------------------------
CodeTable_256	proc	near

		call	AddForLoad

		lea	si,LoadFont_128
		mov	Load,si
		call	MoveBlock		; Load = LoadFont_128

		cmp	ComprFlag,0
		jne	@@no			;  compress 䨪  .

		lea	si,Pointer_256
		mov	Pointer,si
		call	MoveBlock		; Pointer = Pointer_256

		lea	si,Graph_256
		mov	Graph,si
		call	MoveBlock   		; Graph = Graph_256
@@No:
		mov	word ptr es:NumChars[di],256
		mov	word ptr es:BeginChar[di],0

		ret
CodeTable_256	endp
;-------------------------------------------------------------------------------
; CodeTable_128 : ன 䨣樨 /128;  di -> VideoData
;-------------------------------------------------------------------------------
CodeTable_128	proc	near

		test	Adapter,3
		je	@@Graphics			; CGA /128

		call	AddForLoad

		lea	si,LoadFont_128
		mov	Load,si
		call	MoveBlock			; Load = LoadFont_128
@@Graphics:
		cmp	byte ptr es:Fonts[di],8         ; 1- 䮭 - 8x8
		jne	@@End
		cmp	ComprFlag,0
		jne	@@End

		lea	si,Graph_128
		mov	Graph,si
		call	MoveBlock			; Graph = Graph_128
		lea	si,Pointer_128
		mov	Pointer,si
		call	MoveBlock			; Pointer = Pointer_128
@@End:
		mov	word ptr es:NumChars[di],128
		mov	word ptr es:BeginChar[di],128

		ret
CodeTable_128	endp
;-------------------------------------------------------------------------------
; CodeTable_Range : ன 䨣樨 /Range;  di -> VideoData
;-------------------------------------------------------------------------------
CodeTable_Range	proc	near

		call	AddForLoad

		lea	si,LoadFont_Rus
		mov	Load,si
		call	MoveBlock			; Load = LoadFont_Rus

		mov	al,NChar1
		mov	byte ptr es:NumChars[di],al
		mov	al,NChar2
		mov	byte ptr es:NumChars+1[di],al
		mov	al,StChar1
		mov	byte ptr es:BeginChar[di],al
		mov	al,StChar2
		mov	byte ptr es:BeginChar+1[di],al

		ret
CodeTable_Range	endp
;-------------------------------------------------------------------------------
; BuildInt16hBlock :   ࠡ⪨ Int 16h
;-------------------------------------------------------------------------------
BuildInt16hBlock	proc	near

; ------------- 祭 [_Interface] = {Interface|Dummy}

		lea	si,Dummy
		cmp	IntFlag,0
		je	@@AddInt

		lea	si,Interface
		push	si
		call	AddSetReset		; Interface ᯮ SetReset

;       ------- 祭 [BlankFun] = {Dummy|BlankFunctions}

		lea	si,Dummy
		cmp	BlankFlag,0
		je	@@AddBlank
		lea	si,BlankFunctions
@@AddBlank:	mov	BlankFun,si
		call	MoveBlock

		call	TestVideoBlock
		jne	@@1

		call	AddReloadChars
@@1:
		pop	si

@@AddInt:	mov	_Interface,si
		call	MoveBlock

; ------------- 祭 [_BadKeyboard] = {BadKeyboard|Dummy}

		lea	si,Dummy
		cmp	KeybFlag,0
		je	@@AddBad
		test	Adapter,80h
		je	@@AddBad

		lea	si,BadKeyboard
@@AddBad:	mov	_BadKeyboard,si
		call	MoveBlock

		lea	si,Int_16h_Handler	; 祭 Int 16h
		call	MoveBlock
		mov	New_16h,si
		mov	es:Int16h,si

		ret
BuildInt16hBlock	endp
;-------------------------------------------------------------------------------
