unit Screen;

interface

type PWord = ^Word;
     PByte = ^Byte;

var
    VideoSeg  :word;
    VideoSegBar :word;
    ScrSize   :word;
    LineLen   :byte;
    ELineLen  :byte absolute $40:$4A;
    ScrLines  :byte;
    EScrLines :byte absolute $40:$84;

const Attr :word =$0700;
const SBars :boolean = false;

var i    :integer;
    Key  :word;


Procedure FillWord(P :PWord; Size :word; What :word);
Procedure MoveWord(P1:PByte; P2:PWord; size :word; orw :word);

Procedure WriteText(X,Y,color,Len :word; s :string);
Procedure WriteChar(X,Y,color,Len :word; c :char);
Procedure CursorXY(X, Y :byte);
Procedure HideCursor;
Procedure ReadIt(X,Y,Color,MaxLen :word; var s :string);
Function UpperCase(s :string):string;
procedure WinFrame( x1, y1, x2, y2, WBorder, WColor : byte );
Procedure Box(Len, Lines, Color, Style :byte; var X,Y :word);
Procedure Message( s :string );
Procedure InputBox( s:string; var t :string; Len :byte);

Procedure TAt( X,Y,color :word; s :string );
Procedure NAt( X,Y,color :word; L :longInt; i :integer);
Procedure RAt( X,Y,color :word; R :real; i,j :integer);

implementation

Procedure FillWord(P :PWord; size :word; what :word);
  begin
  while size>0 do
    begin
    P^:=what;
    Dec(Size);
    Inc(P);
    end;
  end;

Procedure MoveWord(P1:PByte; P2:PWord; size :word; orw :word);
  begin
  while size>0 do
    begin
    Dec(Size);
    P2^:=Word(P1^) or orw;
    Inc(P1);
    Inc(P2);
    end;
  end;

{----------------------------------------------------------------------------}

Procedure WriteText(X,Y,color,Len :word; s :string);
  var Adr :PWord;
      i   :integer;
  begin
  Dec(X); Dec(Y);
  Adr:=Ptr(VideoSeg,y*ELineLen*2+ x*2);
  if Len <> 0 then FillWord(Adr,Len,Color shl 8);
  for i:=1 to Length(s) do
    begin
    Adr^:=Color shl 8 or byte(s[i]);
    inc(Adr);
    end;
  end;

Procedure TAt( X,Y,color :word; s :string );
  begin
  WriteText(X,Y,color,0,s);
  end;

Procedure NAt( X,Y,color :word; L :longInt; i :integer);
  var s :string;
  begin
  Str( L:i, s );
  TAt( X,Y,color, s );
  end;

Procedure RAt( X,Y,color :word; R :real; i,j :integer);
  var s :string;
  begin
  Str( R:i:j, s );
  TAt( X,Y,Color, s );
  end;


Procedure WriteChar(X,Y,color,Len :word; c :char);
  var s :string[1];
  begin
  s[0]:=#1;
  s[1]:=C;
  WriteText(X,Y,color,Len,s);
  end;

Procedure CursorXY(X, Y :byte);
  begin
    asm
    mov dh,Y
    mov dl,X
    mov bh,0
    mov ah,2
    int 10h
    end;
  end;

Procedure HideCursor;
  begin
    asm
    push es
    mov ax,40h
    mov es,ax
    mov dh,es:EScrLines
    mov dl,0
    inc dh
    inc dh
    mov bh,0
    mov ah,2
    int 10h
    pop es
    end;
  end;

Procedure ReadIt(X,Y,Color,MaxLen :word; var s :string);
  var Key :word;
  begin
  s:='';
  WriteText(X,Y,Color,MaxLen, '');
  CursorXY(X,Y);
  Key:=0;
  While  (Chr(Key)<>#13) do
    begin
    asm mov ah,00; int $16; mov Key,ax end;
    if (not (chr(Key) in [#0,#13,^H,#27])) and (Length(s)<MaxLen) then
      begin
      s:=s+Chr(Key);
      WriteChar(X+Length(s)-1,Y,Color,0,chr(Key));
      CursorXY(X+Length(s), Y);
      end
    else
      case Chr(Key) of
        ^H: if Length(s)>0 then
              begin
              Dec(s[0]);
              WriteChar(X+Length(s),Y,Color,0,' ');
              CursorXY(X+Length(s), Y);
              end;
        #27: begin
             s:='';
             HideCursor;
             exit;
             end;
        end;
    end;
  HideCursor;
  end;

Function UpperCase(s :string):string;
  var
      i   :integer;
  begin
  for i:=1 to Length(s) do S[i]:=UpCase(S[i]);
  UpperCase := s;
  end;

{****************************************************************************
 *  WinFrame : creates one of four frame types around a specified screen    *
 *             region                                                       *
 **------------------------------------------------------------------------**
 *  Input   : x1, y1  = coordinates of the upper left corner of the region  *
 *            x2, y2  = coordinates of the lower right corner of the region *
 *            WBorder  = one of the constants SIN_FR, DBL_FR etc.           *
 *            WColor   = color or attribute for the frame character         *
 *  Globals : none                                                          *
 ***************************************************************************}

function WinStRep( Character : char; Amount : byte ) : string;
var StrepString : String;                    { the String is assembled here }
begin
  StrepString[0] := chr( Amount );
  FillChar( StrepString[1], Amount, Character );
  WinStRep := StrepString;
end;

procedure WinFrame( x1, y1, x2, y2, WBorder, WColor : byte );
type RStruc = record                  { describes the characters of a frame }
                UpperLeft,
                UpperRight,
                LowerLeft,
                LowerRight,
                Vertical,
                Horizontal  : char;
              end;
const RCharacter : array[1..4] of RStruc =       { the possible frame types }
       (
        ( UpperLeft  : ''; UpperRight  : ''; LowerLeft  : '';
          LowerRight : '';  Vertical   : ''; Horizontal : '' ),
        ( UpperLeft  : ''; UpperRight  : ''; LowerLeft  : '';
          LowerRight : ''; Vertical    : ''; Horizontal : '' ),
        ( UpperLeft  : ''; UpperRight  : ''; LowerLeft  : '';
          LowerRight : ''; Vertical    : ''; Horizontal : '' ),
        ( UpperLeft  : ''; UpperRight  : ''; LowerLeft  : '';
          LowerRight : ''; Vertical    : ''; Horizontal : '' )
       );
var StrepBuf : string;                           { stores a horizontal line }
    Line    : byte;                                          { loop counter }
begin
 with RCharacter[ WBorder ] do
   begin
     WriteChar( x1, y1, WColor, 0, UpperLeft  );             { output the four }
     WriteChar( x2, y1, WColor, 0, UpperRight );             { output the four }
     WriteChar( x1, y2, WColor, 0, LowerLeft  );             { output the four }
     WriteChar( x2, y2, WColor, 0, LowerRight );             { output the four }
     StrepBuf := WinStRep( Horizontal, x2-x1-1 );          { output the two }
     WriteText( x1+1, y1, WColor, x2-x1-1, StrepBuf );               { horizontal     }
     WriteText( x1+1, y2, WColor, x2-x1-1, StrepBuf );               { lines          }
     StrepBuf := WinStRep( ' ',x2-x1+1);
     StrepBuf[1]:= Vertical;
     StrepBuf[Length(StrepBuf)] := Vertical;
     for Line:=y1+1 to y2-1 do                         { process each line }
       begin                                           { draw vertical line }
         WriteText( x1, Line, WColor, 0, StrepBuf );
       end;
   end;
end;

Procedure Box(Len, Lines, Color, Style :byte; var X,Y :word);
  var X2, Y2 :word;
  begin
  Y:=EScrLines div 2 - Lines div 2;
  Y2:=EScrLines div 2 + Lines div 2;
  X:=ELineLen div 2 - Len div 2;
  X2:=ELineLen div 2 + Len div 2;
  WinFrame(X-1, Y-1, X2+1, Y2+1, Style, Color);
  end;

Procedure Message( s :string );
  var x,y :word;
  begin
  Box(Length(s), 1, $1F, 1, X, Y);
  WriteText(X, Y, $1F, 1, s);
  end;

Procedure InputBox( s:string; var t :string; Len :byte);
  var x,y :word;
  begin
  Box(Len, 2, $1F, 2, X, Y);
  WriteText(X, Y, $1F, 1, s);
  ReadIt(X, Y+1, $1F, Len, t);
  end;

{---------------------------------------------------------------------------}

begin
LineLen := ELineLen;
ScrLines:= EScrLines;
    asm
    mov ah,0Fh
    int 10h
    mov Byte(VideoSeg),al
    end;

if VideoSeg=7 then begin
                   VideoSeg:=$B000;
                   Attr:=$0A00;
                   end
else VideoSeg:=$B800;
VideoSegBar := VideoSeg;
ScrSize :=LineLen*ScrLines;
end.