;
;  This is include file
;

CmdPhase db 0                   ; 0 - ceka se na Ctrl - Alt - ???
                                ; 1 - ceka se na 1-9

IsIn    macro a,b,e
        local d
        cmp al,a
        jb d
        cmp al,b+1
        jnb d
        sub al,a
        add al,e
        jmp ScanOk
d:
        endm

;==============================================================================
;    The new interrupt handlers follow
;==============================================================================

;-- The new interrupt 09h handler (keyboard) ------------------------------

In09    db 0

new09:
        test In09,0FFh
        jnz Old09

        Inc In09

           sti                    ;Enable interrupts
           push ax                ;Store AX on the stack
           in   al,60h            ;Get scan code from the keyboard port

           cmp  al,128            ;Release code?
           jae  ik_end            ;Yes, do not test

           test CmdPhase,0FFh
           jz NoCmdPhase

           cmp al,2
           jb cancelCmd

           cmp al,11
           ja cancelCmd

           push ax
           mov al,20h
           out 20h,al
           pop ax
           dec al
           call StartCmd
           xor ax,ax
           mov CmdPhase,al
           pop ax
           dec In09
           iret

CancelCmd:
           push ax
           xor ax,ax
           mov CmdPhase,al
           pop ax

NoCmdPhase:
           ;-- Determine if the hotkey was activated -------------------

           push ax                ;Store DS and AX on the stack
           push ds

           mov  ax,0040h          ;Segment address of the BIOS segment to AX
           mov  ds,ax             ;and from there to DS
           mov  ax,ds:[17h]       ;Load BIOS keyboard flag
           and  ax,key_mask       ;Leave the bits from KeyMask
           cmp  ax,key_mask       ;Compare with KeyMask
           pop  ds                ;Restore DS and AX
           pop  ax

           jne  ik_end            ;No Hotkey ---> IK_END

           IsIn lo1 hi1 0
           IsIn lo2 hi2 4
           IsIn lo3 hi3 8
           jmp  ik_End

ScanOK:    push ax
           mov al,20h
           out 20h,al
           pop ax
           call HotKey        ;Start the TSR program

EOI:
           pop   ax               ;Restore the content of the AX register
           dec In09
           iret                   ;Return to the interrupted program

ik_end:
           pop ax
           dec In09
old09:     db 0EAh, 0,0,0,0
           ; call int9_ptr          ;Simulate INT 9h

HotKey:
        pusha
        mov bl,al
        xor bh,bh
        mov al,byte ptr cs:CmdTable[bx]
        mov CmdPhase,al

IF BEEPVER
        mov dx,200
        mov cx,25
        call dobell
ENDIF

        test CmdPhase,80h
        jz @@1

        call StartTsr
        xor ax,ax
        mov CmdPhase,al

@@1:    popa
        retn

