;
; This is include file
;

WOUT    macro a,b
        local c
        OUT a,b
        jmp c
c:
        endm

XCMD    macro a
        mov bl,a
        call Cmd
        endm

XCMD1   macro a
        mov bl,a
        inc bl
        call Cmd
        endm

; --------------------------------------------------------------------------
; --------------------------------------------------------------------------
; --------------------------------------------------------------------------

;
; Init DMA, v EBX lin.adresa bufferu al = 46h cist z diskety, al = 4A zapisovat
;

initDMAX:
;       mov al,46h
        out 12,al
        out 11,al

        mov eax,ebx
        shr eax,16
        wout 81h,al
        mov ax,bx
        wout 4,al
        mov al,ah
        wout 4,al

        mov ax,511
        wout 5,al
        mov al,ah
        wout 5,al
        mov al,2
        wout 10,al
        retn

;
; Cmd, v BL prikaz, v ES ocekavam 0h
;

Cmd:
        mov ecx,es:[timer]
        add ecx,9
        mov dx,03F4h
@@1:    in al,dx
        and al,0C0h
        cmp al,080h
        je CmdOK
        cmp ecx,es:[timer]
        jnb @@1

        Debug 'Can''t send command.'
        stc
        retn

CmdOK:  inc dx               ; 03F5h
        mov al,bl
        out dx,al
        clc
        retn

;
; Rpl, v AL vrati vysledek
;

Rpl:
        mov ecx,es:[timer]
        add ecx,9
        mov dx,03F4h
@@2:    in al,dx
        and al,0C0h
        cmp al,0C0h
        je RplOK
        cmp ecx,es:[timer]
        jnb @@2

        Debug 'Can''t get reply.'
        stc
        retn

RplOK:  inc dx               ; 03F5h
        in al,dx
        clc
        retn

;---------------------------------------------------------------------------

;
; NextSec - zjisti adresu dalsiho sektoru
;


NextSec:
        mov al,sec
        add al,bl
        cmp al,numsec
        jb @@3
        sub al,numsec
@@3:    mov sec,al
        retn


;
; Spocti adresu dalsiho sektoru
;
CompNextSec:
        mov bl,1
        call NextSec
        mov al,2
        mov phase,al
        dec sec2r
        jnz @@1
        mov al,numsec
        mov sec2r,al
        xor head,04h
        jnz @@1
        inc cyl
        mov al,cyl
        cmp al,numcyl
        mov al,1
        mov phase,al
        jne @@1

        mov al,4
        mov phase,al
@@1:    retn

;
; Pocitani dalsiho sektoru pro zapis
;

OldCyl  db 0
WNextSec:
        mov dl,Cyl
        mov OldCyl,dl
WNextSec0:
        call CompNextSec
        cmp phase,4
        je @@1
        cmp phase,1
        jne @@2
        mov bl,secslid
        call NextSec
@@2:
        mov ch,cyl
        mov cl,sec
        mov dh,head
        shr dh,2
        mov bl,numsec
        call getbbit
        btr buffer,ax

        jnc WNextSec0
        mov dl,Cyl
        cmp dl,OldCyl
        je @@1
        mov al,1
        mov phase,al
@@1:    retn

;
; SetBit - nastavi ten spravny bit na precteno
;

SetBit:
        test WriteEn,0FFh
        Assert nz 'Write is enabled'
        jnz @@2

        xor ax,ax
        test SecBad,0FFh
        mov SecBad,al
        Assert nz 'Errors reading'
        jnz @@2
                                ;Nastavit bitik na precteno
        xor ax,ax
        mov al,cyl
        shl ax,1
        xor bx,bx
        mov bl,head
        shr bx,2
        add ax,bx
        mov si,tableadr
        dec ax
        bts cs:[si],ax
@@2:    retn


;
; Obsluha preruseni od FDC
; ͼ

;
; Precti vysledek posledniho cteni
;

ReadRes:

IF Win
        mov eax,LastAdr
        add eax,512
        mov MoveAdr,eax
ENDIF

DoReadRpl:
        Call Rpl
        test al,0C0h
        jz @@1

IFDEF DebugVer

        Debug 'Error reading...'
        pusha
        push ax
        Call Rpl
        push ax
        Call Rpl
        push ax
        Call Rpl
        Call Rpl
        Call Rpl
        Call Rpl
        pop ax
        pop bx
        pop cx
        Debug 'Error reading : Rpl0=~CL, Rpl1=~BL, Rpl2=~AL.'
        popa
        inc SecBad
        inc TSecBad
        jmp @@3

ENDIF
        inc SecBad
        inc TSecBad
@@1:
        mov al,sec2r
        cmp al,numsec
        jne @@2
        call SetBit
@@2:
        Call Rpl
        Call Rpl
        Call Rpl
        Call Rpl
        Call Rpl
        Call Rpl
@@3:    retn

;
; Seekuj
;


Seek:   Call ReadRes
SeekNow:
        XCmd 0Fh
        jc SeekFail
        mov bl,Disk
        or bl,Head
        call Cmd
        jc SeekFail
        mov bl,Cyl
        mov cl,DStep
        shl bl,cl
        call Cmd
        jc SeekFail
;        mov dx,offset Seeked
;        call Error
        cmp WriteEn,2
        je @@2

        mov bl,SecSlid
        call NextSec

;        mov al,numsec
;        mov sec2r,al

@@2:
        mov al,phase
        cmp phase,5
        je @@1
        mov al,3
        mov phase,al
@@1:    jmp Continue

;
; Obsluha chyb :-)
;

SeekFail:
        Debug 'Seek failed.'
;       mov dx,offset errSeek
ReadFail:
        Debug 'Read failed.'
;        mov dx,offset errRead
;        call Error
;        jmp Continue

SenseFail:
        Debug 'Sense failed.'
;        mov dx,offset errSense
;       jmp Failed
Failed:
        Debug 'Something failed -> closing down.'
        mov ax,07FFFh
        mov TSecBad,ax
        mov al,080h
        mov Phase,al
        jmp Continue

;
; Precti vysledek po seeku
;

SenseIntStatus:
        mov bl,08h
        call Cmd
        jc SenseFail
        call Rpl
        jc SenseFail
        call Rpl
        jc SenseFail
        retn

;
; Read - precte sektor z Floppy

Read:   Call ReadRes
ReadNow:
IF LockDMA
        pusha
        push es
        push cs
        pop ax
        mov DMAseg,ax
        mov ax,8103h
        mov dx,0004h
        push cs
        pop es
        lea di,VDMA
        int 4Bh
        jnc @@1
        Debug 'Problems locking DMA...'
@@1:
        pop es
        popa
ENDIF


; Inicializuj DMA
        mov ch,cyl
        mov cl,sec
        mov dh,head
        shr dh,2
        mov bl,numsec
        call getbadr
IF Win
        mov LastAdr,eax

        test WriteEn,0FFh
        jz Skip
        push es

        push cs
        pop es
        lea bx,DMAbuf
        mov si,TableAdr
        sub si,otable+offset bufslot

        add eax,512
        mov Num,512
        call FromXMS
        pop es

Skip:   mov ebx,lBuf
ELSE
        mov ebx,eax
        add ebx,lBuf
ENDIF
        mov al,46h      ; Budeme cist 4A=zapisovat
        test WriteEn,0FFh
        jz @@2
        mov al,4Ah
@@2:    call InitDMAX

DMAready:
; Posli prikaz
        lds si,es:[ 01Eh * 4 ] ; DiskBase
        mov bl,66h             ; Cteni ( 45h = zapisovat )
        test WriteEn,0FFh
        jz @@1
        mov bl,45h
@@1:    call Cmd
        jc ReadFail
        mov bl,Disk
        or bl,Head
        call Cmd
        jc ReadFail
        XCmd Cyl
        jc ReadFail
        mov bl,Head
        shr bl,2
        call Cmd
        jc ReadFail
        XCmd1 Sec
        jc ReadFail
        XCmd ds:[si+3]
        jc ReadFail
        XCmd ds:[si+4]
        jc ReadFail
        XCmd ds:[si+5]
        jc ReadFail
        XCmd ds:[si+6]
        jc ReadFail
        cmp WriteEn,2
        je @@3
        call CompNextSec
        jmp Continue

@@3:    call WNextSec
        jmp Continue

;
; Obsluha Int0E
;
new0E:
        test phase,7Fh
        jz old0E

        pushf
        push cs
        call old0E

        pushax
        push es ds
;       mov al,20h
;       out 20h,al
        xor ax,ax
        mov es,ax
        dec ax
        mov es:[motoroff],al
        cmp phase,1
        je Seek
        cmp phase,2
        je Read
        cmp phase,4
        je @@2
        cmp phase,5
        je @@1
; phase = 3
        call SenseIntStatus
        jmp ReadNow

@@2:
; phase = 4
        mov al,5
        mov phase,al
        call ReadRes
        mov al,0
        mov cyl,al
        jmp SeekNow

@@1:
; phase = 5
        call SenseIntStatus
        mov al,80h
        mov phase,al
        call ReadDone

Continue:

IF Win
MoveData:
        test WriteEn, 0FFh
        jnz @@1
        test MoveAdr, 0FFFFFFFFh
        jz @@1
        inc MoveNow

IF NotMoveInInt
        push cs
        pop es
        lea bx,DMAbuf
        mov si,TableAdr
        sub si,otable+offset bufslot

        mov eax,MoveAdr

        mov Num,512
        call ToXMS
ENDIF

@@1:
ENDIF
        pop ds es
        popax
        iret

old0E:  db 0EAh,0,0,0,0
