;
;  This is include file
;

ohandle  equ 0
olinadr  equ 4
ohead    equ 8
osec     equ 9
ocyl     equ 10
otable   equ 11

XMS     dd 0

CallVxD macro Num,Comment
        mov ax,Num
        Debug 'VxDcall ~AX ...'
        Call [VxDapi]
        Debug '...done.'
        endm

; How many bytes are needed for table?
;
; Max 83 tracks..max 21 bytes
;
;


IF Win
;
;  Lock buffer, si>>5 number of buffer
;
LockBuf:
        retn
IF 0
        mov dx,es:[ btotsec + di ]
        call ToPages
        mov edx,dword ptr bufslot [si+ohandle]
        CallVxD 2 'Locking'
        retn
ENDIF

;
;  UnLock buffer, si>>5 number of buffer
;
UnLockBuf:
        retn
IF 0
        mov dx,TNumSec
        call ToPages
        mov edx,dword ptr bufslot [si+ohandle]
        CallVxD 3 'Unlocking'
        retn
ENDIF
ENDIF

;
;  Uvolni buffer, si..cislo bufferu
;

freebuf:
        shl si,5
IF VxDmem
        mov edx,dword ptr bufslot [si+ohandle]
        or edx,edx
        jz @@1
        cmp InWin,2
        je @@1
        CallVxD 4 'Freeing'
@@1:
ELSE
        mov dx,word ptr bufslot [si+ohandle]
        mov ah,0Dh
        call [XMS]

        mov ah,0Ah
        call [XMS]
ENDIF
        retn

;
;  Smaze/nastavi 'precteno' flagy, si..buffer>>5
;

SetReaded:
        mov di,si
        add di,otable+offset bufslot
        mov tableadr,di
        mov cx,31-otable
        push cs
        pop es
        cld
        rep stosb
        retn

IF LockDMA
VDMA:
DMAsize dd 512
DMAoff  dw offset DMAbuf
        dw 0
DMAseg  dw 0
DMAid   dw 0
DMAphys dd 0
ENDIF

ToPages:
        movzx ecx,dx
        add cx,8        ; ecx has hiword = 0
        shr cx,3        ; -> pages
        retn

;
;  Naalokuje buffer, si..cislo bufferu, dx..pocet sektoru, znici es
;

SpecLinear      dd 0
SpecHandle      dd 0
SpecSize        dw 0

allocbuf:
        shl si,5

        mov al,numhead
        mov bufslot [si+ohead],al
        mov al,numsec
        mov bufslot [si+osec],al
        mov al,numcyl
        mov bufslot [si+ocyl],al
        xor ax,ax
        call SetReaded
        mov TNumSec,dx

IF VxDmem
        call ToPages
        mov di,si
        CallVxD 1 'Allocate'
        push ecx
        mov ecx,esi
        Debug 'Allocated - adress ~CE, result ~DE...'
        pop ecx
        or edx,edx
        jz nomem
        or esi,esi
        jz nomem
        mov dword ptr bufslot [di+ohandle],edx
        mov dword ptr bufslot [di+olinadr],esi
        mov si,di

        CallVxD 7 'Test'

        xor ebx,ebx
        xor ecx,ecx
        mov bx,cs
        shl ebx,4
        lea cx,DMAbuf
        add ebx,ecx
        mov eax,ebx
        mov lBuf,eax
ELSE
;        mov word ptr bufslot [si+olen],dx
        shr dx,1
        inc dx
        mov ah,09h      ; Get Memory
        call [XMS]
        or ax,ax
        jz nomem
        mov word ptr bufslot [si+ohandle],dx

        mov ah,0Ch        ; Lock Memory... not under windows!
        call [XMS]
        or ax,ax
        jz nomem
        movzx eax,dx
        shl eax,16
        mov ax,bx

        mov dword ptr bufslot [si+olinadr],eax
        test eax,511
        jnz nomem
        add eax,512
        mov lBuf,eax
ENDIF
        clc
        ret

nomem:
        stc
        ret

;
; Get XMS bit array EDX cislo bitu, buffer cis. SI>>5
;
getbitarray:
        mov eax,512
        mov Num,eax
        mov bx,offset buffer
        push cs
        pop es
        xor eax,eax
        call fromXMS
        retn

IF Win
Num     dd 512
ELSE
;
; Prenese sektor(y) z XMS do ES:[BX], buffer cis. SI>>5, offset v XMS v EAX
;  (podle nastaveni v XMStable.Num)
XMStable:
Num     dd 512
SHandle dw 0
SAdr    dd 0
DHandle dw 0
DAdr    dd 0
ENDIF

fromXMS:
IF VxDmem
        push edi ecx
        mov edi,dword ptr bufslot[si + olinadr]
        add edi,eax
        mov ecx,Num
        shr ecx,2
        CallVxD 6 'From'
        pop ecx edi
ELSE
        mov SAdr,eax ;ecx
        xor ax,ax
        mov DHandle,ax

        mov word ptr DAdr,bx
        mov ax,es
        mov word ptr DAdr+2,ax

        mov ax,word ptr bufslot[si + ohandle]
        mov SHandle,ax

        push ds si
        mov ah,0Bh
        push cs
        pop ds
        mov si,offset XMSTable
        call [XMS]

;        cmp ax,1
;        je @@2
;        Debug 'FromXMS failed with error code ~b.'
;@@2:
        pop si ds
ENDIF
        retn

;
;  Presune data z bufferu do XMS, cilovy offset = EAX, ES:[BX], buffer SI>>5
;

toXMS:
IF VxDmem
        push edi ecx
        mov edi,dword ptr bufslot[si + olinadr]
        add edi,eax
        mov ecx,Num
        shr ecx,2
        CallVxD 5 'To'
        pop ecx edi
ELSE
        mov DAdr,eax ;ecx

        xor ax,ax
        mov SHandle,ax

        mov word ptr SAdr,bx
        mov ax,es
        mov word ptr SAdr+2,ax

        mov ax,word ptr bufslot[si + ohandle]
        mov DHandle,ax

        push ds si
        mov ah,0Bh
        push cs
        pop ds
        mov si,offset XMSTable
        call [XMS]
;        cmp ax,1
;        je @@2
;        Debug 'ToXMS failed with error code ~b.'
;@@2:
        pop si ds
ENDIF
        retn

;
;   Zjisti adresu zacatku daneho sektoru - v numsec musi byt pocet sectoru akt. diskety
;     CL je zero-based, v BL chci NumSec

getbadr:
        push offset shiftit

getbbit:
        xor eax,eax
        mov al,ch
        shl ax,1
        add al,dh
        mul bl
        xor ch,ch
        add ax,cx
        retn

shiftit:
        shl eax,9
        retn

IF Win
ELSE
;
;  InitXMS ----------------------------------------------------------------
;           Tady zacina inicializacni cast!

initXMS:
        mov ax,4300h
        int 2Fh
        cmp al,80h
        jne noxms

        mov ax,4310h
        int 2Fh
        mov word ptr XMS, bx
        mov word ptr [offset XMS+2], es
        jmp init

errNoXMS db "XMS driver not found.",13,10,"$"
ENDIF
errNotInst db "35sec NOT installed.",13,10,"$"

