{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xpreg.pas,v 1.16 2005/01/01 11:16:30 mw Exp $ }

{ Registrierung }

{$I XPDEFINE.INC }
{$O+,F+}

unit xpreg;

interface

uses  crt,dos,typeform,fileio,inout,keys,winxp,maus2,maske,resource,
      xp0,xp1,xp1o,xp1o2,xp1input,xpglobal;

procedure license;
procedure BetaMessage;
procedure About;
function  LizenzNummer:string;


implementation  { --------------------------------------------------- }

procedure license;
var x,y,i : byte;
    s     : string;
    p     : byte;

    msglines : byte;

    sely  : byte;
    sels  : string[80];
    n     : shortint;
    z     : taste;

  procedure ReadReg;
  var x,y  : byte;
      brk  : boolean;
      code : string[20];
      t    : text;
      nr   : longint;
      z    : taste;
  begin
    if not is_freereg then
    begin
      pushhp(1552);
      if ReadJN(getres2(521,1),false) then  { 'Sie sind bereits registriert. Mchten Sie die Registrierung lschen' }
      with registriert do begin
        _era('regdat.xp');
        nr:=0;
        tc:='F';
        komreg:=false;
        orgreg:=false;
        message(getres2(521,8));    { 'Registrierung wurde gelscht.' }
        mdelay(1500);
        closebox;
      end;
      pophp;
      exit;
    end;
    code:='';
    dialog(length(getres2(521,2))+27,3,'',x,y);
    maddstring(3,2,getres2(521,2),code,20,20,'');   { 'Registrierungs-Code: ' }
      mhnr(1553);
    readmask(brk);
    enddialog;
    if (code<>'') and (firstchar(code)<'A') then code:='A'+code;
    if brk or (code='') then
    begin
      message(getres2(521,3));    { 'Na, dann eben nicht.' }
      wkey(2,false);
      closebox;
    end
    else if (cpos('-',code)=0) or
            (ival(copy(code,2,cpos('-',code)-2))=0) then
    begin
      message(getres2(521,4));   { 'Ungltiger Registrierungs-Code.' }
      wkey(2,false);
      closebox;
    end
    else begin
      if ival(firstchar(code))>0 then
        nr:=ival(left(code,cpos('-',code)-1))
      else
        nr:=ival(copy(code,2,cpos('-',code)-2));
      if IsKomCode(nr) or IsOrgCode(nr) then
      begin
        msgbox(53,8,'',x,y);
        mwrt(x+3,y+2,'Sie sind als nicht-privater '+xp_display+'-Anwender');
        mwrt(x+3,y+3,'registriert. Soll dies in Ihren Nachrichten er-');
        mwrt(x+3,y+4,'kennbar sein?');
        z:='';
        pushhp(1554);
        if readbutton(x+3,y+6,2,getres(107),1,true,z)=1 then  { Ja/Nein }
          code:='!'+code;
        pophp;
        closebox;
      end;
      assign(t,regdat);
      rewrite(t);
      writeln(t,code);
      close(t);
      msgbox(47,8,'',x,y);
      moff;
      wrt(x+3,y+2,getres2(521,5));   { 'Der Registrierungscode wurde gespeichert.' }
      wrt(x+3,y+3,getres2(521,6));   { 'CrossPoint beendet sich jetzt selbst und' }
      wrt(x+3,y+4,getres2(521,7));   { 'mu danach neu gestartet werden.' }
      wrt(x+3,y+6,getres(12));       { 'Taste drcken ...' }
      mon;
      xp1.wait(curon);
      quit:=true;
    end;
  end;

label again;

begin
  msglines:=ival(getres2(520,0));
  msgbox(70,msglines+9,'',x,y);
  moff;
  attrtxt(col.colmboxhigh);
  wrt(x+9,y+2,'\\//');
  wrt(x+9,y+3,'//\\');
  attrtxt(col.colmbox);
  wrt(x+3,y+2,'Cross');
  wrt(x+14,y+3,'Point');
  s := '(c) 1992-1999 ' + pm;
  wrt(x+67-length(s),y+1,s);
  s := '(c) 2000-2001' + forms(' ',5) + iifs(deutsch,'OpenXP-Team','OpenXP Team');
  wrt(x+67-length(s),y+2,s);
  s := forms(x_copyright,14) + forms(' ',length(pm)-length(author_name)) + author_name;
  wrt(x+67-length(s),y+3,s);
  s:=getres2(520,19)+LizenzNummer;   { 'Lizenznummer: ' }
  wrt(x+67-length(s),y+4,s);
  for i:=1 to msglines do
  begin
    s:=getres2(520,i);
    gotoxy(x+3,y+5+i);
    repeat
      p:=cposx('*',s);
      write(left(s,p-1));
      delete(s,1,p);
      p:=cposx('*',s);
      attrtxt(col.colmboxhigh);
      write(left(s,p-1));
      attrtxt(col.colmbox);
      delete(s,1,p);
    until s='';
  end;
  sels:=getres2(520,30);  { ' S^LIZENZ.TXT anzeigen , Registrierungs^code eingeben ' }
  mon;
again:
  sely:=y+msglines+7;
  attrtxt(col.colmbox);
  mwrt(x+3,sely,sp(65));
  z:='';
  n:=1;
  pushhp(1551);
  n:=ReadButton(x+3,sely,2,'*'+sels,n,true,z);
  pophp;
  s:='DOC\' + getres2(520,40);   { 'SLIZENZ.TXT' }
  case n of
    1 : begin
          if not exist(s) then           { 'SLIZENZ.TXT' }
            fehler(getreps2(520,41,s))   { '%s fehlt!' }
          else
            if listfile(s,getres2(520,42),true,false,0)=0 then;    { 'D=Drucken    <Esc>=Ende' }
          goto again;
          end;
    2 : begin
          ReadReg;
          if not quit then goto again;
        end;
  end;
  closebox;
  freeres;
end;

procedure BetaMessage;
var x,y,i,p  : byte;
    msglines : byte;
    z        : taste;
    s        : string;
begin
  msglines:=ival(getres2(530,0));
  msgbox(72,msglines+8,'',x,y);
  moff;
  attrtxt(col.colmboxhigh);
  wrt(x+9,y+2,'\\//');
  wrt(x+9,y+3,'//\\');
  attrtxt(col.colmbox);
  wrt(x+3,y+2,'Cross');
  wrt(x+14,y+3,'Point');
  s := '(c) 1992-1999 ' + pm;
  wrt(x+69-length(s),y+1,s);
  s := '(c) 2000-2001' + forms(' ',5) + iifs(deutsch,'OpenXP-Team','OpenXP Team');
  wrt(x+69-length(s),y+2,s);
  s := forms(x_copyright,14) + forms(' ',length(pm)-length(author_name)) + author_name;
  wrt(x+69-length(s),y+3,s);
  for i:=1 to msglines do begin
    s:=getres2(530,i);
    gotoxy(x+3,y+4+i);
    repeat
      p:=cposx('*',s);
      write(left(s,p-1));
      delete(s,1,p);
      p:=cposx('*',s);
      attrtxt(col.colmboxhigh);
      write(left(s,p-1));
      attrtxt(col.colmbox);
      delete(s,1,p);
    until s='';
  end;
  mon;
  pushhp(1550);
  quit := (ReadButton(x+45,y+msglines+6,2,'*'+getres2(530,30),1,true,z) <> 1);
  pophp;
  closebox;
  freeres;
end;

procedure About;
var x,y : byte;
    z   : taste;
    ver : string;
    addxVer,addxInf,addy : shortint;
    DiaWidth : byte;
begin
  addy := 1;
  ver := xp_xp+' '+verstr+betastr+ovrstr;
 {$IFDEF Snapshot}
  inc(addy);
 {$ENDIF}
  { Breite des Dialogs aus Lnge der Versionsbezeichnung,     }
  { URL, eMail-Adresse und "Mandrella-String" (=30) berechnen }
  DiaWidth:=max(max(max(length(author_url),length(author_mail))+7,length(ver)),30);
  addxVer:=iif(length(ver)=DiaWidth,0,(DiaWidth-length(ver)) div 2);
  addxInf:=iif(addxVer>0,0,(DiaWidth-max(max(length(author_url),length(author_mail))+7,30)) div 2);
  if odd(DiaWidth) then dec(DiaWidth);  { "gerade" Breite erzwingen }
  diabox(DiaWidth+6,18+addy,'',x,y);
  moff;
  attrtxt(col.colmboxhigh);
  wrt(x+((DiaWidth+6) div 2)-2,y+2,'\\//');
  wrt(x+((DiaWidth+6) div 2)-2,y+3,'//\\');
  wrt(x+3+addxVer,y+5,ver);
  {$IFDEF Snapshot}
    wrt(x+3+addxVer,y+6,'Snapshot: '+compiletime);
  {$ENDIF}
  wrt(x+3+addxVer,y+5+addy,getres2(520,19)+LizenzNummer);
  attrtxt(col.colmbox);
  wrt(x+((DiaWidth+6) div 2)-8,y+2,'Cross');
  wrt(x+((DiaWidth+6) div 2)+3,y+3,'Point');
  wrt(x+3+addxInf,y+7+addy,forms('(c) 1992-1999',15)+pm);
  wrt(x+3+addxInf,y+8+addy,forms('(c) 2000-2001',15)+iifs(deutsch,'OpenXP-Team','OpenXP Team'));
  wrt(x+3+addxInf,y+9+addy,forms(x_copyright,15)+author_name);
  wrt(x+3+addxInf,y+11+addy,'Fido : '+author_fido);
  wrt(x+3+addxInf,y+12+addy,'eMail: '+author_mail);
  wrt(x+3+addxInf,y+13+addy,'WWW  : '+author_url);
  mon;
  ReadButton(x+((DiaWidth+6) div 2)-5,y+15+addy,1,'*   ^OK   ',1,true,z);
  closebox;
  freeres;
end;

function LizenzNummer:string;
begin
  with registriert do
    if is_freereg then LizenzNummer:=getres2(361,60) else
    if orgreg then LizenzNummer:='Org-'+tc+strs(nr) else
    if komreg then LizenzNummer:='Kom-'+tc+strs(nr) else
    LizenzNummer:=tc+strs(nr);
end;

end.
{
  $Log: xpreg.pas,v $
  Revision 1.16  2005/01/01 11:16:30  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.15  2004/01/09 16:18:59  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.14  2003/08/03 15:23:03  my
  MY:- FreeXP ist jetzt Freeware. :-) Smtliche Shareware-Beschrnkungen
       und Registrierungsfunktionen deaktiviert bzw. eliminiert. Die
       Eingabe eines freiwilligen Keys ist weiterhin mglich, dieser bzw.
       ein bereits existierender Key wird wie bisher an den entsprechenden
       Stellen (Software-Header, Origin usw.) angezeigt; Freeware-Versio-
       nen ohne Key melden sich mit "R/Free". Men /XPoint/Registrierung
       umbenannt in /XPoint/Lizenz, dort verweist der Button statt auf die
       weggefallene LIZENZ.DOC nun auf die Quelltextlizenz SLIZENZ.TXT.

  Revision 1.13  2003/08/01 23:18:21  my
  MY:- About-, Beta-, und alle sonstigen Dialoge, Ausgaben und
       Versionsmeldungen auf "FreeXP" umgestellt.

  Revision 1.12  2003/07/30 23:09:51  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.11  2003/06/25 17:31:09  tw
  auto-de-branching

  Revision 1.10.2.12  2003/04/13 21:08:49  my
  MY:- 'ovrstr' statt 'xmsstr' an Versionsbezeichnung anhngen.

  Revision 1.10.2.11  2003/01/16 23:30:33  my
  MY: - Schalter /xmsovr in Versionsbezeichnung bercksichtigt
      - betastr an einigen Stellen ergnzt

  Revision 1.10.2.10  2002/04/14 14:28:13  my
  MY:- About-Dialog fr alle "Lebenslagen" fit gemacht (Breite des Dialogs
       und Position der Strings immer richtig berechnen), Position "XP"
       im Beta-Dialog korrigiert.

  Revision 1.10.2.9  2002/03/08 23:40:11  my
  MY:- Registrierungs-, Beta-, "ber OpenXP"- und sonstige Dialoge auf
       OpenXP/16 umgestellt und Copyright-Hinweise sowie Kontakte
       aktualisiert.

  Revision 1.10.2.8  2001/09/16 20:41:33  my
  JG+MY:- Neuer Menpunkt "?" (Hilfe) im Hauptmen mit Untermens fr
          ntzliche und/oder in der Hilfe ansonsten nur schwer auffindbare
          Informationen. Untermen "ber OpenXP" zeigt Versions- und
          Snapshotnummer sowie OpenXP-Kontakte an. Beta- und
          Registrierungsfenster optisch angepat.

  MY:- Copyright-/Lizenz-Header aktualisiert

  Revision 1.10.2.7  2001/08/05 11:45:37  my
  - added new unit XPOVL.PAS ('uses')

  Revision 1.10.2.6  2000/12/28 14:46:34  mk
  - nochmal optische korrektur fuer Copyright-Dialog

  Revision 1.10.2.5  2000/12/26 21:44:59  mk
  - optische korrektur

  Revision 1.10.2.4  2000/12/24 16:47:33  mk
  - regdata.cfg gross geschrieben

  Revision 1.10.2.3  2000/12/14 17:54:10  mk
  - Programmnamen in Regformular schreiben

  Revision 1.10.2.2  2000/10/05 20:29:49  fe
  RFC/UUCP: Hostname masquerading / UUCP-Alias-Points repariert:
  Statt "User@Server.domain" jetzt "User@Server.Serverdomain".

  Revision 1.10.2.1  2000/07/01 09:22:59  mk
  - Mailerstringanpassungen

  Revision 1.10  2000/06/01 16:03:05  mk
  - Verschiedene Aufraeumarbeiten

  Revision 1.9  2000/05/07 18:16:04  hd
  Kleine Linux-Anpassungen

  Revision 1.8  2000/05/02 19:14:03  hd
  xpcurses statt crt in den Units

  Revision 1.7  2000/04/04 10:33:57  mk
  - Compilierbar mit Virtual Pascal 2.0

  Revision 1.6  2000/02/19 11:40:09  mk
  Code aufgeraeumt und z.T. portiert

  Revision 1.5  2000/02/15 20:43:37  mk
  MK: Aktualisierung auf Stand 15.02.2000

}
