{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xpfonts.pas,v 1.11 2005/01/01 11:16:30 mw Exp $ }

{ Interne Screenfonts }

{$I XPDEFINE.INC}

{$O+,F+}

unit xpfonts;

interface

uses
  video,xp0,xpglobal,dos;

procedure InternalFont;
procedure Font8x16;
procedure Font8x14;
procedure Font8x8;
procedure LoadFont(height:byte; var data); { neue EGA/VGA-Font laden }
procedure LoadFontFile(fn:pathstr);        { Font aus Datei laden }
procedure setuserchar(height:byte);

implementation  { ------------------------------------------------------ }


uses typeform, fileio ,dosx;


type ba  = array[0..65000] of byte;
     bp  = ^ba;
var
    p1,p2   : bp;                    { Zeiger fr Font-Generator }

var p : ^Pointer;

{$I XPFONTS.INC}


procedure InternalFont;
var fnr : integer;
    h   : byte;
    p   : ^pointer;
begin
  fnr:=ival(mid(ParFontfile,2));
  case fnr of
     1 : begin h:=14; p:=@FontC2; end;
     2 : begin h:=16; p:=@FontScrawl16; end;
     3 : begin h:=14; p:=@FontBroadway14; end;
     4 : begin h:=16; p:=@Font_Mod1; end;
     5 : begin h:=14; p:=@Font_Mod2; end;
    else h:=0;
  end;
  if h>0 then
  begin
    inc(longint(p));
    p:=p^;
  { if EuroOK then MakeEuroChar(h,p^); }  { spter aktivieren, sobald }
    LoadFont(h,p^);                       { Euro-Symbol existiert     }
  end;
end;

procedure LoadFont(height:byte; var data);
var regs : registers;
begin
  with regs do begin
    ax:=$1110;
    bx:=height*256;
    cx:=256;
    dx:=0;
    es:=seg(data); bp:=ofs(data);
    Xintr($10,regs);
  end;
end;

procedure LoadFontFile(fn:pathstr);        { Font aus Datei laden }
var p  : pointer;
    sr : searchrec;
    h  : byte;
    hmax:byte;
    ofs: byte;
    f  : file;
begin
  if vtype<2 then exit;
  findfirst(fn,ffAnyFile,sr);
  if (doserror=0) and (sr.size mod 256<=8) and (sr.size<65536) then begin
    h:=sr.size div 256;
    ofs:=sr.size mod 256;
    if vtype=2 then hmax:=14 else hmax:=16;
    if (h>=8) and (h<=hmax) then begin
      getmem(p,256*h);
      assign(f,fn);
      reset(f,1);
      seek(f,ofs);
      blockread(f,p^,256*h);
      close(f);
      LoadFont(h,p^);
      freemem(p,256*h);
      end;
    end;
end;

procedure setuserchar(height:byte);   { height = 12/11/10/9/7 }
var regs  : registers;
    sel   : word;

  procedure make15; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x16-Font         }
           lds   si,p1                   { 8x15-Font generieren      }
           mov   dx,256                  { 1. Zeile wird weggelassen }
  @c15lp:  mov   cx,15
           rep   movsb
           inc   si
           dec   dx
           jnz   @c15lp
           pop ds
  end;

  procedure make13; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x14-Font         }
           lds   si,p1                   { 8x13-Font generieren      }
           mov   dx,256                  { 1. Zeile wird weggelassen }
  @c13lp:   inc   si
           mov   cx,13
           rep   movsb
           dec   dx
           jnz   @c13lp
           pop ds
  end;

  procedure make12; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x14-Font          }
           lds   si,p1                   { 8x12-Font generieren       }
           mov   dx,256                  { 1. und letzte Zeile werden }
  @c12lp:  inc   si                      { weggelassen                }
           mov   cx,12
           rep   movsb
           inc   si
           dec   dx
           jnz   @c12lp
           pop ds
  end;

  procedure make11; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x14-Font              }
           lds   si,p1                   { 8x11-Font generieren           }
           mov   dx,256                  { 1., 2. und letzte Zeile werden }
  @c11lp:  inc   si                      { weggelassen                    }
           inc   si
           mov   cx,11
           rep   movsb
           inc   si
           dec   dx
           jnz   @c11lp
           pop ds
  end;

  procedure make10; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x8-Font              }
           lds   si,p1                   { 8x10-Font generieren          }
           mov   dx,256                  { 2. und vorletzte Zeile werden }
           mov   bl,0                    { bei Blockzeichen verdoppelt   }
  @c10lp:  cmp   dl,80
           jnz   @m10j1
           inc   bl
  @m10j1:  cmp   dl,32
           jnz   @m10j2
           dec   bl
  @m10j2:  mov   al,0
           or    bl,bl
           jz    @zero1
           mov   al,[si+1]
  @zero1:  stosb
           mov   cx,8
           rep   movsb
           mov   al,0
           or    bl,bl
           jz    @zero2
           mov   al,[si-2]
  @zero2:  stosb
           dec   dx
           jnz   @c10lp
           pop ds
  end;

  procedure make9; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x8-Font               }
           lds   si,p1                   { 8x9-Font generieren            }
           mov   dx,256                  { 2. Zeile wird bei Blockzeichen }
           mov   bl,0                    { verdoppelt                     }
  @c9lp:   cmp   dl,80
           jnz   @m9j1
           inc   bl
  @m9j1:   cmp   dl,32
           jnz   @m9j2
           dec   bl
  @m9j2:   mov   al,0
           or    bl,bl
           jz    @zero91
           mov   al,[si+1]
  @zero91: stosb
           mov   cx,8
           rep   movsb
           dec   dx
           jnz   @c9lp
           pop ds
  end;

  procedure make7;
  var i,j,sk : integer;
      skip   : array[0..255] of byte;   { zu bersprg. Zeile }
      sp,dp  : word;    { SourcePointer, DestPointer }
  begin
    for i:=0 to 255 do
      skip[i]:=2;

    skip[49]:=4;    { 1 }        skip[53]:=4;    { 5 }
    skip[67]:=4;    { C }        skip[97]:=4;    { O }
    skip[105]:=3;   { i }        skip[106]:=3;   { j }
    skip[129]:=4;   {  }        skip[132]:=2;   {  }
    skip[148]:=3;   {  }        skip[154]:=3;   {  }
    skip[161]:=3;   {  }        skip[168]:=3;   {  }
    skip[225]:=8;   {  }

    sp:=0; dp:=0;
    for i:=0 to 255 do
    begin
      sk:=skip[i];
      for j:=1 to 7 do
      begin
        if j=sk then inc(sp);
        p2^[dp]:=p1^[sp];
        inc(sp); inc(dp);
      end;
    end;
  end;

begin
  getmem(p2,16*256);
  with regs do
  begin
    if height<=10 then
      p:=@Font8x8
    else if height<=14 then
      p:=@Font8x14
    else
      p:=@Font8x16;
    inc(longint(p));
    p1:=p^;
    case height of
      15 : make15;
      13 : make13;
      12 : make12;
      11 : make11;
      10 : make10;
       9 : make9;
       7 : make7;
    else
      fastmove(p1^,p2^,4096);
    end;
  { if EuroOK then MakeEuroChar(height,p2^); }  { spter aktivieren, sobald }
    LoadFont(height,p2^);                       { Euro-Symbol existiert     }
  end;
  freemem(p2,16*256);
end;

end.
{
  $Log: xpfonts.pas,v $
  Revision 1.11  2005/01/01 11:16:30  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.10  2004/03/08 16:15:20  mw
  JM+MW: - Neue "Spafonts" (mit /F:*4 bzw. /F:*5 erreichbar)
         - Die Standardinternfonts die immer geladen werden, sind
           nicht ber einen "Spafont"-Parameter erreichbar.

  Revision 1.9  2004/01/09 16:18:59  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.8  2003/08/07 22:11:03  my
  MY+JM+JG: Videoroutinen berarbeitet und korrigiert:
            --------------------------------------------------------------
            1. Fix: Beim Setzen des Videomodus und der Zeilenanzahl sowie
               dem Laden interner Fonts werden die entsprechenden Aktionen
               generell jetzt wirklich nur noch dann (aber dann auch
               immer) ausgefhrt, wenn sie tatschlich erforderlich sind
               (d.h. wenn sich die Werte der ursprnglichen bzw. vorheri-
               gen DOS-Instanz von den in XP zu verwendenden Werten unter-
               scheiden). Bisher wurden die Routinen teils berflssiger-
               weise, teils aber auch genau dort nicht ausgefhrt, wo dies
               htte geschehen mssen (z.B. bei der Verwendung interner
               Fonts).
            2. Fix: Es wird jetzt auch die Spaltenanzahl geprft und ggf.
               korrigiert. Bisher prsentierte XP einen zerschossenen
               Bildschirm, wenn die Spaltenanzahl in der ursprnglichen
               bzw. vorherigen DOS-Instanz z.B. auf 94 gesetzt war.
            3. Fix: Wenn die Zeilenanzahl der ursprnglichen bzw. vorheri-
               gen DOS-Instanz auf 43 gesetzt war, war die Bildschirmdar-
               stellung nicht korrekt: Bei Verwendung der Standard-Fonts
               war der Bildschirm "zu klein", so da die letzten 4 bis 5
               Zeilen zwar vorhanden, aber nicht sichtbar waren; bei Ver-
               wendung der internen Fonts (Parameter /f:*1 bis /f:*3) wa-
               ren zwar alle Zeilen sichtbar, aber XP lief im 21- (/f:*2)
               bzw. 25-Zeilen-Modus (/f:*1 und /f:*3). Jetzt wird der
               korrekte 25- bzw. 28-Zeilen-Modus verwendet und bei
               Standard-Fonts der Bildschirm vollstndig angezeigt.
               Ursache dieses Fehlverhaltens war, da der 43-Zeilen-Modus
               ein Sondermodus mit 350 vertikalen Bildpunkten ist, XP aber
               stur vom VGA-Standard mit 400 Bildpunkten ausging.
               Falls XP in einer DOS-Instanz im 43-Zeilen-Modus gestartet
               wurde, dann wird nach der Beendigung von XP die ursprng-
               liche Bildpunktanzahl wiederhergestellt (sonst kann es
               sonderbare "Verlngerungseffekte" speziell in einer DOS-Box
               von Windows geben).
               Die nderung wirkt sich auch auf DOS-Boxen unter Windows
               aus, bei denen der 43-Zeilen-Modus nicht ber den "mode"-
               Befehl o.., sondern ber die Bildschirm-Eigenschaften in
               der PIF-Datei gesetzt wurde.
            Alle bis hier beschriebenen nderungen wirken sich aus beim
            XP-Start, beim ndern der Zeilenanzahl in XP, und bei der
            Rckkehr aus einer DOS-Shell nach XP.
            4. VESA-Modus fr 60 Zeilen wieder ausgebaut. Die Funktion hat
               selten richtig funktioniert und war eher eine Quelle fr
               Bugreports als ein wirklich sinnvolles Feature. Bei
               bestehenden Konfigurationen mit 60 Zeilen wird in
               XPOINT.CFG automatisch "ScreenLines=50" eingetragen und
               intern gesetzt.
            5. Der interne Font "C2" (wird mit /f:*1 aktiviert) ist jetzt
               - auer bei den Kleinbuchstaben natrlich, die wie bisher
               als Kapitlchen ausgefhrt sind - identisch mit dem
               Standard-Font 8x14, der in den Zeilenmodi 28, 30, 33 und 36
               geladen wird.
            6. Es wird jetzt in *allen* Zeilenmodi ein XP-interner
               Standard-Font in die Grafikkarte geladen (Vorbereitung fr
               Euro-Support). Bisher war dies nur bei den Zeilenmodi 28,
               30, 33 und 36 der Fall.
            7. Einige optische Anpassungen beim Standard-Font 8x14 (0, ,
               M, m, n etc.).
            8. Der Standard-Font 8x14 ist jetzt *nicht* mehr ber den
               Parameter /f:*4 ansprechbar (wie die Standard-Fonts 8x16
               und 8x8 auch nicht ber Parameter ansprechbar sind).

  Revision 1.7  2003/07/30 23:09:51  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.6  2003/06/25 17:30:38  tw
  auto-de-branching

  Revision 1.5.4.6  2002/06/09 09:33:45  mw
  - CVS-Log korrigiert.

  Revision 1.5.4.5  2002/06/09 08:41:26  mw
  - Fonts jetzt nicht mehr als obj Datei im Source, sondern als db-Zeile
    in der xpfonts.inc
  - Der interne 8x14 Zeichensatz ist jetzt auch als Font Nr. 4
    ansprechbar ( /f:*4 )
  Achtung: Noch kein Euro in den Fonts.

  Revision 1.5.4.4  2000/11/16 18:09:50  mk
  - 26 Zeilen-Modus geht wieder (nur ein kleiner Typo)

  Revision 1.5.4.3  2000/10/26 07:20:51  mk
  - Grafikmodus mit 8 Zeilen/Zeichen wird jetzt direkt ueber das BIOS gesetzt

  Revision 1.5.4.2  2000/09/30 16:28:01  mk
  - VESA 80x60-Zeilenmodus

  Revision 1.5.4.1  2000/08/27 17:17:48  jg
  - LoadFont, LoadFontFile und setuserchar von VIDEO nach XPFONTS verlagert
  - XP Verwendet jetzt einen internen 8x14 Zeichensatz (XPFONTS.INC)

  Revision 1.5  2000/02/19 11:40:09  mk
  Code aufgeraeumt und z.T. portiert

}
