{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xp8.pas,v 1.14 2005/01/01 11:16:30 mw Exp $ }

{ CrossPoint - 'maps & Fileserver }

{$I XPDEFINE.INC}
{$O+,F+}

unit xp8;

interface

uses xpglobal, crt,
  dos,typeform,fileio,inout,keys,datadef,database,lister,
  maske,maus2, resource,win2,xp0,xp1,xp1o2,xp1help,xp1input,xp2c,xp_iti,lfn;


procedure SendMaps(bef:string; var box,datei:string);
procedure MapsDelBrett(brett:string);
procedure MapsReadList;
procedure MapsReadFile;
procedure ReadPromafList(fn:pathstr; var bfile:string);
procedure MapsBrettliste(art:byte);
procedure MapsCommands(defcom:byte);   { 0=Auswahl, 1=Brettliste holen }
procedure GetSysfile;

procedure AddFileechos;
procedure RemoveFileechos;
procedure FilescanReadlist;
procedure FilescanReadFile;
procedure FilescanCommands(cmd:shortint);


function IsServer(const box:string; var fstype:byte):boolean;
procedure FS_ReadList(msg:boolean);
procedure FS_command(comm:string; request:byte);

function testmark(var s:string; block:boolean):boolean;
function BrettMark(var s:string; block:boolean):boolean;
function MapsListcolor(var s:string; line:longint):byte;
procedure MapsKeys(var t:taste);
function UUsendTestSourcefile(var s:string):boolean;
function fileechomarkfunc(var s:string; block:boolean):boolean;
function fileechocolfunc(var s:string; line:longint):byte;


implementation  { ------------------------------------------------- }

uses xp1o,xp3,xp3o2,xp3ex,xp4,xp4o,xp6,xp6o,xp9bp,xp9,xpnt, crc;

const mapsbox : string[BoxNameLen] = '';

var mapsname : string[20];
    mapsnt   : byte;
    mapsart  : byte;

function mapstype(box:string):byte;  { 0=MAPS, 1=AREAFIX, 2=MAF, 3=Maus, 4=Q. }
var d  : DB;                         { 5=Fido, 6=G&S, 7=changesys, 8=Pronet,  }
    nt : byte;                       { 9=Turbobox, 10=ZQWK, 11=GUP, 12=AutoSys}
begin                                { 13=Feeder, 14=postmaster, 16=RFC/Client}
  dbOpen(d,BoxenFile,1);
  dbSeek(d,boiName,ustr(box));
  if not dbFound then
    mapstype:=0
  else begin
    dbRead(d,'nameomaps',mapsname);     { mu vor MAF-Test stehen !! }
    dbRead(d,'netztyp',nt);
    if ntMAF(nt) then
      mapstype:=2
    else if ntNude(nt) then
      mapstype:=3
    else if ntQuickMaps(nt) then
      mapstype:=4
    else if ntAreamgr(nt) then
      mapstype:=5
    else if (nt=nt_Client) then
      mapstype:=16
    else if (nt=nt_UUCP) then begin
      ReadBoxpar(nt,box);
      case Boxpar^.BMtyp of
        bm_changesys : mapstype:=7;
        bm_GUP       : mapstype:=11;
        bm_Feeder    : mapstype:=13;
        bm_AutoSys   : mapstype:=12;
        else           mapstype:=14;  { postmaster }
      end;
      end
    else if (nt=nt_Pronet) then
      mapstype:=8
    else if nt=nt_QWK then
      mapstype:=10
    else
      if mapsname='AREAFIX' then mapstype:=1
      else if mapsname='SYSTEM' then mapstype:=6  { G&S }
      else mapstype:=0;
    end;
  dbClose(d);
end;

function BoxHasMaps(box:string):boolean;
begin
  if ntNoMaps(ntBoxNetztyp(box)) then begin
    rfehler(801);   { 'Diese Box untersttzt keine Brettbestell-Funktionen.' }
    BoxHasMaps:=false;
    end
  else
    BoxHasMaps:=true;
end;

procedure SendMaps(bef:string; var box,datei:string);
var hf : string[12];
    mt : byte;
    nt : byte;

  procedure AreaBef;
  var t1,t2 : text;
      tn    : pathstr;
      s     : string[80];
  begin
    if (bef='ADD') or (bef='DEL') then begin
      tn:=TempS(_filesize(datei)*2);
      assign(t1,datei); reset(t1);
      assign(t2,tn); rewrite(t2);
      while not eof(t1) do begin
        readln(t1,s);
        writeln(t2,bef,' ',s);
        end;
      close(t1); erase(t1);
      close(t2); rename(t2,datei);
      end
    else begin
      assign(t1,datei);
      rewrite(t1);
      writeln(t1,bef);
      close(t1);
      end;
    bef:='AREAFIX';
  end;

  procedure MafNude(maf,promaf:boolean);
  var t1,t2 : text;
      tn    : pathstr;
      s     : string[80];
  begin
    ReadBoxpar(0,box);
    if (bef='ADD') or (bef='DEL') then begin
      tn:=TempS(_filesize(datei)*2);
      assign(t1,datei); reset(t1);
      assign(t2,tn); rewrite(t2);
      if maf then
        writeln(t2,'%',boxpar^.passwort);
      while not eof(t1) do begin
        readln(t1,s);
        if trim(s)<>'' then begin
          if not (maf or promaf) then write(t2,'G');    { Maus-Gruppe }
          if bef='ADD' then writeln(t2,iifs(promaf,'','+'),s)
          else writeln(t2,'-',s);
          end;
        end;
      close(t1); erase(t1);
      close(t2); rename(t2,datei);
      if promaf then bef:='Bretter';
      end
    else if not promaf then begin
      assign(t1,datei);
      rewrite(t1);
      if maf then begin
        writeln(t1,'%',boxpar^.passwort);
        writeln(t1,'%',bef);
        end
      else
        writeln(t1,bef);
      close(t1);
      end;
    if maf then bef:='BRETTER'
    else if not promaf then bef:='<Maus-Command>'
    else forceabs:='SYSOP';
  end;

  procedure ChangeSys;
  type bnodep = ^bnode;
       bnode  = record
                  l,r : bnodep;
                  c   : ^string;
                  del : boolean;
                end;
  var t       : text;
      root    : bnodep;
      sysfile : string[12];
      s       : string;
      syspos  : byte;
      first   : boolean;
      _brett  : string[5];
      d       : DB;

    procedure SetBrett(add:boolean; var bn:bnodep);

      procedure setbretts;
      begin bn^.c^:=s; end;

      function smaller:boolean;
      begin smaller:=(s<bn^.c^); end;

      function found:boolean;
      begin found:=(s=bn^.c^); end;

    begin
      if bn=nil then
        if add then begin     { ADD - Brett hinzufgen }
          new(bn);
          bn^.l:=nil; bn^.r:=nil; bn^.del:=false;
          getmem(bn^.c,length(s)+1);
          setbretts;
          end
        else                  { DEL - Brett nicht vorhanden }
      else
        if found then
          if add then         { ADD - Brett schon vorhanden }
          else bn^.del:=true  { Brett lschen }
        else
          if smaller then SetBrett(add,bn^.l)   { links suchen }
          else SetBrett(add,bn^.r);             { rechts suchen }
    end;

    procedure syswrite(bn:bnodep);
    begin
      if bn<>nil then begin
        syswrite(bn^.l);
        if not bn^.del then
          if syspos=0 then writeln(t,bn^.c^)
          else begin
            if not first then write(t,',')
            else first:=false;
            if syspos+length(bn^.c^)>77 then begin
              writeln(t,'\'); syspos:=1; end;
            write(t,bn^.c^);
            inc(syspos,length(bn^.c^)+1);
            end;
        syswrite(bn^.r);
        end;
    end;

    procedure freelist(bn:bnodep);
    begin
      if bn<>nil then begin
        freelist(bn^.l);
        freelist(bn^.r);
        freemem(bn^.c,length(bn^.c^)+1);
        dispose(bn);
        end;
    end;

  begin
    sysfile:=BoxFilename(box)+'.BBL';
    root:=nil;
    if exist(sysfile) then begin         { alte .BBL-Datei einlesen }
      assign(t,sysfile);
      reset(t);
      while not eof(t) do begin
        readln(t,s);
        if (s<>'') and (s[1]<>'#') then SetBrett(true,root);
        end;
      close(t);
      end;
    assign(t,datei);                     { Brett(ab)bestellungen einlesen }
    reset(t);
    while not eof(t) do begin
      readln(t,s);
      if (s<>'') and (s[1]>='a') then
        if bef='ADD' then SetBrett(true,root)
        else SetBrett(false,root);
      end;
    close(t);
    assign(t,sysfile);                   { neue .BBL-Datei schreiben }
    rewrite(t); syspos:=0; first:=false;
    syswrite(root);
    close(t);
    assign(t,datei);                     { neue (Ab)Bestellung schreiben }
    ReadBoxPar(nt_UUCP,box);
    dbOpen(d,BoxenFile,1);
    dbSeek(d,boiName,ustr(box));
    rewrite(t);
    writeln(t,'system: ',boxpar^.pointname,
                         iifs(boxpar^.BMdomain,dbReadStr(d,'domain'),''));
    writeln(t,'passwd: ',boxpar^.AreaPW);
    write(t,'sysentry: '); syspos:=30; first:=true;
    dbClose(d);
    syswrite(root);
    writeln(t);
    close(t);
    freelist(root);
    bef:='setsys';
    s:=mapsname+'@'+box+ntServerDomain(box);  { evtl. alten setsys-Befehl lschen }
    dbSeek(ubase,uiName,ustr(s));
    if dbFound then begin
      _brett:=mbrettd('U',ubase);
      dbSeek(mbase,miBrett,_brett+dup(4,#255));
      if dbEOF(mbase) then dbGoEnd(mbase)
      else dbSkip(mbase,-1);
      while not dbBOF(mbase) and (dbReadStrN(mbase,mb_brett)=_brett) and
            odd(dbReadInt(mbase,'unversandt')) do begin
        if dbReadStrN(mbase,mb_betreff)='setsys' then
          Unversandt(false,false);
        dbSkip(mbase,-1);
        end;
      end;
  end;

  procedure Guppie(typ:byte);   { 1=GUP, 2=AutoSys, 3=Feeder }
  var tn    : pathstr;
      t1,t2 : text;
      s     : string[120];
      d     : DB;
      domain: string[60];
  begin
    ReadBoxpar(0,box);
    tn:=TempS(_filesize(datei)*2);
    assign(t1,datei); reset(t1);
    assign(t2,tn); rewrite(t2);
    dbOpen(d,BoxenFile,1);
    dbSeek(d,boiName,ustr(box));
    if boxpar^.BMdomain then domain:=dbReadStr(d,'domain')
    else domain:='';
    case typ of
      1 : writeln(t2,'site ',boxpar^.pointname,domain,' ',boxpar^.AreaPW);
      2 : writeln(t2,'host ',boxpar^.pointname,domain,' ',boxpar^.AreaPW);
      3 : writeln(t2,'@id ',boxpar^.pointname,domain,' ',boxpar^.AreaPW);
    end;
    dbClose(d);
    writeln(t2);
    if (bef='ADD') or (bef='DEL') then begin
      if typ=3 then writeln(t2,'@append');
      while not eof(t1) do begin
        readln(t1,s);
        if (trim(s)<>'') and (s[1]<>'#') and (s[1]<>'-') then
          if (bef='ADD') then
            case typ of
              1 : writeln(t2,'include ',s);
              2 : writeln(t2,'add ',s);
              3 : writeln(t2,s);
            end
          else
            case typ of
              1 : writeln(t2,'delete ',s);
              2 : writeln(t2,'rem ',s);
              3 : writeln(t2,'!',s);
            end;
        end;
      if typ=3 then writeln(t2,'@end');
      end
    else
      writeln(t2,bef);
    if (bef<>'help') and (typ<>3) then writeln(t2,'quit');
    close(t1); erase(t1);
    close(t2); rename(t2,datei);
  end;

begin
  mt:=mapstype(box);
  nt:=ntBoxNetztyp(box);
  case mt of
    1 : AreaBef;
    2 : MafNude(true,false);
    3 : MafNude(false,false);
    5 : begin
          ReadBoxpar(nt,box);
          if (bef='ADD') or (bef='DEL') or (bef='') then
            bef:=boxpar^.AreaPW
          else
            bef:=boxpar^.AreaPW+' '+bef;
        end;
    6 : if bef='ADD' then bef:='BRETT +'
        else if bef='DEL' then bef:='BRETT -';
    7 : if (bef='ADD') or (bef='DEL') or (bef='setsys') then
          ChangeSys;
    8 : MafNude(false,true);   { ProNet }
    9 : begin
          mapsname:='SYSTEM';
          ControlMsg:=true;
        end;
   10 : begin
          mapsname:='ZQWK';
          bef:='CONFIG';
        end;
   11 : Guppie(1);
   12 : Guppie(2);
   13 : Guppie(3);
   14 : ;   { Postmaster }
  end;
  hf:='';
  _sendmaps:=true;
  forcebox:=box;
  if DoSend(true,datei,mapsname+'@'+box+ntServerDomain(box),bef,
            false,false,false,false,false,nil,hf,hf,0) then;
  _sendmaps:=false;
end;


procedure wr_btext(var t:text; del,news:boolean);
var bretter : string[15];
begin
  writeln(t,'##  ',getres2(800,1));   { 'Lieber Systemverwalter,' }
  writeln(t,'##');
  bretter:=getres2(800,iif(news,2,3));
  writeln(t,'##  ',getreps2(800,iif(del,4,5),bretter));
  writeln(t,'##');
  writeln(t,'##  ',getres2(800,6));   { 'mit virtuellen Gren' }
  writeln(t,'##     '+xp_xp+' ',verstr+betastr);
  writeln(t);
  writeln(t,dup(40,'-'));
  writeln(t);
  freeres;
end;


{ RFC/Client: Aus Brettlisten-Datei (Format: "Zeile faengt mit Brettnamen an") }
{ wird anhand des RC-Files im Client-Verzeichnis der Box ein BL-File erstellt: }

procedure MakeBL(box:string);
const
    MaxStr = 64;
var t1,t2         : text;
    bfile         : string[8];
    rcfile,blfile : pathstr;
    Line,Line2    : pathstr;
    Count,
    LineCount     : integer;
    marked        : boolean;
    Articles      : String;
    i, j          : Integer;
    x, y          : byte;
    brk           : boolean;
    LineArray: array[1..MaxStr] of String;

begin
  moment;
  bfile:=ustr(boxfilename(box));
  ReadBox(0,bfile,boxpar);
  rcfile:=BoxPar^.PPPClientPath + bfile +'.RC';
  Assign(t1,rcfile);       { BOX.RC }
  if not (exist(rcfile)) then
  begin
    Rewrite(t1);
    Close(t1);
  end;

    blfile:=bfile +'.BL';
    if not exist(rcfile) or not exist(blfile) then exit;
    Assign(t2,blfile);
    Reset(t2);
    Assign(t1,TempFile('')); { neues BL-File }
    Rewrite(t1);

    OpenList(1,80,4,screenlines-fnkeylines-1,-1,'/NS/NLR/M/SB/S/');
    list_readfile(rcfile,0);
    listNoAutoscroll;

    repeat   { bestellte Bretter markieren }
      i := 1;

      while (i<=MaxStr) and (not Eof(t2)) do
      begin
        Readln(t2, Line2);
        if line2[1]<>'!' then begin
          line2:='  '+left(line2,min(cposx('',line2),
            min(cposx(' ',line2),cposx('*',line2)))-1);

          line := first_line;
          while line <> #0 do
          begin
            if left(line,cpos(' ',line)-1)=mid(Line2,3)
            then begin
              Line2[1]:='*';
              line:=#0;
              end
            else line := next_line;
            end;

          lineArray[i]:=line2;
          inc(i);
          end;
        end;

      for j:=1 to i-1 do writeln(t1,LineArray[j]);

    until eof(t2);

    CloseList;
    signal; wkey(1,false);
    close(t2);
    close(t1);
    erase(t2);
    rename(t1,blfile);

  closebox;
end;


function Get_BL_Name(box:string):string;
var
  s1 : pathstr;
begin
  s1:=ustr(boxfilename(box));
  ReadBox(0,s1,boxpar);
  if not exist(s1+'.BL')                               { Brettliste im XP-Verzeichnis }
    then s1:=Boxpar^.PPPClientPath+s1;
  Get_BL_Name:=s1+iifs(exist(s1+'.BL'),'.BL','.GR');   { oder .BL/.GR im Client-Verz. }
end;


{ RFC/Client: RC-File anhand der im Lister markierten Bretter manipulieren }
{ Im Lister muss ein durch Read_RC_File erzeugtes BL-File sein.            }

function MakeRC(bestellen: boolean; const box: string):boolean;
var t1,t2         : text;
    f1            : file of char;
    bfile         : string[8];
    rcfile,blfile : pathstr;
    line          : string;
    Line2         : string[Brettlen];
    Articles      : String[6];
    fileofs       : Longint;
    x,y           : byte;
    c             : char;
    brk           : boolean;
label makercend;

begin
  moment;
  MakeRc:=true;
  bfile:=ustr(boxfilename(box));
  ReadBox(0,bfile,boxpar);
  rcfile:=BoxPar^.PPPClientPath + bfile +'.RC';
  blfile:=Get_BL_Name(box);
  if not exist(blfile) then
  begin
    rfehler(807);
    exit;
    end;
  Assign(t1,rcfile);
  if not (exist(rcfile)) then
  begin
    Rewrite(t1);                           { T1 = RC-FILE (Text)         }
    Close(t1);
    end;                                   { F1 = BL-FILE (File of Char) }
  Assign(f1,blfile);
  Reset(f1);

  if bestellen then                        { Neue Bretter an RC-File anhaengen }
  begin
    c:='*';
    Articles := '10';
    dialog(length(getres2(10800,40))+9,3,getres2(10800,39),x,y);  { 'Newsgroups bestellen' }
    maddstring(2,2,getres2(10800,40), Articles,4,4,'1234567890');  { 'Anzahl der Artikel'   }
    mhnr(11910);
    readmask(brk);
    enddialog;
    if brk then
    begin
      MakeRc:=false;
      goto MakeRCEnd;
      end;
    Append(t1);
    line := first_marked;                  { Im Lister sind markierte neue Bretter...}
    articles:=' -'+Articles;
    while line<>#0 do
    begin
      if line[1]='*' then List_unmark      { Bereits bestellte Bretter entmarkieren }
      else begin
        writeln(t1,rtrim(copy(Line,3,78)),Articles);    { ansonsten an .RC anhaengen }
        fileofs:=ival(mid(line,80));
        seek(f1,fileofs);                  { Offset ins BL-File wurde von READ_BL_FILE }
        write(f1,c);                       { an die Listerzeile angehaengt. Jetzt wird }
        end;                               { an den Zeilenanfang ein "*" geschrieben,  }
      line := next_marked;                 { der ab jetzt das Bestellt-Flag darstellt  }
      end;
    Close(t1);
    close(f1);
    end

  else begin                               { Bestellte Bretter aus RC entfernen }
    line:=first_line;
    c:=' ';
    MakeRc:=false;
    Assign(t2,TempFile(''));
    ReWrite(t2);                           { T2 = Temp-File: RC-Kopie (text) }
    reset(t1);
    while not eof(t1) do
    begin
      readln(t1,line2);                    { Zeile aus RC lesen }
      brk:=true;
      line := first_marked;                { Im Lister sind Bretter zum  }
      while line<>#0 do                    { Abbestellen markiert...     }
      begin
        fileofs:=ival(mid(line,80));       { Offset aus READ_BL_FILE (s.o.) }
        line:=rtrim(copy(Line,3,78));
        if line=left(line2,cposx(' ',line2)-1)
        then begin
          seek(f1,fileofs);                { Abzubestellendes Brett gefunden... }
          write(f1,c);                     { im BL-File "Bestellt"-'*' loeschen }
          list_unmark;                     { abbestelltes Brett demarkieren     }
          brk:=false;                      { und nicht in RC-Kopie uebernehmen  }
          end;
        line:=next_marked;
        end;
      if brk then writeln(t2,line2);       { Nicht abbestellte Zeilen kopieren  }
      end;
    close(f1);
    Close(t1);
    Close(t2);
    Erase(t1);
    Rename(t2,rcfile);                     { RC-File loeschen, TEMP-Kopie -> RC }
    end;

makercend:
  CloseList;
  InOutRes:=0;
  closebox;
end;



{ RFC/Client: Brettliste in Lister laden, Vorbereitung fuer MakeRC-Aktionen }

procedure Read_BL_File(s:string;bestellen:boolean);
var t1,t2    : text;
    s1,tname : string;
    i        : longint;
    n,m      : byte;

  Function Reformat_UKA_Brett(Var s:string):byte; Assembler;
  asm
        push ds                  { Brettlisten-Zeilen im UKA* Format vor der        }
        lds si,s                 { Uebergabe an den Lister ins XP-Format bringen    }
        xor ax,ax                { und Offsetanpassung fuer Bestellt-Flag ermitteln }
        cmp byte ptr [si+2],' '
        je @end                  { Abbruch wenn's eine Liste im XP-Format ist... }
        push si
        lodsb
        mov cx,ax
        mov bl,0
        mov dx,' *'
  @1:   lodsb                    { Brettnamenende suchen }
        cmp al,dh
        je @2
        cmp al,''               {  und * werden als Bestellt-Flag akzeptiert }
        je @3
        cmp al,dl
        je @3
        inc bx
        loop @1
  @2:   mov dl,' '
  @3:   push ds
        pop es
        pop si
        mov cl,bl
        add bl,2
        push bx                  { Offset zum Flag in UKA-Brettliste sichern }
        mov byte ptr [si],bl
        add si,cx
        lea di,[si+2]
        std
        rep movsb                { s:='* '+s }
        dec di
        mov ax,dx
        stosw
        cld
        pop ax
  @end: pop ds
  end;

begin
  moment;
  assign(t1,s);
  reset(t1);
  tname:=TempFile('');
  assign(t2,tname);
  Rewrite(t2);
  i:=0;
  readln(t1,s1);
  if s1[1]='!' then i:=length(s1)
   else reset(t1);
  while not eof(t1) do
  begin
    readln(t1,s1);
    m:=length(s1)+2;
    n:=reformat_UKA_Brett(s1);
    if bestellen or (s1[1]='*') then       { File-Offset des Strings wird angehaengt,  }
     writeln(t2,forms(s1,80)+strs(i+n));   { damit MakeRC schnellen Zugriff hat, um im }
    inc(i,m);                              { BL-File den '*' zu setzen bzw zu loeschen }
    end;
  close(t1);
  close(t2);
  list_readfile(tname,0);        { App_L kann hier nicht verwendet werden, weil es }
  listheader(s);                 { zu verschwenderisch mit den EMS-Handles umgeht. }
  _era(tname);
  closebox;
end;


{ RFC/Client: Bretter anhand eines Files abbestellen (Brettfenster) }

procedure File_abbestellen(const box,f:string);
var t1,t2 : text;
    s1,s2 : string;
    brk   : boolean;
begin
  s1:=Get_BL_Name(box);
  if not exist(s1) then
  begin
    rfehler(807);
    exit;
    end;
  OpenList(1,80,4,4,-1,'/M/SB/S/');        { Dummy-Lister }
  read_BL_File(s1,false);                  { Bestellt-Liste in Lister laden }
  pushkey(^A);                             { Ctrl+A = Alles markieren  }
  pushkey(keyesc);                         { Esc    = Lister verlassen }
  list(brk);                               { Dummy-Lister starten      }

  assign(t1,f);
  s1:=first_marked;                        { Liste der bestellten Bretter     }
  while s1<>#0 do                          { Mit Abbestell-File vergleichen   }
  begin
    brk:=true;
    reset(t1);
    while not eof(t1) do
    begin
      readln(t1,s2);
      if s2=rtrim(copy(s1,3,78))
        then brk:=false;                   { Bretter, die abzubestellen sind }
      end;
    close(t1);
    if brk then list_unmark;               { werden NICHT entmarkiert        }
    s1:=next_marked;
    end;
  makeRC(false,box);                       { (Noch) markierte Bretter abbestellen }
  aufbau:=true;
end;


Procedure ClientBl_Abgleich(const box:string);
var t1      : text;
    f1      : file of char;
    c       : char;
    s1,s2   : string;
    brk     : boolean;
    fileofs : longint;
begin

  ReadBox(0,ustr(boxfilename(box)),boxpar);
  s1:=BoxPar^.PPPClientPath + ustr(boxfilename(box)) + '.RC';
  Assign(t1,s1);       { BOX.RC }
  if not (exist(s1)) then
  begin
    Rewrite(t1);                           { T1 = RC-FILE (Text)         }
    Close(t1);
    end;
  s1:=get_BL_Name(box);
  if not exist(s1) then
  begin
    rfehler(807);
    exit;
    end;
  if not ReadJN(getreps2(810,92,ustr(s1)),true) then exit;  { 'Abgleich RC-Datei mit %s' }

  moment;
  OpenList(1,80,4,4,-1,'/M/SB/S/');        { Dummy-Lister }
  listTp(Mapskeys); 
  read_BL_File(s1,true);                   { Bestellt-Liste in Lister laden }
  pushkey(^A);                             { Ctrl+A = Alles markieren  }
  pushkey(keyesc);                         { Esc    = Lister verlassen }
  list(brk);                               { Dummy-Lister starten      }
  assign(f1,s1);
  reset(f1);
  s1:=first_marked;                        { Brettliste mit .RC vergleichen }
  while s1<>#0 do
  begin
    brk:=false;
    reset(t1);
    while not eof(t1) do
    begin
      readln(t1,s2);
      if left(s2,cposx(' ',s2)-1)=rtrim(copy(s1,3,78))
        then brk:=true;
      end;
    close(t1);
    if (s1[1]='*') xor brk
    then begin
      fileofs:=ival(mid(s1,80));
      c:=iifc(brk,'*',' ');
      seek(f1,fileofs);
      write(f1,c);
      end;
    s1:=next_marked;
    end;
  close(f1);
  CloseList;
  closebox;
  aufbau:=true;
end;

Procedure ClientBL_Sort(const box:string);
var   blfile : pathstr;
      tempBl : pathstr;
const sorter : string[12] = 'RPSORT.COM';
begin
  blfile:=get_BL_Name(Box);
  if not exist(blfile) then
  begin
    rfehler(807);         { Keine Brettliste fr diese Box vorhanden! }
    exit;
    end;
  if not exist(ownpath+sorter) then
  begin
    rfehler1(907,sorter); { Achtung! Das Programm "%s" ist nicht vorhanden! }
    exit;
    end;
  TempBl:=TempS(_Filesize(blfile));
  moment;
  shell(sorter+' /q /a /b /d /n /z '+blfile+' '+TempBl
   +iifs(cpos('\',blfile)=0,' /+3',''),640,0);
  if (errorlevel=0) and (exist(TempBl)) then
    copyfile(TempBl,blfile)
  else rfehler(838);      { Sortierung der Newsgroup-Liste ist fehlgeschlagen! }
  ExErase(Tempbl);
  closebox;
end;

Procedure ClientBL_Del(const box:string);
var s1: string;
begin
  s1:=get_BL_Name(Box);
  if ReadJN(getreps2(810,93,Left(s1, 60)),false) then _era(s1);  { '%s wirklich lschen' }
end;


{ bbase-aktuelles Brett abbestellen  }
{ brett='' -> markierte Bretter abb. }


procedure MapsDelBrett(brett:string);
const maxmaggi = 500;

type maggibrett  = record
                     code  : string[4];
                     name  : string[40];
                   end;
    ma           = array[1..maxmaggi] of maggibrett;
var t          : text;
    fn         : pathstr;
    box        : string[20];
    i,nr       : integer;
    d          : DB;
    topen      : boolean;
    maf        : boolean;
    maus       : boolean;
    quick      : boolean;
    fido       : boolean;
    gs         : boolean;
    uucp       : boolean;
    postmaster : boolean;
    client     : boolean;
    pronet     : boolean;
    qwk,brk    : boolean;
    map        : ^ma;
    mm         : integer;
    bfile      : string[8];

  { s. auch MAGGI.loadbretter! }

  procedure ReadBrettliste;
  var t : text;
      s : string;
  begin
    mm:=0;
    assign(t,bfile+'.BL');
    reset(t);
    if ioresult=0 then begin
      message(getreps(801,ustr(box)));   { 'Brettliste fr %s laden...' }
      while (mm<maxmaggi) and not eof(t) do begin
        readln(t,s);
        if maf then begin
          inc(mm);
          if s[41]<>' ' then
            map^[mm].code:=copy(s,41,4)
          else
            map^[mm].code:=trim(copy(s,41,6));
          s:=trim(left(s,40));
          if left(s,1)<>'/' then s:='/'+s;
          while cpos(' ',s)>0 do s[cpos(' ',s)]:='_';
          map^[mm].name:=ustr(s);
          end
        else   { ProNet }
          if left(s,1)<>';' then begin
            inc(mm);
            map^[mm].code:=left(s,4);
            map^[mm].name:=trim(mid(s,32));
            end;
        end;
      close(t);
      closebox;
      end;
    if ioresult<>0 then;
  end;

  function brettcode(brett:string):string;
  var i : integer;
  begin
    UpString(brett);
    i:=1;
    while (i<=mm) and (brett<>map^[i].name) do inc(i);
    if i<=mm then brettcode:=map^[i].code
    else brettcode:='';
  end;

  procedure GetDel(txt:string);
  var width,x,y : byte;
      t         : taste;
  begin
    width:=max(33,length(txt)+5);
    diabox(width,5,'',x,y);
    mwrt(x+2,y+1,txt+'?');
    t:='';
    nr:=readbutton(x+2,y+3,2,getres(802),1,true,t);   { '  ^Ja  , ^Nein , ^Liste ' }
    closebox;
  end;

  function newsgroup(s:string):string;
  var i : integer;
  begin
    delete(s,1,2);
    for i:=1 to length(s) do
      if s[i]='/' then s[i]:='.';
    newsgroup:=s;
  end;

  function qwkbrett(brett:string):string;
  var t : text;
      s : string[80];
  begin
    brett:=ustr(mid(brett,length(boxpar^.magicbrett)+2));
    assign(t,bfile+'.BL');
    qwkbrett:='';
    if existf(t) then begin
      reset(t);
      while not eof(t) do begin
        readln(t,s);
        if pos(brett,ustr(s))>0 then
          qwkbrett:=left(s,3);
        end;
      close(t);
      end;
  end;

begin
  if brett='' then
    if bmarkanz=0 then
      nr:=3
    else
      GetDel(getreps(803,strs(bmarkanz)))   { '%s markierte Bretter abbestellen' }
  else
    if left(brett,1)<>'A' then
      nr:=3
    else
      GetDel(getreps(804,copy(brett,2,40)));   { '%s abbestellen' }
  if nr=3 then
    MapsBrettliste(1)
  else if nr=1 then begin
    if brett<>'' then begin
      dbReadN(bbase,bb_pollbox,box);
      if box='' then begin
        rfehler(802);   { 'Dieses Brett hat keine Serverbox!' }
        exit; end;
      if not IsBox(box) then begin
        rfehler1(803,box);   { 'Unbekannte Serverbox: %s' }
        exit; end;
      if not BoxHasMaps(box) then exit;
      end;
    new(map);
    fn:=TempS(10000);
    assign(t,fn);
    if brett<>'' then begin
      maf:=false; maus:=false; quick:=false; fido:=false; gs:=false;
      uucp:=false; pronet:=false; qwk:=false; client:=false;
      postmaster:=false;
      case mapstype(box) of
        2 : maf:=true;
        3 : maus:=true;
        4 : quick:=true;
        5 : fido:=true;
        6 : gs:=true;
        7 : uucp:=true;
        8 : pronet:=true;
       10 : qwk:=true;
       11..13 : uucp:=true;
       14 : begin uucp:=true; postmaster:=true; end;
       16 : client:=true;
      end;
      rewrite(t);
      if quick or (uucp and postmaster) then
        wr_btext(t,true,uucp);
      if maus or fido or qwk then
      begin
        ReadBoxPar(0,box);
        if copy(ustr(brett),2,length(boxpar^.magicbrett))=ustr(boxpar^.magicbrett)
        then
          if qwk then begin
            bfile:=boxfilename(box);
            writeln(t,'DROP ',qwkbrett(brett));
            end
          else begin
            if fido then write(t,'-');
            writeln(t,mid(brett,length(boxpar^.magicbrett)+2));
            end;
        end
      else if not maf then
        if gs then writeln(t,copy(brett,3,brettlen))
        else if uucp or client then writeln(t,newsgroup(brett))
        else writeln(t,copy(brett,2,brettlen))
      else begin
        dbOpen(d,OwnPath+BoxenFile,1);
        dbSeek(d,boiName,ustr(box));
        if dbFound then begin
          dbRead(d,'dateiname',bfile);
          ReadBrettliste;
          writeln(t,brettcode(copy(brett,2,40)));
          end;
        dbClose(d);
        end;
      if fido then
        writeln(t,'---');
      close(t);
      if not client then SendMaps('DEL',box,fn)
      else begin
        rewrite(t);
        writeln(t,newsgroup(brett));
        close(t);
        File_Abbestellen(box,fn);
        end;
      end
    else begin   { mehrere markierte Bretter }
      dbOpen(d,OwnPath+BoxenFile,1);
      while not dbEOF(d) do begin
        topen:=false;
        box:=dbReadStr(d,'boxname');
        maf:=ntMAF(dbReadInt(d,'netztyp'));
        quick:=ntQuickMaps(dbReadInt(d,'netztyp'));
        maus:=ntNude(dbReadInt(d,'netztyp'));
        fido:=ntAreaMgr(dbReadInt(d,'netztyp'));
        gs:=(dbReadInt(d,'netztyp')=nt_GS);
        uucp:=(dbReadInt(d,'netztyp')=nt_UUCP);
        client:=(dbReadInt(d,'netztyp')=nt_Client);
        pronet:=(dbReadInt(d,'netztyp')=nt_Pronet);
        qwk:=(dbReadInt(d,'netztyp')=nt_QWK);
        dbRead(d,'dateiname',bfile);
        if maus or fido or qwk or uucp then
          ReadBox(0,bfile,boxpar);
        for i:=0 to bmarkanz-1 do begin
          dbGo(bbase,bmarked^[i]);
          if ustr(dbReadStrN(bbase,bb_pollbox))=ustr(box) then begin
            if not topen then begin
              rewrite(t);
              if quick or (uucp and (boxpar^.BMtyp=bm_postmaster)) then
                wr_btext(t,true,uucp);
              if maf or pronet then ReadBrettliste;
              end;
            dbReadN(bbase,bb_brettname,brett);
            if maus or fido or qwk then begin
              if copy(ustr(brett),2,length(boxpar^.magicbrett))=
                 ustr(boxpar^.magicbrett)
              then
                if qwk then writeln(t,'DROP ',qwkbrett(brett))
                else begin
                  if fido then write(t,'-');
                  writeln(t,mid(brett,length(boxpar^.magicbrett)+2));
                  end;
              end
            else
              if not (maf or pronet) then
                if gs then writeln(t,copy(brett,3,brettlen))
                else if uucp or client then writeln(t,newsgroup(brett))
                else writeln(t,copy(brett,2,BrettLen))
              else writeln(t,brettcode(mid(brett,2)));
            topen:=true;
            end;
          end;
        if topen then begin
          if fido then
            writeln(t,'---');
          close(t);
          if not client then SendMaps('DEL',box,fn)
            else File_Abbestellen(box,fn);
          topen:=false;
          end;
        dbSkip(d,1);
        end;
      dbClose(d);
      end;
    if existf(t) then erase(t);
    dispose(map);
    end;
end;


{ Unterprozeduren fr MapsReadList und MapsReadFile }

function ReadMafList(fn:pathstr; var bfile:string):boolean;
var t1,t2 : text;
    s     : string;
    ss    : string[40];

  function zok:boolean;
  begin
    zok:=pos('bestellt',lstr(s))>40;
  end;

begin
  assign(t1,fn); reset(t1);
  s:='';
  while not eof(t1) and not zok do readln(t1,s);
  if eof(t1) then begin
    closebox;
    fehler('Nachricht ist keine MAF-Brettliste!');
    ReadMaflist:=false;
    end
  else begin
    assign(t2,bfile+'.BL'); rewrite(t2);
    repeat
      if zok then begin
        ss:=trim(left(s,40));
        while cpos(' ',ss)>0 do ss[cpos(' ',ss)]:='_';
        writeln(t2,forms(boxpar^.MagicBrett+ss,40),mid(s,41));
        end;
      readln(t1,s);
    until eof(t1);
    close(t2);
    closebox;
    ReadMaflist:=true;
    end;
  close(t1);
end;

procedure ReadPromafList(fn:pathstr; var bfile:string);
var t1,t2 : text;
    s     : string;
begin
  assign(t1,fn); reset(t1);
  s:='';
  assign(t2,bfile+'.BL'); rewrite(t2);
  repeat
    readln(t1,s);
    if (s[1]=';') or (s[32]<>'/') then
      writeln(t2,s)
    else
      writeln(t2,left(s,31),left(BoxPar^.MagicBrett,length(Boxpar^.Magicbrett)-1),
                 mid(s,32));
  until eof(t1);
  close(t1);
  close(t2);
  closebox;
end;

procedure MapsReadList;
var absender : string[Adrlen];
    box      : string[BoxNameLen];
    betreff  : string[BetreffLen];
    d        : DB;
    bfile    : string[8];
    fido     : boolean;
    turbo    : boolean;
    uucp     : boolean;
    client   : boolean;
    fn       : pathstr;
    bpsik    : BoxPtr;
    i        : byte;
label ende;
begin
  dbReadN(mbase,mb_absender,absender);
  dbReadN(mbase,mb_betreff,betreff);
  box:=systemname(absender);
  dbOpen(d,BoxenFile,1);
  dbSeek(d,boiName,ustr(box));
  if dbFound then
    dbRead(d,'dateiname',bfile)
  else
    if automessaging then begin
      trfehler1(804,box,20);   { 'unbekannte Box (%s) - Brettliste wurde nicht eingelesen' }
      dbClose(d);
      exit;
      end
    else begin
      box:=UniSel(1,false,'');
      if box='' then begin
        dbClose(d);
        exit;
        end
      else
        bfile:=BoxFilename(box);
      end;

  dbClose(d);
  fido:=(mapstype(box)=5);
  turbo:=(mapstype(box)=9);
  uucp:=(mapstype(box) in [7,11]);
  client:=(mapstype(box)=16);
  bpsik:=boxpar;
  new(boxpar);
  ReadBox(0,bfile,boxpar);
  if client then
  begin
    if deutsch then
    begin
      pushkey('N');
      pushkey('M');
      pushkey('D');
    end
    else begin
      pushkey('M');
      pushkey('M');
      pushkey('F');
    end;
    for i:=1 to length(box) do pushkey(box[i]);
    pushkey(keycr);
    exit;
  end;
  if mapstype(box) in [2,8] then begin
    message('Brettliste fr '+ustr(box)+' wird eingelesen ...');
    fn:=TempS(dbReadInt(mbase,'msgsize'));
    extract_msg(0,'',fn,false,0);
    case mapstype(box) of
      2 : if ReadMaflist(fn,bfile) then;
      8 : ReadPromafList(fn,bfile);
    end;
    _era(fn);
    end
  else begin
    if (pos('BRETT',ustr(betreff))=0) and (betreff<>'Gruppenliste') and
       (pos('list',lstr(betreff))=0) and
      not (fido or turbo or uucp)
      and not ReadJN(getres(805),true) then   { 'Sind Sie sicher, da das eine Brettliste ist' }
      goto ende;
    if cpos('@',absender)=0 then
      trfehler(805,60)    { 'Ungltige Absenderangabe' }
    else begin
      message(getreps(806,ustr(box)));   { 'Brettliste fr %s wird eingelesen ...' }
      makebak(bfile+'.BL','BAK');
      fn:=TempS(dbReadInt(mbase,'msgsize'));
      extract_msg(xTractMsg,'',fn,false,0);
      ExpandTabs(fn,bfile+'.BL');
      _era(fn);
      wkey(1,false);
      closebox;
      end;
    end;
ende:
  dispose(boxpar);
  boxpar:=bpsik;
end;


{ Brettliste aus Datei nach .BL einlesen }

procedure MapsReadFile;
var box     : string[BoxNameLen];
    fn      : pathstr;
    useclip : boolean;
    d       : DB;
    maggi   : boolean;
    promaf  : boolean;
    client  : boolean;
    bfile   : string[8];
begin
  box:=UniSel(1,false,DefaultBox);
  if box='' then exit;   { brk }
  dbOpen(d,BoxenFile,1);
  dbSeek(d,boiName,ustr(box));
  dbRead(d,'dateiname',bfile);
  dbClose(d);
  ReadBox(0,bfile,boxpar);
  client:=(mapstype(box)=16);
  if not client then fn:='*.*' else
  begin
    fn:=BoxPar^.PPPClientPath + ustr(boxfilename(box));
    fn:=fn+iifs(exist(fn+'.BL'),'.BL',iifs(exist(fn+'.GR'),'.GR','.BL'));
    end;
  useclip:=true;
  if not ReadFilename(getres(821),fn,true,useclip) then exit;  { 'Brettliste einlesen' }
  if not exist(fn) then
  begin
    hinweis(getres2(10800,23)); { Datei nicht gefunden }
    exit;
    end;
  maggi:=(mapstype(box)=2);     { MagicNet }
  promaf:=(mapstype(box)=8);
(*
  dbOpen(d,BoxenFile,1);
  dbSeek(d,boiName,ustr(box));
  dbRead(d,'dateiname',bfile);
  dbClose(d);
  ReadBox(0,bfile,boxpar);
*)
  message(getreps(806,ustr(box)));   { 'Brettliste fr %s wird eingelesen ...' }
  if maggi then
    if not ReadMafList(fn,bfile) then exit
    else
  else if promaf then
    ReadPromafList(fn,bfile)
  else begin
    ExpandTabs(fn,bfile+'.BL');
    closebox;
    end;
  if client then makebl(box);
  (*else*) if useclip or ReadJN(getreps(817,fn),false) then    { '%s lschen' }
    _era(fn);
end;


function BrettMark(var s:string; block:boolean):boolean;
begin
  BrettMark:=false;
  if (trim(s)='') or
     ((mapsnt=nt_Pronet) and ((s[8]='-') or (s[1] in [';','-']) or (left(s,4)='CODE')))
  then begin
    if not block then errsound;
    end
  else if (mapsnt=nt_ZConnect) and (mapsart=0) and (firstchar(s)='-') then
    rfehler(826)     { 'Dieses Brett kann nicht bestellt werden.' }
  else if (mapsnt=nt_ZConnect) and (mapsart=1) and (firstchar(s)='!') then
    rfehler(827)     { 'Dieses Brett kann nicht abbestellt werden.' }
  else begin
 {   if mapsnt=41 then s[1]:='*';   }
    BrettMark:=true;
    end;
end;


var LcolType : byte;  { 0=nix, 1=Z, 2=Maus, 3=ProNet, 4=Fido }

function MapsListcolor(var s:string; line:longint):byte;
begin
  MapsListcolor:=col.collisttext;
  case LColType of
    1 :   if (length(s)>2) and ((s[1]='J') or (s[1] in ['+','!'])) then
            MapsListcolor:=col.ColMapsBest;
    2,4 : if (length(s)>2) and (s[1]='+') then
            MapsListcolor:=col.colMapsBest;
    3 :   if (s[1]<>';') and (s[8]='X') then
            MapsListcolor:=col.colMapsBest;
    5 :   if s[1]='*' then MapsListcolor:=col.collistmarked;
  end;
end;

procedure MapsKeys(var t:taste);
begin

  if t=keytab then t:=keyctab
  else if (t=keyctab) or (t=keystab) then t:=keytab;

  if t=^S then t:='s'
  else if t='s' then
  begin
    t:='';
    if Suche(getres(438),'#','') then
    begin
      ListShowSeek:=true;
      t:=keyctab;
      end;
    end;

{  if t=^S then if Suche(getres(438),'#','') then begin
    ListShowSeek:=true;
    pushkey(keyctab);
    end; }

  if ustr(t)='E' then ListShowSeek:=not Listshowseek;

  if t[1]=^H then begin
    pushkey('S');
    pushkey('* ');
    pushkey(keycr);
  end;

end;

{ art: 0=bestellen, 1=abbestellen, 2=Bretter anlegen, 3=Inhalt (EM), 4=Rescan }

procedure MapsBrettliste(art:byte);
var d      : DB;
    box    : string[BoxNameLen];
    fn     : string;
    brk    : boolean;
    t      : text;
    s      : string;
    anz    : longint;
    netztyp: byte;
    maf    : boolean;
    promaf : boolean;
    quick  : boolean;
    maus   : boolean;
    fido   : boolean;
    gs     : boolean;
    uucp   : boolean;
    client : boolean;
    changesys  : boolean;
    postmaster : boolean;
    qwk    : boolean;
    ask    : string[60];
    bretter: string[15];
    lfile  : string;
    verbose: boolean;

label again;

  function fidobrett(s:string):string;
  var p : byte;
  begin
    s:=trim(s);
    p:=cpos(' ',s);
    if p=2 then begin
      s:=trim(mid(s,3)); p:=cpos(' ',s); end;
    if p=0 then p:=cpos(#9,s);
    if p>0 then s:=left(s,p-1);
    if s[1]='+' then delfirst(s);
    if s[1]='*' then delfirst(s);
    p:=pos('....',s);         { direkt angehngten Kommentar abschneiden }
    if p>0 then truncstr(s,p-1);
    fidobrett:=s;
  end;

  procedure writeform;
  var p  : byte;
      gr : string[78];
  begin
    if maf then
      if s[41]<>' ' then
        writeln(t,copy(s,41,4))
      else
        writeln(t,trim(copy(s,41,6)))
    else if promaf then
      writeln(t,left(s,4))
    else if maus then begin
      p:=13;
      while (p<length(s)) and (s[p]<>' ') do inc(p);
      gr:=trim(copy(s,3,p-2));
      if left(gr,1)='?' then delfirst(gr);    { geheime Gruppe }
      if (length(gr)=11) and (gr[10]=' ') then
        gr:=trim(left(gr,length(gr)-1));
      writeln(t,gr);
      end
    else if fido then begin
      if (art=0) and boxpar^.AreaPlus then
        write(t,'+');
      if art=1 then write(t,'-');
      s:=fidobrett(s);
(*      if (art=4) and not BoxPar^.areabetreff then
        s:=s+' -R'; {'%Rescan '+s;}     { rescan } *)
      writeln(t,s);
      end
    else if qwk then begin
      if art=0 then write(t,'ADD ')
      else write(t,'DROP ');
      writeln(t,left(s,3));
      end
    else begin
      s:=trim(s);
      if length(s)<2 then exit;
      p:=cpos(' ',s);
      if p=0 then p:=pos(#9,s);
      if p>0 then
        if uucp or client then
          s:=left(s,p-1)
        else begin
          if p<5 then
            s:=copy(s,p+1,80);
          if cpos(' ',s)>0 then
            s:=copy(s,1,cpos(' ',s)-1);
          end;
      if s='' then exit;
      if not (quick or gs or uucp or client) and (s[1]<>'/') then
        write(t,'/');  { Euromail }
      writeln(t,s);
      end;
  end;

  procedure BretterAnlegen;
  var x,y : byte;
      n   : longint;
      s   : string[100];
      i   : integer;
  begin
    msgbox(30,5,'',x,y);
    mwrt(x+3,y+2,getres2(807,10));   { 'Bretter anlegen ...' }
    n:=0;
    s:=first_marked;
    while s<>#0 do begin
      if quick then
        for i:=1 to length(s) do
          if s[i]='/' then s[i]:='\'
          else if s[i]='\' then s[i]:='/';
      if uucp then
        for i:=1 to length(s) do
          if s[i]='.' then s[i]:='/';
      if maf then makebrett(trim(left(s,40)),n,box,netztyp,true) else
      if promaf then makebrett(trim(mid(s,32)),n,box,netztyp,true) else
      if maus then begin
        s:=trim(mid(s,3));
        if left(s,1)='?' then delfirst(s);  { geheime Gruppen }
        makebrett(boxpar^.MagicBrett+s,n,box,netztyp,true);
        end else
      if fido then
        makebrett(boxpar^.MagicBrett+fidobrett(s),n,box,netztyp,true)
      else if qwk then
        makebrett(boxpar^.MagicBrett+trim(copy(s,4,50)),n,box,netztyp,true)
      else makebrett(s,n,box,netztyp,true);
      moff;
      gotoxy(x+22,y+2); write(n:5);
      mon;
      s:=next_marked;
      end;
    closebox;
    dbFlushClose(bbase);
    aufbau:=true;
  end;

  procedure BretterAnlegen2;
  var x,y : byte;
      n   : longint;
      s   : string;
      i   : integer;
      t1: text;
  begin
    msgbox(30,5,'',x,y);
    mwrt(x+3,y+2,getres2(807,10));   { 'Bretter anlegen ...' }
    n:=0;
    assign(t1, fn);
    reset(t1);
    while not eof(t1) do
    begin
      readln(t1, s);
      for i:=1 to length(s) do
        if s[i]='.' then s[i]:='/';
      if s[1]='*' then s[1]:=' ';
      makebrett(trim(s),n,box,netztyp,true);
      moff;
      gotoxy(x+22,y+2); write(n:5);
      mon;
    end;
    Close(t1);
    closebox;
    dbFlushClose(bbase);
  end;

begin
  if mapsbox='' then
  begin
    box:=UniSel(1,false,DefaultBox);
    if box='' then exit;   { brk }
  end else
    box:=mapsbox;
  if not BoxHasMaps(box) then exit;
  dbOpen(d,BoxenFile,1);
  dbSeek(d,boiName,ustr(box));
  if dbFound then
  begin
    dbRead(d,'dateiname',fn);
    netztyp:=dbReadInt(d,'netztyp');
    dbRead(d,'nameomaps',mapsname);
    maf:=ntMAF(netztyp);
    promaf:=ntProMAF(netztyp);
    quick:=ntQuickMaps(netztyp);
    maus:=ntNude(netztyp);
    fido:=ntAreamgr(netztyp);
    gs:=(netztyp=nt_GS);
    uucp:=(netztyp=nt_UUCP);
    client:=(netztyp=nt_Client);
    if uucp then
    begin
      ReadBoxpar(netztyp,box);
      changesys:=(boxpar^.BMtyp=bm_changesys);
      postmaster:=(boxpar^.BMtyp=bm_postmaster);
    end;
    qwk:=(netztyp=nt_QWK);
  end else
  begin
    fn:='';
    maf:=false; quick:=false; maus:=false; fido:=false; gs:=false;
    uucp:=false; promaf:=false; qwk:=false; postmaster:=false;
    client:=false; netztyp:=0;
  end;
  dbClose(d);
  if fn='' then
  begin
    rfehler(806);      { 'BOXEN.IX1 ist defekt - bitte lschen!' }
    Exit;
  end;

  if (art=1) and exist(fn+'.BBL') and changesys and (not client) then
    lfile:=fn+'.BBL' else

  if client then
  begin
    ReadBoxpar(netztyp,box);
    if not exist(fn+'.BL')
      then fn:=Boxpar^.PPPClientPath+fn;
    lfile:=fn+iifs(exist(fn+'.BL'),'.BL','.GR');
  end
  else lfile:=fn+'.BL';

  if not exist(lfile) or (_fileSize(lfile) = 0) then
  begin
    rfehler(807);    { 'Keine Brettliste fr diese Box vorhanden!' }
    Exit;
  end;
  if fido or maus or qwk then
    ReadBoxpar(netztyp,box);
  OpenList(1,iif(_maus,79,80),4,screenlines-fnkeylines-1,4,'/M/SB/S/NLR/'+
             'APGD/'+iifs(_maus,'VSC:080/',''));

  if client then Read_BL_File(lfile,art=0)
    else list_readfile(lfile,0);
  case art of
    0 : showkeys(9);
    1 : showkeys(-9);
    2 : showkeys(12);
    3 : showkeys(9);
    4 : showkeys(12);
  end;
again:
  listVmark(BrettMark); mapsnt:=netztyp; mapsart:=art;
  if maus then LColType:=2 else
  if fido then lcoltype:=4 else
  if maf or quick then LColType:=0 else
  if promaf then lcoltype:=3 else
  if client and (art=0) then lcoltype:=5 else
    LColType:=1;
  ListCFunc(MapsListcolor);
  listTp(Mapskeys);
  listseekcol:=col.collistfound;
  listNoAutoscroll;
  ListShowSeek:=false;
  list(brk);
  if not brk then
  begin
    anz:=list_markanz;
    if anz=0 then anz:=1;
    if (mapsnt=nt_ZConnect) and (anz=1) then
    begin
      if (art=0) and (firstchar(first_marked)='-') then
      begin
        rfehler(826);   { 'Dieses Brett kann nicht bestellt werden.' }
        goto again;
      end;
      if (art=1) and (firstchar(first_marked)='!') then
      begin
        rfehler(827);   { 'Dieses Brett kann nicht abbestellt werden.' }
        goto again;
      end;
    end;
    if client and (anz=1) and (art=0) and
      (firstchar(first_marked)='!') then
    begin
      rfehler(826);   { 'Dieses Brett kann nicht bestellt werden.' }
      goto again;
    end;
    bretter:=getres2(807,iif(anz=1,1,2));
    case art of
        0 : ask:=reps(reps(getreps2(807,3,strs(anz)),bretter),box);
        1 : ask:=reps(reps(getreps2(807,4,strs(anz)),bretter),box);
        2 : ask:=reps(getreps2(807,5,strs(anz)),bretter);
      3,4 : ask:=getres2(807,6);   { 'Inhalt der gewhlten Bretter anfordern' }
    end;
    if not ReadJN(ask,true) then
      goto again;
    if art in [0,1,3,4] then
    begin
      fn:=TempS(10000);
      assign(t,fn);
      rewrite(t);
      if quick or (uucp and postmaster) then
        wr_btext(t,art<>0,uucp);
      s:=first_marked;
      if fido and (art=4) and not Boxpar^.areabetreff then
        writeln(t,'%Rescan');
      while s<>#0 do begin
        writeform;
        s:=next_marked;
      end;
      if fido then writeln(t,'---');
      close(t);
      if (not client) and (art=0) and (uucp or (netztyp=nt_ZConnect)) then
        BretterAnlegen;
      if art=3 then
        verbose:=ReadJN(getres2(810,20),false);  { 'ausfhrliche Liste' }
      if not client then
        case art of
          0 : sendmaps('ADD',box,fn);
          1 : sendmaps('DEL',box,fn);
          3 : sendmaps('INHALT'+iifs(verbose,' VERBOSE',''),box,fn);
          4 : sendmaps(iifs(BoxPar^.AreaBetreff,'-r',''),box,fn);
        end;
      if client and (art in [0,1]) then
        if MakeRC(art=0,box) then
          BretterAnlegen2;
      erase(t);
    end else
      BretterAnlegen;
    if not client then closelist;  { RFC/Client schliet den Lister selbst }
  end else
    CloseList; { Lister bei Brk schlieen }
  freeres;
  aufbau:=true;
  ListShowSeek:=false;
end;

procedure MapsCommands(defcom:byte);   { 0=Auswahl, 1=Brettliste holen }
var brk        : boolean;
    comm       : string;
    box        : string[BoxNameLen];
    t          : text;
    fn         : pathstr;
    d          : DB;
    area       : boolean;
    request    : boolean;
    nt         : byte;
    maf        : boolean;
    maus       : boolean;
    info       : MausInfAP;
    infos      : integer;
    fido       : boolean;
    gs         : boolean;
    uucp,gup   : boolean;
    client     : boolean;
    autosys    : boolean;
    feeder     : boolean;
    postmaster : boolean;
    promaf     : boolean;
    lines      : byte;
    i          : integer;
    domain     : string[60];
    var x,y,j  : byte;

  procedure app(s1,s2:string);
  begin
    app_l(' '+forms(s1,iif(maus,8,iif(fido or client or
                                     (uucp and not gup),15,20)))+s2);
  end;

  procedure rdsystem;
  var x,y : byte;
      sys : string[BoxNameLen];
      brk : boolean;
  begin
    diabox(28,5,getres(808),x,y);   { 'Info <System>' }
    sys:='';
    readstring(x+3,y+2,getres(809),sys,8,8,'>',brk);   { 'Systemname' }
    closebox;
    if brk then comm:=''
    else comm:='INFO '+sys;
  end;

  procedure rdthema;
  begin
    case minisel(33,10+(screenlines-25)div 2,'Thema',
                 '^HILFE,^INFO,^LIST,^SCRIPT,^STATUS,^VERSION,^ADD,^DEL',1) of
      1 : comm:='HILFE HILFE';
      2 : comm:='HILFE INFO';
      3 : comm:='HILFE LIST';
      4 : comm:='HILFE SCRIPT';
      5 : comm:='HILFE STATUS';
      6 : comm:='HILFE VERSION';
      7 : comm:='HILFE ADD';
      8 : comm:='HILFE DEL';
    else
      comm:='';
    end;
  end;

  procedure gruppenuser;
  var gruppe : string[80];
      user   : string[80];
      x,y,p  : byte;
      brk    : boolean;
      aufnehm: boolean;
  begin
    aufnehm:=cpos('>',comm)>0;
    gruppe:=''; user:='';
    case aktdispmode of
      -1,0 : if not dbEOF(bbase) then
               dbReadN(bbase,bb_brettname,gruppe);
      1..4 : if not dbEOF(ubase) then begin
               dbReadN(ubase,ub_username,user);
               end;
    10..12 : if not dbEOF(mbase) then begin
               if not aufnehm then
                 dbReadN(mbase,mb_absender,user);
               dbSeek(bbase,biIntnr,copy(dbReadStrN(mbase,mb_brett),2,4));
               if dbFound then
                 dbReadN(bbase,bb_brettname,gruppe);
               end;
    end;
    if user<>'' then begin
      p:=cpos('@',user);
      if p>0 then user:=trim(left(user,p-1))+' @ '+trim(mid(user,p+1));
      end;
    if gruppe<>'' then begin
      delete(gruppe,1,1);
      ReadBoxPar(0,box);
      with BoxPar^ do
        if left(ustr(gruppe),length(MagicBrett))<>ustr(MagicBrett) then
          gruppe:=''
        else
          delete(gruppe,1,length(magicbrett));
      end;
    dialog(44,5,'User '+iifs(aufnehm,'aufnehmen','ausschlieen'),x,y);
    maddstring(3,2,'Gruppe ',gruppe,30,eBrettLen,''); mhnr(670);
    maddstring(3,4,'User   ',user,30,eAdrLen,'');
    readmask(brk);
    enddialog;
    if brk then
      comm:=''
    else
      comm:='GU'+user+right(comm,1)+gruppe;
  end;

  function MausCRC(comm:string):boolean;
  var i : integer;
  begin
    i:=infos;
    while (i>0) and (comm<>info^[i].ID) do dec(i);
    MausCRC:=((i=0) and (firstchar(comm)='I')) or info^[i].crcflag;
  end;

begin
  box:=UniSel(1,false,DefaultBox);
  if box='' then exit;
  if not BoxHasMaps(box) then exit;
  dbOpen(d,BoxenFile,1);
  dbSeek(d,boiName,ustr(box));
  dbRead(d,'nameomaps',mapsname);
  dbRead(d,'netztyp',nt);
  dbRead(d,'domain',domain);
  dbClose(d);
  maf:=ntMAF(nt);
  ntQuickMaps(nt);
  maus:=ntNude(nt);
  fido:=ntAreamgr(nt);
  gs:=(nt=nt_GS);
  uucp:=(nt=nt_UUCP);
  client:=(nt=nt_Client);
  if uucp then begin
    ReadBoxpar(nt,box);
    gup:=(boxpar^.BMtyp=bm_gup);
    autosys:=(boxpar^.BMtyp=bm_autosys);
    feeder:=(boxpar^.BMtyp=bm_feeder);
    postmaster:=(boxpar^.BMtyp=bm_postmaster);
  end;

  promaf:=ntProMaf(nt);
  case defcom of
    0 : begin
          if (not ntMapsOthers(nt) or ((nt=nt_UUCP) and postmaster))
          then begin
            rfehler(818);     { 'Bei dieser Box nicht mglich.' }
            exit;
          end;
        end;
    1 : if client then
        begin
          msgbox(63,10,_hinweis_,x,y);
          for j := 2 to 7 do
            { 'Netztyp RFC/Client: Zum Anfordern einer neuen Newsgroup-'  }
            { 'Liste mu die entsprechende Funktion beim externen Client' }
            { 'aktiviert sein (siehe auch "Newsgroup-Liste pflegen" bei'  }
            { '/Edit/Boxen/Edit/Mail-/News-Server) und die bisherige'     }
            { 'Newsgroup-Liste gelscht werden (siehe /Nachricht/Brett-'  }
            { 'manager/Sonstiges/Lschen).'                               }
            mwrt(x+3,y+j,getres2(10800,30+j));
          errsound;
          wait(curoff);
          closebox;
          freeres;
          exit;
        end else
       if not ntMapsBrettliste(nt) then begin
          rfehler(818);
          exit;
          end;
  end;
  area:=(mapsname='AREAFIX');
  request:=(mapsname='REQUEST');
  if maf then lines:=4
  else if maus then lines:=17
  else if fido then lines:=5
  else if area then lines:=7
  else if request then lines:=6
  else if gs then lines:=4
  else if client then lines:=3
  else if uucp then
    if gup then lines:=3
    else if autosys then lines:=5
    else if feeder then lines:=5
    else lines:=4
  else lines:=18;
  if maus then begin
    new(info);
    MausReadITI(box,info,infos);
    end;
  if defcom=1 then begin
    if fido then comm:='List' else
    if area then comm:='LIST ALL BRETTER' else
    if request then comm:='LIST BRETTER' else
    if maf  then comm:='LIST ALLE' else
    if maus then comm:='ITG' else
    if gs   then comm:='BESTELLBARE BRETTER' else
    if uucp then if gup then comm:='newsgroups *'
                 else if autosys then comm:='newsgroups'
                 else if feeder then comm:='@active'
                 else comm:='getgroups' else
    if promaf then comm:='REQUEST'
    else comm:='LIST VERBOSE BRETTER *';
    brk:=false;
    end
  else begin
    listbox(iif(maus,45,60),lines,iifs(client,'RFC/Client: '+getres2(810,85),
      getres2(810,0)+mapsname+   { 'Nachricht an ' }
            +iifs((mapsname='MAPS') and (random<0.07),'-o-MAT','')+' @ '+box));
    if fido then begin
      app('List',getres2(810,40));      { 'Liste der verfgbaren Bretter' }
      app('Query',getres2(810,41));     { 'Liste der bestellten Bretter' }
      app('Unlinked',getres2(810,42));  { 'Liste der nicht bestellten Bretter' }
      app('Help',getres2(810,43));      { 'Hilfe zu den Areafix-Befehlen' }
      app('Rescan',getres2(810,44));    { 'Brettinhalt anfordern' }
      end
    else if area then begin
      app('HILFE',getres2(810,50));     { 'Hilfe zu den AREAFIX-Befehlen' }
      app('LIST ALL BRETTER',getres2(810,51));   { 'komplette Brettliste' }
      end
    else if request then begin
      app('HILFE',getres2(810,55));     { 'Hilfe zu den REQUEST-Befehlen' }
      app('LIST BRETTER',getres2(810,56));  { 'Brettliste' }
      app('LIST OTHER BRETTER',getres2(810,57));   { 'nicht bestellte Bretter' }
      end
    else if maf then begin
      app('HILFE','Hilfe zu dem MAF-Befehlen');
      app('LIST ALLE','Brettliste');
      app('LIST BESTELLT','bestellte Bretter');
      app('LIST UNBESTELLT','unbestellte Bretter');
      end
    else if maus then begin
      for i:=1 to infos do
        app(info^[i].ID,info^[i].text);
      app('GU>','Gruppenmitglied aufnehmen');
      app('GU<','Gruppenmitglied ausschlieen');
      end
    else if gs then begin
      app('BESTELLBARE BRETTER','Liste der bestellbaren Bretter');
      app('BESTELLTE BRETTER','Liste der bestellten Bretter');
      app('BRETT +','Bretter bestellen');
      app('BRETT -','Bretter abbestellen');
      end
    else if client then begin
      app(getres2(810,86),getres2(810,87));  { 'Newsgroup-Liste alphabetisch sortieren'     }
      app(getres2(810,88),getres2(810,89));  { 'Newsgroup-Liste mit RC-Datei abgleichen'    }
      app(getres2(810,90),getres2(810,91));  { 'Newsgroup-Liste lschen (= Neuanforderung)' }
      end
    else if uucp then
      if gup then begin
        app('help',getres2(810,70));      { 'Hilfe zu Gup anfordern' }
        app('list',getres2(810,71));      { 'Liste der bestellten Bretter' }
        app('newsgroups *',getres2(810,72));   { 'Liste der verfgbaren Bretter' }
        end
      else if autosys then begin
        app('help',getres2(810,75));        { 'Hilfe zu AutoSys anfordern' }
        app('newsgroups',getres2(810,72));  { 'Liste der verfgbaren Bretter' }
        app('active',getres2(810,77));      { 'Traffic-bersicht' }
        app('perms',getres2(810,76));       { 'Brett-Zugriffsrechte abfragen' }
        app('show',getres2(810,71));        { 'Liste der bestellten Bretter' }
        end
      else if feeder then begin
        app('@help',getres2(810,80));       { 'Hilfe zu Feeder anfordern' }
        app('@active',getres2(810,72));     { 'Liste der verfgbaren Bretter' }
        app('@get',getres2(810,71));        { 'Liste der bestellten Bretter' }
        app('@suspend',getres2(810,81));    { 'alle Bretter vorbergehend abbestellen' }
        app('@resume',getres2(810,82));     { 'alle Bretter reaktivieren' }
        end
      else begin
        app('getgroups',getres2(810,60));
        app('getsys',getres2(810,62));
        app('setsys',getres2(810,63));
        app('help',getres2(810,61));
        end
    else begin
      app('HILFE *',getres2(810,1));        { 'Hilfe zu allen MAPS-Befehlen' }
      app('HILFE <Thema>',getres2(810,2));  { 'Hilfe zu einem Befehl' }
      app('HILFE THEMEN',getres2(810,3));   { 'Themen-bersicht' }
      app('HOLD ON',getres2(810,21));       { 'Bretter vorbergehend abbestellen (Urlaub)' }
      app('HOLD OFF',getres2(810,22));      { 'Bretter wieder aktivieren' }
      app('INHALT',getres2(810,4));         { 'Brettinhalt' }
      app('INFO',getres2(810,5));           { 'Infos zum eigenen System' }
      app('INFO *',getres2(810,6));         { 'Infos zu allen Systemen' }
      app('INFO <System>',getres2(810,7));  { 'Infos zu einem bestimmten System' }
      app('LIST ALL',getres2(810,8));       { 'User-, Brett- und Systemliste' }
      app('LIST BRETTER',getres2(810,9));   { 'Brettliste' }
      end;
    if not (maf or maus or fido or gs or uucp or client) then begin
      if not request then app('LIST USER',getres2(810,11));   { 'Userliste' }
      app('LIST MY BRETTER',getres2(810,12));   { 'bestellte Bretter' }
      if not request then app('LIST OTHER BRETTER',getres2(810,13));   { 'nicht bestellte Bretter' }
      if not (area or request) then begin
        app('PM LOESCHEN',getres2(810,14)); { 'Postfachinhalt in *Mailbox* lschen' }
        app('STATUS',getres2(810,18));      { 'Eigenen Userstatus abfragen' }
        end;
      app('ADD',getres2(810,16));           { 'Bretter bestellen' }
      app('DEL',getres2(810,17));           { 'Bretter abbestellen' }
      end;
    freeres;
    list(brk);
    closebox;
    if not brk then
    begin
      comm:=trim(left(first_marked,iif(maus,9,iif(fido or uucp or client,16,21))));
      if client then
      begin
        brk:=true;
        if comm=getres2(810,86) then ClientBL_Sort(box);
        if comm=getres2(810,88) then ClientBL_Abgleich(box);
        if comm=getres2(810,90) then ClientBL_Del(box);
        end;
      end;
    end;


  if not brk then begin
    if comm='BRETT +' then comm:='ADD'
    else if comm='BRETT -' then comm:='DEL';
    brk:=false;
    if not (area or request or maf or fido)
       and ((left(comm,4)='LIST') and (comm<>'LIST SYSTEME')) and (defcom=0)
    then begin
      pushhp(69);
      if ReadJNesc(getres2(810,20),true,brk) then begin   { 'ausfhrliche Liste' }
        insert(' VERBOSE',comm,cpos(' ',comm));
        comm:=comm+' *';
        end;
      pophp;
      end;
    if not brk then begin
      if Fido or uucp then begin
        ReadBoxPar(0,box);
        if comm='Rescan' then begin
          mapsbox:=box;
          MapsBrettliste(4);
          mapsbox:='';
          exit;
          end;
        end;
      fn:=TempS(2000);
      if comm='INFO <System>' then rdsystem;
      if comm='HILFE <Thema>' then rdthema;
      if (comm='GU>') or (comm='GU<') then
        gruppenuser
      else
        if maus and MausCRC(comm) then
          comm:=comm+' -1';    { CRC -1 -> Maus-Infofile anfordern }
      if comm='INHALT' then begin
        mapsbox:=box;
        mapsbrettliste(3);
        mapsbox:='';
        end
      else if (comm<>'ADD') and (comm<>'DEL') and (comm<>'SCRIPT') then begin
        assign(t,fn);
        rewrite(t);
        if fido then begin
          if not boxpar^.AreaBetreff then writeln(t,'%',comm);
          writeln(t,'---');
          end
        else if uucp then begin
          writeln(t,'system: ',boxpar^.pointname,
                    iifs(boxpar^.BMdomain,domain,''));
          writeln(t,'passwd: ',boxpar^.areapw);
          writeln(t,comm);
          end
        else if promaf then begin
          writeln(t);
          writeln(t);
          writeln(t,'BRETTER');
          end
        else
          writeln(t);
        close(t);
        end
      else begin
        EditFile(fn,false,false,false,0,false);
        if _filesize(fn)<=2 then begin
          rfehler(808);   { 'leere Nachricht - nicht abgeschickt' }
          comm:='';
          end;
        end;
      if exist(fn) and (comm<>'') then
        if fido then begin
          if boxpar^.AreaBetreff then
            if comm='Query' then comm:='-q'
            else if comm='List' then comm:='-l'
            else if comm='Unlinked' then comm:='-u'
            else comm:='-h'
          else
            comm:='';
          SendMaps(comm,box,fn);
          end
        else
          SendMaps(comm,box,fn);
      if exist(fn) then _era(fn);
      end;
    end;
  if maus then
    dispose(info);
  if defcom=0 then
    closelist;
end;


{ Usenet-Sysfile aus akt. Nachricht auslesen   }
{ BoxPar der betreffenden Box mu geladen sein }

{ This is your latest sys file entry

  xpoint/xpoint.sh.sub.org:shlink.dfue,shlink.general,shlink.ibm,shlink.general,\
          shlink.test/!local,all:f:   }

procedure GetSysfile;
var fn   : pathstr;
    t,t2 : text;
    s    : string;
    p    : byte;

  procedure WriteStr;
  var p : byte;
  begin
    repeat
      p:=cpos(',',s);
      if p>0 then begin
        writeln(t2,left(s,p-1));
        delete(s,1,p);
        end;
    until p=0;
  end;

begin
  rmessage(820);      { 'Lese Sysfile-Eintrag ...' }
  fn:=TempS(dbReadInt(mbase,'groesse'));
  XRead(fn,false);
  assign(t,fn);
  reset(t);
  s:='';
  with BoxPar^ do begin
    while not eof(t) and (left(s,length(pointname))<>pointname) do
      readln(t,s);
    s:=trim(s); p:=cpos(':',s);
    if not eof(t) and (p>0) then begin
      assign(t2,BoxFilename(boxpar^.boxname)+'.BBL');
      rewrite(t2);
      delete(s,1,p);
      while right(s,1)='\' do begin
        dellast(s);
        WriteStr;
        readln(t,s);
        s:=trim(s);
        end;
      p:=cpos('/',s); if p=0 then p:=cpos(':',s);
      if p>0 then begin
        s:=left(s,p-1)+',';
        WriteStr;
        end;
      close(t2);
      end;
    end;
  close(t);
  _era(fn);
  closebox;
end;


{$I xp8fs.inc}     { Fileserver }
{$I xp8.inc}       { Fido FileScan }

end.
{
  $Log: xp8.pas,v $
  Revision 1.14  2005/01/01 11:16:30  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.13  2004/01/09 16:18:58  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.12  2003/07/30 23:09:50  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.11  2003/06/25 17:29:37  tw
  auto-de-branching

  Revision 1.10.2.37  2003/01/16 23:30:34  my
  MY: - Schalter /xmsovr in Versionsbezeichnung bercksichtigt
      - betastr an einigen Stellen ergnzt

  Revision 1.10.2.36  2002/03/10 13:52:06  my
  MY:- /Nachricht/Brettmanager/Bestellen: Abfrage "Anzahl Artikel" in
       Ressource verlagert und fr englische User lesbar gemacht. :)

  Revision 1.10.2.35  2002/03/08 23:10:05  my
  MY:- Bugfix RFC/Client: Mehrere Fehler im Brettmanager behoben. An vier
       Stellen wurde bei Boxnamen lnger als 8 Zeichen nicht der korrekte
       Dateiname der Brettliste bzw. RC-Datei bergeben, beim Bestellen/
       Abbestellen von Newsgroups konnte es vorkommen, da XP die
       Brettliste nicht finden konnte, weil das Client-Verzeichnis nicht
       bergeben wurde (Nachwehe der Umstellung von RFC/Client auf einen
       eigenen Netztyp).

  Revision 1.10.2.34  2001/12/20 15:22:14  my
  MY+MK:- Umstellung "RFC/Client" auf neue Netztypnummer 41 und in der
          Folge umfangreiche Code-Anpassungen. Alte RFC/Client-Boxen
          mssen einmal manuell von RFC/UUCP wieder auf RFC/Client
          umgeschaltet werden.

  Revision 1.10.2.33  2001/10/22 23:12:04  my
  MY:- Option "Parken" beim Editieren von Nachrichten erscheint nur noch,
       wenn es sich auch um eine zu versendende Nachricht handelt (also
       nicht bei N//T)

  Revision 1.10.2.32  2001/09/16 20:32:36  my
  JG+MY:- Brettmanager: Text-Markiersuche mit "S" (analog zu Lister),
          Ein-/Ausschalten der markierten Suchbegriffe mit "E", "alte"
          Suchfunktionen jetzt ber <Ctrl-S> (frher "S") bzw. wie bisher
          ber <Shift-S> erreichbar.

  MY:- Copyright-/Lizenz-Header aktualisiert

  Revision 1.10.2.31  2001/09/07 13:22:02  mk
  - fixed ClientBL_Del, filenames longer 60 chars where not deleted

  Revision 1.10.2.30  2001/08/12 11:20:37  mk
  - use constant fieldnr instead of fieldstr in dbRead* and dbWrite*,
    save about 5kb RAM and improve speed

  Revision 1.10.2.29  2001/08/11 22:18:02  mk
  - changed Pos() to cPos() when possible, saves 1814 Bytes ;)

  Revision 1.10.2.28  2001/07/23 17:09:50  my
  - cancelled last 'fix' (that introduced a bug)

  Revision 1.10.2.27  2001/07/21 15:56:24  mk
  - fixed possible memory corruption in assembler proc. Reformat_UKA_Brett

  Revision 1.10.2.26  2001/07/21 13:24:00  mk
  - added some const parameters

  Revision 1.10.2.25  2001/07/14 01:12:44  my
  - Fix RFC/Client: Newsgroup list in XP directory is sorted by column 3
    now rather than by column 2 (RPSORT switch '/+2' => '/+3')
  JG:- Fix RFC/Client: Corrected typo, thus N/M/A doesn't crash anymore
       with particular graphics adapters/drivers
  JG:- Fix RFC/Client: N/M/S doesn't lead to message box "Not possible
       with this server." under certain circumstances anymore.

  Revision 1.10.2.24  2001/07/09 22:15:46  my
  JG+MY:- Optimized ClientBL_Sort procedure

  Revision 1.10.2.23  2001/07/08 21:33:11  my
  - ClientBL_Sort now uses 'rpsort.com' instead of 'sort'
  - Improved error handling in ClientBL_Sort

  Revision 1.10.2.22  2001/07/06 15:35:38  my
  JG:- Fix for RFC/Client: <Enter> needs not be pressed twice anymore
       when N/M/E is mapped to N/M/D
  JG:- Fix for RFC/Client: Mapping N/M/E => N/M/D now also works
       with English (M/M/I => M/M/F).

  Revision 1.10.2.21  2001/07/04 01:32:08  my
  JG:- fixed two Bugs (N/M/E and non-existent RC file when subscribing)

  Revision 1.10.2.20  2001/06/19 17:01:47  my
  - minor fixes with nil effect :-)

  Revision 1.10.2.19  2001/06/17 23:51:02  my
  - RFC/Client: new commands under Message/Message_Area_Manager/Others:
    Sort/Sync/Delete

  Revision 1.10.2.18  2001/06/13 01:37:42  my
  JG:- message area manager update: UKA_PPP support (.GR) implemented, some
       logic changed, more to come (work in progress)

  Revision 1.10.2.16  2001/04/28 13:38:55  mk
  - Client-Boxen umbenennen implementiert

  Revision 1.10.2.15  2001/04/23 18:19:41  mk
  - Lister hat Speicher nicht freigegeben

  Revision 1.10.2.14  2001/04/19 14:28:41  mk
  - save some memory

  Revision 1.10.2.13  2001/04/14 10:07:01  mk
  - Anpassungen Client-Modus

  Revision 1.10.2.12  2001/04/11 07:54:24  mk
  - weitere Arbeiten am Client-Modus

  Revision 1.10.2.11  2001/04/09 16:47:18  mk
  - arbeiten am Client-Modus

  Revision 1.10.2.10  2001/04/03 17:19:45  mk
  - fixes fuer Client-Modus

  Revision 1.10.2.9  2001/03/25 12:01:06  mk
  - zwei kleine Fehler im Brettmanager beseitigt

  Revision 1.10.2.8  2001/03/24 10:13:57  mk
  - automatisches anlegen der Bretter im Brettmanager

  Revision 1.10.2.7  2001/03/19 17:35:46  mk
  - neuer Brettmanager

  Revision 1.10.2.6  2001/01/16 08:13:04  mk
  - Grosschreibung von Dateinamen

  Revision 1.10.2.5  2000/12/12 14:03:56  mk
  - weitere lfn-fixes

  Revision 1.10.2.4  2000/11/18 22:11:28  mk
  - einige Dirname, extname, pathname in string geaendert

  Revision 1.10.2.3  2000/06/29 16:47:00  mk
  - Fixes

  Revision 1.10.2.2  2000/06/26 17:56:12  mk
  - Fix von Jochen eingebaut

  Revision 1.10.2.1  2000/06/24 14:16:35  mk
  - 32 Bit Teile entfernt, Fixes

  Revision 1.10  2000/05/04 10:33:00  mk
  - unbenutzer TurboBox Code entfernt

  Revision 1.9  2000/05/03 00:21:23  mk
  - unbenutzte Units aus uses entfernt

  Revision 1.8  2000/05/02 19:14:02  hd
  xpcurses statt crt in den Units

  Revision 1.7  2000/03/14 15:15:41  mk
  - Aufraeumen des Codes abgeschlossen (unbenoetigte Variablen usw.)
  - Alle 16 Bit ASM-Routinen in 32 Bit umgeschrieben
  - TPZCRC.PAS ist nicht mehr noetig, Routinen befinden sich in CRC16.PAS
  - XP_DES.ASM in XP_DES integriert
  - 32 Bit Windows Portierung (misc)
  - lauffaehig jetzt unter FPC sowohl als DOS/32 und Win/32

  Revision 1.6  2000/02/21 22:48:01  mk
  MK: * Code weiter gesaeubert

  Revision 1.5  2000/02/19 11:40:08  mk
  Code aufgeraeumt und z.T. portiert

}
