{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xp1.pas,v 1.59 2005/01/01 11:16:28 mw Exp $ }

{ CrossPoint - allg. Routinen }

{$I XPDEFINE.INC }
{$O+,F+}

unit xp1;

interface

uses
  crt, dos,dosx,typeform,montage,keys,fileio,inout,winxp,win2,video,
  datadef,database,mouse,maus2,help,maske,lister,printerx,clip,
  resource,xp0,crc,xpglobal,lfn;

const maxhidden  = 500;                 { max. versteckte Menpunkte }

      DisableDOS : boolean = false;
      shellkey   : boolean = false;
      ListMakros : byte    = 0;         { Flag fr XPKEYS.XMakro     }
      Errorlevel : word    = 0;
      miscbase   : DB      = nil;       { wird bei Shell geschlossen }
      menurestart: boolean = false;     { fr Config-Men            }

type mprec     = record
                   mstr    : string[30];
                   hpos    : byte;
                   hkey    : char;
                   enabled : boolean;
                   chain   : byte;      { Untermen-Nr. }
                   keep    : boolean;   { Men nicht verlassen }
                   mpnr    : integer;   { Nummer des Menpunkts }
                 end;
     menuarray = array[1..23] of mprec; {22->23 fuer 20 Zusatzmenueeintraege}
     map       = ^menuarray;
     scrptr    = record
                   scsize  : word;
                   p       : pointer;
                 end;
     ahidden   = array[1..maxhidden] of integer;

Type TStartData = record
                    Length:        Word; { Must be 0x18,0x1E,0x20,0x32, or 0x3C }
                    Related:       Word; { 00 independent, 01 child }
                    FgBg:          Word; { 00 foreground, 01 background }
                    TraceOpt:      Word; { 00-02, 00 = no trace }
                    PgmTitle:      PChar; { max 62 chars or 0000:0000 }
                    PgmName:       PChar; { max 128 chars or 0000:0000 }
                    PgmInputs:     PChar; { max 144 chars or 0000:0000 }
                    TermQ:         PChar; { reserved, must be 00000000 }
                    Environment:   PChar; { max 486 bytes or 0000:0000 }
                    InheritOpt:    Word;  { 00 or 01 }
                    SessionType:   Word;  { 00 OS/2 session manager determines type (default)
                                            01 OS/2 full-screen
                                            02 OS/2 window
                                            03 PM
                                            04 VDM full-screen
                                            07 VDM window }
                    IconFile:      PChar; { max 128 chars or 0000:0000 }
                    PgmHandle:     LongInt; { reserved, must be 00000000 }
                    PgmControl:    Word;
                    InitXPos:      Word;
                    InitYPos:      Word;
                    InitXSize:     Word;
                    InitYSize:     Word;
                    Reserved:      Word; { 0x00 }
                    ObjectBuffer:  PChar; { reserved, must be 00000000 }
                    ObjectBuffLen: LongInt; { reserved, must be 00000000 }
  End;


var printlines : longint;
    WaitKey    : taste;               { Taste, mit der wkey beendet wurde }
    llh        : boolean;             { "L"/"H" im Lister -> xp1o.listExt }
                                      { == Nachrichten-Lister             }
    rbx,rby    : byte;                { Cursorposition fr ReadButton     }
    hidden     : ^ahidden;            { Liste der unsichtbaren Menpkte.  }
    anzhidden  : integer;             { Anzahl der unsichtbaren Menpkte. }
    listseekcol: byte;


procedure showstack;                  { Stack/Heap-Anzeige im Debug-Mode }
procedure sound(hz:word);
procedure XpIdle;

procedure showscreen(newmode:boolean);
procedure showusername;
procedure exitscreen(joke:shortint);
procedure showmain(nr:shortint);      { Hauptmen anzeigen: nr=Position  }
function  mainkey(p:byte):taste;
procedure freemain;
procedure wait(cur:curtype);
procedure CondClearKeybuf;

procedure sichern(var sp:scrptr);
procedure holen(var sp:scrptr);

procedure hlp(nr:word);             { setzt helpst[helpstp] }
procedure pushhp(nr:word);
procedure pophp;
procedure freehelp;

procedure setenable(mnu,nr:byte; flag:boolean);
procedure setmenup(mnu:string; nr:byte; const anew:string);
procedure setmenupos(mnu:string; newpos:byte);
procedure splitmenu(nr:byte; ma:map; var n:integer; nummern:boolean);

procedure SetExtraktMenu;
function  getmenu(nr:byte; enterkey:taste; x,y:byte):integer;
procedure setscreensize(newmode:boolean);
procedure lines(screen,fnkey:byte);   { setzt gl usw. }
procedure newscreenlines(m:integer);
procedure xp_maus_aus;
procedure xp_maus_an(x,y: integer16);
procedure SetMausEmu;
procedure SetXPborder;

procedure blindon(total:boolean);
procedure blindoff;
procedure getpos(width,height:byte; var x,y:byte);
procedure openbox(width,height:byte; const txt:string; var x,y:byte; c1,c2:byte);
procedure msgbox(width,height:byte; const txt:string; var x,y:byte);
procedure diabox(width,height:byte; const txt:string; var x,y:byte);
procedure selbox(width,height:byte; const txt:string; var x,y:byte; hell:boolean);
procedure listbox(width,height:byte; const txt:string);
procedure listboxcol;
procedure listbox2col;
procedure utilbox(l,r,o,u:byte; const txt:string);
procedure dialog(width,height:byte; const txt:string; var x,y:byte);
procedure enddialog;
procedure closebox;
procedure moment;
procedure message(txt:string);
procedure rmessage(nr:word);
procedure WaitIt(txt:atext; p:proc; sec:word);
procedure WriteClipFile(fn:pathstr);
procedure selcol;
procedure file_box(var name:pathstr; changedir:boolean);
procedure XP_testbrk(var brk:boolean);

procedure errsound;
function  _errsound:boolean;
procedure signal;              { s. Config/Anzeige/Hilfen }
procedure fehler(const txt:string);
procedure rfehler(nr:word);
procedure rfehler1(nr:word; const txt:string);
procedure hinweis(const txt:string);
function  mfehler(b:boolean; const txt:string):boolean;
function  fehlfunc(const txt:string):boolean;
procedure logerror(const txt:string);
procedure tfehler(const txt:string; sec:integer);
procedure trfehler(nr:word; sec:integer);
procedure trfehler1(nr:word; const txt:string; sec:integer);
procedure afehler(const txt:string; auto:boolean);
procedure arfehler(nr:word; auto:boolean);
procedure interr(const txt:string);
function  ioerror(i:integer; otxt:atext):atext;

procedure shell(const prog:string; space:word; cls:shortint);  { externer Aufruf }

Procedure Start_OS2(const Programm,Parameter,Title:String);

function  listfile(const name,header:string; savescr,listmsg:boolean;
                   cols:shortint):shortint; { Lister }
procedure RemoveEOF(const fn:pathstr);
procedure editfile(name:pathstr; nachricht,reedit,senden:boolean;
                   keeplines:byte;ed_ukonv:boolean);
procedure dosshell;
procedure delete_tempfiles;
procedure FlushSmartdrive(show:boolean);
procedure set_checkdate;

procedure opendatabases;
procedure closedatabases;
procedure NewExit;                       { Exit-Prozedur          }
procedure TempClose;
procedure TempOpen;
procedure FlushClose;
procedure xp_DB_Error;    { Aufruf bei <DB> internem Fehler }

procedure fmove(var f1,f2:file);
procedure iso_conv(var buf; bufsize:word);

function  aFile(nr:byte):pathstr;

function  mbrett(typ:char; intnr:longint):string; { Xpoint.Db1/Bretter erz. }
function  mbrettd(typ:char; dbp:DB):string;       { Int_Nr auslesen }
function  ixdat(s:string):longint;                { Z-Date -> Long  }
function  longdat(l:longint):string;              { Long -> Z-Date  }
function  ixdispdat(dat:datetimest):longint;      { Datum -> Long   }
function  smdl(d1,d2:longint):boolean;            { Datum1 < Datum2 }

function  fdat(const dat:string):string;             { Z-Datum -> Datum   }
function  zdow(const dat:string):string;             { Z-Datum -> Mo/Di.. }
function  ftime(const dat:string):string;            { Z-Datum -> Uhrzeit }
function  Zdate:string;               { akt. Datum/Zeit im Z-Format }
function  fuser(const s:string):string;              { Spaces vor/hinter '@' }
function  aufnahme_string:string;
function  autoTZ_string:string;

function  MsgidIndex(mid:string):longint;      { case-insensitive CRC32 }

function getb(const su, v:string; var b:byte):boolean;   { PARSER }
function getc(const su, v:string;  var c:char):boolean;
function geti(const su, v:string; var i:integer):boolean;
function getw(const su, v:string; var w:smallword):boolean;
function getl(const su, v:string; var l:longint):boolean;
function getx(const su, v:string; var b:boolean):boolean;
function gets(const s,su, v:string; var ss:string; maxlen:byte):boolean;
function getr(const su, v:string; var r:real):boolean;

procedure exchange(var s:string; const repl,by:string);

function notempty(var s:string):boolean;

function IS_QPC(var betreff:string):boolean;
function IS_DES(var betreff:string):boolean;
function IS_PMC(var betreff:string):boolean;

procedure write_lastcall(const dat:String);

procedure InitPrinter;
procedure PrintPage;
procedure PrintLine(const s:string);
procedure ExitPrinter;

function  TempFree:longint;                 { Platz auf Temp-Laufwerk }
function  TempS(bytes:longint):pathstr;
procedure _era(const fn:pathstr);
procedure ExErase(const fn:pathstr);
procedure _chdir(p:pathstr);
function  testmem(size:longint; wait:boolean):boolean;

procedure cm_w(const s:string);                     { Command-Mode-Ausgabe }
procedure cm_wl(const s:string);                    { Writeln              }
procedure cm_wln;
procedure cm_rl(var s:string; maxlen:byte; dot:boolean; var brk:boolean);
function  cm_key:char;
procedure ListDisplay(x,y:word; var s:string); far;

procedure SetBrettGelesen(const brett:string);       { Ungelesenflag des Bretts loeschen }

function  is_freereg:boolean;  { Freeware-"Key"? }

{$IFDEF Snapshot}
  function compiletime:string;
{$ENDIF}

implementation  {-------------------------------------------------------}

uses
  xpfonts, xp1o,xp1o2,xp1help,xp1input,xp2,xp2f,xp4o,xpe,exxec,xpnt,strings,
  xp3,xpovl;

{ Diese Tabelle konvertiert NUR  !    }
{ vollstndige ISO-Konvertierung: siehe XP3 }

const isotab1   : array[$c0..$ff] of byte =
             ($c0,$c1,$c2,$c3,{ $8e,}$c4,$c5,$c6,$c7,$c8,$c9,$ca,$cb,$cc,$cd,$ce,$cf,
              $d0,$d1,$d2,$d3,$d4,$d5,$99,$d7,$d8,$d9,$da,$db,$9a,$dd,$de,$e1,
              $e0,$e1,$e2,$e3,$84,$e5,$e6,$e7,$e8,$e9,$ea,$eb,$ec,$ed,$ee,$ef,
              $f0,$f1,$f2,$f3,$f4,$f5,$94,$f7,$f8,$f9,$fa,$fb,$81,$fd,$fe,$ff);

      maxwinst  = 20;

      closed    : boolean = false;
      opendb    : boolean = false;
      mainmenu  : map = nil;            { Hauptmen }
      menulast  : byte = 0;             { Hhe des Menu-Stacks }
      winstp    : integer = 0;

var  menulevel : byte;                  { Menebene }
     menustack : array[0..4] of byte;   { fr Rekonstruktion im Config-Men }
     hmpos     : array[1..10] of byte;  { Hauptmen-XPos }
     main_n    : integer;               { MPs im Hauptmen }
     mainrange : array[1..10,0..1] of byte;
     listhicol : byte;
     startvideotype : byte;
     winstack  : array[1..maxwinst] of scrptr;   { fr Blindensupport }
     mst       : boolean;


function  ixdat(s:string):longint; assembler;
asm
         les   si,s
         inc   si                       { Lnge ist z.Zt. immer 10 }
         call  @getbyte                 { Jahr }
         cmp   al,70
         jae   @neunzehn
         add   al,100
@neunzehn:mov   dh,al
         call  @getbyte                 { Monat }
         mov   cl,4
         shl   al,cl
         mov   dl,al
         mov   cx,0
         call  @getbyte                 { Tag }
         shr   al,1
         rcr   ch,1
         add   dl,al
         call  @getbyte                 { Stunde }
         shl   al,1
         shl   al,1
         add   ch,al
         call  @getbyte                 { Minute }
         shr   al,1
         rcr   cl,1
         shr   al,1
         rcr   cl,1
         shr   al,1
         rcr   cl,1
         shr   al,1
         rcr   cl,1
         add   ch,al
         mov   ax,cx
         jmp   @ende

@getbyte:mov   al,es:[si]
         inc   si
         sub   al,'0'
         mov   ah,10
         mul   ah
         add   al,es:[si]
         sub   al,'0'
         inc   si
         retn
@ende:
end;

procedure iso_conv(var buf; bufsize:word); assembler;
asm
         cld
         les   di,buf
         mov   cx,bufsize
         mov   bx,offset isotab1 - 0c0h
@isolp:  mov   al,es:[di]
         cmp   al,0c0h
         jb    @noconv
         xlat
@noconv: stosb
         loop  @isolp
end;

{ Hervorhebungsregeln fuer * und _ im Lister: }
{ 1 = vor  Startzeichen erlaubt }
{ 2 = nach Startzeichen erlaubt }
{ 4 = vor  Endzeichen erlaubt }
{ 8 = nach Endzeichen erlaubt }

const
  delimiters : array[0..255] of byte = (
            0                            ,{ ^@ }
            0                            ,{ ^A }
            0                            ,{ ^B }
            0                            ,{ ^C }
            0                            ,{ ^D }
            0                            ,{ ^E }
            0                            ,{ ^F }
            0                            ,{ ^G }
            0                            ,{ ^H }
            0                            ,{ ^I }
            0                            ,{ ^J }
            0                            ,{ ^K }
            0                            ,{ ^L }
            0                            ,{ ^M }
            0                            ,{ ^N }
            0                            ,{ ^O }
            0                            ,{ ^P }
            0                            ,{ ^Q }
            0                            ,{ ^R }
            0                            ,{ ^S }
            0                            ,{ ^T }
            0                            ,{ ^U }
            0                            ,{ ^V }
            0                            ,{ ^W }
            0                            ,{ ^X }
            0                            ,{ ^Y }
            0                            ,{ ^Z }
            0                            ,{ ^[ }
            0                            ,{ ^\ }
            0                            ,{ ^] }
            0                            ,{ ^^ }
            0                            ,{ ^_ }

            0  +  1 +         8          ,{ Space }
            0  +          4 + 8          ,{ ! }
            0  +  1 + 2 + 4 + 8          ,{ " }
            0                            ,{ # }
            0                            ,{ $ }
            0                            ,{ % }
            0                            ,{ & }
            0  +  1 + 2 + 4 + 8          ,{ ' }
            0  +  1                      ,{ ( }
            0  +              8          ,{ ) }
            0                            ,{ * }
            0                            ,{ + }
            0  +          4 + 8          ,{ , }
            0  +              8          ,{ - }
            0  +          4 + 8          ,{ . }
            0                            ,{ / }
            0  +      2 + 4              ,{ 0 }
            0  +      2 + 4              ,{ 1 }
            0  +      2 + 4              ,{ 2 }
            0  +      2 + 4              ,{ 3 }
            0  +      2 + 4              ,{ 4 }
            0  +      2 + 4              ,{ 5 }
            0  +      2 + 4              ,{ 6 }
            0  +      2 + 4              ,{ 7 }
            0  +      2 + 4              ,{ 8 }
            0  +      2 + 4              ,{ 9 }
            0  +          4 + 8          ,{ : }
            0  +          4 + 8          ,{ ; }
            0                            ,{ < }
            0                            ,{ = }
            0  +  1                      ,{ > }
            0  +          4 + 8          ,{ ? }
            0  +      2 + 4              ,{ @ }
            0  +      2 + 4              ,{ A }
            0  +      2 + 4              ,{ B }
            0  +      2 + 4              ,{ C }
            0  +      2 + 4              ,{ D }
            0  +      2 + 4              ,{ E }
            0  +      2 + 4              ,{ F }
            0  +      2 + 4              ,{ G }
            0  +      2 + 4              ,{ H }
            0  +      2 + 4              ,{ I }
            0  +      2 + 4              ,{ J }
            0  +      2 + 4              ,{ K }
            0  +      2 + 4              ,{ L }
            0  +      2 + 4              ,{ M }
            0  +      2 + 4              ,{ N }
            0  +      2 + 4              ,{ O }
            0  +      2 + 4              ,{ P }
            0  +      2 + 4              ,{ Q }
            0  +      2 + 4              ,{ R }
            0  +      2 + 4              ,{ S }
            0  +      2 + 4              ,{ T }
            0  +      2 + 4              ,{ U }
            0  +      2 + 4              ,{ V }
            0  +      2 + 4              ,{ W }
            0  +      2 + 4              ,{ X }
            0  +      2 + 4              ,{ Y }
            0  +      2 + 4              ,{ Z }
            0  +  1                      ,{ [ }
            0                            ,{ \ }
            0  +              8          ,{ ] }
            0                            ,{ ^ }
            0                            ,{ _ }
            0  +  1 + 2 + 4 + 8          ,{ ` }
            0  +      2 + 4              ,{ a }
            0  +      2 + 4              ,{ b }
            0  +      2 + 4              ,{ c }
            0  +      2 + 4              ,{ d }
            0  +      2 + 4              ,{ e }
            0  +      2 + 4              ,{ f }
            0  +      2 + 4              ,{ g }
            0  +      2 + 4              ,{ h }
            0  +      2 + 4              ,{ i }
            0  +      2 + 4              ,{ j }
            0  +      2 + 4              ,{ k }
            0  +      2 + 4              ,{ l }
            0  +      2 + 4              ,{ m }
            0  +      2 + 4              ,{ n }
            0  +      2 + 4              ,{ o }
            0  +      2 + 4              ,{ p }
            0  +      2 + 4              ,{ q }
            0  +      2 + 4              ,{ r }
            0  +      2 + 4              ,{ s }
            0  +      2 + 4              ,{ t }
            0  +      2 + 4              ,{ u }
            0  +      2 + 4              ,{ v }
            0  +      2 + 4              ,{ w }
            0  +      2 + 4              ,{ x }
            0  +      2 + 4              ,{ y }
            0  +      2 + 4              ,{ z }
            0  +  1                      ,{ { }
            0                            ,{ | }
            0  +              8          ,{   }
            0                            ,{ ~ }
            0                            ,{ DEL }

            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +          4              ,{  }
            0  +          4              ,{  }
            0  +          4              ,{  }
            0  +          4              ,{  }
            0                            ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +          4              ,{  }
            0  +          4              ,{  }
            0  +  1 +         8          ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0  +  1 +         8          ,{  }
            0  +  1                      ,{  }
            0  +              8          ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0  +      2 + 4              ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0                            ,{  }
            0  +          4              ,{  }
            0  +          4              ,{  }
            0                            ,{  }
            0  +  1 +         8          ){ #255 };

var
  dispbuf: array[1..164] of byte;  {82 Zeichen und 82 Attribute}

procedure ListDisplay(x,y:word; var s:string); assembler;

asm
            les di,s
            cld
            xor cx,cx
            mov cl,es:[di]
            inc di
            push cx
            mov bx,offset dispbuf          { s + color -> dispbuf }
            mov ah,textattr
            mov al,' '                     { Abgrenzung links }
            mov [bx],ax
            add bx,2

@dcopylp:   mov al,es:[di]
            inc di
            mov [bx],ax
            add bx,2
            loop @dcopylp
            mov al,' '                    { Abgrenzung rechts }
            mov [bx],ax
            pop cx

            cmp ListXhighlight,0          { keine Hervorhebungen? }
            jz @nodh
            mov al,'*'
            call @testattr                { sichert cx }
            mov al,'_'
            call @testattr
         (* mov al,'/'
            call @testattr *)

@nodh:      cmp ListShowSeek,0
            je @nosu
            call @testsuch

@nosu:      mov ax,base                   { dispbuffer -> Bildschirm }
            mov es,ax
            mov ax,y
            dec ax
            mov si,zpz
            add si,si                     { si <- 160 }
            mul si
            mov di,x
            dec di
            add di,di
            add di,ax                     { es:di <- Bildschirmadresse }
            mov si,offset dispbuf[2]
            rep movsw

            jmp @ende


{-----------------------}

@testattr:  mov dx,cx
            xor bx,bx

            {-----------}
@ta1:       push ax
            mov cx,dx
            xor si,si

@talp1:     cmp al,byte ptr dispbuf[si]           { Startzeichen checken }
            jne @tanext1

             mov bl,byte ptr dispbuf[si-2]
             test byte ptr delimiters[bx],1       { Byte vor Startzeichen ok? }
             jz @tanext1
             mov bl,byte ptr dispbuf[si+2]
             test byte ptr delimiters[bx],2       { Byte vor Startzeichen ok? }
             jnz @tastart                         { Startzeichen gefunden }

@tanext1:   add si,2
            loop @talp1
            jmp @taende

            {-----------}

@tastart:   mov di,si                             { Di = Byte nach Startzeichen }
            dec cx
            jz @taende
            dec cx                                { min. ein Zeichen Abstand }
            jz @taende
            add si,4                              { dann Endzeichen Checken }

@talp2:     cmp al,byte ptr dispbuf[si]
            jne @tanext2

             mov bl,byte ptr dispbuf[si-2]
             test byte ptr delimiters[bx],4       { Byte vor Endzeichen ok? }
             jz @tanext2
             mov bl,byte ptr dispbuf[si+2]
             test byte ptr delimiters[bx],8       { Byte nach Endzeichen ok? }
             jnz @tafound2                        { Endzeichen gefunden }

@tanext2:   add si,2
            loop @talp2
            jmp @taende

            {------------}

@tafound2:  push cx
            mov cx,si
            sub cx,di
            shr cx,1
            dec cx                                { cx <- Anzahl hervorgeh. Zeichen }
            mov ah,listhicol

@tacopy1:   mov al,byte ptr dispbuf[di+2]         { hervorgehobenen Text eins nach }
            mov word ptr dispbuf[di],ax           { vorne kopieren; Farbe tauschen }
            add di,2
            loop @tacopy1

            pop cx
            dec cx                                { restliche Zeichen }
            jz @addspace

@tacopy2:   mov ax,word ptr dispbuf[di+4]
            mov word ptr dispbuf[di],ax
            add di,2
            dec cx
            jns @tacopy2

@addspace:  mov byte ptr dispbuf[di],' '          { 2 Leerzeichen anhngen }
            mov byte ptr dispbuf[di+2],' '
            pop ax
            jmp @ta1                              { ... und das Ganze nochmal }


@taende:    pop ax
            mov cx,dx
            retn

{-------------------------}                   { Letzte Suchbegriffe markieren }

@testsuch:  mov bl,suchanz
            and bx,0ffh  
            je @bye                           { Wenn Suchanz=0 dann Abbruch }


{----------}                                  { Alle Einzelsuchbegriffe suchen }

@sstloop:   dec bx
            js @bye
            cmp byte ptr seeknot[bx],0        { bei NOT-Verknuepfung ueberspringen }
            jne @sstloop                           

            push cx                           { Anzahl Zeichen in Screenpuffer-Zeile }
            xor ax,ax
            mov si,ax       
            mov al,byte ptr seekstart[bx]
            mov di,ax                         { DI=Seekstart[i] } 
            mov dx,word ptr sst[di]           { DL=sst[seekstart[i] }

@1:         mov al,byte ptr dispbuf[si]       { Im Screenpuffer nach erstem Buchst. suchen }
            cmp al,dl
            je @2
            cmp dl,'?'            
            je @2
            cmp dl,'*'                        { Wildcards? }
            je @2
            call @igcase                      { evtl. Gross-/Kleinschreibung? }
            je @2
            call @ulscan
            jne @3 
@2:         call @compare                     { Gefunden -> Weiter vergleichen }
@3:         add si,2
            dec cx                            { ansonsten weiter im Screenpuffer }
            jne @1

            pop cx
            or bx,bx
            jns @sstloop                      { Weitermachen fuer alle Suchbegriffe }
@bye:       retn


{----------}                                  { erster Buchstabe passt -> weiter vergleichen }   

@compare:
            push di
            push dx
            push cx 
            push bx  
            push si                     
            mov cl,byte ptr seeklen[bx]       { CL=Seeklen[i] }
            mov ch,cl
            call @ulscan
            jne @seekloop 
            inc di
            dec cl
            dec ch 

@seekloop:  mov bl,0
            inc di 
            dec cl
            je @good                          { Alles passt, wenn Suchstring zuende ist }

@seek2:     add si,2
            cmp si,160
            je @@0
@s1:        mov dx,word ptr sst[di]
            cmp dl,'*'                        { Wildcard vorbereiten }
            jne @s2
            mov bl,1
            dec ch
            inc di 
            dec cl
            je @good
            jmp @s1
 
@s2:        mov al,byte ptr dispbuf[si]
            cmp al,dl
            je @seekloop
            call @igcase                      { evtl. Gross-/Kleinschreibung? }
            je @seekloop                      { vergleichen, solange alles zusammenpasst }
            call @umlaut
            je @seekloop   
            cmp dl,'?'                        { Wildcard? } 
            je @seekloop             
            cmp bl,1
            jne @@0
            inc ch
            jmp @seek2

@@0:        pop si                  
            pop bx
            pop cx
            pop dx
            pop di                            { ansonsten Abbruch }          
            retn 

@good:      pop si                            { Suchbegriff gefunden: im Screen markieren }                 
            mov cl,ch
            mov ah,listseekcol

@@1:        mov al,byte ptr dispbuf[si]       { Farbe neu setzen }
            mov word ptr dispbuf[si],ax
            dec cl                            { bis Ende des Begriffs }         
            je @@2 
            add si,2
            cmp si,160                        { oder Bildschirmrand erreicht ist.}
            jne @@1

@@2:        mov di,y
            mov byte ptr ListFoundTab[di],1
            pop bx
            pop cx 
            pop dx 
            pop di
            retn            


{----------}

@igcase:    mov ah,byte ptr igcase            { Gross-/Kleinschreibung ignorieren? }
            cmp ah,1                          { Noe? Dann passt's nicht. }
            jne @icend

@ic_ue:     cmp al,''
            jb @ic_az
            jne @ic_ae
            cmp dl,''
            retn 
@ic_ae:     cmp al,''
            jne @ic_oe
            cmp dl,''
            retn
@ic_oe:     cmp al,''
            jne @ic_az
            cmp dl,''
            retn
@ic_az:     push ax
            and al,0dfh                       { Igcase }
            cmp al,'A'                        { zwischen A und Z? }
            jb @ic_end                        { Wenn nicht, dann ist's auch nicht gleich...}
            cmp al,'Z'
            ja @ic_end
            cmp al,dl
@ic_end:    pop ax           
@icend:     retn 



{---------}

@umlaut:    push dx
            cmp al,''                        { Koennte es ein Umlaut sein? }
            jb @ulend
            mov ah,byte ptr umlaut            { Umlaute ignorieren aktiv? }
            cmp ah,1 
            jne @ulend
            cmp dh,'E'                        { wenn's in SST kein Umlaut ist, Schluss }
            je @ul1

            cmp al,''
            jne @ulend
            cmp dx,'SS'
            je @ulfound
            pop dx
            retn
          

@ul1:       call @ulscan
            jne @ulend


@ulfound:   inc di 
            dec cl
            dec ch
            jne @u1
            mov cl,1
@u1:        cmp al,al  

@ulend:     pop dx
            retn

{---------}

@ulscan:    cmp al,''
            je @ss
            cmp al,''
            je @ae
            cmp al,''
            je @ae
            cmp al,''
            je @oe
            cmp al,''
            je @oe
            cmp al,''
            je @ue
            cmp al,''
            jne @ulsend


@ue:        cmp dx,'EU'
            retn 
@ss:        cmp dx,'SS'
            retn
@ae:        cmp dx,'EA'
            retn
@oe:        cmp dx,'EO'
@ulsend:    retn

{-------------------------}

@ende:
end; { of Listdisplay }

procedure interr(const txt:string);
begin
  moff;
  cm_wl(txt);
  runerror:=false;
  halt(1);
end;


procedure sound(hz:word);
begin
  if not ParQuiet then
    crt.sound(hz);
end;


procedure blindon(total:boolean);
var mf : boolean;
    mt : byte;
begin
  if blind and (winstp<maxwinst) and (memavail>160*50*2) then begin
    inc(winstp);
    if winstp=1 then begin
      mst:=m2t; m2t:=false;
      end;
    sichern(winstack[winstp]);
    mf:=forcecolor; forcecolor:=false; mt:=lastattr;
    attrtxt(7);
    moff;
    clwin(1,80,iif(total,1,2),screenlines);
    mon;
    attrtxt(mt);
    forcecolor:=mf;
    end;
end;


procedure blindoff;
begin
  if winstp>0 then begin
    moff;
    holen(winstack[winstp]);
    mon;
    dec(winstp);
    if winstp=0 then m2t:=mst;
    end;
end;


{ Online-Hilfe (s. auch xp1help.pas) }


procedure hlp(nr:word);
begin
  helpst[helpstp]:=nr;
end;


procedure pushhp(nr:word);
begin
  if helpstp>=maxhelpst then
    interr('PushHP: Overflow')
  else begin
    inc(helpstp);
    helpst[helpstp]:=nr;
    end;
end;


procedure pophp;
begin
  if helpstp=1 then
    interr('PopHP: Underflow')
  else
    dec(helpstp);
end;


procedure freehelp;  { wird von shell() benutzt }
begin
  if inithlp then begin
    releasehelp;
    inithlp:=false;
    end;
end;


{$I xp1menu.inc}   { Menfunktionen }


{ ----- Externe Programme ------------------------------------------- }

procedure xp_maus_aus;
begin
  if _maus then begin
    maus_tasten_aus;
    mausaus;
    { mausinit; }
    maus_cursor:=false;
    end;
end;

procedure xp_maus_an(x,y: integer16);
begin
{$Q-}
  if _maus then begin
    if startup or MausShInit then
      mausinit;
    if (x+y>=0) then
      setmaus(x,y);
    setmauswindow(0,639,0,screenlines*8-1);
    mausan;
    maus_tasten_an;
    maus_cursor:=true;
    end;
{$IFDEF Debug }
  {$Q+}
{$ENDIF }
end;

procedure SetMausEmu;
begin
  iomaus:=ParMaus and not _maus;
end;


procedure sichern(var sp:scrptr);
begin
  with sp do
  begin
    scsize:=screenlines*2*screenwidth;
    if maxavail<scsize+500 then interr('Speicher-berlauf');
    getmem(p,scsize);               { Bild sichern }
    moff;
    FastMove(mem[base:0],p^,scsize);
    mon;
  end;
end;


procedure holen(var sp:scrptr);
begin
  with sp do
  begin
    moff;
     FastMove(p^,mem[base:0],scsize);
    mon;
    disp_DT;
    freemem(p,scsize);               { Bild wiederherstellen }
  end;
end;


procedure InitPrinter;
begin
  checklst:=true;
  printlines:=0;
  write(lst,PrintString(DruckInit));
end;

procedure PrintPage;
begin
  write(lst,PrintString(DruckFF));
  printlines:=0;
end;

procedure PrintLine(const s:string);
begin
  writeln(lst,sp(DruckLira),s);
  inc(printlines);
  if (DruckFormlen>0) and (printlines>=DruckFormlen) then
    PrintPage;
end;

procedure ExitPrinter;
begin
  write(lst,PrintString(DruckExit));
end;


{$I xp1s.inc}    { Shell }


procedure delete_tempfiles;
begin
  if exist(TempPath+swapfilename) then
    _era(TempPath+swapfilename);
  if exist(TempPath+MsgTempFile) then
    _era(TempPath+MsgTempFile);
  if exist(TempPath+'header.hdr') then
    _era(TempPath+'header.hdr');
end;


{ --- Bildschirmzeilen -------------------------------------}

procedure XPFont;
begin
  if not ParLCD then
    if ParFontfile[1]='*' then
      InternalFont
    else
      LoadFontfile(ParFontfile);
end;

procedure SetXPborder;
begin
  case videotype of
    1   : SetBorder16(col.colborder and $f);
    2,3 : SetBorder64(col.colborder and $3f);
  end;
end;

{ Zeilenzahl einstellen; evtl. Videomodus zurcksetzen }

procedure setscreensize(newmode:boolean);
var ma  : map;
    n,i : integer;
begin
  if ParSavePal and not ParLCD then
    GetPal;
  if (videotype<2) or ParLCD then
    screenlines:=25
  else begin
    if (videotype=3) and (GetScanlines=0) then  { bei VGA immer in          }
      SetScanlines;                             { 400-Punkte-Modus schalten }
    if newmode and (videotype>0) and
       ((screenlines<>getscreenlines) or
        (getscreencolumns<>screenwidth) or
        (getvideomode<>3)) then
    begin
      setvideomode(3);
      IoVideoInit;
    end;
    if ParFontfile<>'' then
    begin
      XPFont;
      screenlines:=GetScreenlines;
    end
    else if not ParLCD and (newmode or (screenlines<>getscreenlines)) then
      setscreenlines(screenlines);
  end;
  if ParSavePal and not ParLCD then
    SetPal;
  iosclines:=screenlines;
  crline:=screenlines;
  actscreenlines:=screenlines;
  screenwidth:=zpz;
  cursor(curoff);
  window(1,1,80,25);
  new(ma);
  splitmenu(ZeilenMenue,ma,n,true);
  for i:=1 to n do
    if screenlines=ival(ma^[i].mstr) then menupos[ZeilenMenue]:=i;
  dispose(ma);
  set_helppos;
end;


procedure showusername;
var d        : DB;
    user     : string[76];
    realname : string[40];
    nt       : byte;

  procedure showtline;
  begin
    attrtxt(col.coltline);
    wrt(1,3,dup(screenwidth,''));
  end;

  function def_adresse:string;
  var trueboxname : string[BoxNameLen];
      username    : string[30];
      pointname   : string[25];
      domain      : string[60];
      email       : string[eAdrLen];
      flags       : byte;
      aliaspt     : boolean;
  begin
    trueboxname:=dbReadStr(d,'boxname');
    username:=dbReadStr(d,'username');
    pointname:=dbReadStr(d,'pointname');
    domain:=dbReadStr(d,'domain');
    email:=dbReadStr(d,'email');
    dbRead(d,'script', flags);
    aliaspt:=(flags and 4 <> 0);
    case nt of
      nt_Client  : def_adresse:=left(email,cpos('@',email)-1) +
                                ' @ ' + mid(email,cpos('@',email)+1);
      nt_UUCP    : def_adresse:=iifs(email<>'', left(email,cpos('@',email)-1) +
                                ' @ ' + mid(email,cpos('@',email)+1),
                                username + ' @ ' +
                                iifs (aliaspt, trueboxname + ntServerDomain(DefaultBox),
                                      pointname + domain));
      nt_ZConnect: def_adresse:=username + ' @ ' +
                                iifs (aliaspt, pointname, trueboxname) + domain;
    else
      def_adresse:=username + ' @ ' + trueboxname;
    end;
  end;


begin
  if dispusername and not startup then begin
    dbOpen(d,BoxenFile,1);
    dbSeek(d,boiName,ustr(DefaultBox));
    showtline;
    if dbFound then begin
      nt:=dbReadInt(d,'netztyp');
      realname:=iifs(ntRealname(nt),dbReadStr(d,'realname'),'');
      user:=left(def_adresse,sizeof(user));
      if (length(user)+length(realname)) <= screenwidth-7 then
        user:=user + iifs(realname<>'',' ('+realname+')','')
      else if length(user) <= screenwidth-10 then
        user:=user + iifs(realname<>'',' ('+left(realname,screenwidth-10-length(user))+'...)','');
      mwrt(screenwidth-2-length(user),3,' '+user+' ');
      end;
    dbClose(d);
    end
  else
    showtline;
end;


procedure showscreen(newmode:boolean);
begin
  xp_maus_aus;
  attrtxt(7);
  setscreensize(newmode);
  lines(screenlines,1);
  clrscr;
  if (videotype>1) and not ParMono then
    setbackintensity;
  SetXPborder;
  with col do begin
    attrtxt(colmenu[0]);
    Wrt2(sp(screenwidth));
    showusername;
    dispfunctionkeys(false);
    attrtxt(coltline);
    mwrt(1,screenlines-fnkeylines,dup(screenwidth,''));
    normtxt;
    end;
  showmain(0);
  dphback:=col.colmenu[0]; setseconds(false,true);
  timex:=74; timey:=1; m2t:=true;
  disp_DT;
  attrtxt(7);
  gotoxy(1,4);
  xp_maus_an(mausdefx,mausdefy);
  if newmode then startvideotype:=videotype;
end;


{ --- Videomode nach Shell- bzw. externem Aufruf neu setzen ----- }

procedure resetvideo;
var m3,nl : boolean;
    sp : scrptr;
begin
  if ParSavePal and not ParLCD then
    GetPal;
  if startvideotype>0 then
  begin
    m3:=true;
    if getvideomode<>iif(color,3,7) then
      setvideomode(iif(color,3,7))
    else
      m3:=false;
    if (videotype>1) and not ParLCD then
    begin
      if (videotype=3) and (GetScanlines=0) then { bei VGA immer in          }
        SetScanlines;                            { 400-Punkte-Modus schalten }
      nl:=getscreenlines<>screenlines;
      if nl or (getscreencolumns<>screenwidth) then
      begin
        sichern(sp);
        if not m3 then setvideomode(3);
        if ParFontfile<>'' then
          XPFont
        else if nl then
          setscreenlines(screenlines);
        setmauswindow(0,639,0,screenlines*8-1);
        holen(sp);
      end;
    end;
  end;
  if ParSavePal and not ParLCD then
    SetPal;
  if (videotype>1) and not ParMono then setbackintensity;
  SetXPborder;
end;


procedure exitscreen(joke:shortint);
var i : integer;
begin
  moff;
  attrtxt(7);
  if col.colborder<>0 then
    setborder16(0);
  clrscr;
  SetVideoMode(OrgVideomode);
  if (videotype=3) and (OldScanlines=0) then    { bei VGA ggf. auf          }
  asm                                           { 350-Punkte-Modus resetten }
    mov ax,1201h
    mov bl,30h
    int 10h
  end;
{ screenlines:=25;
  setscreensize(false); }
  if deutsch then
    case joke of
      1 : cm_wl('Vielen Dank. Sie haben ein einfaches Pointprogramm sehr glcklich gemacht.');
      2 : cm_wl('Leider verloren.');
    end;
  if (res2anz(221)>0) and (getres2(221,1)<>'(dummy)') then begin
    writeln;
    for i:=1 to res2anz(221) do
      cm_wl(getres2(221,i));
    end;
  cm_wln;
end;


{ fnkeylines und gl anpassen }

procedure lines(screen,fnkey:byte);
begin
  screenlines:=screen; iosclines:=screen;
  fnkeylines:=fnkey;
  gl:=screenlines-4-fnkeylines;
end;


{ screenlines gem 25/26/...-Men-Position neu setzen }

procedure newscreenlines(m:integer);
var ma : map;
    n  : integer;
begin
  new(ma);
  splitmenu(ZeilenMenue,ma,n,true);
  screenlines:=ival(ma^[m].mstr);
  dispose(ma);
  lines(screenlines,fnkeylines);
end;


{ --- Dialog- und sonstige Boxen ------------------------------- }

procedure getpos(width,height:byte; var x,y:byte);
begin
  x:=(screenwidth-width)div 2 +1;
  y:=(actscreenlines-height+1) div 2 +1;
end;


procedure openbox(width,height:byte; const txt:string; var x,y:byte; c1,c2:byte);
begin
  blindon(true);
  getpos(width,height,x,y);
  wpushs(x,x+width-1,y,y+height-1,'-');
  attrtxt(c1);
  forcecolor:=true;
  case getrahmen of
    1 : rahmen1(x,x+width-1,y,y+height-1,'');
    2 : rahmen2(x,x+width-1,y,y+height-1,'');
  end;
  forcecolor:=false;
  if txt<>'' then
    mwrt(x+2,y,' '+txt+' ');
  attrtxt(c2);
  clwin(x+1,x+width-2,y+1,y+height-2);
end;


procedure msgbox(width,height:byte; const txt:string; var x,y:byte);
begin
  openbox(min(width,screenwidth),height,txt,x,y,col.colmboxrahmen,col.colmbox);
end;


procedure diabox(width,height:byte; const txt:string; var x,y:byte);
begin
  openbox(width,height,txt,x,y,col.coldiarahmen,col.coldialog);
end;


procedure selbox(width,height:byte; const txt:string; var x,y:byte; hell:boolean);
begin
  openbox(width,height,txt,x,y,
          iif(hell,col.colselrahmen,col.colsel2rahmen),
          iif(hell,col.colselbox,col.colsel2box));
end;

procedure ListboxCol;
var lc : listcol;
begin
  with lc do
  begin
    coltext:=col.colselbox;
    colselbar:=col.colselbar;
    colmarkline:=col.colselhigh;
    colmarkbar:=col.colselbar and $f0 + col.colselhigh and $f;
    colstatus:=HexVal(reverse(hex(colselbar,2)));
    colfound:=colstatus;
  { colscroll:=col.colselscroll; }
    setlistcol(lc);
    listseekcol:=colstatus;  { fr Markiersuche! }
  end;
end;

procedure Listbox2Col;
var lc : listcol;
begin
  with lc do
  begin
    coltext:=col.colsel2box;
    colselbar:=col.colsel2bar;
    colmarkline:=col.colsel2high;
    colmarkbar:=col.colsel2bar and $f0 + col.colsel2high and $f;
    colstatus:=HexVal(reverse(hex(coltext,2)));
    colfound:=colstatus;
    setlistcol(lc);
    listseekcol:=colstatus;  { fr Markiersuche! }
  end;
end;

procedure listbox(width,height:byte; const txt:string);
var x,y : byte;
begin
  selbox(width+2,height+2,txt,x,y,true);
  openlist(x+1,x+width,y+1,y+height,0,'/NS/SB/NLR/DM/');
  ListboxCol;
  listarrows(x,y+1,y+height,col.colselrahmen,col.colselrahmen,'');
end;


procedure utilbox(l,r,o,u:byte; const txt:string);
begin
  blindon(true);
  attrtxt(col.colutility);
  forcecolor:=true;
  wpushs(l,r,o,u,'');
  forcecolor:=false;
  if txt<>'' then
    mwrt(l+2,o,' '+txt+' ');
end;


procedure closebox;
begin
  wpop;
  blindoff;
end;


procedure WaitIt(txt:atext; p:proc; sec:word);
begin
  message(txt);
  p;
  wkey(sec,false);
  closebox;
end;


procedure message(txt:string);
var x,y : byte;
begin
  msgbox(length(txt)+6,3,'',x,y);
  mwrt(x+3,y+1,left(txt,screenwidth-6));
end;

procedure rmessage(nr:word);
begin
  message(getres(nr));
end;

procedure moment;
begin
  rmessage(105);   { 'Einen Moment bitte ...' }
end;


procedure dialog(width,height:byte; const txt:string; var x,y:byte);
begin
  diabox(width+2,height+2,txt,x,y);
  inc(x); inc(y);
  openmask(x,x+width-1,y,y+height-1,false);
  masksetfninfo(x+width-7,y+height,' [F2] ','');
end;

procedure enddialog;
begin
  closemask;
  closebox;
end;


procedure WriteClipFile(fn:pathstr);
begin
  if exist(fn) then begin
    FileToClip(fn);
    _era(fn);
    end;
end;


procedure errsound;
begin
  if not ParQuiet or soundflash then
  begin
    if soundflash then SetBorder16(3);
    sound(1000);
    delay(25);
    sound(780);
    delay(25);
    nosound;
    if soundflash then
    begin
      mdelay(60);
      SetXPborder;
    end;
  end;
end;

function _errsound:boolean;
begin
  errsound;
  _errsound:=true;
end;

procedure signal;              { s. Config/Anzeige/Hilfen }
begin
  if not ParQuiet and tonsignal then
  begin
    mdelay(60);
    sound(1205);
    mdelay(60);
    sound(1000);
    mdelay(60);
    sound(800);
    mdelay(60);
    nosound;
  end;
end;

procedure _fehler(txt:string; hinweis:boolean);
var x,y   : byte;
    w1,w2 : word;
    lcol  : byte;
begin
  truncstr(txt,screenwidth-4);
  savecursor; lcol:=textattr;
  w1:=windmin; w2:=windmax;
  window(1,1,80,25);
  msgbox(length(txt)+6,5,iifs(hinweis,_hinweis_,_fehler_),x,y);
  mwrt(x+3,y+2,left(txt,screenwidth-6));
  errsound;
  wait(curoff);
  closebox;
  windmin:=w1; windmax:=w2;
  restcursor;
  attrtxt(lcol);
end;

procedure fehler(const txt:string);
begin
  _fehler(txt,false);
end;

procedure rfehler(nr:word);
var s : string[80];
begin
  s:=getres2(10000+100*(nr div 100),nr mod 100);
  freeres;
  pushhp(20000+nr);
  _fehler(s,false);
  pophp;
end;

procedure rfehler1(nr:word; const txt:string);
begin
  freeres;
  pushhp(20000+nr);
  _fehler(getreps2(10000+100*(nr div 100),nr mod 100,txt),false);
  pophp;
end;

function mfehler(b:boolean; const txt:string):boolean;
begin
  if not b then _fehler(txt,false);
  mfehler:=not b;
end;


procedure hinweis(const txt:string);
begin
  _fehler(txt,true);
end;

function fehlfunc(const txt:string):boolean;
begin
  fehler(txt);
  fehlfunc:=true;
end;


procedure logerror(const txt:string);
var f : text;
begin
  assign(f,Logpath+ErrlogFile);
  append(f);
  if ioresult<>0 then rewrite(f);
  writeln(f,left(date,6),right(date,2),' ',time,' ',txt);
  close(f);
  if ioresult<>0 then;   { Logpath knnte falsch gewesen sein }
end;

procedure tfehler(const txt:string; sec:integer);
var x,y : byte;
begin
  msgbox(length(txt)+16,5,_fehler_,x,y);
  mwrt(x+3,y+2,left(txt,screenwidth-16)+'  '#4'  '+formi(sec div 60,2)+':'+
               formi(sec mod 60,2));
  GotoXY(WhereX-5, WhereY);
  errsound;
  logerror(txt);
  wkey(sec,true);
  closebox;
end;

procedure trfehler(nr:word; sec:integer);
begin
  pushhp(20000+nr);
  tfehler(getres2(10000+100*(nr div 100),nr mod 100),sec);
  pophp;
  freeres;
end;

procedure trfehler1(nr:word; const txt:string; sec:integer);
begin
  freeres;
  pushhp(20000+nr);
  tfehler(getreps2(10000+100*(nr div 100),nr mod 100,txt),sec);
  pophp;
end;

procedure afehler(const txt:string; auto:boolean);
begin
  if auto then
    tfehler(txt,20)
  else
    fehler(txt);
end;

procedure arfehler(nr:word; auto:boolean);
begin
  if auto then
    trfehler(nr,20)
  else
    rfehler(nr);
end;


function ioerror(i:integer; otxt:atext):atext;
var s : atext;
begin
  if ioresult<>0 then;
  if ResIsOpen then begin
    s:=getres2(12800,i);
    if left(s,5)='fehlt' then ioerror:=otxt
    else ioerror:=s;
    end
  else
    ioerror:=fileio.ioerror(i,otxt);
end;


procedure selcol;
begin
  normattr:=col.colselbox;
  invattr:=col.colselbar;
  highattr:=col.colselbox;
  normtxt;
end;

procedure file_box(var name:pathstr; changedir:boolean);
begin
  if (cpos('*',name)>0) or (cpos('?',name)>0) then begin
    selcol;
    pushhp(89);
    name:=fsbox(actscreenlines div 2 - 5,name,'','',changedir,false,false);
    pophp;
    end;
end;


function mbrett(typ:char; intnr:longint):string;
begin
  mbrett:=typ+dbLongStr(intnr);
end;

function mbrettd(typ:char; dbp:DB):string;
begin
  mbrettd:=typ+dbLongStr(dbReadInt(dbp,'int_nr'));
end;


{ Internes Datumsformat:
  7.......0  7..43..0  76...210  7..43..0
  lod(Jahr)  mmmmtttt  thhhhhmm  mmmm0000  }


function longdat(l:longint):string;
begin
  longdat:=formi((l shr 24) mod 100,2)+formi((l shr 20) and 15,2)+
           formi((l shr 15) and 31,2)+formi((l shr 10) and 31,2)+
           formi((l shr 4) and 63,2);
end;

function ixdispdat(dat:datetimest):longint;      { Datum -> Long   }
begin
  ixdispdat:=ixdat(right(dat,2)+copy(dat,4,2)+left(dat,2)+'0000');
end;


function smdl(d1,d2:longint):boolean;            { Datum1 < Datum2 }
begin
  smdl:=(d1 shr 1) and $7fffffff < (d2 shr 1) and $7fffffff;
end;


function fdat(const dat:string):string;             { Z-Datum -> Datum  }
begin
  fdat:=copy(dat,5,2)+'.'+copy(dat,3,2)+'.'+left(dat,2);
end;

function zdow(const dat:string):string;             { Z-Datum -> Mo/Di.. }
var j : word;
    d : datetimest;
    n : integer;
begin
  j:=ival(left(dat,2))+1900;
  if j<1970 then inc(j,100);
  schalt(j);
  d:=fdat(dat);
  n:=_daylen_;
  zdow:=trim(copy(_days_^,dow(copy(d,1,6)+strs(j))*n+1-n,n));
  { 'Montag    Dienstag  Mittwoch  DonnerstagFreitag   Samstag   Sonntag' }
end;


function ftime(const dat:string):string;            { Z-Datum -> Uhrzeit }
begin
  ftime:=copy(dat,7,2)+':'+copy(dat,9,2);
end;

{ Datum in Z-Format abfragen }

function Zdate:string;
var t,m,j,dow,h,mm,s,s100 : rtlword;
begin
  getdate(j,m,t,dow);
  gettime(h,mm,s,s100);
  while h>23 do dec(h,24);
  Zdate:=formi(j mod 100,2)+formi(m,2)+formi(t,2)+formi(h,2)+formi(mm,2);
end;


{ Tastaturpuffer lschen, falls kein Makro aktiv }

procedure CondClearKeybuf;
begin
  if forwardkeys='' then ClearKeybuf;
end;


procedure wait(cur:curtype);
var t : taste;
begin
  repeat
    get(t,cur)
  until (t=mausleft) or (t=mausright) or (t=mausldouble) or
        (t<mausfirstkey) or (t>mauslastkey);
  if (t=mausleft) or (t=mausright) then
    repeat
      get(t,cur)
    until (t=mausunleft) or (t=mausunright);
end;


{ === Parser-Routinen ============================ }

{ p ist immer<>0! }
function scomp(const s1,s2 : string; p:byte):boolean;
var p0,n : byte;
begin
  repeat dec(p) until (s1[p]<>' ') or (p=0);   { rtrim }
  p0:=1;
  while (s1[p0]=' ') and (p0<p) do inc(p0);    { ltrim }
  if p-p0+1<>length(s2) then
    scomp:=false
  else begin
    n:=1;
    while (p0<=p) and (s1[p0]=UpCase(s2[n])) do begin
      inc(n); inc(p0);
      end;
    scomp:=p0>p;
    end;
end;


function getb(const su, v:string; var b:byte):boolean;
var res : integer;
    p   : byte;
begin
  p:=cpos('=',su);
  if scomp(su,v,p) then begin
    val(trim(copy(su,p+1,255)),b,res);
    getb:=(res=0);
    end
  else getb:=false;
end;

function getc(const su, v:string; var c:char):boolean;
var p : byte;
begin
  p:=cpos('=',su);
  if scomp(su,v,p) and (p + 1 <= Length(su)) then
  begin
    c:=su[p+1];
    Getc := true;
  end else
    Getc := false;
end;

function geti(const su, v:string; var i:integer):boolean;
var res : integer;
    p   : byte;
begin
  p:=cpos('=',su);
  if scomp(su,v,p) then begin
    val(trim(copy(su,p+1,255)),i,res);
    geti:=(res=0);
    end
  else geti:=false;
end;

function getw(const su, v:string; var w:smallword):boolean;
var res : integer;
    p   : byte;
begin
  p:=cpos('=',su);
  if scomp(su,v,p) then begin
    val(trim(copy(su,p+1,255)),w,res);
    getw:=(res=0);
    end
  else getw:=false;
end;

function getl(const su, v:string; var l:longint):boolean;
var res : integer;
    p   : byte;
begin
  p:=cpos('=',su);
  if scomp(su,v,p) then begin
    val(trim(copy(su,p+1,255)),l,res);
    getl:=(res=0);
    end
  else getl:=false;
end;

function getr(const su, v:string; var r:real):boolean;
var res : integer;
    p   : byte;
begin
  p:=cpos('=',su);
  if scomp(su,v,p) then begin
    val(trim(copy(su,p+1,255)),r,res);
    getr:=(res=0);
    end
  else getr:=false;
end;

function getx(const su, v:string; var b:boolean):boolean;
var ss : string[1];
    p  : byte;
begin
  p:=cpos('=',su);
  if scomp(su,v,p) then begin
    ss:=trim(copy(su,p+1,1));
    if ss='J' then begin
      b:=true; getx:=true;
      end
    else if ss='N' then begin
      b:=false; getx:=true;
      end
    else
      getx:=false;
    end
  else getx:=false;
end;

function gets(const s,su, v:string; var ss:string; maxlen:byte):boolean;
var
    p   : byte;
begin
  p:=cpos('=',su);
  if scomp(su,v,p) then
  begin
    ss:=copy(s,p+1,maxlen);
    gets:=true;
  end else
    gets:=false;
end;


function fuser(const s:string):string;              { Spacec vor/hinter '@' }
var p : byte;
begin
  p:=cpos('@',s);
  if p=0 then fuser:=s
  else fuser:=left(s,p-1)+' @ '+copy(s,p+1,80);
end;

function aufnahme_string:string;
begin
  aufnahme_string:=getres2(108,minmax(useraufnahme,0,3));
end;

function autoTZ_string:string;
begin
  autoTZ_string:=getres2(252,minmax(AutoTimeZone,52,55));
end;


function IS_QPC(var betreff:string):boolean;
begin
  IS_QPC:=(left(betreff,length(QPC_ID))=QPC_ID);     { QPC: }
end;

function IS_DES(var betreff:string):boolean;
begin
  IS_DES:=(left(betreff,length(DES_ID))=DES_ID);     { DES: }
end;

function IS_PMC(var betreff:string):boolean;
begin
  IS_PMC:=(left(betreff,length(PMC_ID))=PMC_ID);     { *crypted* }
end;


{ Datum des letzten Netcalls merken }

procedure write_lastcall(const dat:String);
var t : text;
begin
  assign(t,ownpath+NewDateFile);
  rewrite(t);
  writeln(t,dat);
  close(t);
  if readmode=rmNeues then readdate:=ixdat(dat);
end;


function aFile(nr:byte):pathstr;
begin
  aFile:=AblagenFile+strs(nr);
end;


{--- Allgemeine VFuncs fr Eingabemasken -------------------------}

function notempty(var s:string):boolean;
begin
  if trim(s)='' then errsound;
  notempty:=(trim(s)<>'');
end;


{-----------------------------------------------------------------}

procedure opendatabases;
begin
  if mbase=nil then begin
    dbOpen(mbase,ownpath+msgFile,1);
    dbOpen(ubase,ownpath+userFile,1);
    dbOpen(bbase,ownpath+brettFile,1);
    dbOpen(bezbase,ownpath+bezugFile,1);
    dbOpen(mimebase,ownpath+mimetFile,1);
    end;
  opendb:=true;
end;

procedure closedatabases;
begin
  if ioresult=0 then;
  if mbase<>nil then dbClose(mbase);
  if ubase<>nil then dbClose(ubase);
  if bbase<>nil then dbClose(bbase);
  if bezbase<>nil then dbClose(bezbase);
  if mimebase<>nil then dbClose(mimebase);
  FlushSmartdrive(false);
  opendb:=false;
end;

procedure TempClose;
begin
  if opendb and not closed then begin
    dbTempClose(mbase);
    dbTempClose(ubase);
    dbTempClose(bbase);
    dbTempClose(bezbase);
    dbTempClose(mimebase);
    if miscbase<>nil then
      dbTempClose(miscbase);
    FlushSmartdrive(false);
    closed:=true;
    end;
end;

procedure TempOpen;
begin
  if opendb and closed then begin
    dbTempOpen(mbase);
    dbTempOpen(ubase);
    dbTempOpen(bbase);
    dbTempOpen(bezbase);
    dbTempOpen(mimebase);
    if miscbase<>nil then
      dbTempOpen(miscbase);
    closed:=false;
    end;
end;

procedure FlushClose;
begin
  TempClose;
  TempOpen;
end;


{$S-}
procedure newexit;               { Exit-Prozedur }
begin
  exitproc:=oldexit;
  if ioresult= 0 then ;
  dbReleaseCache;
  if not closed then closedatabases;
  if lockopen then
  begin
    FileUnLock(xp0.lockfile, 0, SizeOf(xp0.lockfile));
    close(xp0.lockfile);
    erase(xp0.lockfile);
    if ioresult<>0 then ;
  end;
  if videotype>1 then setbackintensity;
  setcbreak(orgcbreak);
end;
{$IFDEF Debug }
  {$S+}
{$ENDIF }

procedure showstack;
const lastsptr : word = 0;
      lastavail: longint = 0;
var b : byte;
begin
  if (sptr<>lastsptr) or (memavail<>lastavail) then begin
    b:=dphback; dphback:=col.colkeys;
    {$IFDEF DPMI}
      disphard(70,screenlines,hex(sptr,4)+'/'+hex(memavail,6));
    {$ELSE}
      disphard(71,screenlines,hex(sptr,4)+'/'+hex(memavail,5));
    {$ENDIF}
    dphback:=b;
    lastsptr:=sptr;
    lastavail:=memavail;
    end;
end;


{ alle restlichen Bytes ab fpos(f1) nach f2 kopieren }

procedure fmove(var f1,f2:file);
var x,y   : byte;
    p     : pointer;
    ps : word;
    box   : boolean;
    fpos,
    fsize : longint;
    rr: word;

  procedure show(n:longint);
  begin
    inc(fpos,n);
    if box then mwrt(x+3,y+2,dup(system.round(fpos*50 div fsize),''));
  end;

begin
  ps:=min(maxavail-5000,60000);
  getmem(p,ps);
  fsize:=filesize(f1)-filepos(f1);
  if fsize>0 then
  begin
    box:=(fsize>$100000) and (windmin=0) and (GetFileExt(FileName(f1))<>'$$$');
    if box then
    begin
      MsgBox(56,5,getreps(134,getfilename(FileName(f1))),x,y);
      attrtxt(col.colmboxhigh);
      mwrt(x+3,y+2,dup(50,''));
      fpos:=0;
    end;
    while not eof(f1) and (inoutres=0) do
    begin
      blockread(f1,p^,ps,rr);
      show(rr div 2);
      blockwrite(f2,p^,rr);
      show(rr - rr div 2);
    end;
    if box then
    begin
      mdelay(300);
      closebox;
    end;
    if inoutres<>0 then
      fehler(ioerror(ioresult,getres(102)));  { Fehler beim Dateizugriff :-( }
  end;
  freemem(p,ps);
end;


function TempFree:longint;                 { Platz auf Temp-Laufwerk }
var t : longint;
begin
  if temppath='' then
    TempFree:=disk_free(0)
  else
    TempFree:=disk_free(ord(temppath[1])-64);
end;


function TempS(bytes:longint):pathstr;
begin
  if (temppath='') or (temppath[1]=ownpath[1]) or (TempFree+4096>bytes) then
    TempS:=TempFile(TempPath)
  else
    TempS:=TempFile(OwnPath);
end;


procedure _era(const fn:pathstr);
var f : file;
begin
  assign(f,fn);
  erase(f);
  if ioresult<>0 then
    trfehler1(4,ustr(fn),30);   { 'Kann '+ustr(fn)+' nicht lschen!?' }
end;

procedure ExErase(const fn:pathstr);
begin
  if exist(fn) then _era(fn);
end;

procedure _chdir(p:pathstr);
begin
  p:=trim(p);
  if p<>'' then begin
    if (length(p)>1) and (right(p,1)='\') then
      dellast(p);
    chdir(p);
    if ioresult<>0 then
      trfehler1(5,ustr(p),30);   { ungltiges Verzeichnis: }
    end;
end;

function testmem(size:longint; wait:boolean):boolean;
begin
  if memavail<=size+16 then begin
    if wait then trfehler(6,30)  { 'zu wenig freier Speicher' }
    else rfehler(6);
    testmem:=false;
    end
  else
    testmem:=true;
end;


procedure exchange(var s:string; const repl,by:string);
var p : byte;
begin
  p:=pos(ustr(repl),ustr(s));
  if p>0 then s:=copy(s,1,p-1)+by+copy(s,p+length(repl),255);
end;


procedure XpIdle;
begin
  mdelay(1);
end;

procedure FlushSmartdrive(show:boolean);   { Schreibcache leeren }
begin
  if not ParNoSmart and (SmartCache(ord(getdrive)-65)=2) then begin
    if show then rmessage(131);   { 'Leere Smartdrive-Schreibcache...' }
    SmartResetCache;
    if show then closebox;
    end;
end;


procedure set_checkdate;
var dt    : datetime;
    dummy : rtlword;
    pdt   : longint;
begin
  fillchar(dt,sizeof(dt),0);
  getdate(dt.year,dt.month,dt.day,dummy);
  gettime(dt.hour,dt.min,dt.sec,dummy);
  packtime(dt,pdt);
  if pdt shr 16 <> filetime(NewDateFile) shr 16 then
    fileio.setfiletime(NewDateFile,pdt);
end;


procedure XP_testbrk(var brk:boolean);
begin
  if not brk then begin
    testbrk(brk);
    if brk then begin
      pushhp(1520);
      if not ReadJN(getres(160),true) then brk:=false;   { 'Abbrechen' }
      pophp;
      end;
    end;
end;


procedure xp_DB_Error;    { Aufruf bei <DB> internem Fehler }
var i : integer;
begin
  if ioresult<>0 then;
  attrtxt(15);
  writeln;
  writeln;
  for i:=1 to res2anz(161) do   { Hinweise, was bei beschdigter Datenbank }
    writeln(getres2(161,i));    { zu tun ist                               }
  writeln;
end;


{ rechten Teil der ID in LowerCase umwandeln und CRC32 bilden }

function MsgidIndex(mid:string):longint;
var p : integer;
begin
  p:=cposx('@',mid)+1;
  while p<=length(mid) do begin
    mid[p]:=system.upcase(mid[p]);
    inc(p);
    end;
  MsgidIndex:=CRC32Str(mid);
end;

procedure SetBrettGelesen(const brett:string);       { Ungelesenflag des Bretts loeschen }
var b    : byte;                               { wenn keine ungelesenen Nachrichten }
    nope : boolean;
    rec  : longint;
begin                                          { mehr vorhanden sind. }
  dbSeek(mbase,miGelesen,brett+#0);
  if dbEOF(mbase) then nope:=true
    else nope:=((dbReadStrN(mbase,mb_brett)<>brett)
      or (dbReadInt(mbase,'gelesen')<>0));
  rec:=dbrecno(bbase);
  dbSeek(bbase,biIntnr,mid(brett,2));
  if dbFound then begin
    dbReadN(bbase,bb_flags,b);
    if nope then b:=b and (not 2) else b:=b or 2;
    dbWriteN(bbase,bb_flags,b);
  end;
  dbgo(bbase,rec);
end;

function is_freereg:boolean;
begin
  is_freereg:=(registriert.nr=0) or (registriert.tc='F');
end;

{$IFDEF Snapshot}
function compiletime:string;      { Erstelldatum von XP.EXE als String uebergeben }
var                               { Format: 1105001824 }
 d:datetime;
begin
  unpacktime(filetime(paramstr(0)),d);
  compiletime:=(formi(d.day,2)+formi(d.month,2)+right(formi(d.year,2),2)
    +formi(d.hour,2)+formi(d.min,2));
end;
{$ENDIF}

{$I xp1cm.inc}

end.
{
  $Log: xp1.pas,v $
  Revision 1.59  2005/01/01 11:16:28  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.58  2004/01/09 16:18:57  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.57  2003/08/23 22:58:13  my
  MY:- Neue Funktion 'disk_free' implementiert, die abhngig vom jeweili-
       gen OS (WinNT/2K/XP oder andere) bei der Ermittlung des freien
       Plattenplatzes die entsprechenden Routinen 'diskfree' oder
       'NTDiskFree' verwendet, und in allen Units, die bisher selbst auf
       das OS getestet haben, diese neue Funktion verwendet.

  Revision 1.56  2003/08/23 20:27:46  my
  MW+MY:- Fix NTDiskFree: '1024*1024' und '$10000' (oops!) => '$100000'

  Revision 1.55  2003/08/23 17:28:08  my
  MY:- NTDiskFree-Routinen kompakter geschrieben und Redundanzen
       eliminiert, Typos gefixt, Source formatiert

  Revision 1.54  2003/08/19 11:09:15  mw
  MW: - Umbau auf NTDiskFree

  Revision 1.53  2003/08/11 22:28:56  my
  MY+JM:- Zwei Korrekturen zum letzten Commit (Videoreset):
          ----------------------------------------------------------------
          1. Das Sichern der Farbpalette funktionierte beim XP-Start
             nicht, weil es nach der Video-Initialisierung ausgefhrt
             wurde (und wre bei Verwendung der mit /f:*1 bis /f:*3 zu
             ladenden internen Fonts eben-falls nicht ausgefhrt worden).
             Aufruf an den Anfang (GetPal) bzw. das Ende (SetPal) der
             Video-Initialisierung verlagert.
          2. Bei der Rckkehr aus einer DOS-Shell wird die Farbpalette
             jetzt nur noch dann gesichert und restauriert, wenn der
             Parameter /LCD nicht angegeben wurde (identisches Verhalten
             wie beim XP-Start).

  MY:- Kleine Przisierung zum CVS-Log des letzten Commits.

  MY:- Unit LFN zu 'uses' hinzugefgt (Vorbereitung auf Untersttzung
       langer Pfad- und Dateinamen > 79 Zeichen).

  Revision 1.52  2003/08/07 22:11:03  my
  MY+JM+JG: Videoroutinen berarbeitet und korrigiert:
            --------------------------------------------------------------
            1. Fix: Beim Setzen des Videomodus und der Zeilenanzahl sowie
               dem Laden interner Fonts werden die entsprechenden Aktionen
               generell jetzt wirklich nur noch dann (aber dann auch
               immer) ausgefhrt, wenn sie tatschlich erforderlich sind
               (d.h. wenn sich die Werte der ursprnglichen bzw. vorheri-
               gen DOS-Instanz von den in XP zu verwendenden Werten unter-
               scheiden). Bisher wurden die Routinen teils berflssiger-
               weise, teils aber auch genau dort nicht ausgefhrt, wo dies
               htte geschehen mssen (z.B. bei der Verwendung interner
               Fonts, die nicht geladen werden konnten, wenn die ursprng-
               liche DOS-Instanz im 50-Zeilen-Modus lief).
            2. Fix: Es wird jetzt auch die Spaltenanzahl geprft und ggf.
               korrigiert. Bisher prsentierte XP einen zerschossenen
               Bildschirm, wenn die Spaltenanzahl in der ursprnglichen
               bzw. vorherigen DOS-Instanz z.B. auf 94 gesetzt war.
            3. Fix: Wenn die Zeilenanzahl der ursprnglichen bzw. vorheri-
               gen DOS-Instanz auf 43 gesetzt war, war die Bildschirmdar-
               stellung nicht korrekt: Bei Verwendung der Standard-Fonts
               war der Bildschirm "zu klein", so da die letzten 4 bis 5
               Zeilen zwar vorhanden, aber nicht sichtbar waren; bei Ver-
               wendung der internen Fonts (Parameter /f:*1 bis /f:*3) wa-
               ren zwar alle Zeilen sichtbar, aber XP lief im 21- (/f:*2)
               bzw. 25-Zeilen-Modus (/f:*1 und /f:*3). Jetzt wird der
               korrekte 25- bzw. 28-Zeilen-Modus verwendet und bei
               Standard-Fonts der Bildschirm vollstndig angezeigt.
               Ursache dieses Fehlverhaltens war, da der 43-Zeilen-Modus
               ein Sondermodus mit 350 vertikalen Bildpunkten ist, XP aber
               stur vom VGA-Standard mit 400 Bildpunkten ausging.
               Falls XP in einer DOS-Instanz im 43-Zeilen-Modus gestartet
               wurde, dann wird nach der Beendigung von XP die ursprng-
               liche Bildpunktanzahl wiederhergestellt (sonst kann es
               sonderbare "Verlngerungseffekte" speziell in einer DOS-Box
               von Windows geben).
               Die nderung wirkt sich auch auf DOS-Boxen unter Windows
               aus, bei denen der 43-Zeilen-Modus nicht ber den "mode"-
               Befehl o.., sondern ber die Bildschirm-Eigenschaften in
               der PIF-Datei gesetzt wurde.
            Alle bis hier beschriebenen nderungen wirken sich aus beim
            XP-Start, beim ndern der Zeilenanzahl in XP, und bei der
            Rckkehr aus einer DOS-Shell nach XP.
            4. VESA-Modus fr 60 Zeilen wieder ausgebaut. Die Funktion hat
               selten richtig funktioniert und war eher eine Quelle fr
               Bugreports als ein wirklich sinnvolles Feature. Bei
               bestehenden Konfigurationen mit 60 Zeilen wird in
               XPOINT.CFG automatisch "ScreenLines=50" eingetragen und
               intern gesetzt.
            5. Der interne Font "C2" (wird mit /f:*1 aktiviert) ist jetzt
               - auer bei den Kleinbuchstaben natrlich, die wie bisher
               als Kapitlchen ausgefhrt sind - identisch mit dem
               Standard-Font 8x14, der in den Zeilenmodi 28, 30, 33 und 36
               geladen wird.
            6. Es wird jetzt in *allen* Zeilenmodi ein XP-interner
               Standard-Font in die Grafikkarte geladen (Vorbereitung fr
               Euro-Support). Bisher war dies nur bei den Zeilenmodi 28,
               30, 33 und 36 der Fall.
            7. Einige optische Anpassungen beim Standard-Font 8x14 (0, ,
               M, m, n etc.).
            8. Der Standard-Font 8x14 ist jetzt *nicht* mehr ber den
               Parameter /f:*4 ansprechbar (wie die Standard-Fonts 8x16
               und 8x8 auch nicht ber Parameter ansprechbar sind).

  Revision 1.51  2003/08/03 15:23:02  my
  MY:- FreeXP ist jetzt Freeware. :-) Smtliche Shareware-Beschrnkungen
       und Registrierungsfunktionen deaktiviert bzw. eliminiert. Die
       Eingabe eines freiwilligen Keys ist weiterhin mglich, dieser bzw.
       ein bereits existierender Key wird wie bisher an den entsprechenden
       Stellen (Software-Header, Origin usw.) angezeigt; Freeware-Versio-
       nen ohne Key melden sich mit "R/Free". Men /XPoint/Registrierung
       umbenannt in /XPoint/Lizenz, dort verweist der Button statt auf die
       weggefallene LIZENZ.DOC nun auf die Quelltextlizenz SLIZENZ.TXT.

  Revision 1.50  2003/07/30 23:09:49  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.49  2003/06/25 17:27:48  tw
  auto-de-branching

  Revision 1.48.2.34  2003/03/17 22:56:00  my
  MY:- Anzeige-Fix: Farbe fr Fundstellen bei der Markiersuche mit "s"
       im Nodelist-Browser sinnvoll initialisiert (invertierte Farben des
       Cursorbalkens, bisher: schwarze Schrift auf schwarzem Grund, grmpf).

  MY:- Source-Header aktualisiert/korrigiert.

  Revision 1.48.2.33  2002/03/31 15:47:35  my
  JG:- Zeilenanzahl (C/A/Z) wird nur noch dann neu gesetzt, wenn
       notwendig.

  Revision 1.48.2.32  2002/03/08 22:56:39  my
  MY:- Der interne Befehl *SETUSER ist jetzt zum Netztyp RFC/Client
       kompatibel und gleichzeitig komplett berarbeitet und erweitert:
       - Beim Netztyp RFC/Client mu, bei RFC/UUCP kann eine gltige und
         vollstndige eMail-Adresse statt des Usernamens bergeben werden;
       - FQDN kann gesetzt werden (nur RFC/* und ZConnect);
       - POP3-/SMTP-Envelope-Adresse kann gesetzt werden (nur RFC/Client);
         wenn ein POP3-Server eingetragen ist, darf der POP3-Envelope
         nicht leer sein (= gelscht werden);
       - Eingabefeld "Programmname" bei C/T/.. bzw. C/Z von 60 auf 200
         Zeichen vergrert (bei externen Befehlen sind max. 127 Zeichen
         zulssig);
       - Hinweismeldung "Username: <neuer Username>" am Schlu der Routine
         zeigt jetzt komplette Adresse an und bercksichtigt Alias-Points
         (RFC/UUCP und ZConnect).
       Weitere Details siehe Hilfe.

  MY:- Anzeige der Stammbox-Adresse unterhalb der Menleiste korrigiert
       und berarbeitet (bei aktivierter Option "C/A/D/Stammbox-Adresse
       anzeigen"):
       - Vollstndige Adresse (statt nur Feld "Username") inkl. Domain
         wird angezeigt;
       - Alias-Points werden bercksichtigt (RFC/UUCP und ZConnect);
       - Realname wird in Klammern angezeigt (falls es sich um einen
         Netztyp mit Realnames handelt) und ggf. automatisch gekrzt, wenn
         die Gesamtlnge von Adresse und Realname grer als 76 Zeichen
         ist;
       - Bei einem Wechsel des Netztyps der Stammbox wird die Anzeige
         der Absenderadresse unterhalb der Menleiste unmittelbar nach dem
         Wechsel aktualisiert.

  JG:- Wenn im Brettmanager eine Markiersuche mit "s" durchgefhrt wurde
       und die eingestellte Farbe fr Zeilen- und Wortmarkierung identisch
       war, dann blieb der Cursorbalken nach Drcken von <Tab> nicht nur
       auf den markierten Suchergebnissen, sondern auch auf bestellten
       Brettern stehen.

  Revision 1.48.2.31  2001/12/11 17:47:43  my
  MY:- ANSI-Mll und Typos im CVS-Log bereinigt.

  Revision 1.48.2.30  2001/12/07 17:53:02  my
  MY:- Fix: Farben fr Statuszeile und Suchergebnis in Select-Box
       initialisiert (relevant fr Suchbegriffs-Bibliothek).

  Revision 1.48.2.29  2001/11/20 23:14:05  my
  MY:- Konfiguration Multiserverbetrieb (D/B/E/C/Zustzliche_Server und
       D/B/E/N/Fallback) gem Vereinbarung mit XP2 implementiert, Details
       siehe Mens und Hilfe; umfangreiche Auswahl- und Testroutinen. In
       den Dialogen werden immer die Boxnamen angezeigt, in der .BFG der
       editierten Box jedoch die BFG-Namen der ausgewhlten Box(en)
       abgelegt.

  Revision 1.48.2.28  2001/10/30 11:15:02  mk
  - JG: fixed Listdisplay, see <8Bj$$d0DkpB@ralle.post.rwth-aachen.de>

  Revision 1.48.2.27  2001/10/26 17:40:02  my
  MY+JG+RB:- Automatische Zeitzonenumstellung (Optionen 'manuell',
             'Datum', 'TZ-Var.', 'TZ/Datum). Details siehe Hilfe.

  Revision 1.48.2.26  2001/10/22 23:04:17  my
  MY:- Option "Parken" beim Editieren von Nachrichten erscheint nur noch,
       wenn es sich auch um eine zu versendende Nachricht handelt (also
       nicht bei N//T z.B.)

  Revision 1.48.2.25  2001/09/16 20:18:05  my
  JG+MY:- Markierung der bei der letzten Nachrichten-Suche verwendeten
          Suchbegriffe im Lister (inkl. Umlaut- und Wildcardbehandlung):
          Nach Suche automatisch aktiv, ansonsten durch "E" schaltbar. Mit
          <Tab> springt der Cursorbalken die nchste Zeile mit einem
          markierten Suchbegriff an.

  JG+MY:- Text-Markiersuche im Lister mit "S": mehrere Suchbegriffe,
          Suchoptionen (z.B. umlautunabhngige Suche), Suchbegriff-History
          und Suchbegriffs-Bibliothek verfgbar. "Alte" Suchfunktionen
          jetzt ber <Ctrl-S> (frher "S") bzw. wie bisher ber <Shift-S>
          erreichbar.

  JG+MY:- Zusatzmen fat jetzt bis zu 20 Eintrge (bei 25 Bildschirm-
          zeilen stehen nur die ersten 19 zur Verfgung).

  JG+MY:- Neuer Menpunkt "?" (Hilfe) im Hauptmen mit Untermens fr
          ntzliche und/oder in der Hilfe ansonsten nur schwer auffindbare
          Informationen. Untermen "ber OpenXP" zeigt Versions- und
          Snapshotnummer sowie OpenXP-Kontakte an. Beta- und
          Registrierungsfenster optisch angepat.

  JG+MY:- Brettmanager: Text-Markiersuche mit "S" (analog zu Lister),
          Ein-/Ausschalten der markierten Suchbegriffe mit "E", "alte"
          Suchfunktionen jetzt ber <Ctrl-S> (frher "S") bzw. wie bisher
          ber <Shift-S> erreichbar.

  MY:- Copyright-/Lizenz-Header aktualisiert

  Revision 1.48.2.24  2001/08/28 08:05:13  mk
  - removed GetI16, because unnecessary for 16 Bit
  - optimized GetX functions, should improve startup speed

  Revision 1.48.2.23  2001/08/12 11:20:28  mk
  - use constant fieldnr instead of fieldstr in dbRead* and dbWrite*,
    save about 5kb RAM and improve speed

  Revision 1.48.2.22  2001/08/11 22:17:55  mk
  - changed Pos() to cPos() when possible, saves 1814 Bytes ;)

  Revision 1.48.2.21  2001/08/11 20:16:29  mk
  - added const parameters if possible, saves about 2.5kb exe

  Revision 1.48.2.20  2001/08/11 16:38:00  mk
  - XP1.pas is now overlay
  - resized Overlaybuffer

  Revision 1.48.2.19  2001/08/11 10:58:34  mk
  - debug switch on
  - moved some procedures and functions, because code size of unit

  Revision 1.48.2.18  2001/08/05 11:45:33  my
  - added new unit XPOVL.PAS ('uses')

  Revision 1.48.2.17  2001/01/10 17:39:02  mk
  - PPP-Modus, unversandt, Ruecklaeufer ersetzen, VGA-Palette, UUZ und Bugfixes

  Revision 1.48.2.16  2001/01/03 22:46:48  mk
  - Parameter /Pal hinzugefuegt

  Revision 1.48.2.15  2000/12/31 11:35:54  mk
  - fileio.disksize statt lfn.disksize benutzen

  Revision 1.48.2.14  2000/12/30 12:59:50  mk
  - Farbpalette sichern, die x.te

  Revision 1.48.2.13  2000/12/30 10:43:28  mk
  - Farbpalette sichern, die hundertste

  Revision 1.48.2.12  2000/12/29 16:57:14  mk
  - Palette sichern beim start

  Revision 1.48.2.11  2000/12/29 02:22:20  mk
  - palette sichern verbessert

  Revision 1.48.2.10  2000/12/19 00:23:56  mk
  - Farbalette vor Schell/Videomodus umschalten sichern

  Revision 1.48.2.9  2000/12/18 23:35:14  mk
  - Zeilenzahl wird jetzt nach Shell nochmals ausgelesen

  Revision 1.48.2.8  2000/12/17 23:34:41  mk
  - Config/Extern/Shell/Videomodus nach Shell setzen (Res 257,6, Help-ID 311) implementiert

  Revision 1.48.2.7  2000/11/28 09:59:54  mk
  - letzen Fix wieder entfernt, da unnoetig

  Revision 1.48.2.6  2000/11/27 21:42:59  mk
  RB:- Screenlines nach Userfont setzen

  Revision 1.48.2.5  2000/11/10 11:30:41  mk
  - fixed Bug #116292: Mehrfachstart von XP abfangen

  Revision 1.48.2.4  2000/10/23 22:17:02  mk
  - Portierung entfernt

  Revision 1.48.2.3  2000/10/09 16:28:14  mk
  - Bildschirm in Resetvideo vor Moduswechsel sichern und restaurieren

  Revision 1.48.2.2  2000/10/06 21:10:27  mk
  - spezieller Zeilenmodus wird nach Shell jetzt komplett restauriert

  Revision 1.48.2.1  2000/07/01 09:22:56  mk
  - Mailerstringanpassungen

  Revision 1.48  2000/06/19 20:18:17  ma
  - von CRC16/XPCRC32 auf Unit CRC umgestellt

  Revision 1.47  2000/06/05 16:16:22  mk
  - 32 Bit MaxAvail-Probleme beseitigt

  Revision 1.46  2000/05/17 18:45:33  mk
  - Wieder unter allen Platformen compilierbar

  Revision 1.45  2000/05/17 16:11:04  ml
  Zeilenanzahl aendern nun auch in Win32

  Revision 1.44  2000/05/17 10:23:14  oh
  -header.hdr wird bei Programmende geloescht

  Revision 1.43  2000/05/13 08:42:41  mk
  - Kleinere Portierungen

  Revision 1.42  2000/05/10 10:31:01  hd
  - Linux: sichern/holen angepasst

  Revision 1.41  2000/05/08 13:12:23  hd
  - "Rote Linien" simuliert
  - Usernamen-Darstellung an screenwidth ausgerichtet

  Revision 1.40  2000/05/07 15:57:02  mk
  - Exitprozedure wurde unter 32 Bit nicht zurueckgesetzt

  Revision 1.39  2000/05/07 11:02:54  hd
  - Anpassung an Curses

  Revision 1.38  2000/05/06 17:29:21  mk
  - DOS DPMI32 Portierung

  Revision 1.37  2000/05/06 15:57:04  hd
  - Diverse Anpassungen fuer Linux
  - DBLog schreibt jetzt auch in syslog
  - Window-Funktion implementiert
  - ScreenLines/ScreenWidth werden beim Start gesetzt
  - Einige Routinen aus INOUT.PAS/VIDEO.PAS -> XPCURSES.PAS (nur NCRT)
  - Keine CAPI bei Linux

  Revision 1.36  2000/05/03 17:15:07  hd
  - Anpassung an UnixFS (_chdir)

  Revision 1.35  2000/05/03 12:45:27  hd
  - sound() unter Linux ausgeklammert

  Revision 1.34  2000/05/02 20:11:16  mk
  - ncrt vergessen

  Revision 1.33  2000/05/02 19:13:59  hd
  xpcurses statt crt in den Units

  Revision 1.32  2000/04/27 09:06:56  jg
  - Editor: Pgdn in der letzten Textseite springt ohne scrollen zum Textende
            beim Quote-Reflow wird der Cursor an den Zeilenanfang gesetzt,
            und nicht mehr hinter das Quotezeichen

  - Lister: "/" als Hervorhebezeichen erlaubt.

  Revision 1.31  2000/04/21 15:32:34  jg
  - XP32 Bugfix: Hervorhebung im Lister,
    "_" und "*" in einer Zeile gab Probleme

  Revision 1.30  2000/04/15 21:44:45  mk
  - Datenbankfelder von Integer auf Integer16 gaendert

  Revision 1.29  2000/04/13 13:54:45  mk
  - 32 Bit: Fehlerhafte Prozentanzeigen behoben
  - 32 Bit VP: Shift-Tab funktioniert jetzt

  Revision 1.28  2000/04/13 12:48:34  mk
  - Anpassungen an Virtual Pascal
  - Fehler bei FindFirst behoben
  - Bugfixes bei 32 Bit Assembler-Routinen
  - Einige unkritische Memory Leaks beseitigt
  - Einge Write-Routinen durch Wrt/Wrt2 ersetzt
  - fehlende CVS Keywords in einigen Units hinzugefuegt
  - ZPR auf VP portiert
  - Winxp.ConsoleWrite provisorisch auf DOS/Linux portiert
  - Automatische Anpassung der Zeilenzahl an Consolengroesse in Win32

  Revision 1.27  2000/04/11 16:38:42  jg
  - Config/Optionen/Editor
  - Hilfe der Editoroptionen jetzt kontextsensitiv

  Revision 1.26  2000/04/09 19:47:22  mk
  - Benutze Register fuer ListDisplay und VP angegeben

  Revision 1.25  2000/04/09 06:51:56  jg
  - XP/32 Listdisplay (Hervorhebungsroutine fuer Lister) portiert.
  - XP/16 Listdisplay etwas umgebaut und optimiert (Tabelle in DS)

  Revision 1.24  2000/04/04 21:01:23  mk
  - Bugfixes fr VP sowie Assembler-Routinen an VP angepasst

  Revision 1.23  2000/04/04 10:33:56  mk
  - Compilierbar mit Virtual Pascal 2.0

  Revision 1.22  2000/03/25 11:46:09  jg
  - Lister: Uhr wird jetzt auch bei freiem Nachrichtenkopf eingeblendet
  - Config/Optionen/Lister: Schalter ListUhr zum (de)aktivieren der Uhr

  Revision 1.21  2000/03/25 09:03:56  mk
  - xdelay jetzt komplett entfernt

  Revision 1.20  2000/03/24 15:41:01  mk
  - FPC Spezifische Liste der benutzten ASM-Register eingeklammert

  Revision 1.19  2000/03/22 10:19:21  mk
  - Bug in ListDisplay behoben

  Revision 1.18  2000/03/20 11:58:04  mk
  - Assembler-Routinen komplett in Inline-ASM umgeschrieben

  Revision 1.17  2000/03/16 19:25:10  mk
  - fileio.lock/unlock nach Win32 portiert
  - Bug in unlockfile behoben

  Revision 1.16  2000/03/14 15:15:37  mk
  - Aufraeumen des Codes abgeschlossen (unbenoetigte Variablen usw.)
  - Alle 16 Bit ASM-Routinen in 32 Bit umgeschrieben
  - TPZCRC.PAS ist nicht mehr noetig, Routinen befinden sich in CRC16.PAS
  - XP_DES.ASM in XP_DES integriert
  - 32 Bit Windows Portierung (misc)
  - lauffaehig jetzt unter FPC sowohl als DOS/32 und Win/32

  Revision 1.15  2000/03/09 23:39:32  mk
  - Portierung: 32 Bit Version laeuft fast vollstaendig

  Revision 1.14  2000/03/08 22:36:33  mk
  - Bugfixes fr die 32 Bit-Version und neue ASM-Routinen

  Revision 1.13  2000/03/08 22:13:31  rb
  nicht mehr bentigte Routinen fr OS/2 Programmaufruf entfernt

  Revision 1.12  2000/03/06 08:51:04  mk
  - OpenXP/32 ist jetzt Realitaet

  Revision 1.11  2000/03/02 21:19:51  jg
  - Uhr beim verlassen des Nachrichtenheaders eleganter deaktiviert

  Revision 1.10  2000/02/27 08:24:57  jg
  -Strings.StrPCopy wird wieder benutzt...

  Revision 1.9  2000/02/26 18:14:46  jg
  - StrPCopy in Xp1s.inc integriert
  - Suche aus Archivviewer wieder zugelassen
    (zwecks Headereintregsuche im "O" Fenster)

  Revision 1.8  2000/02/24 23:50:11  rb
  Aufruf externer Viewer bei OS/2 einigermassen sauber implementiert

  Revision 1.7  2000/02/21 22:48:01  mk
  MK: * Code weiter gesaeubert

  Revision 1.6  2000/02/19 11:40:07  mk
  Code aufgeraeumt und z.T. portiert

  Revision 1.5  2000/02/15 20:43:36  mk
  MK: Aktualisierung auf Stand 15.02.2000

}
