{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: pmconv.pas,v 1.8 2005/01/01 11:16:28 mw Exp $ }

{ PMs mit TO-ID versehen }

{$I XPDEFINE.INC}

{$IFDEF Delphi }
  {$APPTYPE CONSOLE }
{$ENDIF }

uses  xpglobal, dos,typeform,xpdatum,xpovl,fileio;

const
      readfirst = 2500;
      TO_ID     : string[10] = '/'#0#0#8#8'TO:';
      xparc     : string[15] = 'X-XP-ARC:'#13#10;
      midlen    = 120;
      nt_ZConnect=2;

      attrCrash   = $0002;            { header.attrib: Crashmail   }
      attrFile    = $0010;            { File attached              }
      attrReqEB   = $1000;            { EB anfordern               }
      attrIsEB    = $2000;            { EB                         }
      AttrPmReply = $0100;            { PM-Reply auf AM (Maus)     }
      AttrQuoteTo = $0400;            { QuoteTo (Maus)             }
      AttrControl = $0020;            { Cancel-Nachricht }
      AttrQPC     = $0001;            { QPC-codiert                }
      realnlen    = 40;
      adrlen      = 80;
      BetreffLen  = 248;
      OrgLen      = 80;
      postadrlen  = 80;
      telelen     = 60;
      homepagelen = 90;
      hderrlen    = 40;
      custheadlen = 60;
      readempflist = false;
      readkoplist  = false;
      readOemList  = false;
      mheadercustom : array[1..2] of string[custheadlen] = ('','');

type      empfnodep=^empfnode;
          empfnode= record
                  next   : empfnodep;
                  empf   : string[AdrLen];
                end;

          header = record
                 netztyp    : byte;
                 archive    : boolean;       { archivierte PM }
                 empfaenger : string[90];    { Brett / User / TO:User }
                 empfanz    : integer;
                 kopien     : empfnodep;
                 betreff    : string[BetreffLen];
                 absender   : string[80];
                 datum      : string[11];    { Netcall-Format }
                 ddatum     : string[14];
                 zdatum     : string[22];    { ZConnect-Format; nur auslesen }
                 pfad       : HugeString;    { Netcall-Format }
                 msgid,ref  : string[120];   { ohne <> }
                 ersetzt    : string[120];   { ohne <> }
                 typ        : string[1];     { T / B }
                 crypttyp   : string[1];
                 groesse    : longint;
                 komlen     : longint;       { Kommentar-Lnge }
                 ckomlen    : longint;
                 realname   : string[realnlen];
                 programm   : string[60];    { Mailer-Name }
                 datei      : string[40];    { Dateiname }
                 prio       : byte;          { 10=direkt, 20=Eilmail }
                 oem,oab,wab: string[90];
                 oemlist    : empfnodep;
                 oar,war    : string[realnlen];
                 real_box   : string[20];    { X-XP-BOX: Absendebox }
                 hd_point   : string[25];    { X-XP-PNT: Pointname  }
                 pm_bstat   : string[20];    { X-XP-BST: Bearb.-Status }
                 org_msgid  : string[120];   { X-XP-ORGMID }
                 org_xref   : string[120];   { X-XP-ORGREF }
                 attrib     : word;          { X-XP-ATT    }
                 filterattr : word;          { X-XP-F      }
                 fido_to    : string[36];    { X-XP-FTO    }
                 organisation  : string[OrgLen];
                 postanschrift : string[PostAdrlen];
                 telefon    : string[telelen];
                 homepage   : string[homepagelen];
                 PmReplyTo  : string[80];      { Reply-To }
                 AmReplyTo  : string[80];
                 amrepanz   : integer;
                 error      : string[hderrlen];
                 ReplyPath  : string[8];
                 ReplyGroup : string[40];
                 x_charset  : string[30];
                 keywords   : string[60];
                 summary    : string[200];
                 priority   : byte;           { Priority by MH }
                 distribution:string[40];
                 pm_reply   : boolean;
                 QuoteString: string[20];
                 empfbestto : string[adrlen];
                 charset    : string[30];
                 ccharset   : string[30];
                 vertreter  : string[80];
                 XPointCtl  : longint;
                 nokop      : boolean;
                 mimever    : string[20];    { MIME }
                 mimect     : string;
                 boundary   : string[70];
                 gate       : string[80];
                 mimetyp    : string[30];
                 xnoarchive: boolean;
                 Cust1,Cust2: string[custheadlen];
                 control    : string[150];
               end;

      charr   = array[0..65530] of char;
      charrp  = ^charr;


var   f,f2  : file;
      nn    : longint;
      uname : string;
      zconn : boolean;

{$IFDEF FPC }
  {$HINTS OFF }
{$ENDIF FPC }
procedure addtoempflist(s:string);
begin
end;
{$IFDEF FPC }
  {$HINTS ON }
{$ENDIF FPC }

function compmimetyp(typ:string):string;
begin
  if left(typ,12)='application/' then
    compmimetyp:=lstr(mid(typ,12))
  else
    compmimetyp:=lstr(typ);
end;

procedure helppage;
begin
  writeln('PMs in Pufferdatei konvertieren:  PMCONV <Puffer> [Username]');
  writeln;
  writeln('Dokumentation: s. XPOINT.TXT, Anhang C');
  halt(1);
end;


procedure error(txt:string);
begin
  writeln;
  writeln(txt);
  halt(1);
end;

{$I xpmakehd.inc}


procedure checkit;
var p      : charrp;
    ps     : word;
    fs,adr : longint;
    rr     : word;
    hd     : header;
    hds    : longint;
    ok     : boolean;
    n      : longint;
    c      : char;

  procedure copymsg;
  var rr   : word;
      size : longint;
  begin
    if (left(hd.empfaenger,1)<>'/') and
       (left(hd.empfaenger,length(TO_ID))<>TO_ID) and not hd.archive and
       ((uname='') or (ustr(left(hd.empfaenger,length(uname)))<>ustr(uname)))
    then begin
      if zconn then
        blockwrite(f2,xparc[1],length(xparc))
      else
        blockwrite(f2,TO_ID[1],length(TO_ID));
      inc(nn);
      end;
    seek(f,adr);
    size:=hd.groesse+hds;
    while size>0 do begin
      blockread(f,p^,min(ps,size),rr);
      blockwrite(f2,p^,rr);
      dec(size,rr);
      end;
  end;

begin
  {$IFDEF BP }
    ps:=min(maxavail-5000,60000);
  {$ELSE }
    ps:=65536;
  {$ENDIF }
  getmem(p,ps);
  reset(f,1);
  if ioresult<>0 then error('Puffer nicht vorhanden!'#7);
  fs:=filesize(f);
  if fs<=8 then error('Puffer ist leer.');
  adr:=0; n:=0; nn:=0;
  rewrite(f2,1);
  while (adr<fs) do begin
    seek(f,adr);
    makeheader(zconn,f,0,0,hds,hd,ok,false);
    if not ok then
      error('Fehlerhafter Puffer!'#7);
    inc(n);
    write(#8#8#8#8#8,n:5);
    copymsg;
    inc(adr,hd.groesse+hds);
    end;
  close(f); close(f2);
  freemem(p,ps);
  if adr-fs>2 then begin
    writeln;
    error('Letzte Nachricht am Pufferende ist unvollstndig!');
    writeln('Bitte mit ZPR reparieren.');
    halt(1);
    end;
end;


function ZC_puffer(fn:pathstr):boolean;
var t : text;
    z : boolean;
    s : string;
    abs,emp,eda : boolean;
begin
  assign(t,fn);
  {$I-}
  reset(t);
  if ioresult<>0 then
    ZC_puffer:=false
  else begin
    abs:=false; emp:=false; eda:=false;
    s:=':';
    while (cpos(':',s)>0) and not eof(t) do begin
      readln(t,s);
      UpString(s);
      if left(s,4)='ABS:' then abs:=true;
      if left(s,4)='EMP:' then emp:=true;
      if left(s,4)='EDA:' then eda:=true;
      end;
    close(t);
    ZC_puffer:=abs and emp and eda;
    end;
end;


begin
  writeln;
  if paramcount=0 then helppage;
  uname:=paramstr(2);
  assign(f,paramstr(1));
  assign(f2,'pmconv.$$$');
  zconn:=ZC_puffer(paramstr(1));
  writeln('Puffer-Format: ',iifs(zconn,'ZCONNECT','Z-Netcall'));
  write('Puffer wird konvertiert...     ');
  checkit;
  makebak(paramstr(1),'bak');
  rename(f2,paramstr(1));
  writeln(' ok.');
  writeln;
  writeln(nn,' Nachrichten wurden konvertiert.');
end.
{
  $Log: pmconv.pas,v $
  Revision 1.8  2005/01/01 11:16:28  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.7  2004/01/09 16:18:57  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.6  2003/09/28 12:59:05  my
  MY:- Header-Variablen 'charset' (= Inhalt des ZC-Headers "CHARSET:"),
       'ccharset' (beide bisher: 7 Zeichen) und 'x_charset' (bisher: 25
       Zeichen) auf 30 Zeichen vergrert, um zuknftig beliebige,
       speziell von Gates produzierte und nicht ZC-konforme Charset-
       Bezeichner untersttzen und auswerten zu knnen.

  Revision 1.5  2003/07/30 23:09:49  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.4  2003/06/25 17:26:56  tw
  auto-de-branching

  Revision 1.3.2.6  2002/07/11 12:27:11  my
  MY:- Betrefflnge von 245 auf 248 Zeichen erhht (255-CRLF-"BET: ").
       Vorgriff auf die genderte Betreffbehandlung im UUZ, der zuknftig
       beliebig lange Betreffs ausgehend verarbeiten knnen wird, weshalb
       die Lnge des Strings "Subject: " nicht mehr bercksichtigt werden
       mu (in XP bleibt es aber b.a.w. bei der 255-Zeichen-Beschrnkung).

  Revision 1.3.2.5  2002/06/10 13:49:42  my
  MY:- Fix: Wenn die max. zulssige Betrefflnge von 250 Zeichen
       ausgenutzt wurde, wurde der Betreff in XP auf 248 und im UUZ auf
       245 Zeichen gekrzt. Max. Betrefflnge daher auf 245 Zeichen
       reduziert (mehr passt nun mal nicht eine max. 255 Zeichen lange
       Zeile, wenn noch die Headerbezeichnung "Subject: " und das
       abschlieende LF hinzukommen).

  Revision 1.3.2.4  2001/09/17 07:38:17  mw

  - PMCONV wieder compilierbar ( fileio eingetragen )

  Revision 1.3.2.3  2001/09/07 13:37:06  mk
  - removed makebak (is included fileio)

  Revision 1.3.2.2  2001/08/24 15:53:26  mw

  - Small Code-Cleanup

  Revision 1.3.2.1  2001/08/23 11:02:59  mk
  MW:- made compilable

  Revision 1.3  2000/06/05 16:16:21  mk
  - 32 Bit MaxAvail-Probleme beseitigt

  Revision 1.2  2000/04/15 10:58:31  mk
  - 1001x .DOC in .TXT geandert

  Revision 1.1  2000/03/03 13:05:36  mk
  PMCONV.PAS in den Tree aufgenommen

}
