{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 2003-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: ntfont.pas,v 1.6 2005/01/01 11:16:28 mw Exp $ }
UNIT ntfont;

INTERFACE

USES  DOS;


{ Definition eines Zeichens und eines kompletten Zeichensatzes im
  Character Generator RAM ( VideoRAM Plane 2 )
}
TYPE  CHARTYP     = ARRAY[0..31] OF BYTE;
      CHARSETTYP  = ARRAY[0..255] OF CHARTYP;

{ SETCHAR    : schreibt ein Zeichen in den Zeichengenerator im Videospeicher
  GETCHAR    : liest ein Zeichen aus dem Zeichengenerator im Videospeicher aus
  Zur Erklaerung des Parameters BLOCK siehe PROCEDURE SETBLOCK
}
PROCEDURE FONTTEST;

VAR   CHRHIG   : BYTE ABSOLUTE $40:$85;  { Zeichenhoehe in Pixeln }
      SCRHIG   : BYTE ABSOLUTE $40:$84;  { Bildschirmhoehe }
      LINWID   : WORD ABSOLUTE $40:$4A;  { Zeichen / Zeile }
      SCRSIZE  : WORD ABSOLUTE $40:$4C;  { Anzahl Bytes pro Seite }

IMPLEMENTATION

uses clip,xpfonts,xp0;
CONST CSI     : ARRAY[0..7] OF BYTE = (0,2,4,6,1,3,5,7);
      refchar : chartyp =
                ( 1,2,4,8,$10,$20,$40,$80,
                  $FF,0,$FF,0,$FF,0,$FF,0,
                  $C0,0,$C0,0,$C0,0,$C0,0,
                  0,$C0,0,$C0,0,$C0,0,$C0
                );
{
   mit welchem Zeichen getestet wird
   '!' ist leicht zu sehen, stoert aber nicht so sehr
   im realen Betrieb waere #0 sinnvoll, weil <Nul>
   eigentlich nie auf dem Bildschirm erscheint
}
const testwith : char = #0;
{
   Zeitabstand fuer den Aufruf des Umschalte- Tests
   18 ist etwas kuerzer als eine Sekunde

   1 erzeugt auf einem Athlon 600 unter WIN98 ueber 50%
   Systemlast
}
const timeout  : byte = 50;

VAR   CHSET   : ARRAY[0..6] OF CHARSETTYP ABSOLUTE $A000:0000;
      vollbild : boolean;               

function checkfont : boolean;
var   testchar : chartyp;
      i        : byte;
begin
   {getchar(0,testwith,testchar);}
   vollbild := true;
   for i := 0 to pred(sizeof(chartyp)) do begin
      if testchar[i] <> refchar[i] then vollbild := false;
   end;
   checkfont := vollbild;
end;

PROCEDURE SETCHAR(BLOCK:BYTE;C:CHAR;DATEN:CHARTYP);
VAR   R  : REGISTERS;
BEGIN
  R.AX := $1100;
  R.BH := 32;
  R.BL := BLOCK;
  R.CX := 1;
  R.DX := WORD(C); 
  R.ES := SEG(DATEN);
  R.BP := OFS(DATEN);
  INTR($10,R);
END; { SETCHAR }


CONST ISTA     : WORD = $3DA;  { Input Status Port }

PROCEDURE HSYNCH;
INLINE($8B/$16/ISTA/  {        MOV  DX,[ISTA] }
       $EC/           { LOOP1: IN   AL,DX   }
       $A8/1/         {        TEST AL,1    }
       $75/$FB/       {        JNZ  LOOP1   }
       $EC/           { LOOP2: IN   AL,DX   }
       $A8/1/         {        TEST AL,1    }
       $74/$FB        {        JZ   LOOP2   }
      );


PROCEDURE GETCHAR(BLOCK:BYTE;C:CHAR;VAR DATEN:CHARTYP);
BEGIN
  HSYNCH;
  INLINE($FA);  { CLI }
  PORTW[$3C4] := $0100; { SYNC RESET }
  PORTW[$3C4] := $0704; { SEQUENZIELLE ADRESSIERUNG }
  PORTW[$3C4] := $0300; { SYNC RESET AUFHEBEN }
  PORTW[$3CE] := $0204; { READ MAP SELECT }
  PORTW[$3CE] := $0005; { SEQUENZIELL }
  PORTW[$3CE] := $0406; { MEMORY MODE $A000, 64K, SEQUENZIELL }
  DATEN := CHSET[CSI[BLOCK]][BYTE(C)];
  PORTW[$3C4] := $0100; { SYNC RESET }
  PORTW[$3C4] := $0304; { ODD / EVEN ADRESSIERUNG }
  PORTW[$3C4] := $0300; { SYNC RESET AUFHEBEN }
  PORTW[$3CE] := $0004; { READ MAP SELECT }
  PORTW[$3CE] := $1005; { ODD / EVEN }
  PORTW[$3CE] := $0E06; { MEMORY MODE $B800, 32K, ODD/EVEN }
  INLINE($FB);  { STI }
END; { GETCHAR }

procedure XPFont;
begin
  if not ParLCD then
    if ParFontfile[1]='*' then
      InternalFont
    else
      LoadFontfile(ParFontfile);
end;

{ Versuch Fonts waehrend der Laufzeit neuzuladen fuehrt }
{ schnell zu einem bunten unleserlichen Bild            }
{ Schade                                                }

PROCEDURE FONTTEST;
begin
(*
  if (WinVersion=4) then begin
    if (nttimer=timeout) then begin
      {setchar(0,testwith,refchar);}
      vollbild := checkfont;
      if modus <> vollbild then begin
         if vollbild then xpfont;
         modus := vollbild;
         nttimer:=0;
      end;
    end else begin
      nttimer:=nttimer+1;
    end;
  end;
*)
end;

BEGIN
END.
{
  $Log: ntfont.pas,v $
  Revision 1.6  2005/01/01 11:16:28  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.5  2004/01/09 16:18:57  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.4  2003/08/19 18:26:53  mw
  MW: - Unit zum Dummy verdammt, da leider Funktion nicht sauber
        herstellbar. (Buntes unleserliches Bild nach Hin- und Herschalten
        zwischen Vollbild und Fenster.

  Revision 1.2  2003/08/19 16:57:53  mw
  MW: - Idle-Procedure fr ntfont.fonttest angezapft.
      - xpx.pas aufgerumt.

  Revision 1.1  2003/08/19 13:54:27  mw
  MW: - Neue Unit ntfont.pas :
        Automatische Bildscirmreparatur beim Schalten in den Vollbildmodus
        (Derzeit wegen exprimentellem Status noch nicht scharf geschaltet).

}  