{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ DOC-File im Blocksatz formatieren                               }
{ --------------------------------------------------------------- }
{ Originalautor           : Peter Mandrella                       }
{ Datum                   : Nov. 1991                             }
{ $Id: docform.pas,v 1.22 2005/09/14 01:26:26 jm Exp $ }
{$R-}
{$M 32768,0,655360}

uses dos,typeform,fileio,xpglobal;

const
        l_ver = '2.0a';
        ParamTab : array[92..92] of byte =
{92} ( 32 ); { Ersatzzeichen fr Leerzeichen in Schalter-Namensangaben }

var infile,outfile,logfile : pathstr;
    dlog           : text;
    rand,breite    : integer;
    NoMark         : boolean;   { keine "|"-Markierungen }
    swidata        : string;
    TriggerVar     : string;
    DocTitle       : string;
    content        : string;
    logs           : string;
    pglines        : integer;
    preproz        : integer;
    inputln        : integer;
    inputcnt       : integer;
    logn           : integer;
    inputnew       : boolean;
    docmode        : boolean;
    printmode      : boolean;
    pseudoblock    : boolean;
    pseudoblock1   : boolean;
    nopseudo       : boolean;
    verbose        : boolean;
    logon          : boolean;

    komlog, kom0log, kom1log, kom2log, f0log, fflog : integer;
    nr12log, vorlog, kaplog, blocklog, block1log : integer;
    tablog, tab0log, tab1log, utablog, tab2log : integer;
    twoplus, twomin, escsq, rmlog, rm1log, qverwlog, qverw1log: integer;

procedure Ersatzzeichen; Assembler;
asm
     cld
     mov   bx,offset ParamTab - 92
     mov   si,offset swidata
     lodsb
     mov   cl,al
     mov   ch,0
     jcxz  @@3
@@1: lodsb
     cmp   al,92
     jne   @@2
     xlat
     mov   [si-1],al
@@2: loop  @@1
@@3:
end;

procedure usage;
const crlf = #13#10;
begin
  writeln(
    '  Usage:   DocForm ? | <infile><outfile><Breite><Rand> [N] [-[_optkixv-]]'  ,+crlf+
    '            * 4 obligat. Argumente + Schalter in beliebiger Reihenfolge *'  ,+crlf+
    '    N      ->  als 5. Argument gesetzt deaktiviert die Randmarkierung "|"'  ,+crlf+
    '    ?      ->  als 1. Argument statt der Eingabedatei zeigt den Hilfstext'  ,+crlf+
    '   -_[]    ->  Logfile fehlerhaften Zeilenumbruchs (Default: DOCFORM.LOG)'  ,+crlf+
    '   -o[o]   ->  schaltet den Pseudoblocksatz zum Start AUS (-oo immer AUS)'  ,+crlf+
    '            * Breite und Rand ohne Angaben haben den Default-Wert: 71 3 *'  ,+crlf+
    '  Beisp.:  DocForm xpoint.dq xpoint.txt 68 5        (wer es klassisch mag)' ,+crlf+
    '           DocForm xpoint.dq xpoint.txt 73 1 -p       (Printformat mit -p)' ,+crlf+
    '            * Alle weiteren Schalter sind NUR mit Schalter -p[] nutzbar *'  ,+crlf+
    '           DocForm in out 71 3 -p -v --          (mit Report, temp. Files)' ,+crlf+
    '           DocForm x y 71 3 -p66 -tAnfang -k\Doku\1\     (neue Bezeichner)' ,+crlf+
    '   -p>9    ->  Printformat mit Kopf, Seitenzahlen, neuer Numerierung sowie' ,+crlf+
    '                einem formatierten Inhaltsverzeichnis/Tabellenverzeichnis.' ,+crlf+
    '   -p      ->  ohne Parameter oder -p<10 => Default-Wert: 60 Zeilen/Seite.' ,+crlf+
    '   -p-     ->  schaltet die Seitenformatierung AUS! m. Kapitelnumerierung,' ,+crlf+
    '                erweitertem Inhaltsverzeichnis, ohne Kopf u. Seitenzahlen.' ,+crlf+
    '   -x      ->  schaltet die Auswertung der Querverweise AN, Bsp.: (->S.20)' ,+crlf+
    '            * "\" Ersatzzeichen statt Leerzeichen bei der Namensvergabe *'  ,+crlf+
    '   -tf\oo  ->  Beginn/Ende beim Inhaltsverzeichnis (Default: I Einfhrung)' ,+crlf+
    '   -k\bar\ ->  neuen Namen im Seitenkopf eintragen (statt Default: FreeXP)' ,+crlf+
    '   -ixyz   ->  neue Namensbezeichnung Inhaltsverzeichnis (Default: Inhalt)' ,+crlf+
    '   -v      ->  Report, Umleitung mit ">"    --    ->  temp. Files erhalten'
          );
  halt(0)
end;

procedure stop(txt:string);
begin
  writeln('Fehler: ',txt);
  writeln;
  halt(1);
end;

procedure d2format;
type bf   = array[0..16383] of byte;
     bufp = ^bf;
var t1,t2,t3,t4,t5,t6,t7,t8 : text;
    b1,b2 : bufp;
    in1file, out1file: file;
    numread, numwritten: word;
    blockbuf: array[1..2048] of char;
    buf, s, istr : string;
    inhalt, k1buf, k2buf, k3buf, k4buf, tbuf, xbuf, wbuf, zbuf : string;
    rbuf, nbuf, oldn, abuf, olda, bbuf, oldb, kbuf, oldk : string;
    refbuf, oldrefbuf, tabname, pgstr, mainstr, substr : string;
    tablestr : string[4];
    h, ih, i, j, k , l, p, q : integer;
    mainval, tablenr : integer;
    romval, oldv, typnr, oldtypnr, newnr : integer;
    maintyp, orgtyp, doctyp, subtyp : integer;
    rand2 : integer;
    r2add : integer;
    rmark : string[2];   { "|"-Markierung am linken Rand }
    endrm : boolean;
    tabelle : boolean;
    kommentar : boolean;
    kommzeile : boolean;
    locked: boolean;
    title: boolean;
    nosplus: boolean;
    tabflag: boolean;
    mainflag: boolean;
    main1flag: boolean;
    nr12flg: boolean;
    inhaltskopf: boolean;
    normchr: set of char;
    negchr: set of char;
    bgchr: set of char;
    alfachr: set of char;
    titchr: set of char;
    tit1chr: set of char;
    lnum : integer;
      { ltotal wurde bisher nur fr Debug-Zwecke gebraucht }
    { ltotal : integer; }
    pgnum : integer;
    romnum : integer;

  Function unterstr(const n:integer):string;
  begin
    unterstr:=dup(n,'');
  end;

  Function doubstr(const n:integer):string;
  begin
    doubstr:=dup(n,'');
  end;

  Function udsc (const n:integer):string;
  begin
    udsc:=dup(n,'_');
  end;

  procedure maincheck;
  begin
      { Grobuchstaben und einzelne Kapitelnamen gelten temporr }
      {   ebenfalls als Kapitelnummern bei Tabellen }
    if (oldtypnr=3) or (oldtypnr=5) then maintyp:=oldtypnr;
      { Der erstmalige Typ der Haupt-Kapitelnumerierung hat immer Prioritt }
    if oldtypnr=orgtyp then maintyp:=orgtyp;
    case maintyp of
      1: mainval:=oldv;
      2: mainstr:=oldn;
      3: mainstr:=olda;
      4: mainstr:=oldb;
      5: mainstr:=oldk;
     else mainval:=0;
     end;
    if (maintyp=1) then str(mainval,mainstr);
    if (maintyp>1) and (maintyp<5) then begin
      k:=pos(#46,mainstr);
      if k>0 then mainstr:=copy(mainstr,1,k-1);
      end;
  end;

  procedure subcheck;
  begin
    if (newnr>1) and (newnr<5) then begin
      subtyp:=newnr;
      l:=0;
      end;
    case subtyp of
      2: if ((pos('.',xbuf)>0) and (lastchar(xbuf) in ['0'..'9'])) or (maintyp=subtyp) then substr:=xbuf;
      3: substr:=xbuf;
      4: substr:=xbuf;
      end;
    if lastchar(substr)='.' then substr:=copy(substr,1,length(substr)-1);
    oldrefbuf:=substr;
  end;

  Function romstr(romnum: integer): string;
    { erzeugt kleine rmische Seitenzahlen bis 89 }
  var x: string;
  begin
  if romnum<90 then begin;
    romstr:='';
    x:='';
    while romnum <> 0 do begin
    if romnum>=50 then begin
      x:='l';
      romnum:=romnum-50;
      end else
        if romnum>=40 then begin
          x:=concat(x,'xl');
          romnum:=romnum-40;
          end else
            if romnum>=10 then begin
              x:=concat(x,'x');
              romnum:=romnum-10;
              end else
                if romnum=9 then begin
                  x:=concat(x,'ix');
                  romnum:=romnum-9;
                  end else
                    if romnum>=5 then begin
                      x:=concat(x,'v');
                      romnum:=romnum-5;
                      end else
                        if romnum=4 then begin
                          x:=concat(x,'iv');
                          romnum:=romnum-4;
                          end else
                            if romnum>=1 then begin
                              x:=concat(x,'i');
                              romnum:=romnum-1;
                              end;
                            end;
    romstr:=x;
    end;
  end;

  procedure Kopf;
  begin
    if printmode then begin
      if inhaltskopf then begin
        if pgnum>1 then
          if (preproz=0) or (preproz=2) then writeln (t7,'');
        romnum:=pgnum;
        pgstr:=romstr(romnum) end else begin
          if (preproz=0) or (preproz=2) then writeln(t2,'');
          str(pgnum,pgstr);
        end;
      k3buf:=concat(udsc(((breite+rand-2) div 2)-7),DocTitle);
      k4buf:=concat(k3buf,udsc((breite-length(k3buf)) - (length(pgstr))-3),'  ',pgstr);
      if inhaltskopf then begin
        if (preproz=0) or (preproz=2) then writeln (t7,sp(rand),k4buf)
          end else if (preproz=0) or (preproz=2) then writeln (t2,sp(rand),k4buf);
      inc(lnum);
      if inhaltskopf then begin
        if (preproz=0) or (preproz=2) then writeln (t7,#13#10)
          end else
            if (preproz=0) or (preproz=2) then writeln (t2,#13#10);
      inc(lnum);
      title:=true;
      inc(pgnum);
      nosplus:=true;
    end;
  end;

  procedure Seite;
  begin
    { ltotal:=ltotal+lnum; }
    lnum:= 1;
    Kopf;
  end;

  procedure Pager;
  begin
    inc(lnum);
    if lnum>=pglines then Seite;
  end;

  procedure writebuf;
  begin
    if (buf<>'') then begin
      if (preproz=0) or (preproz=2) then
         write(t2,rmark,sp(rand-2+rand2+r2add))
      end else if (rmark<>'  ') and (tabelle=false) then
      if (preproz=0) or (preproz=2) then write(t2,rmark);
    r2add:=0;
    if (preproz=0) or (preproz=2) then writeln(t2,buf);
    title:=false; Pager;
    if (buf<>'') and (s='') then begin
      if (rmark<>'  ') and not endrm then begin
        if (preproz=0) or (preproz=2) then writeln(t2,rmark); Pager;
        end else
          if not title then begin
            if (preproz=0) or (preproz=2) then writeln(t2);
            Pager;
            end;
      end;
    buf:='';
    rand2:=0;
  end;

  procedure uKap;
  begin
    if buf<>'' then writebuf;
    if lnum>=pglines-2 then Seite;
    delete(s,1,1);
    s:=trim(s);
    inc(l);
    str(l,k2buf);
    oldrefbuf:=concat(substr,'.',k2buf);
    k1buf:=concat(oldrefbuf,'   ',s);
    k2buf:=unterstr(length(k1buf));
    s:=concat(rmark,sp(rand-2),k1buf,#13#10,rmark,sp(rand-2),k2buf);
    if (preproz=0) or (preproz=2) then writeln(t2,s); Pager; Pager;
      { ausfhrliches Inhaltsverzeichnis }
    k1buf:=concat(rmark,sp(rand+3),k1buf);
    k2buf:=concat(k1buf,sp((breite-length(k1buf)) - (length(pgstr)-(rand-2))),'  ',pgstr);
    if printmode then begin
      if (preproz=0) or (preproz=2) then writeln(t5,k2buf)
        end else
         if docmode and (printmode=false) then
          if (preproz=0) or (preproz=2) then writeln(t5,k1buf,'  0');
    s:='';
    title:=true;
    nosplus:=true;
    tabflag:=true;
    inc(utablog);
    end;

  procedure nametabel;
  begin
    if buf<>'' then writebuf;
      { 1 Leerzeile nach Kapitelberschriften aber nicht direkt nach dem Seitenkopf }
    if ((Title=true) and (lnum>3) and (oldtypnr<>2)) or tabflag then
      if (preproz=0) or (preproz=2) then writeln(t2);
    if lnum>=pglines-2 then Seite;
    if length(s)>3 then begin
      tabname:=trim(copy(s,4,length(s)-3));
      k1buf:=mainstr; maincheck;
      if mainstr<>k1buf then tablenr:=1 else inc(tablenr);
      str(tablenr,tablestr);
      k1buf:=concat('Tabelle ',mainstr,'-',tablestr,'  ',tabname);
      k2buf:=unterstr(length(k1buf));
      s:=concat(rmark,sp(rand-2),k1buf,#13#10,rmark,sp(rand-2),k2buf);
      if (preproz=0) or (preproz=2) then writeln(t2,s); Pager; Pager;
        { Tabellenverzeichnis }
      k2buf:=concat(tablestr,'  ',tabname);
      k1buf:=concat(rmark,sp(rand-2),mainstr,'-',k2buf);
      k2buf:=concat(k1buf,sp((breite-length(k1buf)) - (length(pgstr)-(rand-1))),pgstr);
      if printmode then begin
        if (preproz=0) or (preproz=2) then writeln(t6,k2buf)
          end else
            if docmode and (printmode=false) then
              if (preproz=0) or (preproz=2) then writeln(t6,k1buf);
      s:='';
      title:=true;
      nosplus:=true;
      inc(tab2log);
      end else begin
        s:='';
        nosplus:=true;
        end;
  end;

  procedure putQV;
  begin
    if length(s)>3 then begin
      k1buf:=trim(copy(s,4,length(s)-3));
        if printmode { and (pgstr<>'') } then
         k1buf:=concat('@',k1buf,' (->S.',pgstr,')') else
           if not printmode and docmode then
             k1buf:=concat('@',k1buf,' (->',oldrefbuf,')');
      writeln(t8,k1buf);
      end;
  end;

  procedure getQV;
  var k,i,p : integer;
  cmpstr : string;
  begin
    while pos('{@',s)>0 do begin
      inc(qverw1log);
      cmpstr:=''; k:=0; i:=0; p:=0;
      p:=pos('{@',s);
      k1buf:=copy(s,p+1,length(s)-p);
      s:=rtrim(copy(s,1,p-1));
      k:=pos('}',k1buf);
      cmpstr:=copy(k1buf,1,k-1);
      k2buf:=ltrim(copy(k1buf,k+1,length(k1buf)-k));
      reset(t8);
      k:=0;
      while not eof(t8) do begin
        readln(t8,k1buf);
        i:=length(cmpstr);
        k:=pos(cmpstr,k1buf);
        if (k>0) and (k1buf[i+1]=' ') then break;
        end;
        if k>0 then begin
          p:=pos('(->',k1buf);
          i:=pos(')',k1buf);
          if s<>'' then s:=concat(s,' ',copy(k1buf,p,i+1-p)) else
            s:=copy(k1buf,p,i+1-p);
          if (k2buf<>'') and not (firstchar(k2buf) in [#33,#41,#44,#46,#63,#58,#59]) then
            s:=concat(s,' ',k2buf) else
              s:=concat(s,k2buf);
          end else begin
            s:=istr;
            exit;
            end;
      end;
  end;

  procedure delQV;
  var k,p : integer;
  tempbuf : string;
  begin
    while pos('{@',s)>0 do begin
      inc(qverw1log);
      tempbuf:=''; k:=0; p:=0;
      p:=pos('{@',s);
      k:=pos('}',s);
      tempbuf:=ltrim(copy(s,k+1,length(s)-k));
      s:=rtrim(copy(s,1,p-1));
      if tempbuf<>'' then begin
        if not (firstchar(tempbuf) in [#33,#41,#44,#46,#63,#58,#59]) then begin
        if s<>'' then s:=concat(s,' ',tempbuf) else s:=tempbuf;
        end else begin
          if s<>'' then s:=concat(s,tempbuf) else s:=tempbuf;
          end;
        end;
      end;
  end;

  procedure dumQV;
  var k,p : integer;
  tempbuf : string;
  begin
    while pos('{@',s)>0 do begin
      inc(qverw1log);
      tempbuf:=''; k:=0; p:=0;
      p:=pos('{@',s);
      k:=pos('}',s);
      tempbuf:=ltrim(copy(s,k+1,length(s)-k));
      s:=rtrim(copy(s,1,p-1));
      if tempbuf<>'' then begin
      if s<>'' then s:=concat(s,' (->dummy)',tempbuf) else
        s:=tempbuf;
        end;
      end;
  end;

  procedure chkQV;
  begin
    if pos('{@',s)>0 then begin
      if preproz=0 then delQV else
        if preproz=1 then dumQV else
         if preproz=2 then getQV
      end;
  end;

  procedure tstTitle;
    { entfernt Unterstriche und berflssige Leerzeilen }
    {   unter den berschriften }
  begin
    if (title=true) and (s<>'') then begin
      k:=1;
      while k<=length(s) do begin
        if (s[k] in titchr) or (s[k] in tit1chr) then title:=false;
        inc(k)
        end;
      end;
    if buf<>'' then title:=false;
    if (title=true) then begin
       s:='';
       nosplus:=true;
       end;
  end;

  Function roman(rbuf : string): integer;
    { Zahlenwerte bis 89 von rmischen zu arabischen Ziffern konvertieren }
  const ronum='IVXL'; value : array [1..4] of integer = (1, 5, 10 , 50);
  var romi : byte;
  var rosum : integer;

  begin
    rosum:=0;
    romi := length(rbuf);
    while (romi >= 1) do
    begin
      if romi > 1 then
      begin
        if pos(rbuf[romi], ronum) <= (pos(rbuf[romi - 1], ronum)) then
        begin
          rosum := rosum + value[pos(rbuf[romi], ronum)];
          dec(romi);
        end
        else
        begin
          rosum := rosum + value[pos(rbuf[romi],ronum)] - value[pos(rbuf[romi - 1], ronum)];
          dec(romi, 2);
        end;
      end
      else
      begin
        rosum := rosum + value[pos(rbuf[1], ronum)];
        dec(romi);
      end;
    end;
    roman:=rosum;
  end;

  procedure Findtyp;
    { newnr 0-5 - das Ergebnis der Typ-Prfung einer Zeile ist 1 von 6 Typen }
  begin
    wbuf:=s;
    while pos(#9,wbuf) >0 do wbuf[pos(#9,wbuf)] :=' '; {TABs zu Leerzeichen}
    wbuf:=trim(wbuf);
    if length(wbuf) >=2 then begin
      tbuf:=wbuf; zbuf:=wbuf;
      xbuf:=''; kbuf:='';
        { newnr=0 -- Default-Wert und Restklasse }
      newnr:=0;
      k:= pos (' ', zbuf);
      if (k=0) then kbuf:=zbuf;
      if k > 0 then begin
        xbuf:= copy(zbuf,1,k-1);
        tbuf:= ltrim(copy(zbuf,k,length(zbuf)-(k-1)));
        zbuf:= concat(xbuf,' ',tbuf);
        if (xbuf<>'') or (kbuf<>'') then begin
            { newnr=1 -- filtert rmisch bezifferte Eintrge heraus }
          k:=0;
          while k<>length(xbuf) do begin
            if not(xbuf[k+1] in ['0'..'9']) and not(xbuf[k+1] in negchr) and (xbuf[k+1] in ['I','V','X','L']) then inc(k)
              else break;
            end;
          if (k>0) and (xbuf<>'') then begin
            if (length(xbuf)=k) then begin
              rbuf:=xbuf;
              romval:=roman(rbuf);
              newnr:=1;
              end;
            end;
            { newnr=2 -- numerische Eintrge }
          k:=0;
          while k<>length(xbuf) do begin
           if (xbuf[k+1] in ['0'..'9',#46]) then inc(k)
             else break;
           end;
          if (k>0) and (xbuf<>'') and (xbuf[1] in ['0'..'9']) then begin
            if (length(xbuf)=k) then begin
              nbuf:=xbuf;
              newnr:=2;
              end;
            end;
            { newnr=3 -- ALPHABETISCHE Eintrge }
          if (xbuf<>'') and (length(xbuf)=2) then begin
            if  (xbuf[1] in ['A'..'Z']) and (xbuf[2]='.') then begin
              abuf:=xbuf;
              newnr:=3;
              end;
            end;
            { newnr=4 --  alphabetische Eintrge }
          if (xbuf<>'') and (length(xbuf)=2) then begin
            if  (xbuf[1] in ['a'..'z']) and (xbuf[2]='.') then begin
              bbuf:=xbuf;
              newnr:=4;
              end;
            end;
        end;
      end;
      { newnr=5 -- Einwort-Eintrge }
    k:=0;
    if (kbuf<>'') then begin
      xbuf:=kbuf;
      while k<>length(xbuf) do begin
        if (xbuf[k+1] in [#0..#31,#176..#223]) then break
          else inc(k);
        end;
      if (k>0) and (xbuf<>'') then begin
        if (length(xbuf)=k) then begin
          kbuf:=xbuf;
          newnr:=5;
          end;
        end;
      end;
    end;
  end;

  procedure FindReftyp;
  begin
    oldv:=romval;
    oldn:=nbuf;
    olda:=abuf;
    oldb:=bbuf;
    oldk:=kbuf;
    oldtypnr:=typnr;
    s:=refbuf;
    Findtyp;
    typnr:=newnr;
    s:=istr;
  end;

  procedure Kap;
  begin
    if lnum>=pglines-3 then Seite;
    wbuf:=refbuf;
    kbuf:=refbuf;
    k:= pos (' ', wbuf);
    if k > 0 then begin
        { newnr=0 meint hier undefinierte Mehrwort-Bezeichner }
      if newnr>0 then begin
        p:=pos ('.', wbuf);
        if (p=k-1) and (newnr=2) then begin
          mainflag:=true; main1flag:=true;
          end;
        xbuf:= copy(wbuf,1,k-1);
        oldrefbuf:=xbuf;
        tbuf:= ltrim(copy(wbuf,k,length(wbuf)-(k-1)));
        { Kapitelberschriften und Zahlen mit nur einem Punkt am Ende, die }
        {   ebenfalls nur fr Kapitelberschriften verwendet werden, werden  }
        {   doppelt unterstrichen. Bei Seitenformatierung wird der Unterstrich }
        {   der Lnge des Kapitelnamens angepat, weil der Seitenkopf dominiert. }
        end;
      if ((newnr=orgtyp) and (maintyp<>subtyp)) or mainflag then begin
        if newnr>0 then begin
          if mainflag then kbuf:= concat(xbuf,'   ',tbuf);
          if not mainflag then kbuf:= concat(xbuf,'    ',tbuf);
          if printmode then wbuf:=doubstr(length(kbuf)) else wbuf:=doubstr(breite-1);
            { Vor jedem Hauptkapitel findet ein Seitenvorschub statt, }
            {   lnum>3 verhindert hier nur zwei aufeinander folgende, wenn dieser }
            {   gerade a.a.O. vorgenommen wurde }
          if lnum>3 then Seite;
          mainflag:=false;
          end;
        end else begin
          if newnr>0 then kbuf:= concat(xbuf,'   ',tbuf);
          if printmode then wbuf:=unterstr(length(kbuf)) else wbuf:=unterstr(breite-1);
          mainflag:=false;
          end;
        { nicht numerierte Einwort-Inhaltsbezeichner werden doppelt unterstrichen und }
        {   dienen temporr wie Grobuchstaben zur Tabellenbeschriftung, erzeugen }
        {   im Unterschied dazu aber keine Unterkapitelberschriften. }
        {   (Und als Hauptgliederungsmerkmal wird dennoch wie bei Hauptkapiteln ein }
        {   Seitenvorschub vorgenommen.) }
      end else begin
        oldrefbuf:=wbuf;
        if printmode then wbuf:=doubstr(length(kbuf)) else
          wbuf:=doubstr(breite-1);
        if lnum>3 then Seite;
          end;

    s:=concat(rmark,sp(rand-2),kbuf,#13#10,rmark,sp(rand-2),wbuf);
      { eine zustzliche Zeile vor den Kapitelberschriften, ist eher ein Hack, aber.. }
      {   die Optik verschiebt sich etwas ohne Seitenkopf. Die Vermutung geht dahin, da }
      {   die .DQ-Rohfassung eher fr eine Seitenformatierung ausgelegt sein wird, die }
      {   etwas sparsamer mit greren Abstnden durch Leerzeilen umgeht. }
    if (maintyp=newnr) and not (printmode) then begin
      if (preproz=0) or (preproz=2) then writeln(t2); Pager;
      end;
    if (preproz=0) or (preproz=2) then writeln(t2,s); Pager; Pager;
    if (preproz=0) or (preproz=2) then writeln(t2); Pager;
    if ((orgtyp=newnr) and (maintyp<>subtyp )) or main1flag or (newnr=5) then begin
        { Die zustzliche Leerzeile nach der Kapitelberschrift wird erforderlich um }
        {   Mindestabstnde zu gewhrleisten, da Leerzeilen nach einer Kapitelberschrift }
        {   immer justiert werden. }
      if (preproz=0) or (preproz=2) then writeln(t2); Pager;
      end;

      { ausfhrliches Inhaltsverzeichnis }
    if newnr>0 then begin
      k:= pos (' ', refbuf);
      if k=0 then k1buf:=refbuf else if k>0 then begin
        if ((newnr=orgtyp) and (maintyp<>subtyp)) then
          k1buf:= concat(xbuf,'    ',tbuf) else if newnr=3 then
            k1buf:= concat('   ',xbuf,'   ',tbuf) else
            k1buf:= concat('   ',xbuf,'   ',tbuf);
        end;
      k1buf:=concat(rmark,sp(rand-2),k1buf);
      k2buf:=concat(k1buf,sp((breite-length(k1buf)) - (length(pgstr)-(rand-2))),'  ',pgstr);
      if printmode then begin
        if (preproz=0) or (preproz=2) then writeln(t5,k2buf)
          end else
            if docmode and (printmode=false) then
              if (preproz=0) or (preproz=2) then writeln(t5,k1buf,'  0');
        { Mehrwortbezeichner }
      end else begin
        k1buf:=concat(rmark,sp(rand-2),refbuf);
        k2buf:=concat(k1buf,sp((breite-length(k1buf)) - (length(pgstr)-(rand-2))),'  ',pgstr);
        if printmode then begin
          if (preproz=0) or (preproz=2) then writeln(t5,k2buf)
            end else
             if docmode and (printmode=false) then
               if (preproz=0) or (preproz=2) then writeln(t5,k1buf,'  0');
        end;
    s:='';
    title:=true;
    nosplus:=true;
      { erneutes Einlesen aus dem Referenzinhaltsverz. und Typprfung }
    if not eof(t4) then readln(t4,refbuf);
    FindRefTyp;
    mainflag:=false; main1flag:=false;
  end;

  procedure Titlecheck;
      {  Check der berschriften }
      {     Achtung!  Keine Punkte hinter rmische Ziffern verwenden,             }
      {       wegen des Unterschied zu "A. - Z."                                  }
      {   - Anfang und Ende des Inhaltsverz.: z.B. rmische I und ein Worteintrag }
      {   - Der Bezeichner darf sich spter wiederholen, aber die                 }
      {       ersten beiden Vorkommen sind signifikant.                           }
      {   - ein Punkt hinter der letzten Ziffer wird immer entfernt,              }
      {      wenn es nicht der erste und einzige ist.                             }
      {   -  Leerzeichen zwischen Bezeichner und Eintrag werden auf 1 getrimmt.   }
  begin
    if newnr>0 then begin
      tbuf:=wbuf;
      if length(wbuf) >=2 then begin
        k:= pos (' ', wbuf);
        p:= pos ('.', wbuf);
        if k > 0 then begin
          xbuf:= copy(wbuf,1,k-1);
          if p<>k-1 then begin
            if (xbuf[k-1]='.') and not (xbuf[k-2] in alfachr) then delete (xbuf,k-1,1);
            end else if (p=0) and (newnr=2) then xbuf:=concat(xbuf,'.');
          tbuf:= ltrim(copy(wbuf,k,length(wbuf)-(k-1)));
          wbuf:=concat(xbuf,' ',tbuf);
          end;
        end;
      end;
  end;

  procedure Vorspann;
    { 1. sichert ggf. Deck- und Schmuckseite }
    { 2. sichert Inhaltsverzeichnis mit formatierten Eintrgen }
  begin

      { zuerst wird immer geprft, ob die Startvariable eingelesen wurde }
    Titlecheck;
    if wbuf=inhalt then begin
      inc(ih);
      if (ih=1) then begin
        if newnr<5 then begin

            { Eine gltige Kapitelnumerierung in der Startvariablen "inhalt", bedeutet }
            {   doctyp=1 .}
            { Der Bezeichner in "inhalt" erscheint wieder als erste Zeile im Textteil. }
          doctyp:=1;
          maintyp:=newnr;
          end else

            { Keine gltige Kapitelnumerierung in der Startvariablen "inhalt", bedeutet }
            {   doctyp=2, fr die Mglichkeit aus irgendwelchen Grnden  ein Vorspann vor }
            {   den Text zu setzen, der nicht im Inhaltsverzeichnis aufgefhrt wird... }
            {   oder um die Startvariable frei zu bennenen...}
            {   Der Bezeichner in "inhalt" markiert *dann* lediglich das Ende des Inhalts- }
            {   verzeichnisses und *nicht* die erste Zeile im Textteil, obwohl er diesem  }
            {   voransteht.}
            doctyp:=2;
          end;
        end;

      { Solange keine Startvariable identifiziert wurde, erfolgt }
      {   das Schreiben des Vorspanns in das Temp-File. }

    if (ih=0) then begin
      if wbuf='' then begin

           inc(nr12log);

           nr12flg:=true;

           if (preproz=0) or (preproz=2) then writeln(t3,s);

         end else begin

           if (preproz=0) or (preproz=2) then

             if s<>'' then writeln(t3,rmark,sp(rand-2),s) else writeln(t3);

	         end;

        inc(vorlog);
        end;

      { Hier werden alle gltigen Angaben fr das Referenz-Inhaltsverzeichnis in }
      { eine temporre Datei geschrieben. Leerzeilen und Seitenvorschub werden ignoriert. }

    if (ih=1) then begin
        if wbuf='' then inc(nr12log);
        if (wbuf<>'') and (wbuf<>'') and (wbuf<>#60#60'|') and (wbuf<>#62#62'|') then begin

          { Nur wenn die Startvariable "inhalt" Teil des Inhaltsverzeichnisses ist, also }
          { eine gltige Kapitel-Nummmer bergibt, wird dieser Bezeichner auch spter }
          { im ausfhrlichen Inhaltsverzeichnis des Dokuments eingetragen werden.}

        if doctyp=1 then begin
          if newnr>0 then writeln(t4,wbuf) else writeln(t4,s) end else
            if (doctyp=2) and (wbuf<>inhalt) then begin
            if newnr>0 then writeln(t4,wbuf) else writeln(t4,s) end;

          { Falls in "inhalt" eine Kapitelnumerierung festgestellt wurde (doctyp=1), }
          {   wird die nchste danach identifizierte Numerierung als Unterkapitel-Typ }
          {   als sog "subtyp" fr die "black square"-Konvertierung) ermittelt, aber erst }
          {   wenn "maintyp" nach "orgtyp" kopiert wurde. Damit gleiche Typen "main-" und }
          {   "subtyp" zugwiesen werden knnen, mu definitiv eine weitere Zeile gelesen }
          {   worden sein. Dieser "subtyp" kann also auch derselbe wie der "maintyp" sein: }
          {   z.B. Kapitelnummern wren 1., 2. .. , Unterkapitel dann 1.1 usw. mit maximal }
          {   einem (!) Punkt in der Ziffernkombination im Inhaltsverzeichnis, da weitere }
          {   Unterpunkte wie 1.1.1, 1.1.3 automatisch vergeben werden. }
          { Der "maintyp" kann sich nur ausnahmsweise bei A. B. usw. ndern, damit die }
          {   Tabellenbeschriftung unabhngig vom Kapitelnumerierung erfolgen kann. }
          {   M.a.W. wird der "maintyp" bei den Hauptkapiteln unverndert beibehalten. }
          {   Grobuchstaben (wie im Anhang) erzwingen aber temporr den Wechsel, haben }
          {   dieselbe Wertigkeit wie andere Hauptkapitelnummern (auer beim Seitenkopf!). }
          {   Der "subtyp", also der Unterkapitel-Typ dagegen kann sich jederzeit ndern. }

          if (orgtyp<>0) and (subtyp=0) then subcheck;

          { Falls in "inhalt" keine Kapitelnumerierung festgestellt wird - doctyp=2 -, }
          {   wird die nchste danach identifizierte Numerierung fr die Kapitel genommen; }
          {   Damit sind beliebige Wort-Zeichenkombinationen zur Abgrenzung des Inhaltsvz. }
          {   statthaft, und der Text mu daher auch nicht mit einer gltigen berschrift }
          {   beginnen. }
        if (maintyp=0) and (newnr>0) and (newnr<5) then maintyp:=newnr;
        if orgtyp=0 then orgtyp:=maintyp;
        end;
      end;
    if (ih=2) then begin
      locked:=true;
      Seite;
        { der temp. Vorspann wird hier zum erneuten Lesen zurckgesetzt .. }
      reset(t3);
        { .. das temp. Referenz-Inhaltsverzeichnis ebenfalls. }
      reset(t4);

          { die 1. Zeile des Referenzinh.verz. aus dem Temp-File lesen .. }
        if not eof(t4) then readln(t4,refbuf);

          { .. und bei doctyp=1 ins Temp-File des ausfhrlichen Inhaltsver- }
          {      zeichnisses schreiben }
      if doctyp=1 then begin
        Kap;
        inc(kaplog);
        end;
          { bei doctyp=2 nur den Referenztyp ermitteln }
      if doctyp=2 then Findreftyp;
      end;
  end;

  procedure inhaltformat; { Formatierungsteil fr makeinhalt }

    { Sorry, die Wiederverwendung von Variablennamen, deren Namen ursprnglich }
    {   fr andere Routinen gedacht sind, wirkt etwas irritierend, aber }
    {   solange die Routine nur am Schlu von d2format aufgerufen wird, gibt es }
    {   keine Kollisionen. }

  begin
    if i>l then begin
      k:=0;
      if p>0 then begin
        k:=l-p; ih:=p;
        while p<15 do begin
          if pos(' ',istr[p])=0 then break
            else inc(p);
          end;
        if ih<p then ih:=p-ih+1;
        while k>0 do begin
          if pos(' ',istr[k])=0 then dec(k)
            else break;
          end;
        if k>2 then begin
          if printmode and (lnum>=pglines-2) then Seite;
          write(t7,oldn);
          oldn:=concat(oldb,oldk,sp((rand)+ih),copy(s,k+1,(i-k)+1));
          s:=concat(copy(s,1,k-1),#13#10,oldn);
          if printmode then
            s:=concat(s,sp(breite-(length(oldn)+length(olda)-(rand-1))),sp(length(olda)-ih),olda);
          writeln(t7,s); Pager; Pager;
          end;
        end;
      end else begin
        if printmode then
          s:=concat(oldn,istr,sp(breite-(length(istr)+length(oldn)+length(olda)-(rand-1))),olda)
            else if docmode and (printmode=false) then s:=concat(oldn,istr);
        if (newnr=orgtyp) and (lnum>=pglines-2) then Seite;
        writeln(t7,s); Pager;
        end;
  end;

    { Aufruf erfolgt erst am Ende von docform }
  procedure maketabel;
  begin
      { das temp.  Tabellenverzeichnis wird zum erneuten Lesen zurckgesetzt .. }
    reset(t6);
      { .. und Anhngen des Tabellenverzeichnisses an das Ende des Texteils }
    while not eof(t6) do begin
      readln(t6,s);
      writeln(t2,s); Pager
      end;
  end;

    { Aufruf erfolgt erst am Ende von docform }
  procedure makeinhalt;

   { Die Formatierung des umfassenden Inhaltsverzeichnisses ist nicht vollstndig }
   {   in das berschriften-Konzept integriert worden. Aber im Grunde ausreichend }
   {   - vor allem - fr die Formatierung der typischen CrossPoint-Dokumente. }
   {   Der Hauptgrund ( der separaten Behandlung, genauer eines ziemlichen Hacks) }
   {   liegt vor allem darin, da die Schnittstellen fr denkbare Postprozessoren, }
   {   oder fr mgliche weitere Konvertierungsformate etc. nicht abschlieend }
   {   definiert sind und somit auch die Entscheidung darber offen gelassen wurde, }
   {   ob noch weitere Features dazu kommen oder eher eine Spezialisierung erfolgt. }
  var tstvar:  integer;
  subchapt: boolean;
  mainchapt: boolean;

  begin

    { Bisher wird das Tabellenverzeichnis an das Dokument angehngt }
    {   und der Eintrag fr die berschrift im Inhaltsverzeichnis vorausgesetzt. }
    {   Alternativ knnte der Eintrag "Tabellenverzeichnis" als (erster und einziger }
    {   Bezeichner des Programms) festgelegt werden und damit die Lage des Eintrags }
    {   im Dokument oder direkt hinter das Inhaltsverzeichnis gesteuert werden. }
    {   indem der Eintrag z.B. weggelassen wird, und das Programm bei vorhandenen }
    {   Tabellenbezeichnern den Eintrag im Inhaltsverzeichnis erzeugt. }

    maketabel;

      { Initialisierung beim Seitenformat }

    if printmode then inhaltskopf:=true;
    pgnum:=1; Seite;

      { berschrift des Inhaltsverzeichnisses im Inhaltsverzeichnis }
    if printmode then oldn:=doubstr(length(content)) else oldn:=doubstr(breite-1);
    l:=length(content);
    if printmode then s:=concat(sp(rand),content,sp(breite-(rand+l)+(rand-2)),'i',#13#10,sp(rand),oldn)
      else s:=concat(sp(rand),content,#13#10,sp(rand),oldn);
    writeln(t7,s); Pager; Pager;

    { das temp. Inhaltsverzeichnis t5 wird zum erneuten Lesen zurckgesetzt }
    { das qualifizierte Inhaltsverzeichnis wird temporr nach t7 geschrieben }
    subchapt:=false;
    mainchapt:=false;
    reset(t5);
    while not eof(t5) do begin
      olda:=''; oldb:='  '; oldk:='';
      k:=0; l:=0; ih:=0; oldn:='';
      tabflag:=false;
      mainflag:=false;
      readln(t5,s);
      k:=length(s);
        { Seitenummer erfassen }
      while k>0 do begin
        if pos(' ',s[k])=0 then begin
          inc(ih);
          dec(k);
          end else break;
        end;
        { Seitenummer }
      olda:=trim(copy(s,k,ih+1));
      s:=copy(s,1,k);
      ih:=0;
      if left(s,1)='|' then begin
        oldb:='| ';
        delete(s,1,1);
        end;
      istr:=trim(s);
      Findtyp;
      if newnr=0 then begin
          { Findtyp erkennt keine Buchstaben-Zahlen-Kombination }
        if (length(s)>=3) then s:=concat(copy(istr,1,2),' testdummy');
        Findtyp;
          {  Nummerierung Grobuchstabe mit Punkt danach? }
        if newnr=3 then tabflag:=true else newnr:=0;
        end;
      s:=istr;
      i:=length(istr);
      p:=pos(' ',istr);

        { Zahlen mit lediglich einem Punkt dahinter sind hier bei der abschlieenden }
        {   Formatierung des Inhaltsverzeichnisses immer Hauptkapitel. Das durchbricht }
        {   hier die Logik der maintyp-subtyp-Unterscheidung, die in "Vorspann"  }
        {   durchgehalten wird, was aber in Kauf genommen werden mu, solange nicht }
        {   dieser Teil vollstndig in den Abschnitt fr berschriften "Kap", aufgeht. }
      if (newnr=2) and (pos(#46,s[p-1])>0) then mainflag:=true;
      if p>0 then oldk:=sp(p);

      if ((newnr=3) or (newnr=2) or (newnr=4)) and not mainflag then begin
        if (newnr=3) and (tabflag=false) then begin
          writeln(t7); Pager;
          end;
        l:=breite-(length(olda)+9);
        oldn:=concat(oldb,sp((rand-2)+4));
        inhaltformat;
        subchapt:=true;
        mainchapt:=false;
        end;

      if (newnr=1) or (newnr=5) or (newnr=0) or mainflag then begin
        if not mainchapt then writeln(t7); Pager;
        mainchapt:=true;
        if not subchapt then writeln(t7); Pager;
        l:=breite-(length(olda)+5);
        oldn:=concat(oldb,sp((rand-2)));
        inhaltformat;
        if ((newnr=orgtyp) and (orgtyp<>subtyp)) or mainflag then begin
          writeln(t7); Pager;
          end;
        end;
        oldtypnr:=newnr;
        subchapt:=false;
      end;
      { etwas zur Optik auf dem Bildschirm }
    if printmode then begin
      for tstvar:=1 to 2 do begin
        if lnum<pglines then writeln(t7);
        inc(lnum)
        end;
      end else if docmode and (printmode=false) then begin
          { justiert den Abstand vom Ende des Inhaltsvz. zur ersten Kapitelberschrift }
          {   und restauriert evtl. vorhandenes FF im alten Inhaltsverz. }
        if nr12flg then writeln(t7,'') else writeln(t7);
        writeln(t7);
        end;
  end;

        { 1. Teil der Fehlerbehandlung beim Umbruch:          }
        {   Prfung auf Zeichenketten und Leerzeichen         }
        { Der Teil dient einerseits dazu, grob vorzusortieren }
        { und um lngere fehlerhafte Teile besser kenntlich   }
        { fr die Ausgabe auf dem Bildschirm zu erhalten      }
  procedure chkerr1;
  begin
      p:=length(s);
      if p>breite then begin
        h:=0; i:=0; j:=0; k:=0; q:=0;
        while i<=p-1 do begin
          if (s[i+1] in [#32]) then begin
            inc(q); k:=0;
            if j<q then j:=q;
            end else begin
              inc(k); q:=0;
              if h<k then h:=k;
              end;
          inc(i);
          end;
        if (h>breite-3) or (j>breite div 3) then begin
          inc(logn);
            { Kontrollmeldung auf dem Bildschirm oder ins Logfile }
          if (preproz=0) or (preproz=2) then
            if logon then writeln(dlog,inputln,': ',s) else
              writeln(inputln,': ',s);
          if pseudoblock and not nopseudo then begin
            if buf<>'' then begin
              if (preproz=0) or (preproz=2) then writeln(t2,rmark,sp(rand-2),buf);
                buf:=''; Pager;
              rand2:=0;
              end;
            if (preproz=0) or (preproz=2) then writeln(t2,rmark,sp(rand-2),s); Pager;
            s:='';
            nosplus:=true;
            end;
          end;
        end;
  end;

  procedure wr2form;
  var p,pp : byte;
      fs   : string[80];
      ls   : byte;                   { Anzahl Leerstellen }
      lp   : array[1..80] of byte;   { Position der Leerstellen }
      lc   : array[1..80] of byte;
      spc  : byte;
      count: byte;
      i, j, q : integer;
  begin
    i:=0; j:=0; q:=0;
    title:=false;
    if (preproz=0) or (preproz=2) then write(t2,rmark,sp(rand-2+rand2+r2add));
    if r2add<>0 then begin
      if (preproz=0) or (preproz=2) then write(t2,left(buf,-r2add));
      delete(buf,1,-r2add);
      end;
    p:=breite+1-rand2;
    if (buf[p]='-') then begin
      if (buf[p-1]='(') then dec(p);
      dec(p);
      end;
    while (buf[p]<>' ') and ((buf[p]<>'-') or ((buf[p]='-') and (buf[p-1]='('))) and
          ((buf[p]<>'/') or not (buf[p-1] in normchr)) and (p>0) do
      dec(p);
    if p<3 then begin
      if (preproz=0) or (preproz=2) then
        if (preproz=0) or (preproz=2) then writeln(t2,left(buf,breite-rand2));
        Pager;
      delete(buf,1,breite-rand2);
      end
    else begin
      if buf[p]='/' then dec(p);
      if buf[p]='(' then dec(p);
      fs:=trim(left(buf,p));
      delete(buf,1,p);
      if (buf<>'') and (buf[1]=' ') then
        delfirst(buf);
        { 2. Teil Fehlerbehandlung beim Pseudo-Blocksatz: }
        {   Prfung nur der Leerzeichen }
      p:=length(fs);
      i:=0; j:=0; q:=0;
      while i<=p-1 do begin
        if (fs[i+1] in [#32]) then begin
          inc(q);
          if j<q then j:=q;
          end;
        inc(i);
        end;
        { Pseudo-Blocksatz, wenn mindestens ein Leerzeichen aber nicht mehr }
        {   als ein Drittel im String FS Leerzeichen sind..}
      if (j>0) and (j<p div 3) then begin
        if pseudoblock and not nopseudo then begin
          ls:=0;
          for p:=1 to length(fs) do
            if fs[p]=' ' then begin
              inc(ls); lp[ls]:=p;
              end;
          fillchar(lc,sizeof(lc),0);
          count:=0; spc:=0;
          while length(fs)<breite-rand2 do begin
            repeat
              pp:=random(ls)+1;
            until lc[pp]=count;
            insert(' ',fs,lp[pp]);
            for p:=pp+1 to ls do inc(lp[p]);
            inc(lc[pp]);
            inc(spc);
            if spc=ls then begin
              inc(count); spc:=0;
              end;
            end;
          end;
        end else begin
          inc(logn);
          if (preproz=0) or (preproz=2) then
            if logon then begin
                { Kontrollmeldung auf dem Bildschirm oder ins Logfile }
              if inputnew then writeln(dlog,inputln,': ',fs) else
               writeln(dlog,inputln-inputcnt,':~',fs)
               end else
                 if inputnew then writeln(inputln,': ',fs) else
                 writeln(inputln-inputcnt,':~',fs);
          end;
      if (preproz=0) or (preproz=2) then writeln(t2,fs); Pager;
      end;
    r2add:=0;
  end;

begin
  new(b1); new(b2);
  assign(t1,infile); settextbuf(t1,b1^); reset(t1);
  assign(t2,'.\D2$2FORM.TMP'); settextbuf(t2,b2^); rewrite(t2);
  assign(t3,'.\D2$3FORM.TMP'); rewrite(t3);
  assign(t4,'.\D2$4FORM.TMP'); rewrite(t4);
  assign(t5,'.\D2$5FORM.TMP'); rewrite(t5);
  assign(t6,'.\D2$6FORM.TMP'); rewrite(t6);
  assign(t7,'.\D2$7FORM.TMP'); rewrite(t7);
  if preproz >0 then assign(t8,'.\DX$8FORM.TMP');
  if preproz=1 then rewrite(t8) else if preproz=2 then reset(t8);
  {-------------------------------}
  buf:='';  rmark:='  ';
  inhalt:=''; pgstr:=''; k1buf:=''; k2buf:='';
  k3buf:=''; k4buf:=''; tbuf:=''; kbuf:='';
  refbuf:=''; oldrefbuf:='';
  wbuf:=''; xbuf:=''; zbuf:='';
  rbuf:=''; nbuf:=''; abuf:=''; bbuf:='';
  oldn:=''; olda:=''; oldb:=''; oldk:='';
  tabname:='';
  mainstr:=''; substr:='';
  endrm:=false;
  tabelle:=false;
  kommentar:=false;
  locked:=false;
  title:=false;
  nosplus:=false;
  tabflag:=false;
  mainflag:=false;
  main1flag:=false;
  nr12flg:=false;
  inhaltskopf:=false;
  rand2:=0; r2add:=0;
  h:=0; ih:=0; i:=0; j:=0; k:=0; l:=0; p:=0; q:=0;
  doctyp:=0; maintyp:= 0; orgtyp:=0; subtyp:=0;
  typnr:=0; oldtypnr:=0; romval:=0; oldv:=0;
  mainval:=0; pgnum:=1 ; { ltotal:=0; }
  lnum:=2; {entsprechend dem ersten Seitenkopf}
  tablenr:=1;
  negchr:=['a'..'z','','','',#46];
  alfachr:= ['a'..'z','A'..'Z'];
  normchr:=['a'..'z','A'..'Z','','','','','','','','0'..'9'];
  titchr:= ['a'..'z','A'..'Z','','','','','','','','0'..'9','<','>','@','.','|','+',#44];
   { plus ein paar Grafikzeichen wegen der Tabellen }
  tit1chr:=[#179,#183..#195, #197,#213..#223];

  {-------------------------------}
  s:=TriggerVar;
  Findtyp;
  Titlecheck;
  inhalt:=wbuf;
  while not eof(t1) do begin
    readln(t1,s);
    inc(inputln);
    inputnew:=true;
    if inputcnt>0 then dec(inputcnt);
    istr:=s;
    if kommentar then inc(kom0log);
    if left(s,1)='%' then begin
      kommzeile:=true;
      inc(kom0log);
      s:='';
      end else
        kommzeile:=false;
        if left(s,3)='>>%' then begin
          kommentar:=true;
          inc(kom1log);
          s:=''
          end else
            if left(s,3)='<<%' then begin
              kommentar:=false;
              kommzeile:=true;
              inc(kom2log);
              s:='';
              end else
                if s='>>|' then inc(rmlog) else if s='<<|' then inc(rm1log);
    if not printmode then begin
      if (s='>>F0') or (s='>>f0') then begin
        kommzeile:=true;
        inc(f0log);
        s:='';
        end else
          if (s='>>FF') or (s='>>ff') then begin
            kommzeile:=true;
            inc(fflog);
            s:='';
            end;
      end;
    if not kommentar and not kommzeile then begin
      Findtyp;
      if not locked then Vorspann else begin
        if (typnr=newnr) then begin
          Titlecheck;
          if (pos(refbuf,wbuf)>0) then begin
            if (maintyp<>newnr) or (maintyp<>orgtyp) or (subtyp=newnr) then subcheck;
            Kap;
            inc(kaplog);
            end;
          end;
        if s='>>|' then rmark:=iifs(nomark,'  ','| ') else
          if s='<<|' then endrm:=true
            else begin { end nach wr2form und writebuf }
              if (s='>>O') or (s='>>o') then begin
                pseudoblock:=false;
                inc(blocklog);
                nosplus:=true;
                end else
                  if (s='<<O') or (s='<<o') then begin
                    pseudoblock:=true;
                    inc(block1log);
                    nosplus:=true;
                    end else
                      if (left(s,3)='>>T') or (left(s,3)='>>t') then begin
                        tabelle:=true;
                        inc(tablog);
                        nametabel;
                        end else
                          if (left(s,3)='>>N') or (left(s,3)='>>n') then begin
                            tabelle:=false;
                            inc(tab0log);
                            nametabel;
                            end else
                              if (s='<<T') or (s='<<t') then begin
                                tabelle:=false;
                                tabname:='';
                                inc(tab1log);
                                nosplus:=true;
                                end;
              if printmode then
                if (s='>>F0') or (s='>>f0') then Kopf else
                  if (s='>>FF') or (s='>>ff') then Seite;
              if left(s,1)='' then uKap;
              if s<>'' then tabflag:=false;
              if printmode then
                if left(s,1)=#12 then begin
                  inc(nr12log);
                  s:='';
                  nosplus:=true;
                  end else
                    if left(s,1)=#12 then begin
                      if buf<>'' then begin
                        if (preproz=0) or (preproz=2) then
                          writeln(t2,rmark,sp(rand-2),buf); buf:=''; end;
                      if (preproz=0) or (preproz=2) then write(t2,s[1]);
                      delete(s,1,1);
                      end;
              if nosplus=false then begin
                if (left(s,3)='>>@') then begin
                  inc(qverwlog);
                  if preproz=1 then putQV;
                  s:='';
                  nosplus:=true;
                  end;
                tstTitle;
                if tabelle then begin
                  if buf<>'' then writebuf;
                  if (preproz=0) or (preproz=2) then
                    writeln(t2,rmark,sp(rand-2),s); Pager;
                  s:='';
                  nosplus:=true;
                  end;
                end;
              if nosplus=false then begin
                if left(s,2)='--' then begin
                   inc(twomin);
                   if buf<>'' then writebuf;
                   rand2:=ival(copy(s,3,2));
                   if rand2>0 then begin
                     r2add:=-rand2;
                     delete(s,1,4);
                     end;
                   end else
                     if left(s,2)='++' then begin
                       inc(twoplus);
                                 if buf<>'' then writebuf;
                       rand2:=ival(copy(s,3,2));
                       if rand2>0 then delete(s,1,4);
                       end;
                   end;
                if left(s,2)='\' then begin
                  delete(s,1,1);
                  inc(escsq);
                  end;
                if nosplus=false then begin
                  chkQV;
                  chkerr1;
                  if (buf='') or (buf=' ') then begin
                    inputcnt:=0; inputnew :=true end else begin
                      inputnew:=false; inc(inputcnt);
                      end;
                  if buf<>'' then buf:=buf+' ';
                  buf:=buf+s;
                  while length(buf)>breite-rand2 do
                    wr2form;
                  if (length(s)<=breite-rand2) then writebuf;
                  end;
              end; { fr else begin nach endrm:=true }
        nosplus:=false;
        if endrm and (buf='') then begin
          rmark:='  ';
          endrm:=false;
          end;
        end;
      end;
    end;
  if (preproz=0) or (preproz=2) then makeinhalt;
  close(t1);
  close(t2);
  close(t3);
  close(t4);
  close(t5);
  close(t6);
  close(t7);
  if preproz>0 then close(t8);
  dispose(b1); dispose(b2);
  if (preproz=0) or (preproz=2) then begin
    assign (in1file, 'D2$3FORM.TMP'); { Vorspann }
    reset (in1file, 1);
    assign (out1file, outfile);
    rewrite (out1file, 1);
    repeat
      blockread(in1file, blockbuf, sizeof(buf), numread);
      blockwrite(out1file, blockbuf, numread, numwritten);
    until (numread = 0) or (numwritten <> numread);
    close (in1file);
    assign (in1file, 'D2$7FORM.TMP'); { ausfhrliches Inhaltsverzeichnis }
    reset (in1file, 1);
    repeat
      blockread(in1file, blockbuf, sizeof(buf), numread);
      blockwrite(out1file, blockbuf, numread, numwritten);
    until (numread = 0) or (numwritten <> numread);
    close (in1file);
    assign (in1file, 'D2$2FORM.TMP'); { Textteil }
    reset (in1file, 1);
    repeat
      blockread(in1file, blockbuf, sizeof(buf), numread);
      blockwrite(out1file, blockbuf, numread, numwritten);
    until (numread = 0) or (numwritten <> numread);
    close (in1file);
    close (out1file);
    end;
end;


{ Ab hier wieder das "einfache" docform v1.03/1.04  mit wenigen Erweiterungen,  }
{   die Textmarkierungen der Version 2.0 berlesen, Fehlerbehandlung und einige }
{   Ausgliederung von Prozduren  }

procedure xlate;
type bf   = array[0..16383] of byte;
     bufp = ^bf;
var t1,t2 : text;
    b1,b2 : bufp;
    buf,s : string;
    tempstr : string;
    rand2 : integer;
    r2add : integer;
    h,i,j,k,p,q : integer;
    rmark : string[2];   { "|"-Markierung am linken Rand }
    endrm : boolean;
    tabelle : boolean;
    kommentar : boolean;
    kommzeile : boolean;
    nosplus: boolean;
    normchr: set of char;

  procedure writebuf;
  begin
    if buf<>'' then write(t2,rmark,sp(rand-2+rand2+r2add))
    else if (rmark<>'  ') and (tabelle=false) then write(t2,rmark);
    r2add:=0;
    writeln(t2,buf);
    if (buf<>'') and (s='') then
      if (rmark<>'  ') and not endrm then writeln(t2,rmark)
      else writeln(t2);
    buf:='';
    rand2:=0;
  end;

  procedure delQV;
  var k,p : integer;
  tempbuf : string;
  begin
    while pos('{@',s)>0 do begin
      inc(qverw1log);
      tempbuf:=''; k:=0; p:=0;
      p:=pos('{@',s);
      k:=pos('}',s);
      tempbuf:=ltrim(copy(s,k+1,length(s)-k));
      s:=rtrim(copy(s,1,p-1));
      if tempbuf<>'' then begin
        if not (firstchar(tempbuf) in [#33,#41,#44,#46,#63,#58,#59]) then begin
        if s<>'' then s:=concat(s,' ',tempbuf) else s:=tempbuf;
        end else begin
          if s<>'' then s:=concat(s,tempbuf) else s:=tempbuf;
          end;
        end;
      end;
  end;

        { 1. Teil der Fehlerbehandlung beim Umbruch:          }
        {   Prfung auf Zeichenketten und Leerzeichen         }
        { Der Teil dient einerseits dazu, grob vorzusortieren }
        { und um lngere fehlerhafte Teile besser kenntlich   }
        { fr die Ausgabe auf dem Bildschirm zu erhalten      }
  procedure chkerr1;
  begin
    p:=length(s);
    if p>breite then begin
      h:=0; i:=0; j:=0; k:=0; q:=0;
      while i<=p-1 do begin
        if (s[i+1] in [#32]) then begin
          inc(q); k:=0;
          if j<q then j:=q;
          end else begin
            inc(k); q:=0;
            if h<k then h:=k;
            end;
        inc(i);
        end;
      if (h>breite-3) or (j>breite div 3) then begin
        inc(logn);
          { Kontrollmeldung auf dem Bildschirm oder ins Logfile }
        if logon then writeln(dlog,inputln,': ',s) else
          writeln(inputln,': ',s);
        if pseudoblock and not nopseudo then begin
          if buf<>'' then begin
            writeln(t2,rmark,sp(rand-2),buf); buf:='';
            rand2:=0;
            end;
          writeln(t2,rmark,sp(rand-2),s);
          s:='';
          nosplus:=true;
          end;
        end;
      end;
  end;

  procedure wrform;
  var p,pp : byte;
      fs   : string[80];
      ls   : byte;                   { Anzahl Leerstellen }
      lp   : array[1..80] of byte;   { Position der Leerstellen }
      lc   : array[1..80] of byte;
      spc  : byte;
      count: byte;
      i, j, q : integer;
  begin
    i:=0; j:=0; q:=0;
    write(t2,rmark,sp(rand-2+rand2+r2add));
    if r2add<>0 then begin
      write(t2,left(buf,-r2add));
      delete(buf,1,-r2add);
      end;
    p:=breite+1-rand2;
    if (buf[p]='-') then begin
      if (buf[p-1]='(') then dec(p);
      dec(p);
      end;
    while (buf[p]<>' ') and ((buf[p]<>'-') or ((buf[p]='-') and (buf[p-1]='('))) and
          ((buf[p]<>'/') or not (buf[p-1] in normchr)) and (p>0) do
      dec(p);
    if p<3 then begin
      writeln(t2,left(buf,breite-rand2));
      delete(buf,1,breite-rand2);
      end
    else begin
      if buf[p]='/' then dec(p);
      if buf[p]='(' then dec(p);
      fs:=trim(left(buf,p));
      delete(buf,1,p);
      if (buf<>'') and (buf[1]=' ') then
        delfirst(buf);
        { 2. Teil Fehlerbehandlung beim Pseudo-Blocksatz: }
        {   Prfung nur der Leerzeichen }
      p:=length(fs);
      i:=0; j:=0; q:=0;
      while i<=p-1 do begin
        if (fs[i+1] in [#32]) then begin
          inc(q);
          if j<q then j:=q;
          end;
        inc(i);
        end;
        { Pseudo-Blocksatz, wenn mindestens ein Leerzeichen aber nicht mehr }
        {   als ein Drittel im String FS Leerzeichen sind..}
      if (j>0) and (j<p div 3) then begin
        if pseudoblock and not nopseudo then begin
          ls:=0;
          for p:=1 to length(fs) do
            if fs[p]=' ' then begin
              inc(ls); lp[ls]:=p;
              end;
          fillchar(lc,sizeof(lc),0);
          count:=0; spc:=0;
          while length(fs)<breite-rand2 do begin
            repeat
              pp:=random(ls)+1;
            until lc[pp]=count;
            insert(' ',fs,lp[pp]);
            for p:=pp+1 to ls do inc(lp[p]);
            inc(lc[pp]);
            inc(spc);
            if spc=ls then begin
              inc(count); spc:=0;
              end;
            end;
          end;
        end else begin
          inc(logn);
          if logon then begin
              { Kontrollmeldung auf dem Bildschirm oder ins Logfile }
            if inputnew then writeln(dlog,inputln,': ',fs) else
             writeln(dlog,inputln-inputcnt,':~',fs)
             end else
               if inputnew then writeln(inputln,': ',fs) else
               writeln(inputln-inputcnt,':~',fs);
          end;
      writeln(t2,fs);
      end;
    r2add:=0;
  end;

begin
  new(b1); new(b2);
  assign(t1,infile); settextbuf(t1,b1^); reset(t1);
  assign(t2,outfile); settextbuf(t2,b2^); rewrite(t2);
  buf:='';
  rand2:=0; r2add:=0;
  h:=0; i:=0; j:=0; k:=0; p:=0; q:=0;
  rmark:='  '; endrm:=false;
  tabelle:=false;
  kommentar:=false;
  nosplus:=false;
  normchr:=['a'..'z','A'..'Z','','','','','','','','0'..'9'];
  while not eof(t1) do begin
    readln(t1,s);
    inc(inputln);
    inputnew:=true;
    if inputcnt>0 then dec(inputcnt);
    if left(s,1)='%' then begin
      kommzeile:=true;
      s:='';
      end else
      kommzeile:=false;
    if left(s,3)='>>%' then begin
      kommentar:=true;
      s:='' end else
    if left(s,3)='<<%' then begin
      kommentar:=false;
      kommzeile:=true;
      s:='';
      end;
      if (s='>>F0') or (s='>>f0') then begin
        kommzeile:=true;
        s:=''; end else
          if (s='>>FF') or (s='>>ff') then begin
            kommzeile:=true;
            s:='';
            end;
    if (left(s,3)='>>O') or (left(s,3)='>>o') then begin
      pseudoblock:=false;
      kommzeile:=true;
      s:='' end else
        if (left(s,3)='<<O') or (left(s,3)='<<o') then begin
          pseudoblock:=true;
          kommzeile:=true;
          s:='';
          end;
    if (left(s,3)='>>@') then begin
      kommzeile:=true;
      s:='';
      end;
    if not kommentar and not kommzeile then begin
      if left(s,2)='\' then delete(s,1,1);
      if s='>>|' then rmark:=iifs(nomark,'  ','| ')
      else if s='<<|' then endrm:=true else
      if (left(s,3)='>>T') or  (left(s,3)='>>t') then tabelle:=true else
      if (s='<<T') or (s='<<t') or (left(s,3)='>>N') or (left(s,3)='>>n') then
        tabelle:=false
        else begin { end nach wrform und writebuf }
          if left(s,1)=#12 then begin
            if buf<>'' then begin
              writeln(t2,rmark,sp(rand-2),buf); buf:=''; end;
            write(t2,s[1]);
            delete(s,1,1);
            end else
              if left(s,2)='--' then begin
                if buf<>'' then writebuf;
                rand2:=ival(copy(s,3,2));
                if rand2>0 then begin
                  r2add:=-rand2;
                  delete(s,1,4);
                  end;
                end else
                  if left(s,2)='++' then begin
                    if buf<>'' then writebuf;
                  rand2:=ival(copy(s,3,2));
                  if rand2>0 then
                    delete(s,1,4);
                  end;
        if pos('{@',s)>0 then delQV;
        if tabelle then begin
          if buf<>'' then writebuf;
          write(t2,rmark,sp(rand-2),s);
          s:='';
        end;
        if nosplus=false then begin
          chkerr1;
          if buf<>'' then buf:=buf+' ';
          if (buf='') or (buf=' ') then begin
            inputcnt:=0; inputnew :=true end else begin
              inputnew:=false; inc(inputcnt);
              end;
          buf:=buf+s;
          while length(buf)>breite-rand2 do
            wrform;
          if (length(s)<=breite-rand2) then writebuf;
          end;
          end; { fr else begin nach tabelle:=false}
        nosplus:=false;
        if endrm and (buf='') then begin
          rmark:='  ';
          endrm:=false;
          end;
      end;
    end;
  close(t1);
  close(t2);
  dispose(b1); dispose(b2);
end;

var bs : string[20];
    switchnr : integer;
    iswitchdata : integer;
    sswitchdata : string;


    { zur Funktion umgeschriebene Prozedur UpString aus Typeform.Pas }
  Function UpStr1(var s:string): string;
  var i : integer;
  begin
    for i:=1 to length(s) do
      s[i]:=UpCase(s[i]);
      Upstr1 := s
  end;

{ from: swag-snippets, freeware, command line-parsing from Ryan Thompson, Canada 1993 }
  Function SwitchNum(s : string) : integer;
  var   Temp : string;
        X, Y : integer;
  begin
    Temp:= '';
    X:= ParamCount;
    Y:= 0;
    while (X > 0) and (Y = 0) do begin
      Temp:= ParamStr(X);
      if (Temp[1] = '/') or (Temp[1] = '-') then
        if UpCase(Temp[2]) = UpStr1(s) then Y:= X;
            { wenn Schreibweise der Schalter mageblich sein soll }
{         if Temp[2] = s then Y:= X; }
      dec(X);
    end;
    SwitchNum:= Y;
    End;

  Function SwitchThere(s : string) : Boolean;
  begin
    SwitchThere:= not (SwitchNum(s) = 0);
  end;

  Function SwitchData(s : string) : string;
  var   Temp : string;
  begin
    if SwitchNum(s) > 0 then begin
      Temp:= ParamStr(SwitchNum(s));
      Delete(Temp, 1, 2);
    end
    else Temp:= '';
    SwitchData:= Temp;
  end;

  Function Parameter(N : Byte) : string;
  var X, Count : Byte;
      Parm, Temp : string;
  begin
    X:= 0;
    Count:= 0;
    Parm:= '';
    if ParamCount > 0 then repeat
      inc(X);
      Temp:= ParamStr(X);
      if (Temp[1] = '"') or (Temp[1] = '''') then begin
        Parm:= Temp;
        if X < ParamCount then repeat
          inc(X);
          Parm:= Parm + ' ' + ParamStr(X);
        until (Parm[Length(Parm)] = '"') or
              (Parm[Length(Parm)] = '''') or (X = ParamCount);
        inc(Count);
      end
      else if (Temp[1] <> '/') and (Temp[1] <> '-')
      then begin
        inc(Count);
        Parm:= Temp;
      end;
    until (X = ParamCount) or (Count = N);
    if Count = N then Parameter:= Parm
    else Parameter:= '';
  end;

  Function Parameters : Byte;
  var  X : Byte;
  begin
    X:= 0;
    if ParamCount > 0 then begin
      repeat
        inc(X)
      until Parameter(X) = '';
      Parameters:= X - 1;
    end
    else Parameters:= 0;
  end;

{   Parameters      Returns the number of parameters on the command line.  Does }
{                    not include switches. }
{   Parameter(n)    Returns the nth parameter, ignoring switches and passing }
{                    strings in quotes as " or ' followed by the entire string }
{                    including any imbedded spaces. }
{   SwitchThere(x)  Returns True if the switch specified by the character }
{                    passed is present on the command line. }
{   SwitchData(x)   Returns the data following the switch character if the }
{                    switch character specified is present on the command line. }
{   SwitchNum(x)    Returns the position on the command line of the switch }
{                    specified.  Skips parameters. }

{   For example, the command line: }

{ TESTPRG /C INPUT.DAT /X67 "first one" }

{         Parameters  returns  2 }
{       Parameter(1)  returns  INPUT.DAT }
{       Parameter(2)  returns  "first one }
{   SwitchThere('F')  returns  false }
{    SwitchData('X')  returns  67 }

{   Notice that in quoted parameters, the first quote is returned- this allows }
{ you to check for " vs. ', which you could use as the difference between case }
{ sensitive and non-case-sensitive.  A simple Delete(S,1,1) can remove it from }
{ the string for use. }
{------------------------------------------------------------------------------}

{ JM Anmerkung: Meiner Beobachtung nach werden bei Parameter(2) das letzte           }
{ Quotezeichen ebenfalls angezeigt. Eine sinnvolle Kombination von SwitchNum(x)   }
{ und Parameter(x) ist nicht generell mglich, weswegen nunmehr auf ein           }
{ Ersatzzeichen "\" fr das Leerzeichen in Strings zurckgegriffen wurde, (da     }
{ Windows XP das in der DocForm 2.0 gewhlte "^" anscheinend nicht akzeptiert).   }

    { Kommandozeile aus dem Speicher lesen }
  Function CmdLine : string;
    begin
    CmdLine := string( ptr( prefixseg, $0080 )^ );
  end;

begin
  docmode:=false;
  printmode:=false;
  pseudoblock:=true;
  pseudoblock1:=true;
  nopseudo:=false;
  verbose:=false;
  logon:=false;
  preproz:=0;
  iswitchdata:=0;
  sswitchdata:='';
  logs:='';
  assign(OUTPUT,''); rewrite(OUTPUT); { ermglicht die Ausgabeumleitung }
  assign(dlog,'DOCFORM.LOG'); rewrite (dlog);
  erase(dlog);
  if ioresult = 0 then;
  logn:=0;
  inputln:=0;
  inputnew:=true;
  kom0log:=0; komlog:=0; kom1log:=0; kom2log:=0; f0log:=0; fflog:=0;
  nr12log:=0; vorlog:=0; kaplog:=0; blocklog:=0; block1log:=0;
  tablog:=0; tab0log:=0; tab1log:=0; utablog:=0; tab2log:=0;
  twoplus:=0; twomin:=0; escsq:=0; rmlog:=0; rm1log:=0;
  qverwlog:=0; qverw1log:=0;

  writeln;
  writeln('DocForm v'+l_ver+' --> XP '+verstr+
            betastr+' '+author_name+' '+x_copyright);
  writeln;
  Writeln('Der Aufruf:',CmdLine,' startete mit');
  Writeln(' ',Parameters,'  Argument(en)');
  if SwitchThere('p') then Writeln(' +  dem Schalter -p',switchdata('p'));
  if SwitchThere('o') then Writeln(' +  dem Schalter -o',switchdata('o'));
  if SwitchThere('i') then Writeln(' +  dem Schalter -i');
  if SwitchThere('t') then Writeln(' +  dem Schalter -t',switchdata('t'));
  if SwitchThere('k') then Writeln(' +  dem Schalter -k',switchdata('k'));
  if SwitchThere('-') then Writeln(' +  dem Schalter --');
  if SwitchThere('v') then Writeln(' +  dem Schalter -v');
  if SwitchThere('x') then Writeln(' +  dem Schalter -x');
  if SwitchThere('_') then Writeln(' +  dem Schalter -_',switchdata('_'));
  writeln;
    { temporre Datei(en) lschen }
  erase_mask('D2$*.*');
  erase_mask('DX$*.*');
  infile:=paramstr(1);
  if (ustr(infile)='-H') or (infile='?') or (infile='/?') or (infile='-?')
    then usage;
  outfile:=paramstr(2);
  breite:=ival(paramstr(3));
  rand:=ival(paramstr(4));
  nomark:=(ustr(paramstr(5))='N');
  if infile='' then begin
    writeln('Eingabedatei:  ( Hilfe)');
    readln(infile);
    infile:=trim(infile);
    if (ustr(infile)='-H') or (infile='?') or (infile='/?') then usage;
    if infile='' then usage;
    end;
  if outfile='' then begin
    write('Ausgabedatei: ');
    readln(outfile);
    outfile:=trim(outfile);
    if outfile='' then halt(1);
    end;
  if breite=0 then begin
    write('Formatbreite[71]: ');
    readln(bs);
    if ival(bs)<>breite then breite:=ival(bs);
    if breite=0 then breite:=71;
    end;
  if breite<20 then begin
    WriteLn(' Breite: ',breite,' < 20 wurde auf 71 korrigiert');
    breite:=71;
    end;
  if rand=0 then begin
    write('linker Rand[3]: ');
    readln(bs);
    if ival(bs)<>rand then rand:=ival(bs);
    if rand=0 then rand:=3;
    end;
  if not exist(infile) then stop('Eingabedatei nicht vorhanden');
  if not validfilename(outfile) then stop('ungltige Ausgabedatei');

  if SwitchThere('_') then begin
    if switchdata('_')<>'' then begin
      logfile:=switchdata('_');
        if not validfilename(logfile) then begin
          WriteLn('ungltiges Logfile, der Name wurde in DocForm.Log gendert');
          logfile:='DOCFORM.LOG';
          end;
      end else
        logfile:='DOCFORM.LOG';
     writeln(' Logfile: ',logfile,' wird erstellt');
     assign(dlog,logfile); rewrite(dlog);
     writeln(dlog,'File: ',infile,' ;');
     end;

    { Default-Wert der Startvariablen }
  if SwitchThere('t') then begin
    if switchdata('t')<>'' then begin
      swidata:=switchdata('t');
      Ersatzzeichen;
      TriggerVar:=swidata;
      end else TriggerVar:='I Einfhrung';
    end;

    { Default-Wert des Namens in der Kopfzeile }
  if SwitchThere('k') then begin
    if switchdata('k')<>'' then begin
      swidata:=switchdata('k');
      Ersatzzeichen;
      DocTitle:=swidata;
      end else DocTitle:='FreeXP';
    end;

    { Default-Wert des Inhaltsnamens vor dem Inhaltsverzeichnis }
  if SwitchThere('i') then begin
    if switchdata('i')<>'' then begin
      swidata:=switchdata('i');
      Ersatzzeichen;
      content:=swidata;
      end else content:='Inhalt';
    end;

    { Default-Wert der Zeilenzahl/Seite }
  if SwitchThere('p') then begin
    if switchdata('p')='' then begin
      pglines:=60;
      printmode:=true;
      end else
        if switchdata('p')='-' then docmode:=true
          else begin
            sswitchdata:=switchdata('p');
             while iswitchdata<>length(sswitchdata) do begin
              if sswitchdata[iswitchdata+1] in ['0'..'9'] then inc(iswitchdata)
                else break;
              end;
            if iswitchdata>0 then begin
              if (length(sswitchdata)=iswitchdata) then begin
                pglines:=(ival(switchdata('p')));
                printmode:=true;
                end;
              end;
            end;
    end;


  if printmode then begin
    docmode:=true;
    if TriggerVar='' then TriggerVar:='I Einfhrung';
    if DocTitle='' then DocTitle:='FreeXP';
    if content='' then content:='Inhalt';
    end else if docmode then begin
      if TriggerVar='' then TriggerVar:='I Einfhrung';
      if content='' then content:='Inhalt';
      end;

    { Default-Wert Pseudoblocksatz ein }
  if SwitchThere('o') then pseudoblock:=false;
  if SwitchThere('o') then pseudoblock1:=false;
  if SwitchData('o')='o' then nopseudo:=true;

    { Default-Wert Report aus }
  if SwitchThere('v') then verbose:=true;

    { Default-Wert kein Logfile }
  if SwitchThere('_') then logon:=true;

    { Default-Wert preproz=0 }
  if SwitchThere('x') then preproz:=1;

  if printmode then
    Writeln('> Erweiterte Funktionen mit Seitenformatierung') else
      if docmode then Writeln('> Erweiterte Funktionen ohne Seitenformatierung') else
        Writeln('> Keine erweiterten Funktionen/Seitenformatierung');
  if docmode and SwitchThere('-') then Writeln(' Temp-Files bleiben erhalten');
  if docmode then Writeln(' Startvariable: ',TriggerVar);
  if printmode then Writeln(' Kopfzeile: ',DocTitle);
  if printmode then begin
    if pglines >= 10 then Writeln(' Zeile/Seite: ',pglines) else begin
      Writeln(' Zeile/Seite: ',pglines);
      Writeln('> Wert kleiner als 10 wird korrigiert');
      pglines:=60;
      Writeln(' Zeile/Seite: ',pglines);
      end;
    end;
  if not SwitchThere('o') then Writeln(' Pseudoblocksatz an') else
    Writeln(' Pseudoblocksatz aus');
  if docmode then Writeln(' Inhaltsname: ',content);
  if ((Parameter(5)='N') or (Parameter(5)='n')) then WriteLn(' Randmarkierung aus')
    else WriteLn(' Randmarkierung an');
  if not docmode then begin
    writeln;
    writeln(' DocForm lief im einfachen Modus. Die erweiterte Formatierung');
    writeln(' wird mit dem Optionsschalter -p[-|n>9] aufgerufen.');
    end;
  if not verbose and docmode then writeln(' (weitere Infos mit Schalter -v)');
if docmode then begin
  d2format;
   if verbose then begin
    if vorlog>0 then writeln(' Vorspann: ',vorlog,' Zeilen');
    if nr12log>0 then writeln(' Steuerzeichen Ascii(12): ',nr12log);
    if kaplog>0 then writeln(' Kapitelueberschriften: ', kaplog);
    writeln;
    writeln('> In der Vorlage existieren Textauszeichnungen');
    if utablog>0 then writeln(' Unterkapitel(ex-black-square): ',utablog);
    if escsq>0 then writeln('   escaped black square (\) : ',escsq);
    if twomin>0 then writeln(' Einrueckungen "--": ',twomin, '; "++": ',twoplus);
    if (komlog>0) or (kom1log>0) then writeln(' Kommentarzeilen insgesamt: ',komlog+kom0log);
    if (kom1log>0) and (kom1log=kom2log) then writeln('   Mehrzeilenkommentare: ',kom1log);
    if (kom1log>0) and (kom1log>kom2log) then writeln(' * unbalanciert - Textende fehlt');
    if (kom2log>0) and (kom1log<kom2log) then writeln('   unbalanciert - unkritisch');
    if (tablog>0) or (tab0log>0) then writeln(' Tabellen markiert: ', tablog+tab0log);
    if tab2log>0 then writeln('   mit Namen: ',tab2log);;
    if (tablog>0) and (tablog>tab1log) then writeln(' * unbalanciert - evtl. Formatierungsfehler');
    if (tab1log>0) and (tab1log>tab1log) then writeln('   unbalanciert - unkritisch');
    if rmlog>0 then writeln(' Randmarkierungen: ',rmlog);
    if rmlog<>rm1log then writeln('   unbalanciert');
    if f0log>0 then writeln(' extra Kopfzeilen: ',f0log);
    if fflog>0 then writeln(' extra Seitenvorschuebe: ',fflog);;
    if not nopseudo then begin
      if ((blocklog>0) or (block1log>0)) and not SwitchThere('o') then writeln('> beim Aufruf war der Pseudo-Blocksatz an');
      if ((blocklog>0) or (block1log>0)) and SwitchThere('o') then writeln('> beim Aufruf war der Pseudo-Blocksatz aus');
      end else
        writeln('> ganz ohne Pseudo-Blockformatierung');
    if (blocklog>0) and (block1log>0) then writeln(' Pseudo-Blocksatz aus: ',blocklog,'; ein: ',block1log);
    if (blocklog>0) and (block1log=0) then writeln(' Pseudo-Blocksatz aus: ',blocklog);
    if (blocklog=0) and (block1log>0) then writeln(' Pseudo-Blocksatz ein: ',block1log);
    if ((preproz=0) or (preproz=1)) and ((qverwlog>0) or (qverw1log >0)) then
      writeln(' >>@Verweise: ',qverwlog,'; {@Verweise}: ',qverwlog);
    end;
   writeln;
   WriteLn('File: ',infile,' mit ',inputln,' Zeilen bearbeitet');
  if logon then
    if logn>0 then writeln('Warnung: ',logn,' Eintraege im Logfile ',logfile)
    else
      writeln('Logfile ',logfile,' ohne Eintraege wurde geloescht');
    { temporre Datei(en) lschen }
   if not SwitchThere('-') or (preproz=1) then erase_mask('D2$*.*');
   if preproz=1 then begin
    pseudoblock:=pseudoblock1;
    logn:=0;
    inputln:=0; inputnew:=true;
    kom0log:=0; komlog:=0; kom1log:=0; kom2log:=0; f0log:=0; fflog:=0;
    nr12log:=0; vorlog:=0; kaplog:=0; blocklog:=0; block1log:=0;
    tablog:=0; tab0log:=0; tab1log:=0; utablog:=0; tab2log:=0;
    twoplus:=0; twomin:=0; escsq:=0; rmlog:=0; rm1log:=0;
    inc(preproz);
    d2format;
    if not SwitchThere('-') then erase_mask('D2$*.*');
    if not SwitchThere('-') then erase_mask('DX$*.*');
    end;
  end else begin
    xlate;
    writeln;
    writeln('File: ',infile,' mit ',inputln,' Zeilen bearbeitet');
    if logon then
      if logn>0 then writeln('Warnung: ',logn,' Eintraege im Logfile ',logfile)
      else
        writeln('Logfile ',logfile,' ohne Eintraege wurde geloescht');
    end;
    if logon then close(dlog);
    if logon and (logn=0) then erase(dlog);
end.
{
  $Log: docform.pas,v $
  Revision 1.22  2005/09/14 01:26:26  jm
  JM: kl. Bugfix um Leerzeichen in Leerzeilen im Vorspann zu vermeiden

  Revision 1.21  2005/01/01 11:16:27  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.20  2004/05/27 03:10:44  jm
  JM: Hilfstext nochmals korrigiert

  Revision 1.19  2004/05/27 01:07:21  jm
  JM: Minor-Update auf v2.0a
      - Ersatzzeichen der Leerzeichen bei den Schalter-Parametern
        auf #92 = "\" und deren Konvertierung mit neuer "procedure
        Ersatzzeichen" geaendert, da WindowsXP mit der alten Routine
        nicht klarkam
      - sowie Anpassung und etwas Kosmetik am Hilfstext vorgenommen

  Revision 1.18  2004/01/20 10:20:22  jm
  JM: - Korrekturen am Hilfstext

  Revision 1.17  2004/01/09 16:18:55  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.16  2004/01/08 07:57:49  mw
  MW: - Revision 1.14 gelscht und Datei etwas aufgerumt.

  Revision 1.15  2004/01/08 02:16:22  jm
  JM: - kleine Korrekturen am Hilfstext

  Revision 1.13  2003/12/23 16:11:31  jm
  JM:  Versionssprung auf v2.0 einschlielich neuer und kompletter
       Dokumentation; der vollstndige Umfang der nderungen ist
       der DocForm.Dq/Txt zu entnehmen.

       - xlate wurde etwas modularisiert ist nun eine Art
         Kompatibilittsmodus fr die bisherige einfache Forma-
         tierung der v1.03/1.04 mit wenigen neuen Features und bei
         im Prinzip gleichem Verhalten und mit denselben Aufrufen
         wie vorher bedienbar.
         - Unbekannte Textauszeichnungen aus d2format werden
           berlesen.

       - d2format mit weiteren Modulen bietet als wesentlich
         erweitertes xlate zudem eine Printformatierung mit
         Seitenzahlen, zwei Varianten zur Tabellenbenamung, ein
         automatisch erstelltes Inhalts- und Tabellenverzeichnis
         und wurde um andere Features erweitert, die durch
         (kombinierte) Aufrufschalter und neue Textauszeichnungs-
         markierungen einstellbar sind.
         - Die Verwendung von temporren Files erzeugt dabei einen
           etwas hheren Filehandlesverbrauch
         - ein zweiter Pass fr Querverweise (nur Aufrufschalter
           "-x") wird die Bearbeitungsdauer etwa verdoppeln.

       weitere nderungen:

       - Die Aufrufprozedur wurde fr beide o.g. Prozeduren um
         einen Hilfstext, Default-Einstellungen fr Breite=71 und
         Rand=3 sowie einem einfachen Status-Bericht fr beide
         (und einem erweiterten Berichtsmodus bei d2format fr
         Funktionen und Textauszeichnungen) sowie der Ausgabe von
         Warnhinweisen bei aussetzendem Pseudo-Blocksatz
         ausgetattet.
       - Neu: Ausgabeumleitung von Aufrufmeldungen/Berichten per
         ">" eingebaut.
       - Neu: (in wrform/wr2form): wenn einer ffnenden runden
         Klammer ein Bindestrich folgt, wird nicht nach dem
         Bindestrich umbrochen; schtzt also bereits vorhandene
         Verweise im der Form (->S. 123) Text vor einem Umbruch
         nach "-".
       - Neu: der Pseudoblocksatz kann mit Aufrufschalter -o[o]
         abgestellt werden (und ist mit dem Schalter "_-[Logfile]"
         der einzige wirksame Aufrufschalter im v1.03/1.04
         Kompatibilittmodus).
       - Fix: Bei den Einzugsroutinen "--" und "++" wird jetzt
         zuerst der "buf"- Inhalt mit writebuf ausgegeben und
         damit das Ende des vorherigen Absatzes erzwungen.
       - Fix: Der Schutz vor Einfrieren des Systems bei langen
         Zeichenketten ohne oder nur mit Leerzeichen
         - 2 Fehlerbehandlungen und
         - Begrenzung der kleinsten einstellbaren Breite auf 20
           Zeichen/Zeile.

  Revision 1.12  2003/09/24 23:28:40  jm
  JM: - bugfix: bei gesetztem Tabellen-Tag ">>T" wird nun der
        linke Rand bei Ausgabe der Tabelle gesetzt.

  Revision 1.11  2003/08/19 15:27:45  mw
  MW: - Panne die dazu fhrte das Docform nicht compilierbar war beseitigt.

  Revision 1.10  2003/08/19 14:31:26  mw
  JM:  15.08.03 "|" um eine Stelle nach links verschoben,
       Tabellen-Tag und  Kommentar-Tag (fr absatzweises Kommentieren)
       eingefgt. Diese Tags werden immer doppelt und in einer
       eigenen Zeile eingesetzt. Hinzugefgt wurde weiter die Mglichkeit
       von Einzeiler-Kommentare, diese beginnen mit einem "%"  als erstem
       Zeichen der Zeile.

  Revision 1.9  2003/08/14 09:32:41  mw
  MW: - Uebernahme einer Aenderung aus JGXP:
        DOCFORM setzt jetzt den sekrechten Strich ein Zeichen
        weiter nach links

  Revision 1.8  2003/07/30 23:09:48  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.7  2003/06/25 17:25:48  tw
  auto-de-branching

  Revision 1.6.2.1  2000/09/17 07:56:42  mw
  Compilierbarkeit einiger Dateien wiederhergestellt (XP.exe und DOCFORM.EXE)

  Revision 1.6  2000/04/13 12:48:30  mk
  - Anpassungen an Virtual Pascal
  - Fehler bei FindFirst behoben
  - Bugfixes bei 32 Bit Assembler-Routinen
  - Einige unkritische Memory Leaks beseitigt
  - Einge Write-Routinen durch Wrt/Wrt2 ersetzt
  - fehlende CVS Keywords in einigen Units hinzugefuegt
  - ZPR auf VP portiert
  - Winxp.ConsoleWrite provisorisch auf DOS/Linux portiert
  - Automatische Anpassung der Zeilenzahl an Consolengroesse in Win32

  Revision 1.5  2000/02/17 16:14:19  mk
  MK: * ein paar Loginfos hinzugefuegt

}
